<?php
include 'includes/db.php'; // Database connection
include 'includes/session.php'; // Session to check if user is logged in

// Check if request is made using POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the values from the form
    $product_class = $_POST['product_class'];
    $category_id = $_POST['category_id'];

    // Prepare SQL query to insert subcategory
    $stmt = $conn->prepare("INSERT INTO subcategory (product_class, category_id) VALUES (:product_class, :category_id)");
    $stmt->bindParam(':product_class', $product_class);
    $stmt->bindParam(':category_id', $category_id);

    // Execute the query and check if the insertion is successful
    if ($stmt->execute()) {
        // Return success message
        echo json_encode(['status' => 'success', 'message' => 'Subcategory added successfully.']);
    } else {
        // Return error message
        echo json_encode(['status' => 'error', 'message' => 'Failed to add subcategory. Please try again later.']);
    }
}
?>
