<?php
include 'includes/db.php'; // Database connection
include 'includes/session.php'; // Session to check if user is logged in

// Check if request is made using POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the values from the form
    $category_name = $_POST['category_name'];
    $group_target = $_POST['group_target'];

    // Prepare SQL query to insert category
    $stmt = $conn->prepare("INSERT INTO category (category_name, group_target) VALUES (:category_name, :group_target)");
    $stmt->bindParam(':category_name', $category_name);
    $stmt->bindParam(':group_target', $group_target);

    // Execute the query and check if the insertion is successful
    if ($stmt->execute()) {
        // Return success message
        echo json_encode(['status' => 'success', 'message' => 'Category added successfully.']);
    } else {
        // Return error message
        echo json_encode(['status' => 'error', 'message' => 'Failed to add category. Please try again later.']);
    }
}
?>
