<?php
include 'includes/session.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'includes/db.php'; // Database connection

// Check if ID is passed via POST request
if (isset($_POST['id']) && !empty($_POST['id'])) {
    $kra_id = $_POST['id'];

    try {
        // Prepare SQL query to delete the KRA template
        $stmt = $conn->prepare("DELETE FROM PMS_Template WHERE id = :id");
        $stmt->bindParam(':id', $kra_id, PDO::PARAM_INT);

        // Execute the delete statement
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'KRA Template deleted successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to delete the record.']);
        }
    } catch (PDOException $e) {
        // Handle any errors
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid ID.']);
}
?>
