<?php
include("includes/session.php");
include 'includes/db.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve employee ID and form data
    $employee_code = $_POST['employee_code'];
    $employee_name = $_POST['employee_name'];
    $department_name = $_POST['department_name'];
    $designation = $_POST['designation'];
    $personal_email_id = $_POST['personal_email_id'];
    $personal_mobile_no = $_POST['personal_mobile_no'];
    
    // Add more fields as needed
    $permanent_address = $_POST['permanent_address'];
    $permanent_city = $_POST['permanent_city'];
    $permanent_state = $_POST['permanent_state'];
    $permanent_pin = $_POST['permanent_pin'];
    
    // Prepare the SQL query
    $sql = "UPDATE Employees SET 
                employee_name = :employee_name,
                department_name = :department_name,
                designation = :designation,
                personal_email_id = :personal_email_id,
                personal_mobile_no = :personal_mobile_no,
                permanent_address = :permanent_address,
                permanent_city = :permanent_city,
                permanent_state = :permanent_state,
                permanent_pin = :permanent_pin
            WHERE employee_code = :employee_code";

    $stmt = $conn->prepare($sql);

    // Bind parameters
    $stmt->bindParam(':employee_code', $employee_code);
    $stmt->bindParam(':employee_name', $employee_name);
    $stmt->bindParam(':department_name', $department_name);
    $stmt->bindParam(':designation', $designation);
    $stmt->bindParam(':personal_email_id', $personal_email_id);
    $stmt->bindParam(':personal_mobile_no', $personal_mobile_no);
    $stmt->bindParam(':permanent_address', $permanent_address);
    $stmt->bindParam(':permanent_city', $permanent_city);
    $stmt->bindParam(':permanent_state', $permanent_state);
    $stmt->bindParam(':permanent_pin', $permanent_pin);

    try {
        // Execute the query
        $stmt->execute();

        // Redirect or show a success message
        $_SESSION['success_message'] = "Employee details updated successfully!";
        header("Location: edit_employee.php?employee_code=$employee_code");
        exit;
    } catch (PDOException $e) {
        // Handle errors
        $_SESSION['error_message'] = "Error updating employee: " . $e->getMessage();
        header("Location: edit_employee.php?employee_code=$employee_code");
        exit;
    }
} else {
    // Redirect to customer details page if the request method is not POST
    header("Location: edit_employee.php");
    exit;
}
?>
