<?php
include 'includes/session.php';
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['employee_target_id'];
    $category_id = $_POST['category_id'];
    $target = $_POST['target'];
    $month = $_POST['month'];

    try {
        $stmt = $conn->prepare("UPDATE EmployeeTarget SET category_id = :category_id, target = :target, month = :month WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':category_id', $category_id);
        $stmt->bindParam(':target', $target);
        $stmt->bindParam(':month', $month);

        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Target updated successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update the target.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
