<?php include("includes/session.php");
include 'includes/db.php';

ini_set('display_errors',1);
ini_set('system_startup_errors',1);
error_reporting(E_ALL);
$stmt = $conn->prepare("SELECT * From position_master");
$stmt->execute();
$Positions = $stmt->fetchAll(PDO::FETCH_ASSOC);
// print_r($Positions);

$title = "Manage Positions"; 
include("includes/head.php");
?>
	<body>
	
	
		<!-- Main Wrapper -->
		<div class="main-wrapper">
		
			<!-- Header -->
			<?php include("includes/header.php"); ?>
			<!-- /Header -->
			
				<!-- Sidebar -->
				<?php include("includes/sidebar.php"); ?>
				<!-- /Sidebar -->
	
			<!-- Page Wrapper -->
			<div class="page-wrapper">
				<div class="content container-fluid">				
					<!-- Page Header -->
					<div class="page-header">
						<div class="content-page-header ">
							<h5>Positions</h5>
							<div class="list-btn">
								<ul class="filter-list">
									<li>
										<!--<a class="btn btn-filters w-auto popup-toggle" data-bs-toggle="tooltip" data-bs-placement="bottom" data-bs-original-title="Filter"><span class="me-2"><img src="assets/img/icons/filter-icon.svg" alt="filter"></span>Filter </a>-->
									</li>
									<li>
										<a class="btn btn-primary" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add_user"><i class="fa fa-plus-circle me-2" aria-hidden="true"></i>Add Position</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<!-- /Page Header -->
					
					<div class="row">
						<div class="col-sm-12">
							<div class="card-table">
								<div class="card-body">
									<div class="table-responsive">
										<table class="table table-center table-hover datatable">
											<thead class="thead-light">
												<tr>
													<th>#</th>
													<th>Position Name</th>
													<th Class="no-sort">Actions</th>
												</tr>
											</thead>
											<tbody>
											    <?php foreach($Positions as $i=> $position) { ?>
												<tr>
													<td><?= $i+1 ?></td>
													<td>
														<h2 class="table-avatar">
															<!--<a href="profile.html" class="avatar avatar-sm me-2"><img class="avatar-img rounded-circle" src="assets/img/profiles/avatar-14.jpg" alt="User Image"></a>-->
															<a href="#"><?=  $position['name']?></a>
														</h2>
													</td>
													<td class="d-flex align-items-center">
														<div class="dropdown dropdown-action">
															<a href="#" class=" btn-action-icon " data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-ellipsis-v"></i></a>
															<div class="dropdown-menu dropdown-menu-right">
																<ul>
																	<li>
																		<a class="dropdown-item" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#edit_user<?= $position['id'] ?>"><i class="far fa-edit me-2"></i>Edit</a>
																	</li>
																	<li>
																		<a class="dropdown-item" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#delete_modal<?= $position['id'] ?>"><i class="far fa-trash-alt me-2"></i>Delete</a>
																	</li>
																</ul>
															</div>
														</div>
													</td>
												</tr>
												
												<!-- Edit Position -->
                                    			<div class="modal custom-modal modal-lg fade" id="edit_user<?= $position['id'] ?>" role="dialog">
                                    				<div class="modal-dialog modal-dialog-centered modal-md">
                                    					<div class="modal-content">
                                    						<div class="modal-header border-0 pb-0">
                                    							<div class="form-header modal-header-title text-start mb-0">
                                    								<h4 class="mb-0">Edit Position</h4>
                                    							</div>
                                    							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    								
                                    							</button>
                                    						</div>
                                    						<form id="edit_userForm<?= $position['id'] ?>" action="manage_position.php" method="post" enctype="multipart/form-data">
                                    						    <input type="hidden" name="updateUser" value="true">
                                    						    <input type="hidden" name="userId" value="<?= $position['id'] ?>">
                                    							<div class="modal-body">
                                    								<div class="row">
                                    									<div class="col-md-12">
                                    										<div class="card-body">
                                    											<div class="form-groups-item">
                                    												<div class="row">
                                    													<div class="col-lg-4 col-md-6 col-sm-12">
                                    														<div class="input-block mb-3">
                                    															<label>Position Name</label>
                                    															<input name="name" value="<?= $position['name'] ?>" type="text" class="form-control" placeholder="Enter Position Name">
                                    														</div>
                                    													</div>
                                    												</div>
                                    											</div>						
                                    											
                                    										</div>
                                    									</div>
                                    								</div>
                                    							</div>
                                    							<div class="modal-footer">
                                    								<button type="button" data-bs-dismiss="modal" class="btn btn-primary paid-cancel-btn me-2">Cancel</button>
                                    								<button name="submit" type="submit" class="btn btn-primary paid-continue-btn" data-bs-dismiss="modal">Update</button>
                                    							</div>
                                    						</form>
                                    					</div>
                                    				</div>
                                    			</div>
                                    			<!-- /Edit User -->
                                    			
                                    			
                        						<!-- Delete Items Modal -->
                                    			<div class="modal custom-modal fade" id="delete_modal<?= $position['id'] ?>" role="dialog">
                                                    <div class="modal-dialog modal-dialog-centered modal-md">
                                                        <div class="modal-content">
                                                            <div class="modal-body">
                                                                <div class="form-header">
                                                                    <h3>Delete Position</h3>
                                                                    <p>Are you sure you want to delete?</p>
                                                                </div>
                                                                <div class="modal-btn delete-action">
                                                                    <div class="row">
                                                                        <div class="col-6">
                                                                            <a href="#" class="btn btn-primary paid-continue-btn delete-user" data-id="<?= $position['id'] ?>">Delete</a>
                                                                        </div>
                                                                        <div class="col-6">
                                                                            <a href="#" data-bs-dismiss="modal" class="btn btn-primary paid-cancel-btn">Cancel</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                    			<!-- /Delete Items Modal -->
												<?php } ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Page Wrapper -->

			<!-- Add Asset -->
			<div class="toggle-sidebar">
				<div class="sidebar-layout-filter">
					<div class="sidebar-header">
						<h5>Filter</h5>
						<a href="#" class="sidebar-closes"><i class="fa-regular fa-circle-xmark"></i></a>
					</div>
					<div class="sidebar-body">						
						<form action="#" autocomplete="off">
							<!-- Customer -->
							<div class="accordion" id="accordionMain1">
								<div class="card-header-new" id="headingOne">
									<h6 class="filter-title">
									<a href="javascript:void(0);" class="w-100" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
										Customer	
										<span class="float-end"><i class="fa-solid fa-chevron-down"></i></span>
									</a> 
									</h6>
								</div>
							
								<div id="collapseOne" class="collapse show" aria-labelledby="headingOne"  data-bs-parent="#accordionExample1">
									<div class="card-body-chat">
										<div class="row">
											<div class="col-md-12">
												<div id="checkBoxes1">
													<div class="form-custom">														
														<input type="text" class="form-control" id="member_search1" placeholder="Search here">
														<span><img src="assets/img/icons/search.svg" alt="img"></span>
													</div>
													<div class="selectBox-cont">
														<label class="custom_check w-100">
															<input type="checkbox" name="username">
															<span class="checkmark"></span>  John Smith
														</label>
														<label class="custom_check w-100">
															<input type="checkbox" name="username">
															<span class="checkmark"></span>  Johnny
														</label>
														<label class="custom_check w-100">
															<input type="checkbox" name="username">
															<span class="checkmark"></span>  Robert
														</label>
														<label class="custom_check w-100">
															<input type="checkbox" name="username">
															<span class="checkmark"></span> Sharonda
														</label>
														<!-- View All -->
														<div class="view-content">
															<div class="viewall-One">	
																<label class="custom_check w-100">
																	<input type="checkbox" name="username">
																	<span class="checkmark"></span> Pricilla
																</label>
																<label class="custom_check w-100">
																	<input type="checkbox" name="username">
																	<span class="checkmark"></span> Randall
																</label>
															</div>
															<div class="view-all">
																<a href="javascript:void(0);" class="viewall-button-One"><span class="me-2">View All</span><span><i class="fa fa-circle-chevron-down"></i></span></a>
															</div>
														</div>
														<!-- /View All -->
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Customer -->

							<!-- Select Date -->
							<div class="accordion" id="accordionMain2">
								<div class="card-header-new" id="headingTwo">
									<h6 class="filter-title">
									<a href="javascript:void(0);" class="w-100 collapsed"  data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
										Select Date	
										<span class="float-end"><i class="fa-solid fa-chevron-down"></i></span>
									</a> 
									</h6>
								</div>
							
								<div id="collapseTwo" class="collapse" aria-labelledby="headingTwo"  data-bs-parent="#accordionExample2">
									<div class="card-body-chat">
										<div class="input-block mb-3">
											<label class="form-control-label">From</label>
											<div class="cal-icon">
												<input type="email" class="form-control datetimepicker" placeholder="DD-MM-YYYY">
											</div>
										</div>
										<div class="input-block mb-3">
											<label class="form-control-label">To</label>
											<div class="cal-icon">
												<input type="email" class="form-control datetimepicker" placeholder="DD-MM-YYYY">
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Select Date -->

							<!-- By Status -->
							<div class="accordion accordion-last" id="accordionMain3">
								<div class="card-header-new" id="headingThree">
									<h6 class="filter-title">
									<a href="javascript:void(0);" class="w-100 collapsed"  data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
										By Status	
										<span class="float-end"><i class="fa-solid fa-chevron-down"></i></span>
									</a> 
									</h6>
								</div>
							
								<div id="collapseThree" class="collapse" aria-labelledby="headingThree"  data-bs-parent="#accordionExample3">
									<div class="card-body-chat">
										<div id="checkBoxes2">
											<div class="form-custom">														
												<input type="text" class="form-control" id="member_search2" placeholder="Search here">
												<span><img src="assets/img/icons/search.svg" alt="img"></span>
											</div>
											<div class="selectBox-cont">
												<label class="custom_check w-100">
													<input type="checkbox" name="bystatus">
													<span class="checkmark"></span> Active
												</label>
												<label class="custom_check w-100">
													<input type="checkbox" name="bystatus">
													<span class="checkmark"></span>  Restricted
												</label>
											</div>
										</div>	
									</div>
								</div>
							</div>
							<!-- /By Status -->
							<div class="filter-buttons">
								<button type="submit" class="d-inline-flex align-items-center justify-content-center btn w-100 btn-primary">
									Apply
								</button>
								<button type="submit" class="d-inline-flex align-items-center justify-content-center btn w-100 btn-secondary">
									Reset
								</button>
							</div>
						</form>
						
					</div>
				</div>
			</div>	
			<!--/Add Asset -->

			<!-- Add Position -->
			<div class="modal custom-modal modal-lg fade" id="add_user" role="dialog">
				<div class="modal-dialog modal-dialog-centered modal-md">
					<div class="modal-content">
						<div class="modal-header border-0 pb-0">
							<div class="form-header modal-header-title text-start mb-0">
								<h4 class="mb-0">Add Position</h4>
							</div>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
								
							</button>
						</div>
						<form id="add_userForm" method="post" enctype="multipart/form-data">
							<div class="modal-body">
								<div class="row">
									<div class="col-md-12">
										<div class="card-body">
											<div class="form-groups-item">
												<div class="row">
													<div class="col-lg-4 col-md-6 col-sm-12">
														<div class="input-block mb-3">
															<label>Position Name</label>
															<input name="name" type="text" class="form-control" placeholder="Enter Position Name">
														</div>
													</div>
												</div>
											</div>						
											
										</div>
									</div>
								</div>
							</div>
							<div class="modal-footer">
								<button type="button" data-bs-dismiss="modal" class="btn btn-back cancel-btn me-2">Cancel</button>
								<button name="createUser" type="submit" data-bs-dismiss="modal" class="btn btn-primary paid-continue-btn">Add Position</button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- /Add Position -->
			
		</div>
		<!-- /Main Wrapper -->

		<!-- jQuery -->
        <script src="assets/js/jquery-3.7.1.min.js"></script>
		
		<!-- Bootstrap Core JS -->
		<script src="assets/js/bootstrap.bundle.min.js"></script>

		<!-- Datatable JS -->
		<script src="assets/plugins/datatables/datatables.min.js"></script>

		<!-- select CSS -->
		<script src="assets/plugins/select2/js/select2.min.js"></script>
		
		<!-- Slimscroll JS -->
		<script src="assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
		
		<!-- Datepicker Core JS -->
		<script src="assets/plugins/moment/moment.min.js"></script>
		<script src="assets/js/bootstrap-datetimepicker.min.js"></script>
		
		<!-- multiselect JS -->
		<script src="assets/js/jquery-ui.min.js"></script>

		<!-- Theme Settings JS -->
		<script src="assets/js/theme-settings.js"></script>
		<script src="assets/js/greedynav.js"></script>
		
		<!-- Custom JS -->
		<script src="assets/js/script.js"></script>

	</body>
<script>
$('.delete-user').click(function(e) {
            e.preventDefault(); // Prevent the default anchor click behavior
            var userId = $(this).data('id'); // Get the user ID from data-id attribute
            var deleteUser = true;
            // Perform AJAX request to delete the user
            $.ajax({
                type: "POST",
                url: "manage_position.php", // Change this to your delete script
                data: { 
                    id: userId,
                    deleteUser: deleteUser
                },
                success: function(response) {
                    if (response.status === 'success') {
                        // Optionally, you can refresh the page or remove the deleted user from the UI
                        toastr.success(response.message);
                        location.reload(); // Reload the page to see changes
                    } else {
                        alert("Failed to delete Position: " + response.message);
                    }
                },
                error: function() {
                    alert("An error occurred. Please try again.");
                }
            });
        });
$('#add_userForm').submit(function(e){
    e.preventDefault();

    // Create a FormData object to include file data
    var formData = new FormData(this);
    formData.append('createUser', true); // Append the createUser key to FormData

    $.ajax({
        url: 'manage_position.php',
        type: 'POST',
        data: formData,
        processData: false, // Prevent jQuery from processing the data
        contentType: false, // Prevent jQuery from setting the content-type
        dataType: 'json', // Ensure response is JSON
        success: function(response){
            if(response.status == 'success'){
                toastr.success(response.message);
                $('#add-user').modal('hide'); // Close the modal on success
                window.location.reload();
            } else {
                toastr.error(response.message);
            }
        },
        error: function(xhr, status, error){
            console.log(xhr.responseText); // Log the actual response for debugging
            toastr.error('An error occurred while adding the user.');
        }
    });
});
</script>
</html>