<?php include 'includes/session.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

include 'includes/db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['deleteUser'])) {
    header('Content-Type: application/json');
    $userId = $_POST['id'];

    // Assuming you have established a PDO connection as $conn
    try {
        $query = "DELETE FROM position_master WHERE id = :id";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':id', $userId);

        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'User deleted successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to delete user.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['createUser'])) {
header('Content-Type: application/json');
    
    // Collect the form data
    $name = $_POST['name'];

    // Prepare the SQL insert statement, including profile_pic
    $sql = "INSERT INTO position_master (name) 
            VALUES (:name)";

    try {
        // Prepare statement using PDO
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':name', $name);

        // Execute the statement
        $stmt->execute();

        // Send success response
        echo json_encode([
            'status' => 'success',
            'message' => 'Position created successfully!'
        ]);
    } catch (PDOException $e) {
        // Send error response
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to add position. Please try again.'
        ]);
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['updateUser'])) {
    $userId = $_POST['userId']; // Get the user ID from the request
    $name = $_POST['name'];
    // Perform validation (you can add your validation logic here)
    
    try {
        // Assuming $conn is your PDO connection
        $query = "UPDATE position_master SET name = :name WHERE id = :userId";
        
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':userId', $userId);
        
        if ($stmt->execute()) {
            echo "<script>
                    alert('Position updated successfully.');
                    window.location.href='positions.php';
                  </script>";
            // echo json_encode(['status' => 'success', 'message' => 'User updated successfully.']);
        } else {
            echo "<script>
                    alert('Failed to update position.');
                    window.location.href='positions.php';
                  </script>";
            // echo json_encode(['status' => 'error', 'message' => 'Failed to update user.']);
        }
    } catch (PDOException $e) {
        echo "<script>alert('Error: " . $e->getMessage() . "')</script>";
        // echo json_encode(['status' => 'error', 'message' => 'Error occurred: ' . $e->getMessage()]);
    }
}


?>
