<?php 
include 'includes/session.php'; 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'includes/db.php'; // Database connection

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $employee_code = $_POST['employee_code'];
    $category_id = $_POST['category_id'];
    $target = $_POST['target'];
    $month = $_POST['month'];
    
    $assigned_by = $_POST['assign_by']; // Assuming you have the logged-in admin's ID in the session
    $assigned_at = date('Y-m-d H:i:s');

    try {
        // Insert into EmployeeTarget table
        $stmt = $conn->prepare("INSERT INTO EmployeeTarget (employee_code, category_id, target,month, assigned_by, assigned_at) 
                                VALUES (:employee_code, :category_id, :target, :month, :assigned_by, :assigned_at)");
        
        // Bind parameters
        $stmt->bindParam(':employee_code', $employee_code);
        $stmt->bindParam(':category_id', $category_id);
        $stmt->bindParam(':target', $target, PDO::PARAM_STR);
        $stmt->bindParam(':month', $month, PDO::PARAM_INT);
        $stmt->bindParam(':assigned_by', $assigned_by);
        $stmt->bindParam(':assigned_at', $assigned_at);

        // Execute the statement
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Target assigned successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to assign the target.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
