<?php
include 'includes/db.php'; // Include your database connection

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $employee_code = trim($_POST['employee_code']);
    $personal_mobile_no = trim($_POST['personal_mobile_no']);

    // Validate inputs
    if (empty($employee_code) || empty($personal_mobile_no)) {
        echo json_encode(['status' => 'error', 'message' => 'Employee Code and Mobile Number are required.']);
        exit();
    }

    // Check credentials
    $stmt = $conn->prepare("SELECT * FROM Employees WHERE employee_code = :employee_code AND personal_mobile_no = :personal_mobile_no");
    $stmt->execute([
        ':employee_code' => $employee_code,
        ':personal_mobile_no' => $personal_mobile_no
    ]);
    $employee = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($employee) {
        // Start a session for the employee
        session_start();
        $_SESSION['employee_id'] = $employee['employee_code'];
        $_SESSION['employee_name'] = $employee['employee_name'];
        $_SESSION['designation'] = $employee['designation'];
        $_SESSION['department_name'] = $employee['department_name'];
        $_SESSION['personal_mobile_no'] = $employee['personal_mobile_no'];
       $_SESSION['store_name'] = $employee['store_name'];
        $_SESSION['role'] = 'Employee';
        

        echo json_encode(['status' => 'success', 'redirect' => 'dashboard.php']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid Employee Code or Mobile Number.']);
    }
    exit();
}
?>
