<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | South Goa Sightseeing</title>
     
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">South Goa Sightseeing</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>South Goa Sightseeing</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->
        
        <!-- SECTION START -->
        <div class="section-full p-t120 p-b90">
            <div class="container">
                <!-- SECTION START -->
                <div class="section-content">
                    <div class="row d-flex justify-content-center">
        
                        <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                            <div class="trv-detail-main-wrap">
                                <!--Info Start-->
                                <div class="trv-detail-bx-wrap"> 
                                    <div class="trv-inr-para2">
                                        <div class="trv-sep-rating">
                                            <div class="trv-rating">
                                                <span>(4.8 Review)</span>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                        <h3 class="trv-inner-title-lg">South Goa Sightseeing Tour</h3>
                                        <span class="trv-packege-esti-time">Dream Vacations - Explore South Goa's Best Destinations</span>
        
                                                        <!--Top SLider-->
                                <div class="trv-detail-slider">
                                    <div class="swiper trv_d-slider">
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/ss1.webp" alt="Fort Aguada">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/ss2.webp" alt="Baga Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/ss3.webp" alt="Chapora Fort">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/ss4.webp" alt="Anjuna Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/ss5.webp" alt="Vagator Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/ss6.webp" alt="Saligao Church">   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <!--Top SLider End-->
        
                                        <!-- Navigation -->
                                        <nav class="navbar-one">
                                            <a href="#overview">Package Overview</a>
                                            <a href="#destinations">Destinations</a>
                                            <a href="#inclusions">Inclusions / Exclusions</a>
                                        </nav>
        
                                        <!-- Over View-->
                                        <section id="overview">
                                            <h3 class="trv-inner-title-sm">South Goa Sightseeing Tour Package Overview</h3>
                                            <p>Experience the cultural and spiritual side of Goa with our comprehensive South Goa Sightseeing Tour. Visit ancient temples, historic churches, beautiful beaches, and explore the rich heritage of South Goa with our guided tour.</p>
        
                                            <h4 class="trv-inner-title-sm mt-4">Tour Highlights:</h4>
                                            <ul class="trv-checklist-st1">
                                                <li>
                                                    <i class="bi bi-check-circle-fill"></i>
                                                    <strong>Complete South Goa Tour</strong> - Covering all major attractions
                                                </li>
                                                <li>
                                                    <i class="bi bi-check-circle-fill"></i>
                                                    <strong>Cultural & Spiritual Experience</strong> - Temples & Churches
                                                </li>
                                                <li>
                                                    <i class="bi bi-check-circle-fill"></i>
                                                    <strong>Professional Guided Tour</strong> - English & Hindi speaking guide
                                                </li>
                                                <li>
                                                    <i class="bi bi-check-circle-fill"></i>
                                                    <strong>Comfortable AC Transport</strong> - 40 Seater bus
                                                </li>
                                                <li>
                                                    <i class="bi bi-check-circle-fill"></i>
                                                    <strong>Optional Upgrades</strong> - Sunset Cruise & Dolphin Trip
                                                </li>
                                            </ul>
                                        </section>
        
                                        <!-- Destinations-->
                                        <section id="destinations">
                                            <h3 class="trv-inner-title-sm">Destinations Covered</h3>
                                            
                                            <div class="trv-clist-st-3-wrap">
                                                <ul class="trv-list-st-3">
                                                    <li>
                                                        <div class="trv-list-content">
                                                            <div class="duration">
                                                                <div class="media">
                                                                    <div class="green-bg">1</div>
                                                                </div>
                                                                <span class="day">STOP</span>
                                                            </div>
                                                            <div class="info">
                                                                <h4 class="trv-title">Dona Paula Beach & Viewpoint</h4>
                                                                <p>Famous viewpoint offering panoramic views of the Arabian Sea and Mormugao Harbour. Perfect for photography and enjoying sea breeze.</p>
                                                                <div class="trv-blog-d-column-wrap mt-3">
                                                                    <div class="row">
                                                                        <div class="col-lg-6 col-md-6 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/dp-1.webp" alt="Dona Paula">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-6 col-md-6 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/dp-2.webp" alt="Viewpoint">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="trv-list-content">
                                                            <div class="duration">
                                                                <div class="media">
                                                                    <div class="green-bg">2</div>
                                                                </div>
                                                                <span class="day">STOP</span>
                                                            </div>
                                                            <div class="info">
                                                                <h4 class="trv-title">Shri Mangeshi Temple</h4>
                                                                <p>One of the largest and most famous Hindu temples in Goa dedicated to Lord Shiva. Experience the spiritual atmosphere and architecture.</p>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="trv-list-content">
                                                            <div class="duration">
                                                                <div class="media">
                                                                    <div class="green-bg">3</div>
                                                                </div>
                                                                <span class="day">STOP</span>
                                                            </div>
                                                            <div class="info">
                                                                <h4 class="trv-title">Miramar Beach</h4>
                                                                <p>Beautiful beach located at the confluence of the Mandovi River and Arabian Sea. Perfect for a relaxing break during the tour.</p>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="trv-list-content">
                                                            <div class="duration">
                                                                <div class="media">
                                                                    <div class="green-bg">4</div>
                                                                </div>
                                                                <span class="day">STOP</span>
                                                            </div>
                                                            <div class="info">
                                                                <h4 class="trv-title">Panjim Church (Our Lady of Immaculate Conception)</h4>
                                                                <p>Historic church with Portuguese architecture located in the heart of Panaji. Famous for its magnificent staircase and serene ambiance.</p>
                                                                <div class="trv-blog-d-column-wrap mt-3">
                                                                    <div class="row">
                                                                        <div class="col-lg-4 col-md-4 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/pc-1.webp" alt="Panjim Church">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-4 col-md-4 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/pc-2.webp" alt="Church Interior">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-4 col-md-4 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/pc-3.webp" alt="Architecture">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="trv-list-content">
                                                            <div class="duration">
                                                                <div class="media">
                                                                    <div class="green-bg">5</div>
                                                                </div>
                                                                <span class="day">STOP</span>
                                                            </div>
                                                            <div class="info">
                                                                <h4 class="trv-title">Old Goa Churches (Basilica of Bom Jesus & Se Cathedral)</h4>
                                                                <p>UNESCO World Heritage Sites. Visit the Basilica of Bom Jesus which houses the mortal remains of St. Francis Xavier.</p>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="trv-list-content">
                                                            <div class="duration">
                                                                <div class="media">
                                                                    <div class="green-bg">6</div>
                                                                </div>
                                                                <span class="day">STOP</span>
                                                            </div>
                                                            <div class="info">
                                                                <h4 class="trv-title">Shri Shantadurga Balaji Temple</h4>
                                                                <p>Beautiful temple dedicated to Goddess Shantadurga, known for its peaceful environment and stunning architecture.</p>
                                                                <div class="trv-blog-d-column-wrap mt-3">
                                                                    <div class="row">
                                                                        <div class="col-lg-4 col-md-4 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/ssbt-1.webp" alt="Balaji Temple">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-4 col-md-4 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/ssbt-2.webp" alt="Temple Architecture">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-4 col-md-4 m-b20">
                                                                            <div class="trv-blog-d-column-bx">
                                                                                <img src="img/ssbt-3.webp" alt="Spiritual">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </section>
        
                                        <!-- Inclusion/Exclusions-->
                                        <section id="inclusions">
                                            <div class="trv-checklist-st2-mini-wrap">
                                                <div class="row">
                                                    <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-l">
                                                        <h3 class="trv-inner-title-sm">Package Inclusions</h3>
                                                        <ul class="trv-checklist-st2-mini">
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>Pick-up & Drop</strong> - From your hotel
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>AC Transport</strong> - 40 Seater comfortable bus
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>Tour Guide</strong> - English & Hindi speaking
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>All Destinations Covered</strong> - Complete itinerary
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>Dona Paula Beach</strong> - Visit & photography
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>Mangeshi Temple</strong> - Spiritual experience
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>Panjim Church</strong> - Historic site visit
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-check-circle-fill"></i>
                                                                <strong>Miramar Beach</strong> - Relaxation stop
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-r">
                                                        <h3 class="trv-inner-title-sm">Optional / Extra Charge</h3>
                                                        <ul class="trv-checklist-st2-mini trv-list-disable">
                                                            <li>
                                                                <i class="bi bi-plus-circle"></i>
                                                                <strong>Sunset Cruise</strong> - Additional charge
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-plus-circle"></i>
                                                                <strong>Dolphin Trip</strong> - Additional charge
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-x-circle-fill"></i>
                                                                Meals & Drinks (Not included)
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-x-circle-fill"></i>
                                                                Personal shopping
                                                            </li>
                                                            <li>
                                                                <i class="bi bi-x-circle-fill"></i>
                                                                Temple/Church entry fees (if any)
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </section>
        
                                    </div>
                                </div>
                            </div> 
                        </div> 
        
                        <!-- SIDE BAR START -->
                        <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar m-b30">
                            <aside class="side-bar">
                                <div class="trv-tour-single-r-detail">
                                    <span class="trv-star-from">Starting from</span>
                                    <span class="trv-star-amount">
                                        <s>$99</s> ₹499
                                    </span>
                                    <span class="trv-star-from-person">/ Person</span>
                                    <div class="trv-emi_text">
                                        <i class="bi bi-wallet"></i>No Cost EMI Starts from
                                        <span class="trvng-binding"> ₹<span class="trvng-binding">49</span></span> 
                                        <a class="chsemi" href="javascript:;">See option</a>
                                    </div>
                                    <button type="button" class="site-button butn-bg-shape" onclick="sendWhatsAppEnquiry()">
                                        <i class="bi bi-whatsapp"></i> Enquiry Now
                                    </button>
                                </div>
        
                                <div class="trv-tour-single-r-info">
                                    <div class="trv-main-rg-hol">
                                        <div class="trv-man-sec-hol">
                                            <ul>
                                                <li>
                                                    <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Duration : </span>
                                                    <span class="ng-binding">Full Day Tour</span>
                                                </li>
                                                <li>
                                                    <span  class="trv-tmi-hlo"><i class="bi bi-geo-alt"></i> Coverage :</span>
                                                    <span class="trv-tmi-hlo-info">South Goa Major Attractions</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="trv-oack-sepa"><span class="lay"> Package Includes</span></div>
                                        
                                        <div class="trv-icon-man-holids">
                                            <ul>
                                                <li>
                                                    <div class="trv-holids-icon">
                                                        <img src="images/holi-icon/hotels.png" alt="Transport">
                                                    </div>
                                                    <div class="trv-holids-name">Transport</div>
                                                </li>
                                                <li>
                                                    <div class="trv-holids-icon">
                                                        <img src="images/holi-icon/Sightseeing.png" alt="Sightseeing">
                                                    </div>
                                                    <div class="trv-holids-name">Sightseeing</div>
                                                </li>
                                                <li>
                                                    <div class="trv-holids-icon">
                                                        <img src="images/holi-icon/car.png" alt="Pickup">
                                                    </div>
                                                    <div class="trv-holids-name">Pickup/Drop</div>
                                                </li>
                                                
                                            </ul>
                                        </div>
                                        
                                        <div class="trv-booking-notes mt-4">
                                            <h5 class="trv-inner-title-sm">Destinations Covered:</h5>
                                            <ul class="trv-checklist-mini">
                                                <li><i class="bi bi-check-circle"></i> Dona Paula Beach</li>
                                                <li><i class="bi bi-check-circle"></i> Mangeshi Temple</li>
                                                <li><i class="bi bi-check-circle"></i> Miramar Beach</li>
                                                <li><i class="bi bi-check-circle"></i> Panjim Church</li>
                                                <li><i class="bi bi-check-circle"></i> Old Goa Church</li>
                                                <li><i class="bi bi-check-circle"></i> Balaji Temple</li>
                                            </ul>
                                        </div>
        
                                        <div class="trv-booking-notes mt-4">
                                            <h5 class="trv-inner-title-sm">Optional Activities:</h5>
                                            <ul class="trv-checklist-mini">
                                                <li><i class="bi bi-plus-circle"></i> Sunset Cruise (Extra Charge)</li>
                                                <li><i class="bi bi-plus-circle"></i> Dolphin Trip (Extra Charge)</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </aside>
                        </div>
                        <!-- SIDE BAR END -->
                    </div>
                </div>
            </div>
        </div>
        <!-- SECTION END -->

<script>
// WhatsApp Enquiry Function
function sendWhatsAppEnquiry() {
    const whatsappNumber = "8906666657";
    const message = `🎯 *SOUTH GOA SIGHTSEEING TOUR BOOKING* 🎯
    
🏖️ *Package:* South Goa Sightseeing Tour
💰 *Price:* ₹499 Per Person
⏰ *Duration:* Full Day Tour

📍 *Destinations Covered:*
✅ Dona Paula Beach
✅ Mangeshi Temple
✅ Miramar Beach
✅ Panjim Church
✅ Old Goa Church
✅ Balaji Temple

📋 *Package Includes:*
✅ Pick-up & Drop from Hotel
✅ AC Transport (40 Seater)
✅ English/Hindi Tour Guide
✅ All Destination Entries

🎯 *Optional Activities:*
🔹 Sunset Cruise (Extra Charge)
🔹 Dolphin Trip (Extra Charge)

👤 *My Details:*
Name: ______
Travel Date: ______
Number of Persons: ______
Contact Number: ______

Please confirm availability and booking procedure.`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappURL, '_blank');
}

// Initialize Swiper Slider
document.addEventListener('DOMContentLoaded', function() {
    if(document.querySelector('.trv_d-slider')) {
        const swiper = new Swiper('.trv_d-slider', {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            loop: true,
        });
    }
});
</script>

    </div>
    <!-- CONTENT END -->
</div>


<?php include 'footer.php'; ?>