<!DOCTYPE html>
<html lang="en">
<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | South Goa  </title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">South Goa  </h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>South Goa  </li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

        <!-- SECTION START -->
        <div class="section-full  p-t120 p-b90">
            <div class="container">
            
                <!-- BLOG SECTION START -->
                <div class="section-content">
                    <div class="row d-flex justify-content-center">
        
                        <!-- SIDE BAR START -->
                        <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar  m-b30">
                        
                            <aside class="side-bar-filter">
        
                                <!--Left Search Filter -->
                                <div class="styleswitcher">
                                    
                                    <div class="styleswitcher-inner ">
                                        <div class="twm-side-filter-form">
                                            <form id="tourFilterForm">
        
                                                <div class="twm-sidebar-ele-filter">
        
                                                    <div class="trv-fliter-bx">
                                                        <h4 class="section-head-small mb-4">Search Tour</h4>
                                                        <div class="search-bx-filter">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="tourSearch" placeholder="Search tours...">
                                                                <span class="input-group-btn">
                                                                    <button type="button" class="btn" id="searchBtn"><i class="fa fa-search"></i></button>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                
                                                    <div class="trv-fliter-bx">
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group">
                                                                <label>Location</label>
                                                                <select class="form-control" id="locationFilter">
                                                                    <option value="all" selected>Select Beach</option>
                                                                    <option value="colva">Colva Beach</option>
                                                                    <option value="palolem">Palolem Beach</option>
                                                                    <option value="agonda">Agonda Beach</option>
                                                                    <option value="benaulim">Benaulim Beach</option>
                                                                    <option value="butterfly">Butterfly Beach</option>
                                                                    <option value="majorda">Majorda Beach</option>
                                                                    <option value="betalbatim">Betalbatim Beach</option>
                                                                    <option value="varca">Varca Beach</option>
                                                                    <option value="mobor">Mobor Beach</option>
                                                                    <option value="cavelossim">Cavelossim Beach</option>
                                                                </select>
                                                            </div>
                                                        </div>
        
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group">
                                                                <label>Tour Type</label>
                                                                <select class="form-control" id="tourTypeFilter">
                                                                    <option value="all" selected>Select Tour Type</option>
                                                                    <option value="beach">Beach Tour</option>
                                                                    <option value="adventure">Adventure</option>
                                                                    <option value="honeymoon">Honeymoon</option>
                                                                    <option value="family">Family Package</option>
                                                                    <option value="cultural">Cultural</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group twm-input-with-icon">
                                                                <label>Duration (Nights)</label>
                                                                <select class="form-control" id="durationFilter">
                                                                    <option value="all" selected>Select Duration</option>
                                                                    <option value="1">1 Night</option>
                                                                    <option value="2">2 Nights</option>
                                                                    <option value="3">3 Nights</option>
                                                                    <option value="4">4 Nights</option>
                                                                    <option value="5">5+ Nights</option>
                                                                </select>
                                                            </div>
                                                        </div>
        
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group form-group-2column-wrap twm-input-with-icon">
                                                                <label>Price Range</label>
                                                                <select class="form-control" id="priceFilter">
                                                                    <option value="all" selected>Select Price Range</option>
                                                                    <option value="0-5000">Under ₹5,000</option>
                                                                    <option value="5000-10000">₹5,000 - ₹10,000</option>
                                                                    <option value="10000-15000">₹10,000 - ₹15,000</option>
                                                                    <option value="15000-20000">₹15,000 - ₹20,000</option>
                                                                    <option value="20000+">Above ₹20,000</option>
                                                                </select>
                                                            </div>
                                                        </div>
        
                                                    </div>
        
                                                    <div class="trv-fliter-bx">
                                                        <h4 class="section-head-small mb-4">Tour Inclusions</h4>
                                                        <ul>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input inclusion-filter" id="inc01" value="transport">
                                                                    <label class="form-check-label" for="inc01">Transport</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input inclusion-filter" id="inc02" value="meals">
                                                                    <label class="form-check-label" for="inc02">Meals</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input inclusion-filter" id="inc03" value="accommodation">
                                                                    <label class="form-check-label" for="inc03">Accommodation</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input inclusion-filter" id="inc04" value="guide">
                                                                    <label class="form-check-label" for="inc04">Guide</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input inclusion-filter" id="inc05" value="activities">
                                                                    <label class="form-check-label" for="inc05">Activities</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
        
                                                </div>
        
                                                <div class="twm-side-filter-aply-btn text-center">
                                                    <button type="button" id="applyFilters" class="site-button butn-bg-shape">Apply Filter</button>
                                                    <button type="button" id="filterReset" class="site-button outline mx-2">Reset All</button>
                                                </div>
                                            </form>
                                            <!-- Removed advertisement image -->
                                            
                                        </div>
                                    </div>    
                                </div>
                                <!--Left Search Filter -->
        
                            </aside>
        
                        </div>
                        <!-- SIDE BAR END --> 
                    
                        <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                            <div class="row" id="tourContainer">
                                <!--BOX-1: Colva Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="colva" data-type="beach" data-duration="3" data-price="8500" data-inclusions="transport,meals,accommodation,guide">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Colva-Beach.webp" alt="Colva Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>3 days, 2 Nights</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Colva Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹8,500</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Longest beach in South Goa with water sports, shacks & vibrant nightlife</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Colva Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.5 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-2: Palolem Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="palolem" data-type="beach" data-duration="2" data-price="6500" data-inclusions="transport,meals,accommodation,activities">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Palolem-Beach.webp" alt="Palolem Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>2 days, 1 Night</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Palolem Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹6,500</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Crescent-shaped beauty with dolphin spotting & beach hut stays</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Palolem Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.7 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-half"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-3: Agonda Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="agonda" data-type="honeymoon" data-duration="4" data-price="12500" data-inclusions="transport,meals,accommodation,guide,activities">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Agonda-Beach.webp" alt="Agonda Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>4 days, 3 Nights</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Agonda Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹12,500</span>
                                                    <span class="price-duration">Per Couple</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Serene & peaceful beach perfect for honeymooners and relaxation</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Agonda Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.9 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-4: Benaulim Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="benaulim" data-type="cultural" data-duration="3" data-price="7500" data-inclusions="transport,meals,accommodation">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Benaulim-Beach.webp" alt="Benaulim Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>3 days, 2 Nights</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Benaulim Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹7,500</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Local fishing village experience & water sports activities</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Benaulim Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.6 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-half"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-5: Butterfly Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="butterfly" data-type="adventure" data-duration="1" data-price="3500" data-inclusions="transport,activities">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/butterfly-beach.webp" alt="Butterfly Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>1 day tour</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Butterfly Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹3,500</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Boat tour to secluded beach with butterfly & dolphin sightings</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Butterfly Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.8 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-half"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-6: Majorda Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="majorda" data-type="family" data-duration="5" data-price="18500" data-inclusions="transport,meals,accommodation,guide,activities">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Majorda-Beach.webp" alt="Majorda Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>5 days, 4 Nights</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Majorda Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹18,500</span>
                                                    <span class="price-duration">Family Package</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Luxury beach resorts & fine dining experience for families</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Majorda Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.7 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-half"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-7: Betalbatim Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="betalbatim" data-type="beach" data-duration="2" data-price="5500" data-inclusions="transport,meals">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/bb-beach.webp" alt="Betalbatim Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>2 days, 1 Night</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Betalbatim Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹5,500</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Secluded beach with pine trees, perfect for sunbathing</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Betalbatim Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.4 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-8: Varca Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="varca" data-type="adventure" data-duration="3" data-price="9500" data-inclusions="transport,meals,accommodation,activities">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Varca-Beach.webp" alt="Varca Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>3 days, 2 Nights</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Varca Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹9,500</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">White sand beach with luxury resorts & adventure sports</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Varca Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.8 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-half"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-9: Mobor Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="mobor" data-type="beach" data-duration="2" data-price="6800" data-inclusions="transport,meals,accommodation">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Mobor-Beach.webp" alt="Mobor Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>2 days, 1 Night</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Mobor Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹6,800</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Water sports paradise at the confluence of river and sea</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Mobor Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.6 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--BOX-10: Cavelossim Beach-->
                                <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="cavelossim" data-type="cultural" data-duration="3" data-price="8200" data-inclusions="transport,meals,guide">
                                    <div class="trv-popular-tour-st1">
                                        <div class="trv-media">
                                            <a href="javascript:void(0);"><img src="img/Cavelossim-Beach.webp" alt="Cavelossim Beach"></a>
                                            <div class="trv-tour-duration">
                                                <i class="bi bi-calendar2-week"></i>
                                                <span>3 days, 2 Nights</span>
                                            </div>
                                            <div class="trv-tour-title">
                                                <h3 class="trv-title">
                                                    <a href="javascript:void(0);">
                                                        <i class="bi bi-geo-alt"></i>
                                                        Cavelossim Beach Tour
                                                    </a>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="trv-content">
                                            <div class="trv-content-head-section">
                                                <div class="trv-tour-price">
                                                    <span class="price">₹8,200</span>
                                                    <span class="price-duration">Per Person</span>
                                                </div>
                                                <div class="trv-tour-info">
                                                    <a href="javascript:void(0);">Unique black lava rocks & river cruise cultural experience</a>
                                                </div>
                                            </div>
                                            <div class="trv-content-bottom-section">
                                                <div class="trv-book">
                                                    <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Cavelossim Beach">Book Now</a>
                                                </div>
                                                <div class="trv-tour-rating">
                                                    <span class="trv-tour-review-count">(4.5 Review)</span>
                                                    <div class="trv-review-rating">
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-fill"></i>
                                                        <i class="bi bi-star-half"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="no-results" style="display: none; text-align: center; padding: 40px;">
                                <h3>No tours found matching your filters</h3>
                                <p>Try adjusting your search criteria</p>
                            </div>
                            <ul class="custom-pagination clearfix">
                                <li class="prev"><a href="javascript:void(0);"><span class="bi bi-chevron-left"></span></a></li>
                                <li><a href="javascript:void(0);">1</a></li>
                                <li><a href="javascript:void(0);">2</a></li>
                                <li><a href="javascript:void(0);">3</a></li>
                                <li><a href="javascript:void(0);">...</a></li>
                                <li class="next"><a href="javascript:void(0);"><span class="bi bi-chevron-right"></span></a></li>
                            </ul>
                        </div> 
                
                    </div>
        
                </div>
                
            </div>
            
        </div>   
        <!-- SECTION END -->

<script>
// WhatsApp Enquiry Function
function sendWhatsAppEnquiry(beachName) {
    const whatsappNumber = "8906666657";
    const message = `✈️ Goa Travel Enquiry%0A🏖️ Beach Package: ${beachName}%0A📅 Interested in: South Goa Beach Tour%0A👥 Travellers: 2%0A💰 Budget: As per package%0A_Sent via GoaReddy South Goa  _`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${message}`;
    window.open(whatsappURL, '_blank');
}

// Add event listeners to all Book Now buttons
document.querySelectorAll('.book-now-btn').forEach(button => {
    button.addEventListener('click', function(e) {
        e.preventDefault();
        const beachName = this.getAttribute('data-beach');
        sendWhatsAppEnquiry(beachName);
    });
});

// Filter Functionality
document.addEventListener('DOMContentLoaded', function() {
    const tourItems = document.querySelectorAll('.tour-item');
    const locationFilter = document.getElementById('locationFilter');
    const tourTypeFilter = document.getElementById('tourTypeFilter');
    const durationFilter = document.getElementById('durationFilter');
    const priceFilter = document.getElementById('priceFilter');
    const inclusionCheckboxes = document.querySelectorAll('.inclusion-filter');
    const applyFiltersBtn = document.getElementById('applyFilters');
    const filterResetBtn = document.getElementById('filterReset');
    const tourSearch = document.getElementById('tourSearch');
    const searchBtn = document.getElementById('searchBtn');
    const noResults = document.querySelector('.no-results');

    // Show all tours initially
    function showAllTours() {
        tourItems.forEach(item => {
            item.style.display = 'block';
        });
        noResults.style.display = 'none';
    }

    // Filter Tours Function
    function filterTours() {
        const locationValue = locationFilter.value;
        const tourTypeValue = tourTypeFilter.value;
        const durationValue = durationFilter.value;
        const priceValue = priceFilter.value;
        const searchTerm = tourSearch.value.toLowerCase().trim();
        
        // Get selected inclusions
        const selectedInclusions = [];
        inclusionCheckboxes.forEach(cb => {
            if (cb.checked) selectedInclusions.push(cb.value);
        });

        let visibleCount = 0;

        tourItems.forEach(item => {
            const location = item.getAttribute('data-location');
            const type = item.getAttribute('data-type');
            const duration = parseInt(item.getAttribute('data-duration'));
            const price = parseInt(item.getAttribute('data-price'));
            const inclusions = item.getAttribute('data-inclusions').split(',');
            
            // Get text content for search
            const title = item.querySelector('.trv-title a').textContent.toLowerCase();
            const description = item.querySelector('.trv-tour-info a').textContent.toLowerCase();
            
            // Check location filter
            const locationMatch = locationValue === 'all' || location === locationValue;
            
            // Check tour type filter
            const typeMatch = tourTypeValue === 'all' || type === tourTypeValue;
            
            // Check duration filter
            let durationMatch = true;
            if (durationValue !== 'all') {
                const durationNum = parseInt(durationValue);
                if (durationNum === 5) {
                    durationMatch = duration >= 5;
                } else {
                    durationMatch = duration === durationNum;
                }
            }
            
            // Check price filter
            let priceMatch = true;
            if (priceValue !== 'all') {
                if (priceValue === '0-5000') priceMatch = price <= 5000;
                else if (priceValue === '5000-10000') priceMatch = price > 5000 && price <= 10000;
                else if (priceValue === '10000-15000') priceMatch = price > 10000 && price <= 15000;
                else if (priceValue === '15000-20000') priceMatch = price > 15000 && price <= 20000;
                else if (priceValue === '20000+') priceMatch = price > 20000;
            }
            
            // Check search term
            let searchMatch = true;
            if (searchTerm !== '') {
                searchMatch = title.includes(searchTerm) || description.includes(searchTerm);
            }
            
            // Check inclusions
            let inclusionMatch = true;
            if (selectedInclusions.length > 0) {
                inclusionMatch = selectedInclusions.every(inc => inclusions.includes(inc));
            }
            
            // Show/hide based on all filters
            if (locationMatch && typeMatch && durationMatch && priceMatch && searchMatch && inclusionMatch) {
                item.style.display = 'block';
                visibleCount++;
            } else {
                item.style.display = 'none';
            }
        });

        // Show/hide no results message
        if (visibleCount === 0) {
            noResults.style.display = 'block';
        } else {
            noResults.style.display = 'none';
        }
    }

    // Search functionality
    searchBtn.addEventListener('click', filterTours);
    tourSearch.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            filterTours();
        }
    });

    // Apply filters button
    applyFiltersBtn.addEventListener('click', filterTours);

    // Reset filters button
    filterResetBtn.addEventListener('click', function() {
        locationFilter.value = 'all';
        tourTypeFilter.value = 'all';
        durationFilter.value = 'all';
        priceFilter.value = 'all';
        tourSearch.value = '';
        
        inclusionCheckboxes.forEach(cb => {
            cb.checked = false;
        });
        
        showAllTours();
    });

    // Initialize - show all tours
    showAllTours();
});
</script>
        
        
        <?php include 'enquiry-form.php'; ?> 
    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>