<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | North Goa Sightseeing</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">North Goa Sightseeing</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>North Goa Sightseeing</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->
        
        <!-- SECTION START -->
<div class="section-full p-t120 p-b90">
    <div class="container">
        <!-- SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                    <div class="trv-detail-main-wrap">
                        <!--Info Start-->
                        <div class="trv-detail-bx-wrap">
                            <div class="trv-inr-para2">
                                <div class="trv-sep-rating">
                                    <div class="trv-rating">
                                        <span>(4.8 Review)</span>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                    </div>
                                </div>
                                <h3 class="trv-inner-title-lg">North Goa Sightseeing Tour</h3>
                                <span class="trv-packege-esti-time">Becal Family Resort - Explore North Goa's Best Attractions</span>

                                <!--Top SLider-->
                                <div class="trv-detail-slider">
                                    <div class="swiper trv_d-slider">
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss2.webp" alt="Fort Aguada">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss1.webp" alt="Baga Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss3.webp" alt="Chapora Fort">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss4.webp" alt="Anjuna Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss5.webp" alt="Vagator Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss6.webp" alt="Saligao Church">   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <!--Top SLider End-->

                                <!-- Navigation -->
                                <nav class="navbar-one">
                                    <a href="#overview">Package Overview</a>
                                    <a href="#destinations">Destinations</a>
                                    <a href="#inclusions">Inclusions / Exclusions</a>
                                </nav>

                                <!-- Over View-->
                                <section id="overview">
                                    <h3 class="trv-inner-title-sm">North Goa Sightseeing Tour Package Overview</h3>
                                    <p>Discover the vibrant and lively side of Goa with our North Goa Sightseeing Tour. From historic forts and beautiful beaches to famous churches and buzzing markets, experience everything that makes North Goa a tourist paradise.</p>

                                    <h4 class="trv-inner-title-sm mt-4">Tour Highlights:</h4>
                                    <ul class="trv-checklist-st1">
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Complete North Goa Coverage</strong> - All major attractions
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Historic Forts & Beaches</strong> - Portuguese heritage & coastline
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Expert Guided Tour</strong> - Knowledgeable tour guide
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Comfortable AC Transport</strong> - 40 Seater bus
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Optional Entertainment</strong> - Snow Park & Thunder World
                                        </li>
                                    </ul>
                                </section>

                                <!-- Destinations-->
                                <section id="destinations">
                                    <h3 class="trv-inner-title-sm">Destinations Covered</h3>
                                    
                                    <div class="trv-clist-st-3-wrap">
                                        <ul class="trv-list-st-3">
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">1</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Fort Aguada</h4>
                                                        <p>17th-century Portuguese fort with a lighthouse offering panoramic views of the Arabian Sea. One of the largest and best-preserved forts in Goa.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/fa-1.webp" alt="Fort Aguada">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/fa-2.webp" alt="Lighthouse">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">2</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Sinquerim Fort</h4>
                                                        <p>Historic fort located near Candolim Beach, known for its strategic location and beautiful views of the coastline.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">3</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Baga Beach</h4>
                                                        <p>Most popular beach in North Goa known for its vibrant nightlife, water sports, beach shacks, and lively atmosphere.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">4</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Anjuna Beach</h4>
                                                        <p>Famous for its Wednesday flea market, rocky shoreline, and hippie culture. Enjoy the unique vibe and scenic beauty.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ab-1.webp" alt="Anjuna Beach">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ab-2.webp" alt="Flea Market">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ab-3.webp" alt="Rocky Shore">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">5</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Vagator Beach</h4>
                                                        <p>Known for its dramatic red cliffs, two beautiful bays (Big Vagator and Little Vagator), and stunning sunset views.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">6</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Chapora Fort (Dil Chahta Hai Fort)</h4>
                                                        <p>Made famous by Bollywood movie "Dil Chahta Hai". Offers breathtaking views of Vagator Beach and Chapora River.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg">7</div>
                                                        </div>
                                                        <span class="day">STOP</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Saligao Church (Our Lady of Rosary)</h4>
                                                        <p>Beautiful white-washed church known for its unique architecture and peaceful surroundings in the village of Saligao.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/sc-goa.webp" alt="Saligao Church">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/sc-goa-1.webp" alt="Church Interior">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/sc-goa-2.webp" alt="Architecture">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </section>

                                <!-- Inclusion/Exclusions-->
                                <section id="inclusions">
                                    <div class="trv-checklist-st2-mini-wrap">
                                        <div class="row">
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-l">
                                                <h3 class="trv-inner-title-sm">PACKAGE INCLUSION</h3>
                                                <ul class="trv-checklist-st2-mini">
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Pick-up & Drop</strong> - Near your hotel
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>AC Transport</strong> - 40 Seater comfortable bus
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Expert Tour Guide</strong> - Knowledgeable guide
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>All Destinations Covered</strong> - Complete itinerary
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Fort Aguada</strong> - Visit & photography
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Sinquerim Fort</strong> - Historical site
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Beach Visits</strong> - Baga, Anjuna, Vagator
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Chapora Fort</strong> - Famous movie location
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-r">
                                                <h3 class="trv-inner-title-sm">Optional / Extra Charge</h3>
                                                <ul class="trv-checklist-st2-mini trv-list-disable">
                                                    <li>
                                                        <i class="bi bi-plus-circle"></i>
                                                        <strong>Snow Park</strong> - Additional charge
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-plus-circle"></i>
                                                        <strong>Thunder World</strong> - Additional charge
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Meals & Drinks (Not included)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Water sports activities
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Personal shopping
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </section>

                            </div>
                        </div>
                    </div> 
                </div> 

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar m-b30">
                    <aside class="side-bar">
                        <div class="trv-tour-single-r-detail">
                            <span class="trv-star-from">Starting from</span>
                            <span class="trv-star-amount">
                                <s>$99</s> ₹499
                            </span>
                            <span class="trv-star-from-person">/ Per Person</span>
                            <div class="trv-emi_text">
                                <i class="bi bi-wallet"></i>No Cost EMI Starts from
                                <span class="trvng-binding"> ₹<span class="trvng-binding">49</span></span> 
                                <a class="chsemi" href="javascript:;">See option</a>
                            </div>
                            <button type="button" class="site-button butn-bg-shape" onclick="sendWhatsAppEnquiry()">
                                <i class="bi bi-whatsapp"></i> Enquiry Now
                            </button>
                        </div>

                        <div class="trv-tour-single-r-info">
                            <div class="trv-main-rg-hol">
                                <div class="trv-man-sec-hol">
                                    <ul>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Duration : </span>
                                            <span class="ng-binding">Full Day Tour</span>
                                        </li>
                                        <li>
                                            <span  class="trv-tmi-hlo"><i class="bi bi-geo-alt"></i> Coverage :</span>
                                            <span class="trv-tmi-hlo-info">North Goa Major Attractions</span>
                                        </li>
                                     
                                    </ul>
                                </div>
                                <div class="trv-oack-sepa"><span class="lay"> Package Includes</span></div>
                                
                                <div class="trv-icon-man-holids">
                                    <ul>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/hotels.png" alt="Transport">
                                            </div>
                                            <div class="trv-holids-name">Transport</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/Sightseeing.png" alt="Sightseeing">
                                            </div>
                                            <div class="trv-holids-name">Sightseeing</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/car.png" alt="Pickup">
                                            </div>
                                            <div class="trv-holids-name">Pickup/Drop</div>
                                        </li>
                                        
                                    </ul>
                                </div>
                                
                                <div class="trv-booking-notes mt-4">
                                    <h5 class="trv-inner-title-sm">Destinations Covered:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-check-circle"></i> Fort Aguada</li>
                                        <li><i class="bi bi-check-circle"></i> Sinquerim Fort</li>
                                        <li><i class="bi bi-check-circle"></i> Baga Beach</li>
                                        <li><i class="bi bi-check-circle"></i> Anjuna Beach</li>
                                        <li><i class="bi bi-check-circle"></i> Vagator Beach</li>
                                        <li><i class="bi bi-check-circle"></i> Chapora Fort</li>
                                        <li><i class="bi bi-check-circle"></i> Saligao Church</li>
                                    </ul>
                                </div>

                                <div class="trv-booking-notes mt-4">
                                    <h5 class="trv-inner-title-sm">Optional Activities:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-plus-circle"></i> Snow Park (Extra Charge)</li>
                                        <li><i class="bi bi-plus-circle"></i> Thunder World (Extra Charge)</li>
                                    </ul>
                                </div>

                        
                            </div>
                        </div>
                    </aside>
                </div>
                <!-- SIDE BAR END -->
            </div>
        </div>
    </div>
</div>
<!-- SECTION END -->

<script>
// WhatsApp Enquiry Function
function sendWhatsAppEnquiry() {
    const whatsappNumber = "8906666657";
    const message = `🎯 *NORTH GOA SIGHTSEEING TOUR BOOKING* 🎯
    
🏖️ *Package:* North Goa Sightseeing Tour
💰 *Price:* ₹499 Per Person
⏰ *Duration:* Full Day Tour
🏨 *Resort:* Becal Family Resort

📍 *Destinations Covered:*
✅ Fort Aguada
✅ Sinquerim Fort
✅ Baga Beach
✅ Anjuna Beach
✅ Vagator Beach
✅ Chapora Fort
✅ Saligao Church

📋 *Package Includes:*
✅ Pick-up & Drop Near Hotel
✅ AC Transport 40 Seater
✅ Expert Tour Guide
✅ All Destination Visits

🎯 *Optional Activities:*
🔹 Snow Park (Extra Charge)
🔹 Thunder World (Extra Charge)

👤 *My Details:*
Name: ______
Travel Date: ______
Number of Persons: ______
Contact Number: ______

Please confirm availability and booking procedure.`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappURL, '_blank');
}

// Initialize Swiper Slider
document.addEventListener('DOMContentLoaded', function() {
    if(document.querySelector('.trv_d-slider')) {
        const swiper = new Swiper('.trv_d-slider', {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            loop: true,
        });
    }
});
</script>

    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>