<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | North Goa  </title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">North Goa  </h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>North Goa  </li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->


        <!-- SECTION START -->
<div class="section-full  p-t120 p-b90">
    <div class="container">
    
        <!-- BLOG SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar  m-b30">
                
                    <aside class="side-bar-filter">

                        <!--Left Search Filter -->
                        <div class="styleswitcher">
                            
                            <div class="styleswitcher-inner ">
                                <div class="twm-side-filter-form">
                                    <form id="tourFilterForm">

                                        <div class="twm-sidebar-ele-filter">

                                            <div class="trv-fliter-bx">
                                                <h4 class="section-head-small mb-4">Search Tour</h4>
                                                <div class="search-bx-filter">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" id="tourSearch" placeholder="Search tours...">
                                                        <span class="input-group-btn">
                                                            <button type="button" class="btn" id="searchBtn"><i class="fa fa-search"></i></button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        
                                            <div class="trv-fliter-bx">
                                                <div class="trv-fltr-select">
                                                    <div class="form-group">
                                                        <label>Location</label>
                                                        <select class="form-control" id="locationFilter">
                                                            <option value="all" selected>Select Beach</option>
                                                            <option value="baga">Baga Beach</option>
                                                            <option value="calangute">Calangute Beach</option>
                                                            <option value="anjuna">Anjuna Beach</option>
                                                            <option value="vagator">Vagator Beach</option>
                                                            <option value="morjim">Morjim Beach</option>
                                                            <option value="ashwem">Ashwem Beach</option>
                                                            <option value="candolim">Candolim Beach</option>
                                                            <option value="arambol">Arambol Beach</option>
                                                            <option value="sinquerim">Sinquerim Beach</option>
                                                            <option value="chapora">Chapora Beach</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="trv-fltr-select">
                                                    <div class="form-group">
                                                        <label>Tour Type</label>
                                                        <select class="form-control" id="tourTypeFilter">
                                                            <option value="all" selected>Select Tour Type</option>
                                                            <option value="beach">Beach Tour</option>
                                                            <option value="adventure">Adventure</option>
                                                            <option value="party">Party & Nightlife</option>
                                                            <option value="family">Family Package</option>
                                                            <option value="cultural">Cultural</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="trv-fltr-select">
                                                    <div class="form-group twm-input-with-icon">
                                                        <label>Duration (Nights)</label>
                                                        <select class="form-control" id="durationFilter">
                                                            <option value="all" selected>Select Duration</option>
                                                            <option value="1">1 Night</option>
                                                            <option value="2">2 Nights</option>
                                                            <option value="3">3 Nights</option>
                                                            <option value="4">4 Nights</option>
                                                            <option value="5">5+ Nights</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="trv-fltr-select">
                                                    <div class="form-group form-group-2column-wrap twm-input-with-icon">
                                                        <label>Price Range</label>
                                                        <select class="form-control" id="priceFilter">
                                                            <option value="all" selected>Select Price Range</option>
                                                            <option value="0-5000">Under ₹5,000</option>
                                                            <option value="5000-10000">₹5,000 - ₹10,000</option>
                                                            <option value="10000-15000">₹10,000 - ₹15,000</option>
                                                            <option value="15000-20000">₹15,000 - ₹20,000</option>
                                                            <option value="20000+">Above ₹20,000</option>
                                                        </select>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="trv-fliter-bx">
                                                <h4 class="section-head-small mb-4">Tour Inclusions</h4>
                                                <ul>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input inclusion-filter" id="inc01" value="transport">
                                                            <label class="form-check-label" for="inc01">Transport</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input inclusion-filter" id="inc02" value="meals">
                                                            <label class="form-check-label" for="inc02">Meals</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input inclusion-filter" id="inc03" value="accommodation">
                                                            <label class="form-check-label" for="inc03">Accommodation</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input inclusion-filter" id="inc04" value="guide">
                                                            <label class="form-check-label" for="inc04">Guide</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input inclusion-filter" id="inc05" value="activities">
                                                            <label class="form-check-label" for="inc05">Activities</label>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>

                                        </div>

                                        <div class="twm-side-filter-aply-btn text-center">
                                            <button type="button" id="applyFilters" class="site-button butn-bg-shape">Apply Filter</button>
                                            <button type="button" id="filterReset" class="site-button outline mx-2">Reset All</button>
                                        </div>
                                    </form>
                                    <!-- Removed advertisement image -->
                                    
                                </div>
                            </div>    
                        </div>
                        <!--Left Search Filter -->

                    </aside>

                </div>
                <!-- SIDE BAR END --> 
            
                <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                    <div class="row" id="tourContainer">
                        <!--BOX-1: Baga Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="baga" data-type="party" data-duration="3" data-price="9500" data-inclusions="transport,meals,accommodation,guide,activities">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/baga-beach.webp" alt="Baga Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>3 days, 2 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Baga Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹9,500</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Famous for nightlife, water sports & beach shacks. Party hub of North Goa</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Baga Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.6 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-2: Calangute Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="calangute" data-type="beach" data-duration="2" data-price="7500" data-inclusions="transport,meals,accommodation,activities">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Calangute-Beach-1.webp" alt="Calangute Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>2 days, 1 Night</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Calangute Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹7,500</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">"Queen of Beaches" with vibrant atmosphere and water sports</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Calangute Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.5 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-3: Anjuna Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="anjuna" data-type="adventure" data-duration="3" data-price="8500" data-inclusions="transport,meals,accommodation,guide">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Anjuna-Beach.webp" alt="Anjuna Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>3 days, 2 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Anjuna Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹8,500</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Famous Wednesday flea market & rocky shoreline. Hippie culture hub</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Anjuna Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.7 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-4: Vagator Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="vagator" data-type="beach" data-duration="3" data-price="8200" data-inclusions="transport,meals,accommodation">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Vagator-Beach.webp" alt="Vagator Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>3 days, 2 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Vagator Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹8,200</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Dramatic red cliffs & two beautiful bays. Perfect sunset views</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Vagator Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.8 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-5: Morjim Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="morjim" data-type="cultural" data-duration="4" data-price="10500" data-inclusions="transport,meals,accommodation,guide">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/morjim-beach.webp" alt="Morjim Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>4 days, 3 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Morjim Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹10,500</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">"Little Russia" - Olive ridley turtle nesting site, peaceful & serene</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Morjim Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.6 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-6: Ashwem Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="ashwem" data-type="family" data-duration="5" data-price="15500" data-inclusions="transport,meals,accommodation,guide,activities">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Ashwem-Beach.webp" alt="Ashwem Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>5 days, 4 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Ashwem Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹15,500</span>
                                            <span class="price-duration">Family Package</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Upscale & less crowded beach with luxury resorts. Perfect for families</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Ashwem Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.9 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-7: Candolim Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="candolim" data-type="beach" data-duration="3" data-price="8800" data-inclusions="transport,meals,accommodation,activities">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Candolim-Beach.webp" alt="Candolim Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>3 days, 2 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Candolim Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹8,800</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Long sandy beach with water sports, beach shacks & nightlife</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Candolim Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.7 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-8: Arambol Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="arambol" data-type="adventure" data-duration="2" data-price="6200" data-inclusions="transport,meals">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Arambol-Beach.webp" alt="Arambol Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>2 days, 1 Night</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Arambol Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹6,200</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Hippie paradise with sweet water lake & paragliding opportunities</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Arambol Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.4 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-9: Sinquerim Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="sinquerim" data-type="beach" data-duration="3" data-price="9200" data-inclusions="transport,meals,accommodation,activities">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Sinquerim-Beach.webp" alt="Sinquerim Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>3 days, 2 Nights</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Sinquerim Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹9,200</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Famous for Fort Aguada views & dolphin sighting trips</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Sinquerim Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.6 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--BOX-10: Chapora Beach-->
                        <div class="col-xl-6 col-lg-6 col-md-6 m-b30 tour-item" data-location="chapora" data-type="cultural" data-duration="2" data-price="5800" data-inclusions="transport,meals,guide">
                            <div class="trv-popular-tour-st1">
                                <div class="trv-media">
                                    <a href="javascript:void(0);"><img src="img/Chapora-Beach.webp" alt="Chapora Beach"></a>
                                    <div class="trv-tour-duration">
                                        <i class="bi bi-calendar2-week"></i>
                                        <span>2 days, 1 Night</span>
                                    </div>
                                    <div class="trv-tour-title">
                                        <h3 class="trv-title">
                                            <a href="javascript:void(0);">
                                                <i class="bi bi-geo-alt"></i>
                                                Chapora Beach Tour
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="trv-content">
                                    <div class="trv-content-head-section">
                                        <div class="trv-tour-price">
                                            <span class="price">₹5,800</span>
                                            <span class="price-duration">Per Person</span>
                                        </div>
                                        <div class="trv-tour-info">
                                            <a href="javascript:void(0);">Famous Chapora Fort (Dil Chahta Hai) & local fishing village experience</a>
                                        </div>
                                    </div>
                                    <div class="trv-content-bottom-section">
                                        <div class="trv-book">
                                            <a href="javascript:void(0);" class="site-button outline book-now-btn" data-beach="Chapora Beach">Book Now</a>
                                        </div>
                                        <div class="trv-tour-rating">
                                            <span class="trv-tour-review-count">(4.5 Review)</span>
                                            <div class="trv-review-rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="no-results" style="display: none; text-align: center; padding: 40px;">
                        <h3>No tours found matching your filters</h3>
                        <p>Try adjusting your search criteria</p>
                    </div>
                    <ul class="custom-pagination clearfix">
                        <li class="prev"><a href="javascript:void(0);"><span class="bi bi-chevron-left"></span></a></li>
                        <li><a href="javascript:void(0);">1</a></li>
                        <li><a href="javascript:void(0);">2</a></li>
                        <li><a href="javascript:void(0);">3</a></li>
                        <li><a href="javascript:void(0);">...</a></li>
                        <li class="next"><a href="javascript:void(0);"><span class="bi bi-chevron-right"></span></a></li>
                    </ul>
                </div> 
        
            </div>

        </div>
        
    </div>
    
</div>   
<!-- SECTION END -->

<script>
// WhatsApp Enquiry Function
function sendWhatsAppEnquiry(beachName) {
    const whatsappNumber = "8906666657";
    const message = `✈️ Goa Travel Enquiry%0A🏖️ Beach Package: ${beachName}%0A📅 Interested in: North Goa Beach Tour%0A👥 Travellers: 2%0A💰 Budget: As per package%0A_Sent via GoaReddy North Goa  _`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${message}`;
    window.open(whatsappURL, '_blank');
}

// Add event listeners to all Book Now buttons
document.querySelectorAll('.book-now-btn').forEach(button => {
    button.addEventListener('click', function(e) {
        e.preventDefault();
        const beachName = this.getAttribute('data-beach');
        sendWhatsAppEnquiry(beachName);
    });
});

// Filter Functionality
document.addEventListener('DOMContentLoaded', function() {
    const tourItems = document.querySelectorAll('.tour-item');
    const locationFilter = document.getElementById('locationFilter');
    const tourTypeFilter = document.getElementById('tourTypeFilter');
    const durationFilter = document.getElementById('durationFilter');
    const priceFilter = document.getElementById('priceFilter');
    const inclusionCheckboxes = document.querySelectorAll('.inclusion-filter');
    const applyFiltersBtn = document.getElementById('applyFilters');
    const filterResetBtn = document.getElementById('filterReset');
    const tourSearch = document.getElementById('tourSearch');
    const searchBtn = document.getElementById('searchBtn');
    const noResults = document.querySelector('.no-results');

    // Show all tours initially
    function showAllTours() {
        tourItems.forEach(item => {
            item.style.display = 'block';
        });
        noResults.style.display = 'none';
    }

    // Filter Tours Function
    function filterTours() {
        const locationValue = locationFilter.value;
        const tourTypeValue = tourTypeFilter.value;
        const durationValue = durationFilter.value;
        const priceValue = priceFilter.value;
        const searchTerm = tourSearch.value.toLowerCase().trim();
        
        // Get selected inclusions
        const selectedInclusions = [];
        inclusionCheckboxes.forEach(cb => {
            if (cb.checked) selectedInclusions.push(cb.value);
        });

        let visibleCount = 0;

        tourItems.forEach(item => {
            const location = item.getAttribute('data-location');
            const type = item.getAttribute('data-type');
            const duration = parseInt(item.getAttribute('data-duration'));
            const price = parseInt(item.getAttribute('data-price'));
            const inclusions = item.getAttribute('data-inclusions').split(',');
            
            // Get text content for search
            const title = item.querySelector('.trv-title a').textContent.toLowerCase();
            const description = item.querySelector('.trv-tour-info a').textContent.toLowerCase();
            
            // Check location filter
            const locationMatch = locationValue === 'all' || location === locationValue;
            
            // Check tour type filter
            const typeMatch = tourTypeValue === 'all' || type === tourTypeValue;
            
            // Check duration filter
            let durationMatch = true;
            if (durationValue !== 'all') {
                const durationNum = parseInt(durationValue);
                if (durationNum === 5) {
                    durationMatch = duration >= 5;
                } else {
                    durationMatch = duration === durationNum;
                }
            }
            
            // Check price filter
            let priceMatch = true;
            if (priceValue !== 'all') {
                if (priceValue === '0-5000') priceMatch = price <= 5000;
                else if (priceValue === '5000-10000') priceMatch = price > 5000 && price <= 10000;
                else if (priceValue === '10000-15000') priceMatch = price > 10000 && price <= 15000;
                else if (priceValue === '15000-20000') priceMatch = price > 15000 && price <= 20000;
                else if (priceValue === '20000+') priceMatch = price > 20000;
            }
            
            // Check search term
            let searchMatch = true;
            if (searchTerm !== '') {
                searchMatch = title.includes(searchTerm) || description.includes(searchTerm);
            }
            
            // Check inclusions
            let inclusionMatch = true;
            if (selectedInclusions.length > 0) {
                inclusionMatch = selectedInclusions.every(inc => inclusions.includes(inc));
            }
            
            // Show/hide based on all filters
            if (locationMatch && typeMatch && durationMatch && priceMatch && searchMatch && inclusionMatch) {
                item.style.display = 'block';
                visibleCount++;
            } else {
                item.style.display = 'none';
            }
        });

        // Show/hide no results message
        if (visibleCount === 0) {
            noResults.style.display = 'block';
        } else {
            noResults.style.display = 'none';
        }
    }

    // Search functionality
    searchBtn.addEventListener('click', filterTours);
    tourSearch.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            filterTours();
        }
    });

    // Apply filters button
    applyFiltersBtn.addEventListener('click', filterTours);

    // Reset filters button
    filterResetBtn.addEventListener('click', function() {
        locationFilter.value = 'all';
        tourTypeFilter.value = 'all';
        durationFilter.value = 'all';
        priceFilter.value = 'all';
        tourSearch.value = '';
        
        inclusionCheckboxes.forEach(cb => {
            cb.checked = false;
        });
        
        showAllTours();
    });

    // Initialize - show all tours
    showAllTours();
});
</script>
        
<?php include 'enquiry-form.php'; ?>
        

    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>