<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Kayaking Goa, South Goa Kayaking, Palolem Kayaking, Goa Water Sports">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="Best Kayaking Experience in South Goa - Sunrise & Sunset Kayaking Tours in Palolem, Agonda & Cabo de Rama">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | Best Kayaking in South Goa - Palolem & Agonda</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Best Kayaking in South Goa</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>Best Kayaking in South Goa</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

<!-- SECTION START -->
<div class="section-full p-t120 p-b90">
    <div class="container">
        <!-- SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                    <div class="trv-detail-main-wrap">
                        <!--Info Start-->
                        <div class="trv-detail-bx-wrap">
                            <div class="trv-inr-para2">
                                <div class="trv-sep-rating">
                                    <div class="trv-rating">
                                        <span>(4.9 Review)</span>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                    </div>
                                </div>
                                <h3 class="trv-inner-title-lg">Best Kayaking Experience in South Goa</h3>
                                <span class="trv-packege-esti-time">Sunrise & Sunset Kayaking Tours in Palolem & Agonda</span>

                                <!--Top SLider-->
                                <div class="trv-detail-slider">
                                    <div class="swiper trv_d-slider">
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/kayak-1.webp" alt="Kayaking in Palolem Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/kayak-2.webp" alt="Sunset Kayaking Goa">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/kayak-3.webp" alt="Kayaking Training Session">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide"> 
                                                <div class="trv_d-slider-media">
                                                    <img src="img/kayak-4.webp" alt="Mangrove Kayaking Experience">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/kayak-5.webp" alt="Kayaking at Cabo de Rama">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/kayak-6.webp" alt="Group Kayaking Adventure">   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <!--Top SLider End-->

                                <!-- Navigation -->
                                <nav class="navbar-one">
                                    <a href="#overview">Package Overview</a>
                                    <a href="#details">Kayaking Experience</a>
                                    <a href="#inclusions">Inclusions / Exclusions</a>
                                </nav>

                                <!-- Over View-->
                                <section id="overview">
                                    <h3 class="trv-inner-title-sm">South Goa Kayaking Package Overview</h3>
                                    <p>Experience the most serene and adventurous kayaking in South Goa's pristine waters. Choose between magical sunrise or romantic sunset kayaking tours in Palolem, Agonda, and Cabo de Rama beaches. Perfect for beginners and experienced kayakers alike.</p>

                                    <h4 class="trv-inner-title-sm mt-4">Package Highlights:</h4>
                                    <ul class="trv-checklist-st1">
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Two Timing Options</strong> - Sunrise (6:00 AM) or Sunset (4:30 PM)
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Beginner Friendly</strong> - No prior experience needed
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Professional Guidance</strong> - Certified kayaking instructors
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>All Equipment Provided</strong> - Kayak, paddle, life jacket
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Dolphin Spotting Chance</strong> - See dolphins in their natural habitat
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Safety First</strong> - All safety equipment and briefing included
                                        </li>
                                    </ul>
                                </section>

                                <!-- Package Details-->
                                <section id="details">
                                    <h3 class="trv-inner-title-sm">Complete Kayaking Adventure Experience</h3>
                                    
                                    <div class="trv-clist-st-3-wrap">
                                        <ul class="trv-list-st-3">
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-sunrise"></i></div>
                                                        </div>
                                                        <span class="day">SUNRISE</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Magical Sunrise Kayaking Experience</h4>
                                                        <p>Start your day with breathtaking sunrise kayaking. Paddle through calm morning waters as the sun rises over the Arabian Sea. Experience the tranquility of South Goa beaches before the crowds arrive. Best for photography and peaceful meditation on water.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-sunrise-1.webp" alt="Sunrise Kayaking">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-sunrise-2.webp" alt="Morning Kayaking">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-sunset"></i></div>
                                                        </div>
                                                        <span class="day">SUNSET</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Romantic Sunset Kayaking Tour</h4>
                                                        <p>Experience the magic of Goa's famous sunsets from your kayak. Paddle through golden waters as the sun sets over the horizon. Perfect for couples, families, and solo travelers. Watch the sky turn from orange to purple while floating on peaceful waters.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-droplet"></i></div>
                                                        </div>
                                                        <span class="day">TRAINING</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Complete Kayaking Training Session</h4>
                                                        <p>Beginner-friendly training by certified instructors. Learn basic paddling techniques, safety procedures, and kayak handling. 30-minute training session before the tour. Suitable for all ages (10+ years). Swimming knowledge not required.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-training-1.webp" alt="Kayaking Training">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-training-2.webp" alt="Safety Briefing">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-training-3.webp" alt="Equipment Demo">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-tree"></i></div>
                                                        </div>
                                                        <span class="day">MANGROVE</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Mangrove & River Kayaking (Optional)</h4>
                                                        <p>Explore South Goa's hidden mangrove forests and serene rivers. Paddle through calm backwaters, spot exotic birds, and experience Goa's rich biodiversity. Perfect for nature lovers and photography enthusiasts. Available as an upgrade option.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-camera"></i></div>
                                                        </div>
                                                        <span class="day">PHOTOS</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Professional Photography (Extra Cost)</h4>
                                                        <p>Capture your kayaking adventure with professional photography services. Our photographer will capture your best moments on water. Receive digital photos within 24 hours. Perfect for creating unforgettable memories of your Goa trip.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-photo-1.webp" alt="Action Photography">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-photo-2.webp" alt="Sunset Photos">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/kayak-photo-3.webp" alt="Group Photos">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </section>

                                <!-- Inclusion/Exclusions-->
                                <section id="inclusions">
                                    <div class="trv-checklist-st2-mini-wrap">
                                        <div class="row">
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-l">
                                                <h3 class="trv-inner-title-sm">PACKAGE INCLUDE</h3>
                                                <ul class="trv-checklist-st2-mini">
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Hotel Pickup & Drop</strong> - From South Goa hotels
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Professional Kayaking Instructor</strong> - Certified guide
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Kayaking Equipment</strong> - Kayak, paddle, life jacket
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Safety Briefing & Training</strong> - 30-minute session
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>2-Hour Kayaking Session</strong> - In calm waters
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>All Safety Equipment</strong> - Life jackets, whistles
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Mineral Water Bottle</strong> - Stay hydrated
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Basic First Aid Kit</strong> - Safety first approach
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-r">
                                                <h3 class="trv-inner-title-sm">Not Included</h3>
                                                <ul class="trv-checklist-st2-mini trv-list-disable">
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Professional Photography (Extra ₹500)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Mangrove Kayaking Upgrade (Extra ₹300)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Meals & Beverages
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        North Goa Hotel Pickup (Extra charge)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Personal expenses & tips
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </section>

                            </div>
                        </div>
                    </div> 
                </div> 

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar m-b30">
                    <aside class="side-bar">
                        <div class="trv-tour-single-r-detail">
                            <span class="trv-star-from">Starting from</span>
                            <span class="trv-star-amount">
                                <s>$6</s> ₹500
                            </span>
                            <span class="trv-star-from-person">/ Person</span>
                            <div class="trv-emi_text">
                                <i class="bi bi-wallet"></i>Best Quality Kayaking
                                <span class="trvng-binding"></span> 
                                <a class="chsemi" href="javascript:;">Special Deals</a>
                            </div>
                            <button type="button" class="site-button butn-bg-shape" onclick="sendWhatsAppEnquiry()">
                                <i class="bi bi-whatsapp"></i>Enquiry Now
                            </button>
                        </div>

                        <div class="trv-tour-single-r-info">
                            <div class="trv-main-rg-hol">
                                <div class="trv-man-sec-hol">
                                    <ul>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Trip Duration : </span>
                                            <span class="ng-binding">2 Hours (Choose Timing)</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-truck"></i> Transport : </span>
                                            <span class="ng-binding">Pickup from South Goa Hotels</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-water"></i> Activity : </span>
                                            <span class="ng-binding">Kayaking in Calm Waters</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-person-check"></i> Guide : </span>
                                            <span class="ng-binding">Certified Kayaking Instructor</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-exclamation-circle"></i> Note : </span>
                                            <span class="trv-tmi-hlo-info">Safe & Beginner Friendly Experience</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-award"></i> Certification : </span>
                                            <span class="trv-tmi-hlo-info">Licensed Water Sports Operator</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-patch-check"></i> Safety : </span>
                                            <span class="trv-tmi-hlo-info">100% Safety Record</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-shield-check"></i> Quality : </span>
                                            <span class="trv-tmi-hlo-info">Premium Kayaking Equipment</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="trv-oack-sepa"><span class="lay"> Package Includes</span></div>
                                
                                <div class="trv-icon-man-holids">
                                    <ul>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/hotels.png" alt="Pickup">
                                            </div>
                                            <div class="trv-holids-name">Hotel Pickup</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/Sightseeing.png" alt="Kayaking">
                                            </div>
                                            <div class="trv-holids-name">Kayaking</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/car.png" alt="Transport">
                                            </div>
                                            <div class="trv-holids-name">Hotel Drop</div>
                                        </li>
                                        
                                        
                                    </ul>
                                </div>
                                
                                <div class="trv-booking-notes mt-4">
                                    <h5 class="trv-inner-title-sm">Choose Your Timing:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-sunrise text-warning"></i> Sunrise Kayaking (6:00 AM)</li>
                                        <li><i class="bi bi-sunset text-orange"></i> Sunset Kayaking (4:30 PM)</li>
                                    </ul>
                                    
                                    <h5 class="trv-inner-title-sm mt-3">Upgrade Options (Extra Cost):</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-plus-circle"></i> Professional Photography: ₹500</li>
                                        <li><i class="bi bi-plus-circle"></i> Mangrove Kayaking: ₹300</li>
                                        <li><i class="bi bi-plus-circle"></i> Private Kayaking: ₹1000</li>
                                    </ul>
                                </div>

                            </div>
                        </div>
                    </aside>
                </div>
                <!-- SIDE BAR END -->
            </div>
        </div>
    </div>
</div>
<!-- SECTION END -->

<script>
// WhatsApp Enquiry Function for Kayaking
function sendWhatsAppEnquiry() {
    const whatsappNumber = "8906666657";
    const message = `🚣‍♂️ *BEST KAYAKING IN SOUTH GOA - ENQUIRY* 🚣‍♂️
    
🌊 *Package:* South Goa Kayaking Experience
💰 *Price:* ₹500 Per Person
⏰ *Duration:* 2 Hours (Choose Timing)

🏖️ *Kayaking Locations:*
• Palolem Beach • Agonda Beach • Cabo de Rama
• Sal River • Mobor Backwaters

📋 *Package Includes:*
✅ Hotel Pickup & Drop from South Goa
✅ Professional Kayaking Instructor
✅ Complete Kayaking Equipment (Kayak, Paddle, Life Jacket)
✅ Safety Briefing & Basic Training (30 minutes)
✅ 2-Hour Kayaking Session in Calm Waters
✅ All Safety Equipment Provided
✅ Mineral Water Bottle
✅ Basic First Aid Kit

⏰ *Choose Your Timing:*
🌅 Sunrise Kayaking: 6:00 AM (Magical Morning Experience)
🌇 Sunset Kayaking: 4:30 PM (Romantic Evening Paddle)

🎯 *Special Features:*
• Beginner Friendly - No Experience Needed
• Chance to Spot Dolphins
• Certified & Licensed Operators
• 100% Safety Record
• All Ages Welcome (10+ Years)

📸 *Upgrade Options (Extra Cost):*
• Professional Photography: ₹500
• Mangrove Kayaking Tour: ₹300
• Private Kayaking Experience: ₹1000

👤 *My Details:*
Name: ______
Preferred Timing: [Sunrise/Sunset] ______
Travel Date: ______
Number of Persons: ______
Contact Number: ______
Hotel Location in Goa: ______

🏆 *Quality Assurance:*
• Licensed Water Sports Operator
• Premium Kayaking Equipment
• Certified Instructors
• Safety First Approach

📞 *Contact:* Best Kayaking Partner in South Goa

Please provide availability for my preferred timing and location.`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappURL, '_blank');
}

// Initialize Swiper Slider
document.addEventListener('DOMContentLoaded', function() {
    if(document.querySelector('.trv_d-slider')) {
        const swiper = new Swiper('.trv_d-slider', {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            loop: true,
        });
    }
});
</script>
    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>