<!DOCTYPE html>
<html lang="en">
<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoReddy | Tours & Travel</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css">
    <link rel="stylesheet"  href="css/bootstrap-select.min.css">
    <link rel="stylesheet"  href="css/font-awesome.min.css">
    <link rel="stylesheet"  href="css/feather.css">
    <link rel="stylesheet"  href="css/owl.carousel.min.css">
    <link rel="stylesheet"  href="css/magnific-popup.min.css">
    <link rel="stylesheet"  href="css/swiper-bundle.min.css">  
    <link rel="stylesheet"  href="css/style.css">
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"> 
    <link rel="stylesheet"  href="css/bootstrap-icons.css">
    <link rel="stylesheet"  href="css/lc_lightbox.css">
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css">  
    
    <style>
        .header-style-1.site-header {
            background:transparent !important;
        }
    </style>
</head>

<body>
<?php include 'header.php'; ?>
<main>
<div class="page-wraper">
    
    <!-- CONTENT START -->
    <div class="page-content">

        <!-- Banner Style One -->
        <div class="trv-banner-1-wrap">
            <div class="trv-banner-1-rain-effect">
                <div class="rain front-row"></div>
                <div class="rain back-row"></div>
            </div>
            <video muted autoplay playsinline loop class="trv-vid-full">
                <source src="images/video-1.mp4" type="video/mp4">
            </video>

            <div class="trv-banner-1-overlay">
                <div class="trv-banner-1-text">
                    <span class="trv-banner-1-text-small">Explore</span>
                    <div class="trv-banner-1-text-mid">
                        <h1 class="trv-banner-1-text-large" title="Vietnam">Goa<img class="trv-btrfly" src="images/butterfly.gif" alt="image"></h1>
                        <h1 class="trv-banner-1-text-large-outline" title="Vietnam">Goa</h1>
                    </div>
                    <span class="trv-banner-rock-pic">
                        <img src="images/main-slider/slider1/Rock.png" alt="Image">
                    </span>
                    <div class="trv-banner-text-detail">The Safety of our customers at all stages</div>
                    <div class="trv-banner-btn"><a href="contact.php" class="site-button butn-bg-shape">Get In Touch</a></div>
                </div>

                <div class="trv-banner-1-social">
                    <span>Follow Us</span>
                    <ul>
                        <li><a href="javascript:;"><i class="feather feather-facebook"></i></a></li>
                        <li><a href="javascript:;"><i class="feather feather-linkedin"></i></a></li>
                        <li><a href="javascript:;"><i class="feather feather-instagram"></i></a></li>
                        <li><a href="javascript:;"><i class="bi bi-twitter-x"></i></a></li>
                    </ul>
                </div>

                <div class="twm-img-bg-circle-area">
                    <div class="twm-img-bg-circle1-wrap">
                        <div class="twm-img-bg-circle1 rotate-center"><span></span></div>
                    </div>
                    <div class="twm-img-bg-circle2-wrap">
                        <div class="twm-img-bg-circle2 rotate-center-reverse"><span></span></div>
                    </div>
                    <div class="twm-img-bg-circle3-wrap">
                        <div class="twm-img-bg-circle3 rotate-center"><span></span></div>
                    </div>
                    
                </div>
            </div>
        

            <div class="tvr-banner-1-bottom-left">
                <div class="media">
                    <img src="images/lizard.png" alt="Image" class="lizard">
                    <img src="images/li-eye.gif" alt="image" class="lizard-eye">
                </div>
            </div>
            <div class="trv-cloud-1">            
                <div class="marquee-hm1-cloud1">
                    <img src="images/cloud-1.png" alt="Image">
                </div>
            </div>
            <div class="trv-cloud-2">
                <div class="marquee-hm1-cloud2">
                    <img src="images/cloud-2.png" alt="Image">    
                </div>
            </div>
            
        </div> 
        <!-- Banner Style One End -->

        <!-- SEARCH BAR START-->
        <div class="trv-search-st1-wrap">
            <div class="trv-search-st1">
                <div class="trv-search-st1-bg">
                    <form id="travelForm">
                        <div class="trv-search-st1-column-wrap">
                            <div class="trv-search-st1-column">
                                <div class="form-group">
                                    <label><i><img src="images/search-icon/icon1.png" alt="Image"></i>Location</label>
                                    <select class="form-select form-control" name="goa_location" required>
                                        <option value="">Select Location</option>
                                        <option value="Baga Beach">Baga Beach</option>
                                        <option value="Calangute Beach">Calangute Beach</option>
                                        <option value="Anjuna Beach">Anjuna Beach</option>
                                        <option value="Vagator Beach">Vagator Beach</option>
                                        <option value="Candolim Beach">Candolim Beach</option>
                                        <option value="Palolem Beach">Palolem Beach</option>
                                        <option value="Panaji">Panaji</option>
                                        <option value="Old Goa">Old Goa</option>
                                    </select>
                                </div>
                            </div>
                            <div class="trv-search-st1-column">
                                <div class="form-group">
                                    <label><i><img src="images/search-icon/icon2.png" alt="Image"></i>Activity Type</label>
                                    <select class="form-select form-control" name="activity" required>
                                        <option value="">Select Activity</option>
                                        <option value="Beach Tour">Beach Tour</option>
                                        <option value="Adventure Sports">Adventure Sports</option>
                                        <option value="Heritage Walk">Heritage Walk</option>
                                        <option value="Water Sports">Water Sports</option>
                                        <option value="Nightlife">Nightlife</option>
                                        <option value="Sightseeing">Sightseeing</option>
                                    </select>
                                </div>
                            </div>
                            <div class="trv-search-st1-column">
                                <div class="form-group form-group-2column-wrap twm-input-with-icon">
                                    <label><i><img src="images/search-icon/icon3.png" alt="Image"></i>Date</label>
                                    <div class="input-group">
                                        <input class="form-control" type="date" name="travel_date" required>
                                        <span class="input-group-append input-group-addon">
                                            <span class="input-group-text">
                                                <i class="fa fa-solid fa-calendar-days"></i>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="trv-search-st1-column">
                                <div class="form-group form-group-2column-wrap twm-input-with-icon">
                                    <label><i><img src="images/search-icon/icon4.png" alt="Image"></i>Traveler</label>
                                    <div class="quantity btn-quantity2">
                                        <input type="number" name="travelers" value="1" min="1" max="20" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="trv-search-st1-column-last">
                                <div class="trv-search-st1-search-btn">
                                    <button type="submit" class="site-button butn-bg-shape">Book Now</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div> 
        <!-- SEARCH BAR END-->


        <!--POPULAR DESTINATION SECTION START-->
        <div class="section-full p-t120 p-b90 trv-popular-destination tvr-hot-ballon-wrap" style="background-image: url(images/background/Cloud-bg.png)">
            <div class="container">
                <!-- TITLE START-->
                <div class="section-head trv-head-title-wrap center-position">
                    <h2 class="trv-head-title"><span class="site-text-yellow">Popular </span>Destinations in Goa</h2>
                    <div class="trv-head-discription">Explore Goa's most iconic beaches, heritage sites, and scenic spots</div>
                    <div class="trv-head-title-image">
                        <img src="images/background/Title-Separator.png" alt="Image">
                    </div>
                </div>
                <!-- TITLE END-->

                <div class="section-content">

                    <div class="swiper trv-popular-destination-row trv-pop-des-st1-carousal swiper-nav-center-bottom">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/baga-beach.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Baga Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/Calangute-Beach-1.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Calangute Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/Anjuna-Beach.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Anjuna Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>
 
                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/candolim.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Candolim Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/panaji.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Panaji (Panjim)</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/old-goa.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Old Goa</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/dudhsagar.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Dudhsagar Waterfalls</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/Vagator-Beach.webp" alt="Image"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Vagator Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/Palolem-Beach.webp" alt="Palolem Beach"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Palolem Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/Agonda-Beach.webp" alt="Agonda Beach"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Agonda Beach</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="swiper-slide">
                                <div class="trv-destination-bx1">
                                    <div class="trv-media">
                                        <a href="#"><img src="img/church.webp" alt="Basilica of Bom Jesus"></a>
                                    </div>
                                    <div class="trv-content">
                                        <h3 class="trv-title"><a href="#">Basilica of Bom Jesus</a></h3>
                                    </div>
                                    <div class="trv-on-hover">
                                        <img src="images/destinations/hotballon-right.png" alt="image">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    
                </div> 

            </div>

            <div class="left-hot-ballon"><img src="images/hotballon-Left.png" alt="image"></div>
            <div class="right-hot-ballon"><img src="images/hotballon-right.png" alt="image"></div>
        
        </div>
        <!--POPULAR DESTINATION SECTION END-->

        <!--WE RECOMMEND SECTION START-->
        <div class="section-full p-t120 p-b0 trv-we-recommend">
            <div class="container">
                <div class="section-content">
                    <div class="trv-we-recommend-row">
                        <div class="row">
                            <div class="col-xl-5 col-lg-7 col-md-12">
                                <div class="trv-we-recommend-content">
                                    <!-- TITLE START-->
                                    <div class="section-head trv-head-title-wrap left-position">
                                        <h2 class="trv-head-title">GoaReddy <span class="site-text-yellow">Presents </span>Goa's Best Kept Secrets</h2>
                                        <div class="trv-head-discription">GoaReddy is your premier travel partner for discovering the true 
                                            essence of Goa. We specialize in creating personalized travel experiences that 
                                            showcase Goa's stunning beaches, rich Portuguese heritage, vibrant markets, 
                                            and unforgettable nightlife. Let us guide you through paradise.
                                        </div>
                                    </div>
                                    <!-- TITLE END-->

                                    <div class="trv-we-rec-mid-section">
                                        <div class="trv-24-7-bx">
                                        <div class="trv-24-7-info">
                                                <span class="nbr">24/7</span>
                                                <span class="info">Travel Support</span>
                                        </div> 
                                        </div>

                                        <div class="trv-icon-bx-st1-bx">
                                            <div class="trv-icon-bx-st1 m-b30">
                                                <div class="trv-icon-bx-media"><span><img src="images/trv-icon/travel-guide.png" alt="#"></span></div>
                                                <div class="trv-icon-bx-info">
                                                    <h4 class="trv-icon-bx-title">Expert Goa Guides</h4>
                                                    <p class="p-text">Our experienced guides know Goa intimately - from hidden beaches to local culinary delights.</p>   
                                                </div>
                                            </div>
                                            <div class="trv-icon-bx-st1 m-b30">
                                                <div class="trv-icon-bx-media"><span><img src="images/trv-icon/mission-icon.png" alt="#"></span></div>
                                                <div class="trv-icon-bx-info">
                                                    <h4 class="trv-icon-bx-title">Our Mission</h4>
                                                    <p class="p-text">To provide exceptional Goa travel experiences that create lasting memories for every traveler.</p>   
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="trv-we-rec-bottom-section">
                                        <div class="trv-we-rec-btn">
                                            <a href="#" class="site-button butn-bg-shape">Discover Goa</a>
                                        </div>
                                        <div class="trv-hpy-cus">
                                            <div class="trv-cus-pic-box">
                                                <span class="trv-cus-pic-box-pic first-bx">
                                                    <img src="images/hpy-cus/pic1.jpg" alt="">
                                                </span>
                                                <span class="trv-cus-pic-box-pic">
                                                    <img src="images/hpy-cus/pic2.jpg" alt="">
                                                </span>
                                                <span class="trv-cus-pic-box-pic">
                                                    <img src="images/hpy-cus/pic3.jpg" alt="">
                                                </span>
                                            </div>
                                            <div class="trv-hpy-cus-count">
                                                <span>8.7k</span>
                                                <p>Satisfied Travelers</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-7 col-lg-5 col-md-12 trv-we-rec-media-main-wrap">

                                <div class="trv-year-section">
                                    <div class="trv-year-media">
                                        <img src="images/plane1.png" alt="image">
                                    </div>
                                    <div class="trv-year-info">
                                        <h2 class="numbr">5</h2>
                                        <span>Years Serving Goa</span>
                                    </div>
                                </div>
                                <div class="trc-we-rec-circle-bx">
                                    <img src="images/we-rec-pic2.jpg" alt="image">
                                </div>
                                <div class="trv-we-rec-media-main">
                                    <img src="images/we-rec-pic.png" alt="Image">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                </div> 

            </div>
        
        </div>
        <!--WE RECOMMEND SECTION END-->

        <!-- CLIENT LOGO SECTION START -->
        <div class="section-full trv-client-section">
            <div class="trv-client-row">
                <div class="container">
                    <div class="section-content">
                        <div class="trv-client-carousel">
                            <div class="row">
                                <div class="col-xl-3 col-lg-12 col-md-12">
                                    <div class="trv-client-titlesection">
                                        <h2 class="trv-head-title"><span class="site-text-yellow">GoaReddy </span>Your #1 Travel Partner in Goa</h2>
                                    </div>
                                </div>
                                <div class="col-xl-9 col-lg-12 col-md-12">
                                    <div class="owl-carousel home-client-carousel">

                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/1.png" alt=""></a></div>
                                                </div>
                                            </div>
                                        
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/2.png" alt=""></a></div>
                                                </div>
                                            </div>
                                            
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/3.png" alt=""></a></div>
                                                </div>
                                            </div>
                                        
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/4.png" alt=""></a></div>
                                                </div>
                                            </div>
                                            
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/5.png" alt=""></a></div>
                                                </div>
                                            </div>

                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/1.png" alt=""></a></div>
                                                </div>
                                            </div>
                                        
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/2.png" alt=""></a></div>
                                                </div>
                                            </div>
                                            
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/3.png" alt=""></a></div>
                                                </div>
                                            </div>
                                        
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/4.png" alt=""></a></div>
                                                </div>
                                            </div>
                                            
                                            <div class="item">
                                                <div class="ow-client-logo">
                                                    <div class="client-logo client-logo-media">
                                                    <a href="#"><img src="images/client-logo/dark/5.png" alt=""></a></div>
                                                </div>
                                            </div>
                                            
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- CLIENT LOGO  SECTION End -->
        
        <!--TOUR CATEGORY SECTION START-->
        <div class="section-full p-t120 p-b0 trv-tour-category-section" style="background-image: url(images/background/tour-bg.jpg);">
        
            <div id="module">
                <div class="trv-feature">
                    <h2>&nbsp;</h2>
                    <p></p>
                    <a type="submit" href="#" class="site-button butn-bg-shape">Book Now</a>
                </div>
                <div class="swiper trv-tr-cat-carousal">
                    <div class="swiper-wrapper">
                        <!--Block 1-->
                        <div class="trv-cat-sld swiper-slide" data-title="Scuba Combo Goa" 
                        data-description="Scuba Diving + Watersports + Transportation + Tour Guide + Video Shoot">
                            <div class="trv-tr-cat-carousal-media">
                                <img src="img/scuba-com.jpg" alt="Scuba Combo Goa">
                                <h3 class="trv-bx-title"><a href="scuba-combo.php">Scuba Combo Goa</a></h3>
                            </div>
                            
                        </div>
                        <!--Block 2-->
                        <div class="trv-cat-sld swiper-slide" data-title="Dinner Cruise Goa" data-description="3 Hours Cruising + Buffet Dinner + DJ Music + River Sightseeing + 2 Drinks">
                            <div class="trv-tr-cat-carousal-media">
                                <img src="img/dcg.jpg" alt="Dinner Cruise Goa">
                                <h3 class="trv-bx-title"><a href="dinner-cruise.php">Dinner Cruise Goa</a></h3>
                            </div>
                        </div>
                        <!--Block 3-->
                        <div class="trv-cat-sld swiper-slide" data-title="North Goa Sightseeing" data-description="Fort Aguada, Baga Beach, Anjuna Beach, Vagatore Beach, Chapora Fort & more">
                            <div class="trv-tr-cat-carousal-media">
                                <img src="img/ngss.jpg" alt="North Goa Sightseeing">
                                <h3 class="trv-bx-title"><a href="north-sightseeing.php">North Goa Sightseeing</a></h3>
                            </div>
                        </div>
                        <!--Block 4-->
                        <div class="trv-cat-sld swiper-slide" data-title="South Goa Sightseeing" data-description="Dona Paula, Miramar Beach, Panjim Church, Mangeshi Temple, Old Goa Church">
                            <div class="trv-tr-cat-carousal-media">
                                <img src="img/sgss1.jpg" alt="South Goa Sightseeing">
                                <h3 class="trv-bx-title"><a href="south-sightseeing.php">South Goa Sightseeing</a></h3>
                            </div>
                        </div>
                        
                        <!--Block 1-->
                        <div class="trv-cat-sld swiper-slide" data-title="Scuba Combo Goa" 
                        data-description="Scuba Diving + Watersports + Transportation + Tour Guide + Video Shoot">
                            <div class="trv-tr-cat-carousal-media">
                                <img src="img/scuba-com.jpg" alt="Scuba Combo Goa">
                                <h3 class="trv-bx-title"><a href="scuba-combo.php">Scuba Combo Goa</a></h3>
                            </div>
                            
                        </div>
                        
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        
            <div class="container">
                <div class="trv-btm-title-section">
                    <span>Wonderful Place For You</span>
                    <h2 class="trv-btm-title-large">Tour Categories</h2>
                </div>
            </div>
        
        </div>
        
        <script>
// WhatsApp Enquiry Function for Tour Categories
document.addEventListener('DOMContentLoaded', function() {
    const bookNowBtn = document.querySelector('.trv-feature .site-button.butn-bg-shape');
    
    if (bookNowBtn) {
        bookNowBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            // WhatsApp number (आपका नंबर डालें)
            const whatsappNumber = "8906666657"; 
            const message = `✈️ Goa Travel Enquiry%0A🏖️ Package: All Tour Packages%0A📅 Interested in: Goa Tour Packages%0A👥 Travellers: %0A📞 Contact me for more details%0A_Sent via GoaReddy Website_`;
            
            const whatsappURL = `https://wa.me/${whatsappNumber}?text=${message}`;
            window.open(whatsappURL, '_blank');
        });
    }
});
</script>
        <!--TOUR CATEGORY SECTION END-->
        
        
        <!-- VIDEO WITH ACHIVMENT SECTION START-->
        <div class="section-full trv-achivment-section">
            <div class="container">
                <div class="trv-achivment-row">
                    <div class=" parallax-section">
                        <div class="parallax-content">
                            <div class="video-section-outer">
                                <div class="video-section">
                                    <a href="https://player.vimeo.com/video/213315632?color=ffffff&amp;title=0&amp;byline=0&amp;portrait=0" class="mfp-video play-now-video">
                                        <i class="icon fa fa-play"></i>
                                        <span class="ripple"></span>
                                    </a>                                              
                                </div>
                            </div>
                            <div class="trv-say-yesbx-wrap">
                                <div class="trv-say-yesbx">
                                    <div class="say-title">Explore <span>Goa!</span></div>
                                    <div class="say-title2">With Perfect Ride</div> 
                                </div>
                            </div>
                            
                        </div>
                        <div class="trv-vid-st2  parallax-image" style="background-image: url(images/background/vid-bg2.jpg);"></div>
                        <div class="trv-vid-st2-counter">
                            <div class="row">

                                <div class="col-lg-3 col-md-6 col-sm-6 col-6 m-b30">
                                    <div class="trv-counter-outer-one">
                                        <div class="trv-counter-media">
                                            <img src="images/trv-icon/count-icon1.png" alt="Image">
                                        </div>
                                        <div class="trv-icon-content-info">
                                            <h4 class="trv-icon-title">Trusted Service</h4>
                                            <div class="counter-out"><span class="counter">9.8</span><b>/10</b></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6 col-sm-6 col-6 m-b30">
                                    <div class="trv-counter-outer-one">
                                        <div class="trv-counter-media">
                                            <img src="images/trv-icon/count-icon2.png" alt="Image">
                                        </div>
                                        <div class="trv-icon-content-info">
                                            <h4 class="trv-icon-title">Fleet Strength</h4>
                                            <div class="counter-out"><span class="counter">150</span><b>+</b></div>
                                        </div>
                                    </div>    
                                </div>
                                
                                <div class="col-lg-3 col-md-6 col-sm-6 col-6 m-b30">
                                    <div class="trv-counter-outer-one">
                                        <div class="trv-counter-media">
                                            <img src="images/trv-icon/count-icon3.png" alt="Image">
                                        </div>
                                        <div class="trv-icon-content-info">
                                            <h4 class="trv-icon-title">Coastal Rides</h4>
                                            <div class="counter-out"><span class="counter">18.5</span><b>K</b></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6 col-sm-6 col-6 m-b30">
                                    <div class="trv-counter-outer-one">
                                        <div class="trv-counter-media">
                                            <img src="images/trv-icon/count-icon4.png" alt="Image">
                                        </div>
                                        <div class="trv-icon-content-info">
                                            <h4 class="trv-icon-title">Beach Miles</h4>
                                            <div class="counter-out"><span class="counter">1.2</span><b>M</b></div>
                                        </div>
                                    </div>    
                                </div>
                            
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--VIDEO WITH ACHIVMENT SECTION END-->

        <!--WE OFFER SERVICES SECTION START-->
        <div class="section-full trv-we-off-service p-t120 p-b90">
            <div class="container">
                <div class="trv-we-off-sevice-row">
                    <div class="row">
                        <div class="col-lg-5 col-md-12">
                            <div class="trv-we-off-media">
                                <img class="media1" src="images/Left-Man-Image.png" alt="image">
                                <img class="media2" src="images/travel-sites.png" alt="image">
                                <div class="img-bg-shade"></div>
                            </div>
                        </div>
                        <div class="col-lg-7 col-md-12">
                            <div class="trv-we-off-content">
                                <!-- TITLE START-->
                                    <div class="section-head trv-head-title-wrap left-position with-bg-dark">
                                        <h2 class="trv-head-title">Our Goa Travel <span class="site-text-yellow">Services </span></h2>
                                        <div class="trv-head-discription">GoaReddy specializes in creating unforgettable Goa experiences. We offer comprehensive travel solutions including beach tours, heritage walks, adventure activities, and customized itineraries that capture the true spirit of Goa's sun, sand, and culture.</div>
                                    </div>
                                <!-- TITLE END-->
                                <!--servce box-->
                                <div class="row">
                                    <div class="col-xl-4 col-lg-6 col-md-6 m-b30">
                                        <div class="trv-servi-bx1 trv-servi-bx-clr1 ">
                                            <div class="trv-icon">
                                                <span><img src="images/trv-icon/ship.png" alt="Image"></span>
                                            </div>
                                            <div class="trv-icon-content">
                                                <h4 class="title">Beach & Cruise Tours</h4>
                                                <p class="p-text">Experience Goa's pristine beaches and scenic river cruises with our exclusive packages</p>
                                            </div>
                                            <div class="trv-step-corner-bx">
                                                <div class="trv-step-corner">
                                                    <span>Step</span>
                                                    <div class="number">01</div>
                                                </div>   
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xl-4 col-lg-6 col-md-6 m-b30">
                                        <div class="trv-servi-bx1 trv-servi-bx-clr2">
                                            <div class="trv-icon">
                                                <span><img src="images/trv-icon/plane-booking.png" alt="Image"></span>
                                            </div>
                                            <div class="trv-icon-content">
                                                <h4 class="title">Easy Goa Packages</h4>
                                                <p class="p-text">Simple booking process for hotels, flights, and complete Goa travel packages</p>
                                            </div>
                                            <div class="trv-step-corner-bx">
                                                <div class="trv-step-corner">
                                                    <span>Step</span>
                                                    <div class="number">02</div>
                                                </div>   
                                            </div>
                                            
                                        </div>
                                    </div>
                                    
                                    <div class="col-xl-4 col-lg-6 col-md-6 m-b30">
                                        <div class="trv-servi-bx1 trv-servi-bx-clr3">
                                            <div class="trv-icon">
                                                <span><img src="images/trv-icon/guide-icon.png" alt="Image"></span>
                                            </div>
                                            <div class="trv-icon-content">
                                                <h4 class="title">Local Expertise</h4>
                                                <p class="p-text">Guided by experienced professionals who know Goa's hidden gems and best spots</p>
                                            </div>
                                            <div class="trv-step-corner-bx">
                                                <div class="trv-step-corner">
                                                    <span>Step</span>
                                                    <div class="number">03</div>
                                                </div>   
                                            </div>
                                            
                                        </div>
                                    </div>
                                    
                                </div>

                                <div class="media1-large">
                                    <img src="images/landscape-pic.jpg" alt="image">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="trv-left-bulding"><img src="images/building-1.png" alt="Image"></div>
            <div class="trv-right-sm-plane"><img src="images/Right-top-plane.png" alt="Image"></div>
        </div>
        <!--WE OFFER SERVICES SECTION START-->

        <!--POPULAR SEARCH DESTINATION START-->
        <div class="section-full trv-popular-search">
            <div class="trv-pop-search-carousel-bx">
                <div class="owl-carousel tvr-pop-search-carousel">
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>85 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Baga Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>72 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Calangute Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>65 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Anjuna Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>58 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Vagator Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>55 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Morjim Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>52 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Ashwem Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>48 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Palolem Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>45 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Agonda Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>42 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Colva Beach</a>
                        </div>
                    </div>
                    <div class="item">
                        <div class="tvr-pop-tour">
                            <div class="tvr-total-listing">
                                <i class="bi bi-flag"></i>38 Tours 
                            </div>
                            <a href="#" class="tvr-pop-tour-name">Arambol Beach</a>
                        </div>
                    </div>
                </div>
            </div>
            
                    <div class="container">
                        <div class="tvr-pop-search-bot-section">
                            <div class="row">
                                <div class="col-md-5">
                                    <div class="media">
                                        <img src="images/pop-search-left-pic.png" alt="Image">
                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <div class="tvr-large-title-st1">
                                        <span class="sm-title">Popular Goa!</span>
                                        <h2 class="lg-title">Destinations</h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            
        </div>
        <!--POPULAR SEARCH DESTINATION END-->
    
        <!--EXPLORE POPULAR TOUR START-->
        <div class="section-full trv-popular-tours p-t120">
            <div class="container-fluid">
                <!-- TITLE START-->
                <div class="section-head trv-head-title-wrap center-position">
                    <h2 class="trv-head-title">Rent Your<span class="site-text-yellow"> Ride in Goa!</span></h2>
                    <div class="trv-head-description">Choose from our verified fleet of bikes and cars. Pay at pickup, home delivery available</div>
                    <div class="trv-head-title-image">
                        <img src="images/background/Title-Separator.png" alt="Image">
                    </div>
                </div>
                <!-- TITLE END-->

                <div class="section-content">

                    <div class="swiper trv-popular-tours-row trv-tours-st1-carousal swiper-nav-center-bottom">
                        <div class="swiper-wrapper">
                            <!-- Vehicle 1: Royal Enfield Bullet 350 -->
                            <div class="swiper-slide">
                                <div class="trv-popular-tour-st1">
                                    <div class="trv-media">
                                        <!-- Royal Enfield Bullet ki proper photo -->
                                        <a href="#"><img src="https://cdn.bikedekho.com/processedimages/royal-enfield/classic-650/source/classic-65068d29d3880421.jpg" alt="Royal Enfield Bullet 350"></a>
                                        <div class="trv-tour-duration">
                                            <i class="bi bi-gear"></i>
                                            <span>Manual | 350cc | Petrol</span>
                                        </div>
                                        <div class="trv-tour-title">
                                            <h3 class="trv-title">
                                                <a href="#">
                                                    <i class="bi bi-bicycle"></i>
                                                    Royal Enfield Bullet 350
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="trv-content">
                                        <div class="trv-content-head-section">
                                            <div class="trv-tour-price">
                                                <span class="price">₹899</span>
                                                <span class="price-duration">Per Day</span>
                                            </div>
                                            <div class="trv-tour-info">
                                                <a href="#">Perfect for long rides on Goa's coastal roads. Classic thump sound and comfortable seating.</a>
                                            </div>
                                        </div>
                                        <div class="trv-content-bottom-section">
                                            <div class="trv-book">
                                                <a href="bike-rental.php" class="site-button outline">Book Now</a>
                                            </div>
                                            <div class="trv-tour-rating">
                                                <span class="trv-tour-review-count">(4.8 Review)</span>
                                                <div class="trv-review-rating">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Vehicle 2: Honda Activa 6G -->
                            <div class="swiper-slide">
                                <div class="trv-popular-tour-st1">
                                    <div class="trv-media">
                                        <!-- Honda Activa ki proper photo -->
                                        <a href="#"><img src="https://www.carandbike.com/_next/image?url=https%3A%2F%2Fimages.carandbike.com%2Fbike-images%2Fcolors%2Fhonda%2Factiva-6g%2Fhonda-activa-6g-rebel-red-metallic.jpg%3Fv%3D1641197652&w=640&q=75" alt="Honda Activa 6G"></a>
                                        <div class="trv-tour-duration">
                                            <i class="bi bi-gear"></i>
                                            <span>Automatic | 110cc | Petrol</span>
                                        </div>
                                        <div class="trv-tour-title">
                                            <h3 class="trv-title">
                                                <a href="#">
                                                    <i class="bi bi-scooter"></i>
                                                    Honda Activa 6G
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="trv-content">
                                        <div class="trv-content-head-section">
                                            <div class="trv-tour-price">
                                                <span class="price">₹499</span>
                                                <span class="price-duration">Per Day</span>
                                            </div>
                                            <div class="trv-tour-info">
                                                <a href="#">Best for Goa beaches and city commute. Easy to ride with great fuel efficiency.</a>
                                            </div>
                                        </div>
                                        <div class="trv-content-bottom-section">
                                            <div class="trv-book">
                                                <a href="bike-rental.php" class="site-button outline">Book Now</a>
                                            </div>
                                            <div class="trv-tour-rating">
                                                <span class="trv-tour-review-count">(4.7 Review)</span>
                                                <div class="trv-review-rating">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-half"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Vehicle 3: Maruti Suzuki Swift -->
                            <div class="swiper-slide">
                                <div class="trv-popular-tour-st1">
                                    <div class="trv-media">
                                        <!-- Maruti Swift ki proper photo -->
                                        <a href="#"><img src="https://stimg.cardekho.com/images/car-images/large/Maruti/Swift/7820/1614160452458/226_Pearl-Arctic-White_d1d1d1.jpg?impolicy=resize&imwidth=420" alt="Maruti Suzuki Swift"></a>
                                        <div class="trv-tour-duration">
                                            <i class="bi bi-gear"></i>
                                            <span>Manual | 5 Seater | Petrol</span>
                                        </div>
                                        <div class="trv-tour-title">
                                            <h3 class="trv-title">
                                                <a href="#">
                                                    <i class="bi bi-car-front"></i>
                                                    Maruti Suzuki Swift
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="trv-content">
                                        <div class="trv-content-head-section">
                                            <div class="trv-tour-price">
                                                <span class="price">₹1,799</span>
                                                <span class="price-duration">Per Day</span>
                                            </div>
                                            <div class="trv-tour-info">
                                                <a href="#">Compact hatchback perfect for Goa's narrow lanes and family trips.</a>
                                            </div>
                                        </div>
                                        <div class="trv-content-bottom-section">
                                            <div class="trv-book">
                                                <a href="car-rental.php" class="site-button outline">Book Now</a>
                                            </div>
                                            <div class="trv-tour-rating">
                                                <span class="trv-tour-review-count">(4.6 Review)</span>
                                                <div class="trv-review-rating">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-half"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Vehicle 4: TVS Jupiter 125 -->
                            <div class="swiper-slide">
                                <div class="trv-popular-tour-st1">
                                    <div class="trv-media">
                                        <!-- TVS Jupiter ki proper photo -->
                                        <a href="#"><img src="https://www.tvsmotor.com/-/media/28DECBlogs/TVS-Jupitor-125-Aug.png" alt="TVS Jupiter 125"></a>
                                        <div class="trv-tour-duration">
                                            <i class="bi bi-gear"></i>
                                            <span>Automatic | 125cc | Petrol</span>
                                        </div>
                                        <div class="trv-tour-title">
                                            <h3 class="trv-title">
                                                <a href="#">
                                                    <i class="bi bi-scooter"></i>
                                                    TVS Jupiter 125
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="trv-content">
                                        <div class="trv-content-head-section">
                                            <div class="trv-tour-price">
                                                <span class="price">₹449</span>
                                                <span class="price-duration">Per Day</span>
                                            </div>
                                            <div class="trv-tour-info">
                                                <a href="#">Comfortable family scooter with large under-seat storage for beach gear.</a>
                                            </div>
                                        </div>
                                        <div class="trv-content-bottom-section">
                                            <div class="trv-book">
                                                <a href="bike-rental.php" class="site-button outline">Book Now</a>
                                            </div>
                                            <div class="trv-tour-rating">
                                                <span class="trv-tour-review-count">(4.5 Review)</span>
                                                <div class="trv-review-rating">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-half"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Vehicle 5: Mahindra Thar 4x4 -->
                            <div class="swiper-slide">
                                <div class="trv-popular-tour-st1">
                                    <div class="trv-media">
                                        <!-- Mahindra Thar ki proper photo -->
                                        <a href="#"><img src="https://imgd.aeplcdn.com/1056x594/n/oquamhb_1877457.jpg?q=80" alt="Mahindra Thar 4x4"></a>
                                        <div class="trv-tour-duration">
                                            <i class="bi bi-gear"></i>
                                            <span>Manual | 4 Seater | Diesel</span>
                                        </div>
                                        <div class="trv-tour-title">
                                            <h3 class="trv-title">
                                                <a href="#">
                                                    <i class="bi bi-truck"></i>
                                                    Mahindra Thar 4x4
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="trv-content">
                                        <div class="trv-content-head-section">
                                            <div class="trv-tour-price">
                                                <span class="price">₹3,999</span>
                                                <span class="price-duration">Per Day</span>
                                            </div>
                                            <div class="trv-tour-info">
                                                <a href="#">Adventure vehicle for Goa's off-road trails and beach driving.</a>
                                            </div>
                                        </div>
                                        <div class="trv-content-bottom-section">
                                            <div class="trv-book">
                                                <a href="car-rental.php" class="site-button outline">Book Now</a>
                                            </div>
                                            <div class="trv-tour-rating">
                                                <span class="trv-tour-review-count">(4.9 Review)</span>
                                                <div class="trv-review-rating">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Vehicle 6: Yamaha Fascino 125 -->
                            <div class="swiper-slide">
                                <div class="trv-popular-tour-st1">
                                    <div class="trv-media">
                                        <!-- Yamaha Fascino ki proper photo -->
                                        <a href="#"><img src="https://www.yamaha-motor-india.com/theme/v4/images/webp_images/fascino_all/fascino125fi-new/color/Disc/Dark-Matte-Blue.webp" alt="Yamaha Fascino 125"></a>
                                        <div class="trv-tour-duration">
                                            <i class="bi bi-gear"></i>
                                            <span>Automatic | 125cc | Petrol</span>
                                        </div>
                                        <div class="trv-tour-title">
                                            <h3 class="trv-title">
                                                <a href="#">
                                                    <i class="bi bi-scooter"></i>
                                                    Yamaha Fascino 125
                                                </a>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="trv-content">
                                        <div class="trv-content-head-section">
                                            <div class="trv-tour-price">
                                                <span class="price">₹699</span>
                                                <span class="price-duration">Per Day</span>
                                            </div>
                                            <div class="trv-tour-info">
                                                <a href="#">Stylish and lightweight scooter perfect for Goa's fashion streets.</a>
                                            </div>
                                        </div>
                                        <div class="trv-content-bottom-section">
                                            <div class="trv-book">
                                                <a href="bike-rental.php" class="site-button outline">Book Now</a>
                                            </div>
                                            <div class="trv-tour-rating">
                                                <span class="trv-tour-review-count">(4.4 Review)</span>
                                                <div class="trv-review-rating">
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star-fill"></i>
                                                    <i class="bi bi-star"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    
                </div> 

            </div>
        </div>
        <!--EXPLORE POPULAR TOUR END-->

        <!--3 STEP SECTION START-->
        <div class="section-full trv-3step-section">
            <div class="trv-yl-shedow-left"></div>
            <div class="trv-yl-shedow-right"></div>
            <div class="trv-bl-shedow-top"></div>
            <div class="container">
                <div class="section-content">
                    <div class="trv-3step-section-row">
                        <div class="row">
                            <div class="col-xl-7 col-lg-12 col-md-12">

                                <div class="trv-3step-section-left">
                                    
                                    <!-- TITLE START -->
                                    <div class="section-head trv-head-title-wrap left-position">
                                        <h2 class="trv-head-title"><span class="site-text-yellow">3 Easy Steps </span>to Rent Your Vehicle</h2>
                                    </div>
                                    <!-- TITLE END -->

                                    <div class="trv-3step-section-l-mid">
                                        <div class="trv-offer-st1">
                                            <div class="media"><img src="images/offer/pic1.jpg" alt="Image"></div>
                                            <div class="info">
                                                <span class="sm-title">Summer Special</span>
                                                <div class="ofr-price">
                                                    <h2 class="lg-title">25</h2>
                                                    <div class="per-off">%<span>Off</span></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="trv-step-bx2-wrap">

                                            <div class="trv-step-bx2">
                                                <div class="trv-tp-part">
                                                    <div class="trv-num">
                                                        01
                                                    </div>
                                                    <div class="info">
                                                        <div class="trv-title">Choose Your Ride</div>
                                                        <p class="trv-text">Select from our premium fleet of bikes and cars for your Goa adventure</p>
                                                    </div>
                                                    <div class="trv-icon-back">
                                                        <div class="trv-icon-front">
                                                            <img src="images/trv-icon/destination.png" alt="image">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="trv-step-bx2">
                                                <div class="trv-tp-part">
                                                    <div class="trv-num">
                                                        02
                                                    </div>
                                                    <div class="info">
                                                        <div class="trv-title">Submit Documents</div>
                                                        <p class="trv-text">Upload your license and ID proof for quick verification and approval</p>
                                                    </div>
                                                    <div class="trv-icon-back">
                                                        <div class="trv-icon-front">
                                                            <img src="images/trv-icon/make-payment.png" alt="image">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="trv-step-bx2">
                                                <div class="trv-tp-part">
                                                    <div class="trv-num">
                                                        03
                                                    </div>
                                                    <div class="info">
                                                        <div class="trv-title">Ready to Explore</div>
                                                        <p class="trv-text">Pick up your vehicle and start exploring Goa's beautiful destinations</p>
                                                    </div>
                                                    <div class="trv-icon-back">
                                                        <div class="trv-icon-front">
                                                            <img src="images/trv-icon/travelling.png" alt="image">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="col-xl-5 col-lg-12 col-md-12">
                                <div class="trv-for-summer-section">
                                    <img src="images/Girl-Image.png" alt="" class="media-girl">
                                    <img src="images/hotballon-Left.png" alt="" class="media-left-ballon">
                                    <img src="images/hotballon-right.png" alt="" class="media-right-ballon">
                                    <img src="images/cloud-1.png" alt="Image" class="media-cloud1">
                                    <img src="images/cloud-2.png" alt="Image" class="media-cloud2">
                                    <div class="trv-for-summer-text-wrap">
                                        <span>Perfect for <b>Goa!</b></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="trv-whychoose">
                    <div class="w-choo-left">
                        <h3 class="w-title">
                            Why Choose GoaReddy!
                        </h3>
                        <div class="trv-cloumn-list">
                            <ul>
                                <li><i class="feather feather-check"></i><span>Well-Maintained Vehicles</span></li>
                                <li><i class="feather feather-check"></i><span>Transparent Pricing</span></li>
                                <li><i class="feather feather-check"></i><span>24/7 Roadside Support</span></li>
                                <li><i class="feather feather-check"></i><span>Easy Document Process</span></li>
                            </ul>
                        </div>
                        <a href="#" class="site-button butn-bg-shape">Book Now</a>
                    </div>
                    <div class="w-choo-right">
                        <div class="media">
                            <img src="images/24-Image.png" alt="image">
                        </div>
                        <div class="info">
                            <h3 class="call-us">Call Us Now</h3>
                            <span class="num">+91 8906666657</span>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!--3 STEP SECTION END-->

        <!--TESTIMONIAL SECTION START-->
        <div class="section-full trv-testimonial-st2-wrap tvr-hot-ballon-wrap">
            <div class="container">
                <!-- TITLE START-->
                <div class="section-head trv-head-title-wrap center-position">
                    <h2 class="trv-head-title">Our Happy <span class="site-text-yellow">Customers!</span></h2>
                    <div class="trv-head-discription">Hear what our customers say about their Goa rental experience with us</div>
                    <div class="trv-head-title-image">
                        <img src="images/background/Title-Separator.png" alt="Image">
                    </div>
                </div>
                <!-- TITLE END-->
                <div class="section-content">
                    <div class="trv-gradi-text">
                        Reviews
                        <img src="images/airplane-takeoff1.png" alt="Image">
                    </div>

                    <div class="trv-testimonial-st2">
                        <!--Image Slider-->
                        <div class="swiper testimonial-content-sld">
                            <div class="swiper-wrapper">
                                <!--1-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic1.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Rahul Sharma</h4>
                                                    <span class="trv-testimonial-position">Royal Enfield Rider</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Rented a Royal Enfield Bullet for 3 days in Goa. The bike was in perfect condition and delivery was prompt. Highly recommended for bike enthusiasts!
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--2-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic2.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Priya Patel</h4>
                                                    <span class="trv-testimonial-position">Family Vacationer</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Booked a Maruti Swift for our family trip. The car was clean, well-maintained and perfect for Goa roads. Deposit refund was instant!
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--3-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic3.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Amit Kumar</h4>
                                                    <span class="trv-testimonial-position">Adventure Traveler</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Took a Mahindra Thar for off-roading in North Goa. Amazing experience! The 4x4 performed excellently on beaches. Will rent again!
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--4-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic4.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Simran Kaur</h4>
                                                    <span class="trv-testimonial-position">Solo Traveler</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Rented a Honda Activa for beach hopping. Perfect scooter for Goa weather. Service was excellent with 24/7 support available.
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--5-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic1.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Vikram Singh</h4>
                                                    <span class="trv-testimonial-position">Group Traveler</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Booked Toyota Innova for our group of 6. Spacious and comfortable car. The driver option was very convenient. Great service!
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--6-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic2.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Neha Gupta</h4>
                                                    <span class="trv-testimonial-position">Couple Traveler</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Yamaha Fascino was perfect for our couple trip. Lightweight, stylish and easy to handle. The pay-at-pickup option was very helpful.
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--7-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic3.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Rajesh Mehta</h4>
                                                    <span class="trv-testimonial-position">Business Traveler</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                Rented a TVS Jupiter for quick meetings across Panjim. Very reliable scooter with good mileage. Will use their service again.
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-half"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--8-->
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2">
                                        <div class="media">
                                            <img src="images/trv-testimonial2/pic4.jpg" alt="Image">
                                        </div>
                                        <div class="info">
                                            <div class="trv-testimo-head">
                                                <div class="left-part">
                                                    <h4 class="trv-testimonial-name">Sneha Reddy</h4>
                                                    <span class="trv-testimonial-position">Local Resident</span>
                                                </div>
                                                <div class="right-part">
                                                    <img src="images/trv-icon/Quote.png" alt="image">
                                                </div>
                                            </div>
                                            <p>
                                                As a Goan, I regularly rent bikes for my relatives visiting from out of town. Best rental service in Goa with transparent pricing.
                                            </p>
                                            <div class="rating">
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                                <i class="bi bi-star-fill"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="testimonial-content-sld-control">
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                            
                        </div>
                        <!--Thumbnail Slider-->
                        <div class="swiper testimonial-thum-sld">
                            <div class="swiper-wrapper">

                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic1.jpg" alt="Image">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic2.jpg" alt="Image">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic3.jpg" alt="Image">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic4.jpg" alt="Image">
                                    </div>
                                </div>

                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic1.jpg" alt="Image">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic2.jpg" alt="Image">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic3.jpg" alt="Image">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="trv-testimo-bx2-thumb">
                                        <img src="images/trv-testimonial2/pic4.jpg" alt="Image">
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="right-hot-ballon"><img src="images/hotballon-right.png" alt="image"></div>
        </div>
        <!--TESTIMONIAL SECTION End-->

        <!-- ADVENTURE SECTION START -->
        <div class="trv-adventure-st1" style="background-image: url(images/background/adv-bg.jpg);">
            <div class="circle-text2">
                <div class="emblem-wrap">
                    <div class="emblem">Want-to-see-our-top-destinations-</div>
                    <i><img src="images/advanture-st1.png" alt="In Circle Pic"></i>
                </div>
            </div>
            <h2 class="adventure-title">Adventure</h2>
            <p class="adventure-text">It’s time to Travel </p>
            <a href="#enq-form" class="site-button butn-bg-shape">Booking Now</a>
        </div>
        <!-- ADVENTURE SECTION END -->
        
        <!--FAQ SECTION START-->
        <div class="section-full trv-faq-warp p-t120 p-b90">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5 col-md-12">
                        <div class=" trv-faq-left-media-wrap m-b30">
                            <!-- TITLE START-->
                            <div class="section-head trv-head-title-wrap left-position">
                                <h2 class="trv-head-title">Find <span class="site-text-yellow">Answers</span> for Vehicle Rental Questions.</h2>
                                <div class="trv-head-discription">
                                    GoaReddy provides reliable vehicle rental services in Goa. Get answers to all your questions about bike and car rentals for a hassle-free Goan experience.
                                </div>
                            </div>
                            <!-- TITLE END-->
                            <div class="trv-faq-left-media-wrap">
                                <div class="trv-f-pic">
                                    <img src="images/faq-media.png" alt="#">
                                </div>
                                <div class="trv-f-quote">
                                    <div class="trv-f-quote-icon"><i class="bi bi-quote"></i></div>
                                    <h3 class="trv-title">Rent with confidence in Goa!</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-12">
                        <div class="trv-faq-right-section m-b30">
                            <!-- Accordian -->
                            <div class="wt-accordion" id="accordion-two">

                                <!--One-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingOne">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            01 - What documents are required for vehicle rental?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            For bike rentals: Original Driving License (with 2-wheeler endorsement), ID Proof (Aadhar/Passport), and 2 passport photos. For car rentals: Original Driving License (with 4-wheeler endorsement), ID Proof, and address proof. International tourists need International Driving Permit.
                                        </div>
                                    </div>
                                </div>

                                <!--Two-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingTwo">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                02 - What is the security deposit amount?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            Scooters: ₹1500-₹2000, Bikes: ₹2000-₹3000, Cars: ₹5000-₹10000 depending on vehicle model. Deposit is fully refundable upon safe return of vehicle in original condition within 24 hours.
                                        </div>
                                    </div>
                                </div> 
                                
                                <!--Three-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingThree">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                                03 - Do you provide helmets with bike rentals?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            Yes, we provide ISI-certified helmets free of charge with every two-wheeler rental. We offer both full-face and open-face helmets. Additional helmets available at ₹50/day.
                                        </div>
                                    </div>
                                </div> 
                                
                                <!--Four-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingFour">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                                04 - What is your cancellation policy?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            Cancellation 48 hours before pickup: Full refund. 24-48 hours: 50% refund. Less than 24 hours: No refund. For peak season (Nov-Feb) bookings, cancellation policy may vary.
                                        </div>
                                    </div>
                                </div>

                                <!--Five-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingFive">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                                05 - Is fuel included in the rental price?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            No, fuel is not included. We provide sufficient fuel to reach nearest petrol pump. Please return vehicle with similar fuel level. Fuel charges are borne by customer.
                                        </div>
                                    </div>
                                </div>

                                <!--Six-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingSix">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                                06 - Do you offer delivery and pickup service?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseSix" class="collapse" aria-labelledby="headingSix" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            Yes, free delivery within 5km radius of our locations (Panjim, Calangute, Margao). Beyond 5km, ₹100 delivery charge. Airport pickup/drop available at additional charges.
                                        </div>
                                    </div>
                                </div>
                                
                                <!--Seven-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingSeven">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                                07 - What happens in case of breakdown or accident?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseSeven" class="collapse" aria-labelledby="headingSeven" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            Call our 24/7 helpline immediately. Basic repairs covered. For accidents, inform us first. Third-party liability insurance provided. Customer responsible for vehicle damage as per rental agreement.
                                        </div>
                                    </div>
                                </div>

                                <!--Eight-->
                                <div class="panel wt-panel">
                                    <div class="acod-head" id="headingEight">
                                        <h4 class="acod-title">
                                            <a class="collapsed" data-bs-toggle="collapse" href="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                                                08 - What is the minimum age for renting?
                                            <span class="indicator"><i class="bi bi-chevron-right"></i></span>
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseEight" class="collapse" aria-labelledby="headingEight" data-bs-parent="#accordion-two">
                                        <div class="acod-content p-tb15">
                                            Two-wheelers: Minimum 18 years with valid license. Four-wheelers: Minimum 21 years with valid license. International tourists need valid International Driving Permit.
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--FAQ SECTION END-->

        <!--ALL BLOGS SECTION START-->
        <div class="trv-blog-all-style p-t120 p-b90">
            <div class="container">
                  <!--TITLE START -->
                <div class="row trv-column-style-head">
                    <div class="col-xl-4 col-lg-6 col-md-12">
                        <div class="section-head trv-head-title-wrap left-position">
                            <h2 class="trv-head-title">Explore<span class="site-text-yellow"> Goa Travel Tips</span></h2>
                            <div class="trv-head-discription">Get the latest updates on Goa travel, vehicle rental tips, and essential information for planning your perfect Goan adventure with GoaReddy.</div>
                        </div>
                    </div>
                    <div class="col-xl-8 col-lg-6 col-md-12">
                        <div class="trv-column-style-head-btn">
                            <a href="blogs.php" class="site-button butn-bg-shape">See More Articles</a>
                        </div>
                    </div>
                </div>
                  <!--TITLE END -->

                <div class="section-content">

                    <div class="row d-flex justify-content-center">

                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="trv-blog-st1">
                                <div class="trv-post-media">
                                    <a href="#"><img src="images/trv-blog/blog-sm/pic1.jpg" alt="Image"></a>
                                </div>
                                
                                <div class="post-date"><span>14</span>June</div>                                        
                                <div class="trv-post-info">
                                    <div class="post-category">Rohan Singh</div>
                                    <div class="trv-post-title ">
                                        <h5 class="post-title"><a href="#">Complete Guide to Renting Bikes in Goa - 2024 Tips</a></h5>
                                    </div>
                                </div>                                
                            </div>

                            <div class="trv-blog-st1">
                                <div class="trv-post-media">
                                    <a href="#"><img src="images/trv-blog/blog-sm/pic2.jpg" alt="Image"></a>
                                </div>
                                
                                <div class="post-date"><span>26</span>June</div>                                        
                                <div class="trv-post-info">
                                    <div class="post-category">Priya Sharma</div>
                                    <div class="trv-post-title ">
                                        <h5 class="post-title"><a href="#">Essential Documents Required for Vehicle Rental in Goa</a></h5>
                                    </div>
                                </div>                                
                            </div>

                            <div class="trv-blog-st1">
                                <div class="trv-post-media">
                                    <a href="#"><img src="images/trv-blog/blog-sm/pic3.jpg" alt="Image"></a>
                                </div>
                                
                                <div class="post-date"><span>20</span>June</div>                                        
                                <div class="trv-post-info">
                                    <div class="post-category">Ajay Kumar</div>
                                    <div class="trv-post-title ">
                                        <h5 class="post-title"><a href="#">Best Goa Beaches Accessible by Two-Wheelers</a></h5>
                                    </div>
                                </div>                                
                            </div>

                        </div>

                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="trv-blog-st1">
                                <div class="trv-post-media">
                                    <a href="#"><img src="images/trv-blog/blog-sm/pic4.jpg" alt="Image"></a>
                                </div>
                                
                                <div class="post-date"><span>28</span>June</div>                                        
                                <div class="trv-post-info">
                                    <div class="post-category">Neha Patel</div>
                                    <div class="trv-post-title ">
                                        <h5 class="post-title"><a href="#">Car vs Bike: What's Best for Goa Family Vacation?</a></h5>
                                    </div>
                                </div>                                
                            </div>


                            <div class="trv-blog-st2">
                                <div class="trv-post-media">
                                    <a href="#"><img src="images/trv-blog/blog-md/pic1.jpg" alt="Image"></a>
                                </div>
                                
                                <div class="post-date"><span>15</span>July</div>                                        
                                <div class="trv-post-info">
                                    <div class="post-category">GoaReddy Team</div>
                                    <div class="trv-post-title ">
                                        <h5 class="post-title"><a href="#">Monsoon Travel in Goa: Safety Tips for Vehicle Rentals</a></h5>
                                    </div>
                                </div>                                
                            </div>
                        

                        </div>

                        <div class="col-xl-4 col-lg-6 col-md-6">

                            <div class="trv-blog-st3">
                                <div class="trv-post-media">
                                    <a href="#"><img src="images/trv-blog/blog-lg/pic1.jpg" alt="Image"></a>
                                </div>
                                
                                <div class="post-date"><span>08</span>June</div>                                        
                                <div class="trv-post-info">
                                    <div class="post-category">By Goa Travel Expert</div>
                                    <div class="trv-post-title ">
                                        <h3 class="post-title"><a href="#">Ultimate Goa Travel Guide: Top 10 Must-Visit Places with Rental Vehicles</a></h3>
                                    </div>
                                </div>                                
                            </div> 
                            
                        </div>

                    </div>
                        
                </div>  

            </div>
        </div>
        <!--ALL BLOGS SECTION END-->
    
        <?php include 'enquiry-form.php'; ?>
    </div>
    <!-- CONTENT END -->

</div>

</main>

<script>
document.getElementById('travelForm').addEventListener('submit', function(e) {
  e.preventDefault();

  const form = e.target;

  const location = form.goa_location.value;
  const activity = form.activity.value;
  const date = form.travel_date.value;
  const travelers = form.travelers.value;

  let message =
    `✈️ Goa Travel Enquiry%0A` +
    `📍 Location: ${location}%0A` +
    `🎯 Activity: ${activity}%0A` + 
    `📅 Travel Date: ${date}%0A` +
    `👥 Travellers: ${travelers}%0A` +
    `_Sent via GoaReddy Website_`;

  const whatsappNumber = "8906666657";
  const whatsappURL = `https://wa.me/${whatsappNumber}?text=${message}`;

  window.open(whatsappURL, '_blank');
  
  // Optional: Reset form
  form.reset();
  form.travelers.value = 1;
});
</script>
<?php include 'footer.php'; ?>

