        <!--CONTACT SECTION START-->
        <div class="section-full trv-contact-form" id="enq-form">
            <div class="row">
                <div class="col-lg-6 col-md-12 trv-cot-media-section" style="background-image: url(images/background/con-sec-bg.jpg);">
                    <div class="trv-cot-media-info">
                        <h4 class="trv-subtitle">Plan Your Perfect Goa Trip!</h4>
                <h2 class="trv-title">Let's Create Your Dream Vacation</h2>
                <p class="trv-subtext">Tell us about your travel plans and we'll customize the perfect Goa experience just for you.</p>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="trv-contact-right-part">
                        <div class="trv-form">
                            <!-- TITLE START-->
                            <div class="section-head trv-head-title-wrap left-position">
                                <h2 class="trv-head-title"><span class="site-text-yellow">Reach</span> & Get in Touch With Us!</h2>
                                <div class="trv-head-discription">We'd love to hear from you. Our friendly team is always here to chat</div>
                            </div>
                            <!-- TITLE END-->
                            <form class="trv-cons-contact-form" id="travelForm">
                                <!-- Name -->
                                <div class="form-group">
                                    <input class="form-control" type="text" name="name" placeholder="Enter Your Name" required>
                                </div>
                                
                                <!-- Contact Number -->
                                <div class="form-group">
                                    <input class="form-control" type="tel" name="phone" placeholder="Contact Number" required>
                                </div>
                                
                                <!-- Select Goa Location -->
                                <div class="form-group">
                                    <select class="form-control" name="goa_location" required>
                                        <option value="">Select Destination in Goa</option>
                                        <option value="baga">North Goa Beaches</option>
                                        <option value="calangute">South Goa Beaches</option>
                                        <option value="anjuna">Both </option>
                                        
                                    </select>
                                </div>
                                
                                <!-- Travel Date and No. of Travelers in one row -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <input class="form-control" type="date" name="travel_date" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <div class="quantity-input">
                                                <button type="button" class="qty-btn minus">-</button>
                                                <input type="number" name="travelers" value="1" min="1" max="20" class="form-control qty-input">
                                                <button type="button" class="qty-btn plus">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Message -->
                                <div class="form-group">
                                    <textarea class="form-control" name="message" placeholder="Message" rows="3"></textarea>
                                </div>
                                
                                <button type="submit" class="site-button butn-bg-shape">Send Message</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--CONTACT SECTION END-->
        
<style>
    .trv-subtext{
        color:#fff;
        padding:10px;
        font-family: "Kaushan Script", cursive;
        font-size: 20px;
        font-weight: 400;
    }

/* Quantity Input Styling */
.quantity-input {
    display: flex;
    align-items: center;
}

.qty-input {
    width: 60px;
    text-align: center;
    margin: 0 5px;
    padding: 0;
    border: 1px solid #ddd;
    border-radius: 0;
    -moz-appearance: textfield;
}

.qty-input::-webkit-outer-spin-button,
.qty-input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
}

.qty-btn {
    width: 40px;
    height: 50px;
    background: #f8f9fa;
    border: 1px solid #ddd;
    font-size: 18px;
    font-weight: bold;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}

.qty-btn:hover {
    background: #e9ecef;
    border-color: #ccc;
}

.qty-btn.minus {
    border-radius: 8px 0 0 8px;
}

.qty-btn.plus {
    border-radius: 0 8px 8px 0;
}

/* Form styling */
.form-control {
    padding: 12px 15px;
    height: 50px;
    border-radius: 8px;
    border: 1px solid #ddd;
    font-size: 15px;
}

.form-control:focus {
    border-color: #FFD700;
    box-shadow: 0 0 0 0.2rem rgba(255, 215, 0, 0.25);
}

textarea.form-control {
    height: auto;
    min-height: 100px;
    resize: vertical;
}

/* Date input styling */
input[type="date"] {
    position: relative;
    padding-right: 40px;
    background: white url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23666' viewBox='0 0 16 16'%3E%3Cpath d='M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z'/%3E%3C/svg%3E") no-repeat right 15px center;
    background-size: 16px;
}

input[type="date"]::-webkit-calendar-picker-indicator {
    opacity: 0;
    position: absolute;
    right: 0;
    width: 100%;
    height: 100%;
    cursor: pointer;
}

/* Select styling */
select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23666' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 15px center;
    background-size: 12px;
    padding-right: 35px;
}

/* Button styling - same as original */
.site-button.butn-bg-shape {
    padding: 12px 30px;
    font-size: 16px;
    font-weight: 600;
    margin-top: 10px;
    width: auto;
    display: inline-block;
}
</style>

<script>
// Quantity button functionality
document.addEventListener('DOMContentLoaded', function() {
    const quantityInputs = document.querySelectorAll('.qty-input');
    
    quantityInputs.forEach(input => {
        const minusBtn = input.previousElementSibling;
        const plusBtn = input.nextElementSibling;
        
        minusBtn.addEventListener('click', () => {
            let value = parseInt(input.value);
            if (value > parseInt(input.min || 1)) {
                input.value = value - 1;
            }
        });
        
        plusBtn.addEventListener('click', () => {
            let value = parseInt(input.value);
            const max = parseInt(input.max || 20);
            if (value < max) {
                input.value = value + 1;
            }
        });
        
        // Ensure value stays within bounds
        input.addEventListener('change', () => {
            let value = parseInt(input.value);
            const min = parseInt(input.min || 1);
            const max = parseInt(input.max || 20);
            
            if (isNaN(value)) value = min;
            if (value < min) value = min;
            if (value > max) value = max;
            
            input.value = value;
        });
    });
});
</script>

<script>
document.getElementById('travelForm').addEventListener('submit', function(e) {
  e.preventDefault();

  const form = e.target;

  const name = form.name.value;
  const phone = form.phone.value;
  const location = form.goa_location.value;
  const date = form.travel_date.value;
  const travelers = form.travelers.value;
  const messageText = form.message.value;

  let message =
    `✈️ Travel Enquiry%0A` +
    `Name: ${name}%0A` +
    `Phone: ${phone}%0A` +
    `Destination: ${location}%0A` + 
    `Travel Date: ${date}%0A` +
    `Travellers: ${travelers}`;

  if (messageText) {
    message += `%0AMessage: ${messageText}`;
  }

  const whatsappNumber = "8906666657";
  const whatsappURL = `https://wa.me/${whatsappNumber}?text=${message}`;

  window.open(whatsappURL, '_blank');
});
</script>
