<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | Dudhsagar Waterfall Trip Goa</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Dudhsagar Waterfall Trip Goa</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>Dudhsagar Waterfall Trip Goa</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

<!-- SECTION START -->
<div class="section-full p-t120 p-b90">
    <div class="container">
        <!-- SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                    <div class="trv-detail-main-wrap">
                        <!--Info Start-->
                        <div class="trv-detail-bx-wrap">
                            <div class="trv-inr-para2">
                                <div class="trv-sep-rating">
                                    <div class="trv-rating">
                                        <span>(4.8 Review)</span>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                    </div>
                                </div>
                                <h3 class="trv-inner-title-lg">Dudhsagar Waterfall Trip</h3>
                                <span class="trv-packege-esti-time">Goa's Most Popular Waterfall Adventure</span>

                                <!--Top SLider-->
                                <div class="trv-detail-slider">
                                    <div class="swiper trv_d-slider">
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dsw-4.webp" alt="Dudhsagar Waterfall">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/nss6.webp" alt="Jeep Safari">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dsw-3.webp" alt="Spice Plantation">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide"> 
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dsw-5.webp" alt="Buffet Lunch">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dsw-6.webp" alt="Forest Adventure">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dsw-1.webp" alt="Waterfall View">   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <!--Top SLider End-->

                                <!-- Navigation -->
                                <nav class="navbar-one">
                                    <a href="#overview">Package Overview</a>
                                    <a href="#details">Package Details</a>
                                    <a href="#inclusions">Inclusions / Exclusions</a>
                                </nav>

                                <!-- Over View-->
                                <section id="overview">
                                    <h3 class="trv-inner-title-sm">Dudhsagar Waterfall Trip Package Overview</h3>
                                    <p>Experience Goa's most spectacular natural wonder - Dudhsagar Waterfall! A full-day adventure package including jeep safari through forests, spice plantation tour, waterfall visit, and unlimited buffet lunch. Quality service with government approved operators.</p>

                                    <h4 class="trv-inner-title-sm mt-4">Package Highlights:</h4>
                                    <ul class="trv-checklist-st1">
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Full Day Adventure</strong> - 6:00 AM to 5:30 PM
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Jeep Safari Experience</strong> - Through forest trails to waterfall
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Spice Plantation Tour</strong> - Guided educational tour
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Unlimited Buffet Lunch</strong> - At spice plantation
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Dudhsagar Waterfall Visit</strong> - Goa's largest waterfall
                                        </li>
                                    </ul>
                                </section>

                                <!-- Package Details-->
                                <section id="details">
                                    <h3 class="trv-inner-title-sm">Complete Waterfall Adventure Experience</h3>
                                    
                                    <div class="trv-clist-st-3-wrap">
                                        <ul class="trv-list-st-3">
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-tree"></i></div>
                                                        </div>
                                                        <span class="day">ADVENTURE</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Jeep Safari & Forest Adventure to Dudhsagar</h4>
                                                        <p>Exciting jeep safari through Bhagwan Mahavir Wildlife Sanctuary to reach Dudhsagar Waterfall. Includes forest entry fees, life jacket fees, and all government charges. Experience the thrill of off-road adventure.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-3.webp" alt="Jeep Safari">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-2.webp" alt="Forest Adventure">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-flower1"></i></div>
                                                        </div>
                                                        <span class="day">PLANTATION</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Spice Plantation Educational Tour</h4>
                                                        <p>Guided tour of authentic Goan spice plantation. Learn about various spices like cardamom, pepper, cinnamon, and their cultivation. Experience the aroma and beauty of Goan plantations.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-water"></i></div>
                                                        </div>
                                                        <span class="day">WATERFALL</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Dudhsagar Waterfall - The Sea of Milk</h4>
                                                        <p>Visit to Goa's most famous Dudhsagar Waterfall, one of India's tallest waterfalls. Perfect for photography, swimming (seasonal), and enjoying nature's beauty. Safety equipment and guidance provided.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-7.webp" alt="Dudhsagar Waterfall">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-8.webp" alt="Waterfall View">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-9.webp" alt="Natural Beauty">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-egg-fried"></i></div>
                                                        </div>
                                                        <span class="day">DINING</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Unlimited Buffet Lunch at Plantation</h4>
                                                        <p>Delicious unlimited buffet lunch served at the spice plantation. Enjoy authentic Goan and Indian cuisine in a natural setting. Vegetarian and non-vegetarian options available.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-bicycle"></i></div>
                                                        </div>
                                                        <span class="day">ACTIVITIES</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Adventure Activities (Extra Cost)</h4>
                                                        <p>For adventure lovers, additional activities available: Giant Swing, Zipline, Climbing Rope Activity, Archery, and Target Shooting (available at extra cost). Perfect for thrill seekers.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-5.webp" alt="Zipline">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-6.webp" alt="Archery">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ds-4.webp" alt="Adventure">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </section>

                                <!-- Inclusion/Exclusions-->
                                <section id="inclusions">
                                    <div class="trv-checklist-st2-mini-wrap">
                                        <div class="row">
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-l">
                                                <h3 class="trv-inner-title-sm">PACKAGE INCLUDE</h3>
                                                <ul class="trv-checklist-st2-mini">
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Pick up from hotel</strong> - Main road by AC sharing coach
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Jeep Safari Fees</strong> - Complete safari to waterfall
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Forest Entry & Life Jacket Fees</strong> - All included
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Online Reservation + GTDC Fee</strong> - Government charges
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>English & Hindi Speaking Tour Coordinator</strong> - Guided tour
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Spice Plantation Tour</strong> - Educational visit
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Unlimited Buffet Lunch</strong> - At spice plantation
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Dudhsagar Waterfall Visit</strong> - Main attraction
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-r">
                                                <h3 class="trv-inner-title-sm">Not Included</h3>
                                                <ul class="trv-checklist-st2-mini trv-list-disable">
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Professional Camera Charges
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Beverages (Soft drinks & Liquor)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Breakfast
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Adventure Activities (Extra cost)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Personal expenses
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </section>

                            </div>
                        </div>
                    </div> 
                </div> 

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar m-b30">
                    <aside class="side-bar">
                        <div class="trv-tour-single-r-detail">
                            <span class="trv-star-from">Starting from</span>
                            <span class="trv-star-amount">
                                <s>$27</s> ₹2,250
                            </span>
                            <span class="trv-star-from-person">/ Person</span>
                            <div class="trv-emi_text">
                                <i class="bi bi-wallet"></i>Best Quality Service
                                <span class="trvng-binding"></span> 
                                <a class="chsemi" href="javascript:;">Special Deals</a>
                            </div>
                            <button type="button" class="site-button butn-bg-shape" onclick="sendWhatsAppEnquiry()">
                                <i class="bi bi-whatsapp"></i>Enquiry Now
                            </button>
                        </div>

                        <div class="trv-tour-single-r-info">
                            <div class="trv-main-rg-hol">
                                <div class="trv-man-sec-hol">
                                    <ul>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Trip Duration : </span>
                                            <span class="ng-binding">6:00 AM to 5:30 PM</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-truck"></i> Transport : </span>
                                            <span class="ng-binding">AC Sharing Coach</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-tree"></i> Activities : </span>
                                            <span class="ng-binding">Jeep Safari + Waterfall</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-person-check"></i> Guide : </span>
                                            <span class="ng-binding">English & Hindi Speaking</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-exclamation-circle"></i> Note : </span>
                                            <span class="trv-tmi-hlo-info">Don't Go For Price Go For Quality Service</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-award"></i> Service : </span>
                                            <span class="trv-tmi-hlo-info">Government Approved Operator</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-patch-check"></i> Approval : </span>
                                            <span class="trv-tmi-hlo-info">Approved by Govt. of Goa</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-shield-check"></i> Quality : </span>
                                            <span class="trv-tmi-hlo-info">Trusted Service Provider</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="trv-oack-sepa"><span class="lay"> Package Includes</span></div>
                                
                                <div class="trv-icon-man-holids">
                                    <ul>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/hotels.png" alt="Pickup">
                                            </div>
                                            <div class="trv-holids-name">Hotel Pickup</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/Sightseeing.png" alt="Sightseeing">
                                            </div>
                                            <div class="trv-holids-name">Jeep Safari</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/car.png" alt="Transport">
                                            </div>
                                            <div class="trv-holids-name">AC Transport</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/meal.png" alt="Lunch">
                                            </div>
                                            <div class="trv-holids-name">Buffet Lunch</div>
                                        </li>
                                        
                                    </ul>
                                </div>
                                
                                <div class="trv-booking-notes mt-4">
                                    <h5 class="trv-inner-title-sm">Adventure Activities (Extra Cost):</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-plus-circle"></i> Giant Swing</li>
                                        <li><i class="bi bi-plus-circle"></i> Zipline</li>
                                        <li><i class="bi bi-plus-circle"></i> Climbing Rope Activity</li>
                                        <li><i class="bi bi-plus-circle"></i> Archery</li>
                                        <li><i class="bi bi-plus-circle"></i> Target Shooting</li>
                                    </ul>
                                </div>

                            </div>
                        </div>
                    </aside>
                </div>
                <!-- SIDE BAR END -->
            </div>
        </div>
    </div>
</div>
<!-- SECTION END -->

<script>
// WhatsApp Enquiry Function
function sendWhatsAppEnquiry() {
    const whatsappNumber = "8906666657";
    const message = `🎯 *DUDHSAGAR WATERFALL TRIP PACKAGE ENQUIRY* 🎯
    
🌿 *Package:* Dudhsagar Waterfall Trip
💰 *Price:* ₹2,250 Per Person
⏰ *Duration:* 6:00 AM to 5:30 PM (Full Day)

📋 *Package Includes:*
✅ Pick up from hotel main road by AC sharing coach
✅ Jeep Safari Fees to Dudhsagar
✅ Forest Entry & Life Jacket Fees
✅ Online Reservation + GTDC Fee
✅ English & Hindi Speaking Tour Coordinator
✅ Spice Plantation Tour
✅ Unlimited Buffet lunch at Spice Plantation
✅ Dudhsagar Waterfall Visit

🏆 *Quality Assurance:*
• Government Approved Operator
• Don't Go For Price Go For Quality Service
• Trusted Service Provider

🎯 *Adventure Activities (Extra Cost):*
• Giant Swing • Zipline • Climbing Rope Activity
• Archery • Target Shooting

👤 *My Details:*
Name: ______
Travel Date: ______
Number of Persons: ______
Contact Number: ______

📞 *Contact:* Best Travel Partner in Goa

Please provide more details and availability.`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappURL, '_blank');
}

// Initialize Swiper Slider
document.addEventListener('DOMContentLoaded', function() {
    if(document.querySelector('.trv_d-slider')) {
        const swiper = new Swiper('.trv_d-slider', {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            loop: true,
        });
    }
});
</script>
    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>