<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | Coral Queen Cruise Goa</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Coral Queen Cruise Goa</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>Coral Queen Cruise Goa</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

<!-- SECTION START -->
<div class="section-full p-t120 p-b90">
    <div class="container">
        <!-- SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                    <div class="trv-detail-main-wrap">
                        <!--Info Start-->
                        <div class="trv-detail-bx-wrap">
                            <div class="trv-inr-para2">
                                <div class="trv-sep-rating">
                                    <div class="trv-rating">
                                        <span>(4.8 Review)</span>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                    </div>
                                </div>
                                <h3 class="trv-inner-title-lg">Coral Queen Cruise </h3>
                                <span class="trv-packege-esti-time">Goa's Biggest Cruise Experience</span>

                                <!--Top SLider-->
                                <div class="trv-detail-slider">
                                    <div class="swiper trv_d-slider">
                                        <div class="swiper-wrapper">
                                            
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cqc-2.webp" alt="Mandovi River Cruise">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dc2.webp" alt="Buffet Dinner">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cqc-1.webp" alt="DJ Music">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dc4.webp" alt="River View">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cqc-3.webp" alt="Panjim City">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/dc6.webp" alt="Coral Queen Cruise">   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <!--Top SLider End-->

                                <!-- Navigation -->
                                <nav class="navbar-one">
                                    <a href="#overview">Package Overview</a>
                                    <a href="#details">Package Details</a>
                                    <a href="#inclusions">Inclusions / Exclusions</a>
                                </nav>

                                <!-- Over View-->
                                <section id="overview">
                                    <h3 class="trv-inner-title-sm">Coral Queen Cruise Package Overview</h3>
                                    <p>Dine with loads of entertainment on Goa's biggest cruise - Coral Queen! Experience an unforgettable evening on Mandovi River with Russian dance performances, Bollywood music, unlimited buffet dinner, and spectacular views of Panjim city.</p>

                                    <h4 class="trv-inner-title-sm mt-4">Package Highlights:</h4>
                                    <ul class="trv-checklist-st1">
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>3 Hours Cruising</strong> - Goa's biggest cruise experience
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Unlimited Buffet Dinner</strong> - Veg/Non-veg options available
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Russian & Bollywood Dance Performances</strong> - Live entertainment
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>2 Complimentary Drinks</strong> - Alcoholic/Non-alcoholic
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Panjim City Sightseeing</strong> - 2 hours duration
                                        </li>
                                    </ul>
                                </section>

                                <!-- Package Details-->
                                <section id="details">
                                    <h3 class="trv-inner-title-sm">Complete Cruise Experience</h3>
                                    
                                    <div class="trv-clist-st-3-wrap">
                                        <ul class="trv-list-st-3">
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-music-note"></i></div>
                                                        </div>
                                                        <span class="day">ENTERTAINMENT</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Russian & Bollywood Dance Performances with Live DJ</h4>
                                                        <p>Experience world-class Russian dance performances along with Bollywood entertainment. Live DJ keeps the energy high throughout the cruise with the latest tracks.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/dcdj.webp" alt="Russian Dancer">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/dcdj1.webp" alt="Bollywood Performance">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-egg-fried"></i></div>
                                                        </div>
                                                        <span class="day">DINING</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Unlimited Buffet Dinner (Veg/Non-veg)</h4>
                                                        <p>Enjoy unlimited buffet dinner with a wide variety of Indian and international cuisines. Special arrangements available for celebrations.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-camera"></i></div>
                                                        </div>
                                                        <span class="day">SIGHTSEEING</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Panjim City Sightseeing & Mandovi River Cruise</h4>
                                                        <p>2 hours of beautiful Panjim city sightseeing from the cruise. Enjoy views of Central Jail, Santa Monica Jetty, and the beautiful Mandovi River.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/mandovi-goa.webp" alt="Mandovi River">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ssss.webp" alt="Panjim City">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/atal-setu.webp" alt="City Views">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-cup-straw"></i></div>
                                                        </div>
                                                        <span class="day">DRINKS</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">2 Complimentary Drinks (Alcoholic/Non-Alcoholic)</h4>
                                                        <p>Two complimentary drinks per person included. Choose from a variety of alcoholic and non-alcoholic beverages to complement your dinner.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-gift"></i></div>
                                                        </div>
                                                        <span class="day">CELEBRATIONS</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Special Celebrations Arrangements</h4>
                                                        <p>Special arrangements available on board to celebrate birthdays and anniversary celebrations (on extra cost). Make your special moments unforgettable.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cq-1.webp" alt="Birthday Celebration">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cs-2.webp" alt="Anniversary">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cs-3.webp" alt="Celebrations">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </section>

                                <!-- Inclusion/Exclusions-->
                                <section id="inclusions">
                                    <div class="trv-checklist-st2-mini-wrap">
                                        <div class="row">
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-l">
                                                <h3 class="trv-inner-title-sm">PACKAGE INCLUDE</h3>
                                                <ul class="trv-checklist-st2-mini">
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Bus Pickup</strong> - 7:00 PM from hotels
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>3 Hours Cruising</strong> - On Mandovi River
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Russian Dance Performance</strong> - Live entertainment
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Bollywood Live DJ</strong> - Music and entertainment
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Unlimited Buffet Dinner</strong> - Veg/Non-veg options
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Panjim City Sightseeing</strong> - 2 hours duration
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>2 Complimentary Drinks</strong> - Alcoholic/Non-alcoholic
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Cruise on Goa's Biggest Cruise</strong> - Coral Queen
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-r">
                                                <h3 class="trv-inner-title-sm">Not Included</h3>
                                                <ul class="trv-checklist-st2-mini trv-list-disable">
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Additional drinks beyond 2 complimentary
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Birthday/Anniversary celebration decorations (extra cost)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Professional photography
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Tips and gratuities
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Personal shopping
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </section>

                            </div>
                        </div>
                    </div> 
                </div> 

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar m-b30">
                    <aside class="side-bar">
                        <div class="trv-tour-single-r-detail">
                            <span class="trv-star-from">Starting from</span>
                            <span class="trv-star-amount">
                                <s>$26</s> ₹1,999
                            </span>
                            <span class="trv-star-from-person">/ Person</span>
                            <div class="trv-emi_text">
                                <i class="bi bi-wallet"></i>Contact for Special Deals
                                <span class="trvng-binding"></span> 
                                <a class="chsemi" href="javascript:;">See options</a>
                            </div>
                            <button type="button" class="site-button butn-bg-shape" onclick="sendWhatsAppEnquiry()">
                                <i class="bi bi-whatsapp"></i>Enquiry Now
                            </button>
                        </div>

                        <div class="trv-tour-single-r-info">
                            <div class="trv-main-rg-hol">
                                <div class="trv-man-sec-hol">
                                    <ul>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Trip Duration : </span>
                                            <span class="ng-binding">3 Hours</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Bus PickUp Time : </span>
                                            <span class="ng-binding">7:00 PM</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Reporting at Jetty : </span>
                                            <span class="ng-binding">8:15 PM</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Departure : </span>
                                            <span class="ng-binding">8:30 PM</span>
                                        </li>
                                        <li>
                                            <span  class="trv-tmi-hlo"><i class="bi bi-geo-alt"></i> Departure From :</span>
                                            <span class="trv-tmi-hlo-info">Santa Monica Jetty, Panaji, Goa</span>
                                        </li>
                                        
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-exclamation-circle"></i> Note :</span>
                                            <span class="trv-tmi-hlo-info">Kids above 3 years - Full price</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="trv-oack-sepa"><span class="lay"> Package Includes</span></div>
                                
                                <div class="trv-icon-man-holids">
                                    <ul>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/hotels.png" alt="Pickup">
                                            </div>
                                            <div class="trv-holids-name">Bus Pickup</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/Sightseeing.png" alt="Sightseeing">
                                            </div>
                                             <div class="trv-holids-name">Panjim Sightseeing</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/car.png" alt="Cruise">
                                            </div>
                                            <div class="trv-holids-name">Cruise Ride</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/meal.png" alt="Dinner">
                                            </div>
                                            <div class="trv-holids-name">Buffet Dinner</div>
                                        </li>
                                        
                                    </ul>
                                </div>
                                
                                <div class="trv-booking-notes mt-4">
                                    <h5 class="trv-inner-title-sm">Package Highlights:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-check-circle"></i> Goa's Biggest Cruise</li>
                                        <li><i class="bi bi-check-circle"></i> Russian Dance Performance</li>
                                        <li><i class="bi bi-check-circle"></i> Unlimited Buffet Dinner</li>
                                        <li><i class="bi bi-check-circle"></i> 2 Complimentary Drinks</li>
                                        <li><i class="bi bi-check-circle"></i> Panjim City Sightseeing</li>
                                        <li><i class="bi bi-check-circle"></i> Bollywood Live DJ</li>
                                    </ul>
                                </div>

                            </div>
                        </div>
                    </aside>
                </div>
                <!-- SIDE BAR END -->
            </div>
        </div>
    </div>
</div>
<!-- SECTION END -->

<script>
// WhatsApp Enquiry Function
function sendWhatsAppEnquiry() {
    const whatsappNumber = "8906666657";
    const message = `🎯 *CORAL QUEEN CRUISE GOA PACKAGE ENQUIRY* 🎯
    
🚢 *Package:* Coral Queen Cruise
💰 *Price:* ₹1,999 Per Person
⏰ *Duration:* 3 Hours Cruise

📋 *Package Includes:*
✅ Bus Pickup at 7:00 PM
✅ 3 Hours Cruising on Mandovi River
✅ Russian Dance Performance
✅ Bollywood Live DJ Music
✅ Unlimited Buffet Dinner (Veg/Non-veg)
✅ 2 Complimentary Drinks (Alcoholic/Non-Alcoholic)
✅ Panjim City Sightseeing (2 hours)
✅ Goa's Biggest Cruise Experience

📍 *Departure:* Santa Monica Jetty, Panaji, Goa
📞 *Contact:* 8906666657

👤 *My Details:*
Name: ______
Travel Date: ______
Number of Persons: ______
Contact Number: ______

Please provide more details and availability.`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappURL, '_blank');
}

// Initialize Swiper Slider
document.addEventListener('DOMContentLoaded', function() {
    if(document.querySelector('.trv_d-slider')) {
        const swiper = new Swiper('.trv_d-slider', {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            loop: true,
        });
    }
});
</script>
    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>