<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Goa car rental, rent car in Goa, self drive car Goa, SUV rental Goa">
    <meta name="author" content="GoaReddy">
    <meta name="robots" content="">    
    <meta name="description" content="Rent cars in Goa with GoaReddy. Best prices for hatchbacks, sedans, SUVs and luxury cars for your Goa trip.">
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | Car Rentals in Goa</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css">
    <link rel="stylesheet"  href="css/bootstrap-select.min.css">
    <link rel="stylesheet"  href="css/font-awesome.min.css">
    <link rel="stylesheet"  href="css/feather.css">
    <link rel="stylesheet"  href="css/owl.carousel.min.css">
    <link rel="stylesheet"  href="css/magnific-popup.min.css">
    <link rel="stylesheet"  href="css/swiper-bundle.min.css">  
    <link rel="stylesheet"  href="css/style.css">
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"> 
    <link rel="stylesheet"  href="css/bootstrap-icons.css">
    <link rel="stylesheet"  href="css/lc_lightbox.css">
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css">  
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Car Rentals in Goa</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>Car Rentals</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->
        
        
        <div class="vehicle-type-nav">
    <a href="bike-rental.php">Bike</a>
    <a href="car-rental.php" class="active">Car</a>
</div>


        <!-- SECTION START -->
<div class="section-full  p-t80 p-b90">
    <div class="container">
    
        <!-- BLOG SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar  m-b30">
                
                    <aside class="side-bar-filter">

                        <!--Left Search Filter -->
                        <div class="styleswitcher">
                            
                            <div class="styleswitcher-inner ">
                                <div class="twm-side-filter-form">
                                    <form id="carFilterForm">

                                        <div class="twm-sidebar-ele-filter">

                                            <div class="trv-fliter-bx">
                                                <h4 class="section-head-small mb-4">Search Car</h4>
                                                <div class="search-bx-filter">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" id="carSearch" placeholder="Search cars...">
                                                        <span class="input-group-btn">
                                                            <button type="button" class="btn" id="searchBtn"><i class="fa fa-search"></i></button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        
                                            <div class="trv-fliter-bx">
                                                <div class="trv-fltr-select">
                                                    <div class="form-group">
                                                        <label>Car Type</label>
                                                        <select class="form-control" id="carTypeFilter">
                                                            <option value="all" selected>Select Car Type</option>
                                                            <option value="hatchback">Hatchback</option>
                                                            <option value="sedan">Sedan</option>
                                                            <option value="suv">SUV</option>
                                                            <option value="luxury">Luxury</option>
                                                            <option value="mpv">MPV</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="trv-fltr-select">
                                                    <div class="form-group">
                                                        <label>Transmission</label>
                                                        <select class="form-control" id="transmissionFilter">
                                                            <option value="all" selected>Select Transmission</option>
                                                            <option value="manual">Manual</option>
                                                            <option value="automatic">Automatic</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="trv-fltr-select">
                                                    <div class="form-group twm-input-with-icon">
                                                        <label>Seating Capacity</label>
                                                        <select class="form-control" id="seatingFilter">
                                                            <option value="all" selected>Select Seats</option>
                                                            <option value="4">4 Seaters</option>
                                                            <option value="5">5 Seaters</option>
                                                            <option value="6">6 Seaters</option>
                                                            <option value="7">7+ Seaters</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="trv-fltr-select">
                                                    <div class="form-group form-group-2column-wrap twm-input-with-icon">
                                                        <label>Price Per Day</label>
                                                        <select class="form-control" id="priceFilter">
                                                            <option value="all" selected>Select Price Range</option>
                                                            <option value="0-1500">Under ₹1,500</option>
                                                            <option value="1500-2500">₹1,500 - ₹2,500</option>
                                                            <option value="2500-3500">₹2,500 - ₹3,500</option>
                                                            <option value="3500-4500">₹3,500 - ₹4,500</option>
                                                            <option value="4500+">Above ₹4,500</option>
                                                        </select>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="trv-fliter-bx">
                                                <h4 class="section-head-small mb-4">Car Features</h4>
                                                <ul>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input feature-filter" id="feat01" value="ac">
                                                            <label class="form-check-label" for="feat01">Air Conditioning</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input feature-filter" id="feat02" value="insurance">
                                                            <label class="form-check-label" for="feat02">Insurance</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input feature-filter" id="feat03" value="delivery">
                                                            <label class="form-check-label" for="feat03">Free Delivery</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input feature-filter" id="feat04" value="support">
                                                            <label class="form-check-label" for="feat04">24/7 Support</label>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input feature-filter" id="feat05" value="music">
                                                            <label class="form-check-label" for="feat05">Music System</label>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>

                                        </div>

                                        <div class="twm-side-filter-aply-btn text-center">
                                            <button type="button" id="applyFilters" class="site-button butn-bg-shape">Apply Filter</button>
                                            <button type="button" id="filterReset" class="site-button outline mx-2">Reset All</button>
                                        </div>
                                    </form>
                                    <!-- Removed advertisement image -->
                                    
                                </div>
                            </div>    
                        </div>
                        <!--Left Search Filter -->

                    </aside>

                </div>
                <!-- SIDE BAR END --> 
            
                <?php
include('db.php');

$sql = "SELECT id, image, category_tags, car_name, short_description, price FROM cars ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$cars = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-xl-8 col-lg-8 col-md-12 m-b30">
    <div class="row" id="carContainer">
        <?php foreach ($cars as $car): ?>
            <div class="col-xl-6 col-lg-6 col-md-6 m-b30 car-item" 
                 data-type="hatchback" 
                 data-transmission="manual" 
                 data-seating="5" 
                 data-price="<?php echo preg_replace('/[^0-9]/', '', $car['price']); ?>" 
                 data-features="ac,insurance,support,music">
                <div class="trv-popular-tour-st1">
                    <div class="trv-media">
                        <a href="javascript:void(0);">
                            <?php if (!empty($car['image'])): ?>
                                <img src="admin/uploads/cars/<?php echo $car['image']; ?>" alt="<?php echo htmlspecialchars($car['car_name']); ?>">
                            <?php else: ?>
                                <img src="https://via.placeholder.com/400x300?text=No+Image" alt="<?php echo htmlspecialchars($car['car_name']); ?>">
                            <?php endif; ?>
                        </a>
                        <div class="trv-tour-duration">
                            <i class="bi bi-gear"></i>
                            <span><?php echo htmlspecialchars($car['category_tags']); ?></span>
                        </div>
                        <div class="trv-tour-title">
                            <h3 class="trv-title">
                                <a href="javascript:void(0);">
                                    <i class="bi bi-car-front"></i>
                                    <?php echo htmlspecialchars($car['car_name']); ?>
                                </a>
                            </h3>
                        </div>
                    </div>
                    <div class="trv-content">
                        <div class="trv-content-head-section">
                            <div class="trv-tour-price">
                                <span class="price"><?php echo htmlspecialchars($car['price']); ?></span>
                                <span class="price-duration">Per Day</span>
                            </div>
                            <div class="trv-tour-info">
                                <a href="javascript:void(0);"><?php echo htmlspecialchars($car['short_description']); ?></a>
                            </div>
                        </div>
                        <div class="trv-content-bottom-section">
                            <div class="trv-book">
                                <a href="javascript:void(0);" class="site-button outline book-now-btn" data-package="<?php echo htmlspecialchars($car['car_name']); ?>" data-type="car-rent">Book Now</a>
                            </div>
                            <div class="trv-tour-rating">
                                <span class="trv-tour-review-count">(4.6 Review)</span>
                                <div class="trv-review-rating">
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-half"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <div class="no-results" style="display: none; text-align: center; padding: 40px;">
        <h3>No cars found matching your filters</h3>
        <p>Try adjusting your search criteria</p>
    </div>
    <ul class="custom-pagination clearfix">
        <li class="prev"><a href="javascript:void(0);"><span class="bi bi-chevron-left"></span></a></li>
        <li><a href="javascript:void(0);">1</a></li>
        <li><a href="javascript:void(0);">2</a></li>
        <li><a href="javascript:void(0);">3</a></li>
        <li><a href="javascript:void(0);">...</a></li>
        <li class="next"><a href="javascript:void(0);"><span class="bi bi-chevron-right"></span></a></li>
    </ul>
</div>
        
            </div>

        </div>
        
    </div>
    
</div>   
<!-- SECTION END -->

<script>
// Car Rental Specific Filter Functionality
document.addEventListener('DOMContentLoaded', function() {
    const carItems = document.querySelectorAll('.car-item');
    const carTypeFilter = document.getElementById('carTypeFilter');
    const transmissionFilter = document.getElementById('transmissionFilter');
    const seatingFilter = document.getElementById('seatingFilter');
    const priceFilter = document.getElementById('priceFilter');
    const featureCheckboxes = document.querySelectorAll('.feature-filter');
    const applyFiltersBtn = document.getElementById('applyFilters');
    const filterResetBtn = document.getElementById('filterReset');
    const carSearch = document.getElementById('carSearch');
    const searchBtn = document.getElementById('searchBtn');
    const noResults = document.querySelector('.no-results');

    // Show all cars initially
    function showAllCars() {
        carItems.forEach(item => {
            item.style.display = 'block';
        });
        noResults.style.display = 'none';
    }

    // Filter Cars Function
    function filterCars() {
        const carTypeValue = carTypeFilter.value;
        const transmissionValue = transmissionFilter.value;
        const seatingValue = seatingFilter.value;
        const priceValue = priceFilter.value;
        const searchTerm = carSearch.value.toLowerCase().trim();
        
        // Get selected features
        const selectedFeatures = [];
        featureCheckboxes.forEach(cb => {
            if (cb.checked) selectedFeatures.push(cb.value);
        });

        let visibleCount = 0;

        carItems.forEach(item => {
            const carType = item.getAttribute('data-type');
            const transmission = item.getAttribute('data-transmission');
            const seating = item.getAttribute('data-seating');
            const price = parseInt(item.getAttribute('data-price'));
            const features = item.getAttribute('data-features').split(',');
            
            // Get text content for search
            const title = item.querySelector('.trv-title a').textContent.toLowerCase();
            const description = item.querySelector('.trv-tour-info a').textContent.toLowerCase();
            
            // Check car type filter
            const carTypeMatch = carTypeValue === 'all' || carType === carTypeValue;
            
            // Check transmission filter
            const transmissionMatch = transmissionValue === 'all' || transmission === transmissionValue;
            
            // Check seating filter
            const seatingMatch = seatingValue === 'all' || seating === seatingValue;
            
            // Check price filter
            let priceMatch = true;
            if (priceValue !== 'all') {
                if (priceValue === '0-1500') priceMatch = price <= 1500;
                else if (priceValue === '1500-2500') priceMatch = price > 1500 && price <= 2500;
                else if (priceValue === '2500-3500') priceMatch = price > 2500 && price <= 3500;
                else if (priceValue === '3500-4500') priceMatch = price > 3500 && price <= 4500;
                else if (priceValue === '4500+') priceMatch = price > 4500;
            }
            
            // Check search term
            let searchMatch = true;
            if (searchTerm !== '') {
                searchMatch = title.includes(searchTerm) || description.includes(searchTerm);
            }
            
            // Check features
            let featuresMatch = true;
            if (selectedFeatures.length > 0) {
                featuresMatch = selectedFeatures.every(feat => features.includes(feat));
            }
            
            // Show/hide based on all filters
            if (carTypeMatch && transmissionMatch && seatingMatch && priceMatch && searchMatch && featuresMatch) {
                item.style.display = 'block';
                visibleCount++;
            } else {
                item.style.display = 'none';
            }
        });

        // Show/hide no results message
        if (visibleCount === 0) {
            noResults.style.display = 'block';
        } else {
            noResults.style.display = 'none';
        }
    }

    // Search functionality
    searchBtn.addEventListener('click', filterCars);
    carSearch.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            filterCars();
        }
    });

    // Apply filters button
    applyFiltersBtn.addEventListener('click', filterCars);

    // Reset filters button
    filterResetBtn.addEventListener('click', function() {
        carTypeFilter.value = 'all';
        transmissionFilter.value = 'all';
        seatingFilter.value = 'all';
        priceFilter.value = 'all';
        carSearch.value = '';
        
        featureCheckboxes.forEach(cb => {
            cb.checked = false;
        });
        
        showAllCars();
    });

    // Initialize - show all cars
    showAllCars();
});
</script>

        
        
        <?php include 'enquiry-form.php'; ?> 
    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>