<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Cabo de Rama Beach Goa, Secluded Beaches Goa, South Goa Beaches, Goa Hidden Beaches">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="Cabo de Rama Beach Goa - Most Secluded & Pristine Beach in South Goa with Cliffside Views">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | Cabo de Rama Beach Goa - Most Secluded Beach Experience</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Cabo de Rama Beach Goa</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>Cabo de Rama Beach Goa</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

<!-- SECTION START -->
<div class="section-full p-t120 p-b90">
    <div class="container">
        <!-- SECTION START -->
        <div class="section-content">
            <div class="row d-flex justify-content-center">

                <div class="col-xl-8 col-lg-8 col-md-12 m-b30">
                    <div class="trv-detail-main-wrap">
                        <!--Info Start-->
                        <div class="trv-detail-bx-wrap">
                            <div class="trv-inr-para2">
                                <div class="trv-sep-rating">
                                    <div class="trv-rating">
                                        <span>(4.8 Review)</span>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                        <i class="bi bi-star-fill"></i>
                                    </div>
                                </div>
                                <h3 class="trv-inner-title-lg">Cabo de Rama Beach Experience</h3>
                                <span class="trv-packege-esti-time">Goa's Most Secluded & Pristine Beach Paradise</span>

                                <!--Top SLider-->
                                <div class="trv-detail-slider">
                                    <div class="swiper trv_d-slider">
                                        <div class="swiper-wrapper">
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cdr-1.webp" alt="Cabo de Rama Beach View">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cdr-2.webp" alt="Golden Sands Beach">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cdr-3.webp" alt="Cliffside Beach Access">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide"> 
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cdr-4.webp" alt="Secluded Beach Goa">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cdr-5.webp" alt="Beach Relaxation">   
                                                </div>
                                            </div>
                                            <div class="swiper-slide">
                                                <div class="trv_d-slider-media">
                                                    <img src="img/cdr-6.webp" alt="Clear Waters">   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                                <!--Top SLider End-->

                                <!-- Navigation -->
                                <nav class="navbar-one">
                                    <a href="#overview">Package Overview</a>
                                    <a href="#details">Beach Experience</a>
                                    <a href="#inclusions">Inclusions / Exclusions</a>
                                </nav>

                                <!-- Over View-->
                                <section id="overview">
                                    <h3 class="trv-inner-title-sm">Cabo de Rama Beach Package Overview</h3>
                                    <p>Discover Goa's best-kept secret - Cabo de Rama Beach! Escape the tourist crowds and experience pristine golden sands, crystal clear waters, and dramatic cliffside scenery. This secluded paradise offers the perfect blend of natural beauty, tranquility, and adventure.</p>

                                    <h4 class="trv-inner-title-sm mt-4">Package Highlights:</h4>
                                    <ul class="trv-checklist-st1">
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Most Secluded Beach</strong> - Away from tourist crowds
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Pristine Natural Beauty</strong> - Unspoiled golden sands
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Dramatic Cliff Views</strong> - Scenic cliffside access
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Clear Turquoise Waters</strong> - Perfect for swimming
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Photography Paradise</strong> - Breathtaking landscapes
                                        </li>
                                        <li>
                                            <i class="bi bi-check-circle-fill"></i>
                                            <strong>Romantic Getaway</strong> - Perfect for couples
                                        </li>
                                    </ul>
                                </section>

                                <!-- Package Details-->
                                <section id="details">
                                    <h3 class="trv-inner-title-sm">Complete Beach Paradise Experience</h3>
                                    
                                    <div class="trv-clist-st-3-wrap">
                                        <ul class="trv-list-st-3">
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-water"></i></div>
                                                        </div>
                                                        <span class="day">BEACH</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Pristine Beach Relaxation & Swimming</h4>
                                                        <p>Enjoy Goa's most secluded and pristine beach with soft golden sands and clear turquoise waters. Perfect for swimming, sunbathing, beach walks, and simply relaxing away from the crowds. The beach is relatively untouched, offering a natural and peaceful environment.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cds-3.webp" alt="Beach Relaxation">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cds-2.webp" alt="Swimming Spot">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-image"></i></div>
                                                        </div>
                                                        <span class="day">VIEWS</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Spectacular Cliffside Views & Photography</h4>
                                                        <p>Experience breathtaking views from the cliffside pathways leading to the beach. Capture stunning photographs of dramatic cliffs meeting the Arabian Sea. Perfect spot for landscape photography, Instagram-worthy shots, and enjoying panoramic ocean vistas.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-sunset"></i></div>
                                                        </div>
                                                        <span class="day">SUNSET</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Magical Sunset Experience</h4>
                                                        <p>Witness one of Goa's most spectacular sunsets from Cabo de Rama Beach. Watch the sun dip into the Arabian Sea, painting the sky in vibrant shades of orange, pink, and purple. The perfect romantic or photographic moment to cherish forever.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ms-1.webp" alt="Beach Sunset">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ms-3.webp" alt="Golden Hour">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/ms-2.webp" alt="Sunset Views">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-tree"></i></div>
                                                        </div>
                                                        <span class="day">NATURE</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Natural Surroundings & Seclusion</h4>
                                                        <p>Enjoy complete seclusion surrounded by natural beauty. The beach is flanked by dramatic cliffs and lush greenery, creating a peaceful sanctuary. Listen to the waves, feel the soft sand, and experience true relaxation in this hidden paradise.</p>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="trv-list-content">
                                                    <div class="duration">
                                                        <div class="media">
                                                            <div class="green-bg"><i class="bi bi-camera"></i></div>
                                                        </div>
                                                        <span class="day">PHOTOS</span>
                                                    </div>
                                                    <div class="info">
                                                        <h4 class="trv-title">Professional Beach Photography (Extra Cost)</h4>
                                                        <p>Capture your Cabo de Rama beach memories with professional photography services. Our photographer will capture stunning portraits against the beautiful beach backdrop. Receive edited digital photos within 24 hours - perfect for memories and social media.</p>
                                                        <div class="trv-blog-d-column-wrap mt-3">
                                                            <div class="row">
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cds-1.webp" alt="Beach Portraits">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cds-4.webp" alt="Couple Photos">
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-4 col-md-4 m-b20">
                                                                    <div class="trv-blog-d-column-bx">
                                                                        <img src="img/cds-5.webp" alt="Family Photos">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </section>

                                <!-- Inclusion/Exclusions-->
                                <section id="inclusions">
                                    <div class="trv-checklist-st2-mini-wrap">
                                        <div class="row">
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-l">
                                                <h3 class="trv-inner-title-sm">PACKAGE INCLUDE</h3>
                                                <ul class="trv-checklist-st2-mini">
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Hotel Pickup & Drop</strong> - From South Goa hotels
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>AC Vehicle Transport</strong> - Comfortable travel
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Beach Access Guide</strong> - Local guide assistance
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Beach Umbrella Setup</strong> - Shade arrangement
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Mineral Water Bottles</strong> - Stay hydrated
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Basic First Aid Kit</strong> - Safety first approach
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Beach Clean-up Kit</strong> - Eco-friendly approach
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-check-circle-fill"></i>
                                                        <strong>Tour Coordinator</strong> - English & Hindi speaking
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-xl-6 col-lg-12 col-md-12 trv-checklist-st2-mini-r">
                                                <h3 class="trv-inner-title-sm">Not Included</h3>
                                                <ul class="trv-checklist-st2-mini trv-list-disable">
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Professional Photography (Extra ₹500)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Meals & Beverages
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Beach Chairs (Extra ₹100 each)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        North Goa Hotel Pickup (Extra charge)
                                                    </li>
                                                    <li>
                                                        <i class="bi bi-x-circle-fill"></i>
                                                        Personal expenses & tips
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </section>

                            </div>
                        </div>
                    </div> 
                </div> 

                <!-- SIDE BAR START -->
                <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar m-b30">
                    <aside class="side-bar">
                        <div class="trv-tour-single-r-detail">
                            <span class="trv-star-from">Starting from</span>
                            <span class="trv-star-amount">
                                <s>$12</s> ₹800
                            </span>
                            <span class="trv-star-from-person">/ Person</span>
                            <div class="trv-emi_text">
                                <i class="bi bi-wallet"></i>Best Secluded Beach
                                <span class="trvng-binding"></span> 
                                <a class="chsemi" href="javascript:;">Special Deals</a>
                            </div>
                            <button type="button" class="site-button butn-bg-shape" onclick="sendWhatsAppEnquiry()">
                                <i class="bi bi-whatsapp"></i>Enquiry Now
                            </button>
                        </div>

                        <div class="trv-tour-single-r-info">
                            <div class="trv-main-rg-hol">
                                <div class="trv-man-sec-hol">
                                    <ul>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-clock"></i> Beach Time : </span>
                                            <span class="ng-binding">4 Hours (Choose Timing)</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-truck"></i> Transport : </span>
                                            <span class="ng-binding">AC Vehicle with Driver</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-geo-alt"></i> Location : </span>
                                            <span class="ng-binding">South Goa - Canacona</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-person-check"></i> Guide : </span>
                                            <span class="ng-binding">Beach Access Assistance</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-exclamation-circle"></i> Note : </span>
                                            <span class="trv-tmi-hlo-info">Most Secluded Beach in Goa</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-award"></i> Experience : </span>
                                            <span class="trv-tmi-hlo-info">Pristine & Natural Beauty</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-patch-check"></i> Best For : </span>
                                            <span class="trv-tmi-hlo-info">Couples & Peace Seekers</span>
                                        </li>
                                        <li>
                                            <span class="trv-tmi-hlo"><i class="bi bi-shield-check"></i> Safety : </span>
                                            <span class="trv-tmi-hlo-info">Safe Swimming Conditions</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="trv-oack-sepa"><span class="lay"> Package Includes</span></div>
                                
                                <div class="trv-icon-man-holids">
                                    <ul>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/hotels.png" alt="Pickup">
                                            </div>
                                            <div class="trv-holids-name">Hotel Pickup</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/Sightseeing.png" alt="Beach">
                                            </div>
                                            <div class="trv-holids-name">Beach Access</div>
                                        </li>
                                        <li>
                                            <div class="trv-holids-icon">
                                                <img src="images/holi-icon/car.png" alt="Transport">
                                            </div>
                                            <div class="trv-holids-name">AC Transport</div>
                                        </li>
                                        
                                        
                                    </ul>
                                </div>
                                
                                <div class="trv-booking-notes mt-4">
                                    <h5 class="trv-inner-title-sm">Choose Your Timing:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-sun text-warning"></i> Morning Relax: 9:00 AM - 1:00 PM</li>
                                        <li><i class="bi bi-moon text-primary"></i> Sunset Special: 3:00 PM - 7:00 PM</li>
                                    </ul>
                                    
                                    <h5 class="trv-inner-title-sm mt-3">What to Bring:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-check-circle"></i> Swimwear & Towel</li>
                                        <li><i class="bi bi-check-circle"></i> Sunscreen & Hat</li>
                                        <li><i class="bi bi-check-circle"></i> Camera/Phone</li>
                                        <li><i class="bi bi-check-circle"></i> Comfortable Footwear</li>
                                        <li><i class="bi bi-check-circle"></i> Extra Water</li>
                                    </ul>
                                    
                                    <h5 class="trv-inner-title-sm mt-3">Beach Features:</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-star"></i> Golden Sandy Beach</li>
                                        <li><i class="bi bi-star"></i> Clear Turquoise Water</li>
                                        <li><i class="bi bi-star"></i> Dramatic Cliff Views</li>
                                        <li><i class="bi bi-star"></i> Secluded & Peaceful</li>
                                        <li><i class="bi bi-star"></i> Perfect for Swimming</li>
                                    </ul>
                                    
                                    <h5 class="trv-inner-title-sm mt-3">Upgrade Options (Extra Cost):</h5>
                                    <ul class="trv-checklist-mini">
                                        <li><i class="bi bi-plus-circle"></i> Professional Photography: ₹500</li>
                                        <li><i class="bi bi-plus-circle"></i> Beach Chairs (2): ₹200</li>
                                        <li><i class="bi bi-plus-circle"></i> Picnic Setup: ₹300</li>
                                    </ul>
                                </div>

                            </div>
                        </div>
                    </aside>
                </div>
                <!-- SIDE BAR END -->
            </div>
        </div>
    </div>
</div>
<!-- SECTION END -->

<script>
// WhatsApp Enquiry Function for Cabo de Rama Beach
function sendWhatsAppEnquiry() {
    const whatsappNumber = "8906666657";
    const message = `🏖️ *CABO DE RAMA BEACH EXPERIENCE - ENQUIRY* 🏖️
    
🌊 *Package:* Cabo de Rama Secluded Beach Experience
💰 *Price:* ₹800 Per Person
⏰ *Duration:* 4 Hours Beach Time (Choose Timing)

📍 *Location:* Canacona, South Goa
🏝️ *Beach Type:* Most Secluded & Pristine Beach in Goa

📋 *Package Includes:*
✅ Hotel Pickup & Drop from South Goa
✅ AC Vehicle Transport with Driver
✅ Local Beach Access Guide Assistance
✅ Beach Umbrella Setup for Shade
✅ Mineral Water Bottles (Stay Hydrated)
✅ Basic First Aid Kit (Safety First)
✅ Beach Clean-up Kit (Eco-Friendly)
✅ English & Hindi Speaking Tour Coordinator

🏖️ *Cabo de Rama Beach Features:*
• Most Secluded Beach in Goa
• Pristine Golden Sands
• Clear Turquoise Waters
• Dramatic Cliffside Views
• Away from Tourist Crowds
• Perfect for Swimming & Relaxation
• Natural & Unspoiled Environment

⏰ *Choose Your Timing:*
☀️ Morning Relax: 9:00 AM to 1:00 PM (Avoid Afternoon Heat)
🌅 Sunset Special: 3:00 PM to 7:00 PM (Includes Magical Sunset)

🎯 *Experience Highlights:*
• Beach Relaxation & Sunbathing
• Safe Swimming in Clear Waters
• Scenic Cliffside Photography
• Romantic Beach Walks
• Peaceful & Serene Environment
• Natural Sound of Waves

📸 *Photography Opportunities:*
• Dramatic Cliff & Sea Views
• Golden Beach Landscapes
• Sunset Photography
• Portrait Shots on Beach
• Seascape Photography

👤 *My Details:*
Name: ______
Preferred Timing: [Morning/Sunset] ______
Travel Date: ______
Number of Persons: ______
Contact Number: ______
Hotel Location in Goa: ______

🎒 *What to Bring:*
• Swimwear & Beach Towel
• Sunscreen & Hat/Cap
• Camera/Phone for Photos
• Comfortable Footwear
• Extra Water Bottle
• Sunglasses

🏆 *Why Choose Cabo de Rama Beach:*
• Most Secluded Beach Experience
• Away from Crowded Tourist Beaches
• Pristine Natural Environment
• Perfect for Couples & Peace Seekers
• Safe Swimming Conditions
• Breathtaking Scenery

📞 *Contact:* Best Beach Experience in South Goa

Please provide availability for my preferred timing and more details about the beach facilities.`;
    
    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappURL, '_blank');
}

// Initialize Swiper Slider
document.addEventListener('DOMContentLoaded', function() {
    if(document.querySelector('.trv_d-slider')) {
        const swiper = new Swiper('.trv_d-slider', {
            slidesPerView: 1,
            spaceBetween: 10,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            loop: true,
        });
    }
});
</script>
    </div>
    <!-- CONTENT END -->
</div>
<?php include 'footer.php'; ?>