<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="robots" content="">    
    <meta name="description" content="">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>GoaReddy | About Us</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Blogs</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li>Blogs</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

<!--EXPLORE POPULAR TOUR START-->
<div class="section-full trv-blog-grid-inner p-t120 p-b90">
    <div class="container">
        <div class="section-content">
            <div class="trv-blog-grid-inner-row">
                <div class="row masonry-wrap">
                    <?php
                    include('db.php'); // Database connection
                    
                    // Fetch blogs from database
                    $sql = "SELECT `id`, `blog_name`, `publish_date`, `author_name`, `category`, `short_description`, `description`, `image`, `created_at`, `updated_at` FROM `blogs` WHERE 1 ORDER BY `publish_date` DESC";
                    
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute();
                    $blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    if ($blogs) {
                        foreach ($blogs as $blog) {
                            // Format date like "15 Dec"
                            $publish_date = new DateTime($blog['publish_date']);
                            $day = $publish_date->format('d'); // 15
                            $month = $publish_date->format('M'); // Dec (short month)
                            
                            // Prepare author name
                            $author = !empty($blog['author_name']) ? $blog['author_name'] : 'Goa Travel Expert';
                            
                            // Prepare image path
                            $image_path = !empty($blog['image']) ? 'admin/uploads/blogs/' . $blog['image'] : 'img/bd-' . $blog['id'] . '.webp';
                            
                            // Blog details link
                            $blog_link = 'blog-details.php?id=' . $blog['id'];
                    ?>
                    <div class="col-lg-4 col-md-6 masonry-item">
                        <div class="trv-blog-st3">
                            <div class="trv-post-media">
                                <a href="<?php echo $blog_link; ?>">
                                    <img src="<?php echo $image_path; ?>" alt="<?php echo htmlspecialchars($blog['blog_name']); ?>">
                                </a>
                            </div>
                            
                            <div class="post-date">
                                <span><?php echo $day; ?></span><?php echo $month; ?>
                            </div>                                        
                            <div class="trv-post-info">
                                <div class="post-category">By <?php echo htmlspecialchars($author); ?></div>
                                <div class="trv-post-title">
                                    <h3 class="post-title">
                                        <a href="<?php echo $blog_link; ?>">
                                            <?php echo htmlspecialchars($blog['blog_name']); ?>
                                        </a>
                                    </h3>
                                </div>
                            </div>                                
                        </div>
                    </div>
                    <?php
                        }
                    } else {
                        echo '<div class="col-12 text-center"><p>No blogs available.</p></div>';
                    }
                    ?>
                </div>
                <ul class="custom-pagination clearfix">
                    <li class="prev"><a href="#"><span class="bi bi-chevron-left"></span></a></li>
                    <li><a href="#">1</a></li>
                    <li><a href="#">2</a></li>
                    <li><a href="#">3</a></li>
                    <li><a href="$">...</a></li>
                    <li class="next"><a href="#"><span class="bi bi-chevron-right"></span></a></li>
                </ul>
            </div>
        </div> 
    </div>
</div>
<!--EXPLORE POPULAR TOUR END-->
        
        
<?php include 'enquiry-form.php'; ?>
        

    </div>
    <!-- CONTENT END -->
</div>

<?php include 'footer.php'; ?>