<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Goa Travel Blog, Goa Beaches, Goa Guide">
    <meta name="author" content="GoaReddy">
    <meta name="robots" content="index, follow">    
    <meta name="description" content="Complete guide to visiting Goa - beaches, food, heritage and travel tips">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>Best Time to Visit Goa: Season Guide 2024 | GoaReddy</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Blog Details</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li><a href="blogs.php">Blogs</a></li>
                            <li>Best Time to Visit Goa</li>
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->

<!-- BLOG DETAILS START -->
<div class="section-full trv-blog-details p-t120 p-b90">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="trv-blog-details-content">
                    <?php
                    include('db.php'); // Database connection
                    
                    // Get blog ID from URL parameter
                    $blog_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
                    
                    if ($blog_id > 0) {
                        // Fetch specific blog from database
                        $sql = "SELECT `id`, `blog_name`, `publish_date`, `author_name`, `category`, `short_description`, `description`, `image`, `created_at`, `updated_at` FROM `blogs` WHERE `id` = ?";
                        $stmt = $pdo->prepare($sql);
                        $stmt->execute([$blog_id]);
                        $blog = $stmt->fetch(PDO::FETCH_ASSOC);
                        
                        if ($blog) {
                            // Format date
                            $publish_date = new DateTime($blog['publish_date']);
                            $day = $publish_date->format('d'); // 15
                            $month = $publish_date->format('M'); // Dec
                            $year = $publish_date->format('Y'); // 2024
                            
                            // Prepare author name
                            $author = !empty($blog['author_name']) ? $blog['author_name'] : 'Goa Travel Expert';
                            
                            // Prepare category
                            $category = !empty($blog['category']) ? $blog['category'] : 'Travel Guide';
                            
                            // Prepare image path
                            $image_path = !empty($blog['image']) ? 'admin/uploads/blogs/' . $blog['image'] : 'images/trv-blog/blog-lg/pic2.jpg';
                            
                            // Estimate read time (assuming 200 words per minute)
                            $word_count = str_word_count(strip_tags($blog['description']));
                            $read_time = ceil($word_count / 200);
                            if ($read_time < 1) $read_time = 1;
                            
                            // Split description into paragraphs
                            $description_paragraphs = explode("\n", $blog['description']);
                            
                            // Get short description for conclusion
                            $conclusion_text = !empty($blog['short_description']) ? $blog['short_description'] : 'This article provides comprehensive information about ' . $blog['blog_name'];
                    ?>
                    <!-- Blog Header -->
                    <div class="trv-blog-details-header">
                        <div class="post-date-large">
                            <span class="day"><?php echo $day; ?></span>
                            <span class="month"><?php echo $month; ?></span>
                            <span class="year"><?php echo $year; ?></span>
                        </div>
                        <h1 class="blog-title"><?php echo htmlspecialchars($blog['blog_name']); ?></h1>
                        <div class="blog-meta">
                            <span class="author"><i class="bi bi-person"></i> By <?php echo htmlspecialchars($author); ?></span>
                            <span class="category"><i class="bi bi-tag"></i> <?php echo htmlspecialchars($category); ?></span>
                            <span class="read-time"><i class="bi bi-clock"></i> <?php echo $read_time; ?> min read</span>
                        </div>
                    </div>
                    
                    <!-- Featured Image -->
                    <div class="trv-blog-details-img">
                        <img src="<?php echo $image_path; ?>" alt="<?php echo htmlspecialchars($blog['blog_name']); ?>" class="img-responsive">
                    </div>
                    
                    <!-- Blog Content -->
                    <div class="trv-blog-details-text">
                        <?php
                        // Display description paragraphs
                        foreach ($description_paragraphs as $paragraph) {
                            if (trim($paragraph) !== '') {
                                echo '<p>' . htmlspecialchars($paragraph) . '</p>';
                            }
                        }
                        ?>
                    </div>
                    
                    <div class="blog-conclusion">
                        <h3>Conclusion</h3>
                        <p><?php echo htmlspecialchars($conclusion_text); ?></p>
                        <p>Remember to book accommodations in advance for peak season and check weather forecasts before planning monsoon visits. Regardless of when you visit, Goa promises an unforgettable experience!</p>
                    </div>
                    
                    <!-- Blog Tags -->
                    <div class="blog-tags">
                        <h4>Tags:</h4>
                        <?php
                        // Split category/tags
                        $tags = [];
                        if (!empty($blog['category'])) {
                            $tags = array_map('trim', explode(',', $blog['category']));
                        }
                        
                        // Default tags
                        $default_tags = ['Goa Travel', 'Travel Guide', 'Goa', 'Travel Tips'];
                        $all_tags = array_merge($tags, $default_tags);
                        $all_tags = array_unique($all_tags);
                        
                        foreach ($all_tags as $tag) {
                            echo '<a href="#">' . htmlspecialchars($tag) . '</a> ';
                        }
                        ?>
                    </div>
                    
                    <!-- Share Buttons -->
                    <div class="blog-share">
                        <h4>Share this article:</h4>
                        <div class="social-share">
                            <?php
                            $current_url = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
                            $share_title = urlencode($blog['blog_name']);
                            ?>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($current_url); ?>" target="_blank" class="facebook"><i class="bi bi-facebook"></i></a>
                            <a href="https://twitter.com/intent/tweet?text=<?php echo $share_title; ?>&url=<?php echo urlencode($current_url); ?>" target="_blank" class="twitter"><i class="bi bi-twitter"></i></a>
                            <a href="https://api.whatsapp.com/send?text=<?php echo $share_title; ?>%20<?php echo urlencode($current_url); ?>" target="_blank" class="whatsapp"><i class="bi bi-whatsapp"></i></a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode($current_url); ?>&title=<?php echo $share_title; ?>" target="_blank" class="linkedin"><i class="bi bi-linkedin"></i></a>
                        </div>
                    </div>
                    
                    <?php
                        } else {
                            // Blog not found
                            echo '<div class="alert alert-danger">Blog not found. Please go back to <a href="blogs.php">Blogs page</a>.</div>';
                        }
                    } else {
                        // No ID parameter
                        echo '<div class="alert alert-warning">Invalid blog ID. Please go back to <a href="blogs.php">Blogs page</a>.</div>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- BLOG DETAILS END -->
        
                                
                            
                        
        
        
<?php include 'enquiry-form.php'; ?>
        

    </div>
    <!-- CONTENT END -->
</div>
<style>
.blog-conclusion {
    background: #f0f8ff;
    padding: 25px;
    border-radius: 10px;
    margin: 30px 0;
    border: 1px solid #e3f2fd;
}

.blog-tags {
    margin: 30px 0;
    padding-top: 20px;
    border-top: 1px solid #eee;
}

.blog-tags a {
    display: inline-block;
    background: #f0f0f0;
    color: #666;
    padding: 5px 15px;
    margin: 5px;
    border-radius: 20px;
    font-size: 14px;
    text-decoration: none;
    transition: all 0.3s;
}

.blog-tags a:hover {
    background: #FFD700;
    color: #333;
}
.blog-share {
    margin: 30px 0;
}

.social-share {
    display: flex;
    gap: 10px;
    margin-top: 10px;
}

.social-share a {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    color: white;
    font-size: 18px;
    text-decoration: none;
}

.facebook { background: #3b5998; }
.twitter { background: #1da1f2; }
.whatsapp { background: #25d366; }
.linkedin { background: #0077b5; }
.trv-blog-details-content {
    background: #fff;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

.trv-blog-details-header {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 2px solid #f0f0f0;
}

.post-date-large {
    background: #FFD700;
    color: #333;
    padding: 15px;
    border-radius: 10px;
    display: inline-block;
    text-align: center;
    margin-bottom: 20px;
}

.post-date-large .day {
    display: block;
    font-size: 36px;
    font-weight: 700;
    line-height: 1;
}

.post-date-large .month {
    display: block;
    font-size: 18px;
    font-weight: 600;
    margin: 5px 0;
}

.post-date-large .year {
    display: block;
    font-size: 14px;
    color: #666;
}

.blog-title {
    font-size: 36px;
    color: #333;
    margin: 20px 0;
    line-height: 1.3;
}

.blog-meta {
    display: flex;
    gap: 20px;
    flex-wrap: wrap;
    color: #666;
    font-size: 14px;
}

.blog-meta span {
    display: flex;
    align-items: center;
    gap: 5px;
}

.blog-meta i {
    color: #FFD700;
}

.trv-blog-details-img {
    margin: 30px 0;
    border-radius: 10px;
    overflow: hidden;
    display: flex;
    justify-content: center;
    align-items: center;
}

.trv-blog-details-img img {
    width: 85%;
    height: 550px;
    border-radius: 10px;
}

.trv-blog-details-text {
    font-size: 16px;
    line-height: 1.8;
    color: #555;
}

.trv-blog-details-text h3 {
    color: #333;
    margin: 30px 0 15px;
    font-size: 24px;
}

.trv-blog-details-text h4 {
    color: #444;
    margin: 20px 0 10px;
    font-size: 18px;
}

.blog-points, .blog-tips {
    background: #f9f9f9;
    padding: 20px;
    border-radius: 10px;
    margin: 20px 0;
    border-left: 4px solid #FFD700;
}

.blog-points ul, .blog-tips ol {
    padding-left: 20px;
    margin: 10px 0;
}

.blog-points li, .blog-tips li {
    margin-bottom: 8px;
    line-height: 1.6;
}

.blog-conclusion {
    background: #f0f8ff;
    padding: 25px;
    border-radius: 10px;
    margin: 30px 0;
    border: 1px solid #e3f2fd;
}
</style>

<?php include 'footer.php'; ?>

