
<!DOCTYPE html>
<html lang="en">

<head>
	<!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="Goa Travel Blog, Goa Beaches, Goa Guide">
    <meta name="author" content="GoaReddy">
    <meta name="robots" content="index, follow">    
    <meta name="description" content="Complete guide to visiting Goa - beaches, food, heritage and travel tips">
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png">
    
    <!-- PAGE TITLE HERE -->
    <title>Bike Rental | GoaReddy</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet"  href="css/bootstrap.min.css"><!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-select.min.css"><!-- BOOTSTRAP SELECT BOX CSS -->
    <link rel="stylesheet"  href="css/font-awesome.min.css"><!-- FONTAWESOME STYLE SHEET -->
    <link rel="stylesheet"  href="css/feather.css"><!-- FEATHER ICON SHEET -->
    <link rel="stylesheet"  href="css/owl.carousel.min.css"><!-- OWL CAROUSEL STYLE SHEET -->
    <link rel="stylesheet"  href="css/magnific-popup.min.css"><!-- MAGNIFIC POPUP STYLE SHEET -->
    <link rel="stylesheet"  href="css/swiper-bundle.min.css"><!-- Link Swiper's CSS -->  
    <link rel="stylesheet"  href="css/style.css"><!-- MAIN STYLE SHEET -->
    <link rel="stylesheet"  href="css/bootstrap-datetimepicker.css"><!-- DATEPICKER STYLE SHEET -->   
    <link rel="stylesheet"  href="css/bootstrap-icons.css"><!-- BOOTSTRAP ICON STYLE SHEET -->
    <link rel="stylesheet"  href="css/lc_lightbox.css"><!-- Lc light box popup -->
    <link rel="stylesheet"  href="css/bootstrap-slider.min.css"><!-- Price Range Slider -->     
    
    
</head>

<body> 
    

<?php include 'header.php'; ?>

<div class="page-wraper">

    <!-- CONTENT START -->
    <div class="page-content">

        <!-- INNER PAGE BANNER -->
        <div class="wt-bnr-inr overlay-wraper bg-center">
            <div class="overlay-main innr-bnr-olay"></div>
            <div class="wt-bnr-inr-entry">
                <div class="banner-title-outer">
                    <div class="banner-title-name">
                        <h2 class="wt-title">Bike Rental</h2>
                    </div>
                    <!-- BREADCRUMB ROW -->                            
                    <div>
                        <ul class="wt-breadcrumb breadcrumb-style-2">
                            <li><a href="index.php">Home</a></li>
                            <li><a href="blogs.php">Bike Rental</a></li>
                            
                        </ul>
                    </div>
                </div>
                <!-- BREADCRUMB ROW END -->                        
            </div>
            <div class="trv-inr-bnr-cloud">            
                <div class="marquee">
                    <img src="images/inr-banner-cloud.png" alt="Image">
                </div>
            </div>
            <div class="trv-inr-bnr-plane">
                <div class="trv-inr-bnr-plane-bx"><img src="images/airplane.png" alt="Image"></div>
                
            </div>
            <div class="trv-inr-bnr-bloon-1"><img src="images/hotballon-Left.png" alt="Image"></div>
            <div class="trv-inr-bnr-bloon-2"><img src="images/hotballon-right.png" alt="Image"></div>
        </div>
        <!-- INNER PAGE BANNER END -->
        
        <div class="vehicle-type-nav">
    <a href="bike-rental.php" class="active">Bike</a>
    <a href="car-rental.php">Car</a>
</div>

        <!-- SECTION START -->
        <div class="section-full  p-t80 p-b90">
            <div class="container">
            
                <!-- BLOG SECTION START -->
                <div class="section-content">
                    <div class="row d-flex justify-content-center">
        
                        <!-- SIDE BAR START -->
                        <div class="col-xl-4 col-lg-4 col-md-12 rightSidebar  m-b30">
                        
                            <aside class="side-bar-filter">
        
                                <!--Left Search Filter -->
                                <div class="styleswitcher">
                                    
                                    <div class="styleswitcher-inner ">
                                        <div class="twm-side-filter-form">
                                            <form id="vehicleFilterForm">
        
                                                <div class="twm-sidebar-ele-filter">
        
                                                    <div class="trv-fliter-bx">
                                                        <h4 class="section-head-small mb-4">Search Bike</h4>
                                                        <div class="search-bx-filter">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="vehicleSearch" placeholder="Search bikes...">
                                                                <span class="input-group-btn">
                                                                    <button type="button" class="btn" id="searchBtn"><i class="fa fa-search"></i></button>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                
                                                    <div class="trv-fliter-bx">
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group">
                                                                <label>Bike Type</label>
                                                                <select class="form-control" id="vehicleTypeFilter">
                                                                    <option value="all" selected>Select Bike Type</option>
                                                                    <option value="cruiser">Cruiser Bike</option>
                                                                    <option value="scooter">Scooter</option>
                                                                    <option value="sports">Sports Bike</option>
                                                                    <option value="classic">Classic Bike</option>
                                                                </select>
                                                            </div>
                                                        </div>
        
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group">
                                                                <label>Engine Capacity</label>
                                                                <select class="form-control" id="engineFilter">
                                                                    <option value="all" selected>Select CC</option>
                                                                    <option value="100-125">100-125cc</option>
                                                                    <option value="125-200">125-200cc</option>
                                                                    <option value="200-350">200-350cc</option>
                                                                    <option value="350+">350cc+</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group twm-input-with-icon">
                                                                <label>Rental Duration</label>
                                                                <select class="form-control" id="durationFilter">
                                                                    <option value="all" selected>Select Duration</option>
                                                                    <option value="1">1 Day</option>
                                                                    <option value="2">2 Days</option>
                                                                    <option value="3">3 Days</option>
                                                                    <option value="4">4 Days</option>
                                                                    <option value="5">5+ Days</option>
                                                                </select>
                                                            </div>
                                                        </div>
        
                                                        <div class="trv-fltr-select">
                                                            <div class="form-group form-group-2column-wrap twm-input-with-icon">
                                                                <label>Price Per Day</label>
                                                                <select class="form-control" id="priceFilter">
                                                                    <option value="all" selected>Select Price Range</option>
                                                                    <option value="0-500">Under ₹500</option>
                                                                    <option value="500-1000">₹500 - ₹1,000</option>
                                                                    <option value="1000-1500">₹1,000 - ₹1,500</option>
                                                                    <option value="1500+">Above ₹1,500</option>
                                                                </select>
                                                            </div>
                                                        </div>
        
                                                    </div>
        
                                                    <div class="trv-fliter-bx">
                                                        <h4 class="section-head-small mb-4">Bike Features</h4>
                                                        <ul>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input feature-filter" id="feat01" value="helmet">
                                                                    <label class="form-check-label" for="feat01">Helmet Included</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input feature-filter" id="feat02" value="insurance">
                                                                    <label class="form-check-label" for="feat02">Insurance</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input feature-filter" id="feat03" value="delivery">
                                                                    <label class="form-check-label" for="feat03">Free Delivery</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input feature-filter" id="feat04" value="support">
                                                                    <label class="form-check-label" for="feat04">24/7 Support</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="form-check">
                                                                    <input type="checkbox" class="form-check-input feature-filter" id="feat05" value="luggage">
                                                                    <label class="form-check-label" for="feat05">Luggage Rack</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
        
                                                </div>
        
                                                <div class="twm-side-filter-aply-btn text-center">
                                                    <button type="button" id="applyFilters" class="site-button butn-bg-shape">Apply Filter</button>
                                                    <button type="button" id="filterReset" class="site-button outline mx-2">Reset All</button>
                                                </div>
                                            </form>
                                            <!-- Removed advertisement image -->
                                            
                                        </div>
                                    </div>    
                                </div>
                                <!--Left Search Filter -->
        
                            </aside>
        
                        </div>
                        <!-- SIDE BAR END --> 
                    
                        <?php
include('db.php');

$sql = "SELECT id, image, category_tags, bike_name, short_description, price FROM bikes ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$bikes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-xl-8 col-lg-8 col-md-12 m-b30">
    <div class="row" id="vehicleContainer">
        <?php foreach ($bikes as $bike): ?>
            <!--BOX-1-->
            <div class="col-xl-6 col-lg-6 col-md-6 m-b30 vehicle-item" data-type="cruiser" data-engine="200-350" data-duration="1" data-price="<?php echo preg_replace('/[^0-9]/', '', $bike['price']); ?>" data-features="helmet,insurance,support,luggage">
                <div class="trv-popular-tour-st1">
                    <div class="trv-media">
                        <a href="javascript:void(0);">
                            <?php if (!empty($bike['image'])): ?>
                                <img src="admin/uploads/bikes/<?php echo $bike['image']; ?>" alt="<?php echo htmlspecialchars($bike['bike_name']); ?>">
                            <?php else: ?>
                                <img src="https://via.placeholder.com/400x300?text=No+Image" alt="<?php echo htmlspecialchars($bike['bike_name']); ?>">
                            <?php endif; ?>
                        </a>
                        <div class="trv-tour-duration">
                            <i class="bi bi-gear"></i>
                            <span><?php echo htmlspecialchars($bike['category_tags']); ?></span>
                        </div>
                        <div class="trv-tour-title">
                            <h3 class="trv-title">
                                <a href="javascript:void(0);">
                                    <i class="bi bi-bicycle"></i>
                                    <?php echo htmlspecialchars($bike['bike_name']); ?>
                                </a>
                            </h3>
                        </div>
                    </div>
                    <div class="trv-content">
                        <div class="trv-content-head-section">
                            <div class="trv-tour-price">
                                <span class="price"><?php echo htmlspecialchars($bike['price']); ?></span>
                                <span class="price-duration">Per Day</span>
                            </div>
                            <div class="trv-tour-info">
                                <a href="javascript:void(0);"><?php echo htmlspecialchars($bike['short_description']); ?></a>
                            </div>
                        </div>
                        <div class="trv-content-bottom-section">
                            <div class="trv-book">
                                <a href="javascript:void(0);" class="site-button outline book-now-btn" data-package="<?php echo htmlspecialchars($bike['bike_name']); ?>" data-type="bike-rent">Book Now</a>
                            </div>
                            <div class="trv-tour-rating">
                                <span class="trv-tour-review-count">(4.8 Review)</span>
                                <div class="trv-review-rating">
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                    <i class="bi bi-star-fill"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <!-- Rest of your code remains same -->
    <div class="no-results" style="display: none; text-align: center; padding: 40px;">
        <h3>No bikes found matching your filters</h3>
        <p>Try adjusting your search criteria</p>
    </div>
    <ul class="custom-pagination clearfix">
        <li class="prev"><a href="javascript:void(0);"><span class="bi bi-chevron-left"></span></a></li>
        <li><a href="javascript:void(0);">1</a></li>
        <li><a href="javascript:void(0);">2</a></li>
        <li><a href="javascript:void(0);">3</a></li>
        <li><a href="javascript:void(0);">...</a></li>
        <li class="next"><a href="javascript:void(0);"><span class="bi bi-chevron-right"></span></a></li>
    </ul>
</div>
                
                    </div>
        
                </div>
                
            </div>
            
        </div>   
        <!-- SECTION END -->

        <script>
        // Bike Rent Specific Filter Functionality
        document.addEventListener('DOMContentLoaded', function() {
            const vehicleItems = document.querySelectorAll('.vehicle-item');
            const vehicleTypeFilter = document.getElementById('vehicleTypeFilter');
            const engineFilter = document.getElementById('engineFilter');
            const durationFilter = document.getElementById('durationFilter');
            const priceFilter = document.getElementById('priceFilter');
            const featureCheckboxes = document.querySelectorAll('.feature-filter');
            const applyFiltersBtn = document.getElementById('applyFilters');
            const filterResetBtn = document.getElementById('filterReset');
            const vehicleSearch = document.getElementById('vehicleSearch');
            const searchBtn = document.getElementById('searchBtn');
            const noResults = document.querySelector('.no-results');
        
            // Show all bikes initially
            function showAllBikes() {
                vehicleItems.forEach(item => {
                    item.style.display = 'block';
                });
                noResults.style.display = 'none';
            }
        
            // Filter Bikes Function
            function filterBikes() {
                const vehicleTypeValue = vehicleTypeFilter.value;
                const engineValue = engineFilter.value;
                const durationValue = durationFilter.value;
                const priceValue = priceFilter.value;
                const searchTerm = vehicleSearch.value.toLowerCase().trim();
                
                // Get selected features
                const selectedFeatures = [];
                featureCheckboxes.forEach(cb => {
                    if (cb.checked) selectedFeatures.push(cb.value);
                });
        
                let visibleCount = 0;
        
                vehicleItems.forEach(item => {
                    const vehicleType = item.getAttribute('data-type');
                    const engine = item.getAttribute('data-engine');
                    const duration = parseInt(item.getAttribute('data-duration'));
                    const price = parseInt(item.getAttribute('data-price'));
                    const features = item.getAttribute('data-features').split(',');
                    
                    // Get text content for search
                    const title = item.querySelector('.trv-title a').textContent.toLowerCase();
                    const description = item.querySelector('.trv-tour-info a').textContent.toLowerCase();
                    
                    // Check vehicle type filter
                    const vehicleTypeMatch = vehicleTypeValue === 'all' || vehicleType === vehicleTypeValue;
                    
                    // Check engine filter
                    const engineMatch = engineValue === 'all' || engine === engineValue;
                    
                    // Check duration filter
                    let durationMatch = true;
                    if (durationValue !== 'all') {
                        const durationNum = parseInt(durationValue);
                        if (durationNum === 5) {
                            durationMatch = duration >= 5;
                        } else {
                            durationMatch = duration === durationNum;
                        }
                    }
                    
                    // Check price filter
                    let priceMatch = true;
                    if (priceValue !== 'all') {
                        if (priceValue === '0-500') priceMatch = price <= 500;
                        else if (priceValue === '500-1000') priceMatch = price > 500 && price <= 1000;
                        else if (priceValue === '1000-1500') priceMatch = price > 1000 && price <= 1500;
                        else if (priceValue === '1500+') priceMatch = price > 1500;
                    }
                    
                    // Check search term
                    let searchMatch = true;
                    if (searchTerm !== '') {
                        searchMatch = title.includes(searchTerm) || description.includes(searchTerm);
                    }
                    
                    // Check features
                    let featuresMatch = true;
                    if (selectedFeatures.length > 0) {
                        featuresMatch = selectedFeatures.every(feat => features.includes(feat));
                    }
                    
                    // Show/hide based on all filters
                    if (vehicleTypeMatch && engineMatch && durationMatch && priceMatch && searchMatch && featuresMatch) {
                        item.style.display = 'block';
                        visibleCount++;
                    } else {
                        item.style.display = 'none';
                    }
                });
        
                // Show/hide no results message
                if (visibleCount === 0) {
                    noResults.style.display = 'block';
                } else {
                    noResults.style.display = 'none';
                }
            }
        
            // Search functionality
            searchBtn.addEventListener('click', filterBikes);
            vehicleSearch.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    filterBikes();
                }
            });
        
            // Apply filters button
            applyFiltersBtn.addEventListener('click', filterBikes);
        
            // Reset filters button
            filterResetBtn.addEventListener('click', function() {
                vehicleTypeFilter.value = 'all';
                engineFilter.value = 'all';
                durationFilter.value = 'all';
                priceFilter.value = 'all';
                vehicleSearch.value = '';
                
                featureCheckboxes.forEach(cb => {
                    cb.checked = false;
                });
                
                showAllBikes();
            });
        
            // Initialize - show all bikes
            showAllBikes();
        });
        </script>

        <?php include 'enquiry-form.php'; ?> 
    </div>
    <!-- CONTENT END -->
</div>

<?php include 'footer.php'; ?>