<?php 
session_start(); // Add session start at the top
include('header.php');
include('db.php'); 

// Show success/error messages from session
if (isset($_SESSION['success'])) {
    echo "<script>showNotification('success', '" . addslashes($_SESSION['success']) . "');</script>";
    unset($_SESSION['success']);
}

if (isset($_SESSION['error'])) {
    echo "<script>showNotification('error', '" . addslashes($_SESSION['error']) . "');</script>";
    unset($_SESSION['error']);
}

// Fetch all cars
$sql = "SELECT * FROM cars ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$cars = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- External CSS -->
<link rel="stylesheet" href="assets/dist/css/style.css">
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    /* Show Cars Specific Styles */
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .table-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        color: #000 !important;
        overflow-x: auto;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .table-scroll {
        width: 100%;
        overflow-x: auto;
        border-radius: 10px;
    }

    table {
        width: 100%;
        min-width: 1400px;
        border-collapse: collapse;
        color: #000 !important;
        background: #fff !important;
    }

    th, td {
        padding: 16px;
        text-align: left;
        border-bottom: 1px solid #ddd !important;
        color: #000 !important;
        font-size: 14px;
        background: #fff !important;
        vertical-align: middle;
        white-space: nowrap;
    }

    th {
        color: #000 !important;
        font-weight: 700;
        text-transform: uppercase;
        background: #f8f9fa !important;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    tr {
        padding: 10px auto;
        background: #fff !important;
    }

    tr:hover {
        background: rgba(0, 0, 0, 0.05) !important;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    .btn-edit, .btn-delete, .btn-view {
        background: #273B92 !important;
        border: 1px solid #273B92 !important;
        border-radius: 8px;
        color: #fff !important;
        padding: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 16px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border: none;
    }

    .btn-edit:hover, .btn-delete:hover, .btn-view:hover {
        background: #FF6B00 !important;
        border-color: #FF6B00 !important;
        color: #fff !important;
        transform: translateY(-2px);
    }

    .car-image {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
    }

    .empty-message {
        text-align: center;
        padding: 40px;
        color: #666;
        font-style: italic;
        min-width: 100%;
    }

    .btn-add {
        display: inline-block;
        background: #FF6B00 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .btn-add:hover {
        background: #E55A00 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
        text-decoration: none;
    }

    /* Sticky first column for actions */
    td:first-child, th:first-child {
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    th:first-child {
        z-index: 15;
    }

    /* Content preview styling */
    .content-preview {
        max-width: 300px;
        white-space: normal;
        max-height: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        line-height: 1.4;
    }

    .date-column {
        min-width: 120px;
    }

    .category-column {
        min-width: 150px;
    }

    .desc-column {
        min-width: 250px;
        max-width: 300px;
    }

    /* Search Bar */
    .search-container {
        display: flex;
        justify-content: flex-end;
        margin-bottom: 20px;
    }

    .search-input {
        padding: 12px 20px;
        width: 300px;
        border: 2px solid #ddd;
        border-radius: 12px;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .search-input:focus {
        border-color: #FF6B00;
        box-shadow: 0 0 0 3px rgba(255, 107, 0, 0.2);
        outline: none;
    }

    /* Custom Notification */
    .custom-notification {
        position: fixed;
        top: 100px;
        right: 20px;
        padding: 15px 25px;
        border-radius: 10px;
        color: white;
        font-weight: 600;
        z-index: 9999;
        animation: slideInRight 0.5s ease, fadeOut 0.5s ease 2.5s forwards;
        display: flex;
        align-items: center;
        gap: 10px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .notification-success {
        background: linear-gradient(90deg, #28a745, #20c997);
        border-left: 5px solid #218838;
    }

    .notification-error {
        background: linear-gradient(90deg, #dc3545, #e4606d);
        border-left: 5px solid #c82333;
    }

    .notification-warning {
        background: linear-gradient(90deg, #ffc107, #ffca2c);
        border-left: 5px solid #e0a800;
        color: #212529;
    }

    @keyframes slideInRight {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
        }
        to {
            opacity: 0;
        }
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px;
        }
        .table-container {
            padding: 20px;
        }
        table {
            min-width: 1500px;
        }
        .action-buttons {
            gap: 8px;
        }
        .btn-edit, .btn-delete, .btn-view {
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
        .car-image {
            width: 60px;
            height: 60px;
        }
        .content-preview {
            max-width: 200px;
        }
        .desc-column {
            min-width: 150px;
            max-width: 200px;
        }
        .search-container {
            justify-content: center;
        }
        .search-input {
            width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="table-container">
        <h2>Cars List</h2>
        
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px; flex-wrap: wrap; gap: 15px;">
            <a href="add-cars.php" class="btn-add">
                <i class="fas fa-plus-circle"></i> Add New Car
            </a>
            
            <div class="search-container">
                <input type="text" id="searchInput" class="search-input" 
                       placeholder="Search cars by name, category, price..." 
                       onkeyup="searchCars()">
            </div>
        </div>

        <?php if (empty($cars)): ?>
            <div class="empty-message">No cars found. Add your first car above.</div>
        <?php else: ?>
        
        <div class="table-scroll">
            <table>
                <thead>
                    <tr>
                        <th>Actions</th>
                        <th>#</th>
                        <th>Image</th>
                        <th>Car Name</th>
                        <th class="category-column">Category Tags</th>
                        <th class="date-column">Price</th>
                        <th class="desc-column">Description</th>
                        <th class="date-column">Created Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($cars as $index => $car): 
                        // Format date
                        $created_formatted = '';
                        if (!empty($car['created_at'])) {
                            $created_formatted = date('d/m/Y', strtotime($car['created_at']));
                        }
                        
                        // Description preview
                        $desc_preview = '';
                        if (!empty($car['short_description'])) {
                            $desc_preview = strlen($car['short_description']) > 100 
                                ? substr($car['short_description'], 0, 100) . '...' 
                                : $car['short_description'];
                        }
                    ?>
                    <tr>
                        <td>
                            <div class="action-buttons">
                                <!-- Edit button - goes to edit page -->
                                <a href="edit-cars.php?id=<?php echo $car['id']; ?>" class="btn-edit" title="Edit Car">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <!-- Delete button with confirmation -->
                                <a href="delete-car.php?delete_id=<?php echo $car['id']; ?>" class="btn-delete" 
                                   onclick="return confirmDelete()" title="Delete Car">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </td>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <?php if (!empty($car['image'])): ?>
                                <img src="uploads/cars/<?php echo htmlspecialchars($car['image']); ?>" 
                                     alt="<?php echo htmlspecialchars($car['car_name']); ?>" 
                                     class="car-image"
                                     onerror="this.src='https://via.placeholder.com/80?text=No+Image'">
                            <?php else: ?>
                                <img src="https://via.placeholder.com/80?text=No+Image" 
                                     class="car-image"
                                     alt="No Image">
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($car['car_name']); ?></td>
                        <td class="category-column"><?php echo htmlspecialchars($car['category_tags']); ?></td>
                        <td class="date-column"><?php echo htmlspecialchars($car['price']); ?></td>
                        <td class="desc-column" title="<?php echo htmlspecialchars($car['short_description']); ?>">
                            <div class="content-preview"><?php echo htmlspecialchars($desc_preview); ?></div>
                        </td>
                        <td class="date-column"><?php echo $created_formatted; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <?php endif; ?>
    </div>
</div>

<script>
// Custom notification function
function showNotification(type, message) {
    // Remove existing notifications
    const existingNotif = document.querySelector('.custom-notification');
    if (existingNotif) {
        existingNotif.remove();
    }
    
    // Create notification
    const notification = document.createElement('div');
    notification.className = `custom-notification notification-${type}`;
    
    // Add icon based on type
    let icon = 'fa-info-circle';
    if (type === 'success') icon = 'fa-check-circle';
    if (type === 'error') icon = 'fa-exclamation-circle';
    if (type === 'warning') icon = 'fa-exclamation-triangle';
    
    notification.innerHTML = `
        <i class="fas ${icon}"></i>
        <span>${message}</span>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 3 seconds
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 3000);
}

// Delete confirmation
function confirmDelete() {
    return confirm("Are you sure you want to delete this car?");
}

// Search functionality
function searchCars() {
    var input = document.getElementById('searchInput');
    var filter = input.value.toUpperCase();
    var table = document.querySelector('table');
    var tr = table.getElementsByTagName('tr');
    
    for (var i = 1; i < tr.length; i++) {
        var tdName = tr[i].getElementsByTagName('td')[3]; // Car Name column
        var tdCategory = tr[i].getElementsByTagName('td')[4]; // Category column
        var tdPrice = tr[i].getElementsByTagName('td')[5]; // Price column
        var tdDesc = tr[i].getElementsByTagName('td')[6]; // Description column
        
        var showRow = false;
        
        if (tdName) {
            var txtValue = tdName.textContent || tdName.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdCategory) {
            var txtValue = tdCategory.textContent || tdCategory.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdPrice) {
            var txtValue = tdPrice.textContent || tdPrice.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdDesc) {
            var txtValue = tdDesc.textContent || tdDesc.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (showRow) {
            tr[i].style.display = '';
        } else {
            tr[i].style.display = 'none';
        }
    }
}
</script>

<?php include('footer.php'); ?>