<?php 
session_start(); // Add session start at the top
include('header.php');
include('db.php'); 

// Show success/error messages from session
if (isset($_SESSION['success'])) {
    echo "<script>showNotification('success', '" . addslashes($_SESSION['success']) . "');</script>";
    unset($_SESSION['success']);
}

if (isset($_SESSION['error'])) {
    echo "<script>showNotification('error', '" . addslashes($_SESSION['error']) . "');</script>";
    unset($_SESSION['error']);
}

// Fetch all blogs
$sql = "SELECT * FROM blogs ORDER BY publish_date DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- External CSS -->
<link rel="stylesheet" href="assets/dist/css/style.css">
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    /* Show Blogs Specific Styles */
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .table-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        color: #000 !important;
        overflow-x: auto;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .table-scroll {
        width: 100%;
        overflow-x: auto;
        border-radius: 10px;
    }

    table {
        width: 100%;
        min-width: 1600px;
        border-collapse: collapse;
        color: #000 !important;
        background: #fff !important;
    }

    th, td {
        padding: 16px;
        text-align: left;
        border-bottom: 1px solid #ddd !important;
        color: #000 !important;
        font-size: 14px;
        background: #fff !important;
        vertical-align: middle;
        white-space: nowrap;
    }

    th {
        color: #000 !important;
        font-weight: 700;
        text-transform: uppercase;
        background: #f8f9fa !important;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    tr {
        padding: 10px auto;
        background: #fff !important;
    }

    tr:hover {
        background: rgba(0, 0, 0, 0.05) !important;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    .btn-edit, .btn-delete, .btn-view {
        background: #273B92 !important;
        border: 1px solid #273B92 !important;
        border-radius: 8px;
        color: #fff !important;
        padding: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 16px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border: none;
    }

    .btn-edit:hover, .btn-delete:hover, .btn-view:hover {
        background: #FF6B00 !important;
        border-color: #FF6B00 !important;
        color: #fff !important;
        transform: translateY(-2px);
    }

    .blog-image {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
    }

    .empty-message {
        text-align: center;
        padding: 40px;
        color: #666;
        font-style: italic;
        min-width: 100%;
    }

    .btn-add {
        display: inline-block;
        background: #FF6B00 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .btn-add:hover {
        background: #E55A00 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
        text-decoration: none;
    }

    /* Sticky first column for actions */
    td:first-child, th:first-child {
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    th:first-child {
        z-index: 15;
    }

    /* Content preview styling */
    .content-preview {
        max-width: 300px;
        white-space: normal;
        max-height: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        line-height: 1.4;
    }

    .date-column {
        min-width: 120px;
    }

    .category-column {
        min-width: 100px;
    }

    .full-desc-column {
        min-width: 200px;
        max-width: 300px;
    }

    /* Search Bar */
    .search-container {
        display: flex;
        justify-content: flex-end;
        margin-bottom: 20px;
    }

    .search-input {
        padding: 12px 20px;
        width: 300px;
        border: 2px solid #ddd;
        border-radius: 12px;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .search-input:focus {
        border-color: #FF6B00;
        box-shadow: 0 0 0 3px rgba(255, 107, 0, 0.2);
        outline: none;
    }

    /* Custom Notification */
    .custom-notification {
        position: fixed;
        top: 100px;
        right: 20px;
        padding: 15px 25px;
        border-radius: 10px;
        color: white;
        font-weight: 600;
        z-index: 9999;
        animation: slideInRight 0.5s ease, fadeOut 0.5s ease 2.5s forwards;
        display: flex;
        align-items: center;
        gap: 10px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .notification-success {
        background: linear-gradient(90deg, #28a745, #20c997);
        border-left: 5px solid #218838;
    }

    .notification-error {
        background: linear-gradient(90deg, #dc3545, #e4606d);
        border-left: 5px solid #c82333;
    }

    .notification-warning {
        background: linear-gradient(90deg, #ffc107, #ffca2c);
        border-left: 5px solid #e0a800;
        color: #212529;
    }

    @keyframes slideInRight {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
        }
        to {
            opacity: 0;
        }
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px;
        }
        .table-container {
            padding: 20px;
        }
        table {
            min-width: 1800px;
        }
        .action-buttons {
            gap: 8px;
        }
        .btn-edit, .btn-delete, .btn-view {
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
        .blog-image {
            width: 60px;
            height: 60px;
        }
        .content-preview {
            max-width: 200px;
        }
        .full-desc-column {
            min-width: 150px;
            max-width: 200px;
        }
        .search-container {
            justify-content: center;
        }
        .search-input {
            width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="table-container">
        <h2>Blog Posts List</h2>
        
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px; flex-wrap: wrap; gap: 15px;">
            <a href="add-blogs.php" class="btn-add">
                <i class="fas fa-plus-circle"></i> Add New Blog
            </a>
            
            <div class="search-container">
                <input type="text" id="searchInput" class="search-input" 
                       placeholder="Search blogs by name, author, category..." 
                       onkeyup="searchBlogs()">
            </div>
        </div>

        <?php if (empty($blogs)): ?>
            <div class="empty-message">No blog posts found. Add your first blog above.</div>
        <?php else: ?>
        
        <div class="table-scroll">
            <table>
                <thead>
                    <tr>
                        <th>Actions</th>
                        <th>#</th>
                        <th>Image</th>
                        <th>Blog Name</th>
                        <th class="date-column">Publish Date</th>
                        <th>Author Name</th>
                        <th>Category</th>
                        <th>Short Description</th>
                        <th class="full-desc-column">Full Description</th>
                        <th class="date-column">Created Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($blogs as $index => $blog): 
                        // Format dates
                        $publish_date_formatted = '';
                        if (!empty($blog['publish_date'])) {
                            $publish_date_formatted = date('d/m/Y', strtotime($blog['publish_date']));
                        }
                        
                        $created_formatted = '';
                        if (!empty($blog['created_at'])) {
                            $created_formatted = date('d/m/Y', strtotime($blog['created_at']));
                        }
                        
                        // Short description preview
                        $short_desc_preview = '';
                        if (!empty($blog['short_description'])) {
                            $short_desc_preview = strlen($blog['short_description']) > 100 
                                ? substr($blog['short_description'], 0, 100) . '...' 
                                : $blog['short_description'];
                        }
                        
                        // Full description preview
                        $full_desc_preview = '';
                        if (!empty($blog['description'])) {
                            $plain_desc = strip_tags($blog['description']);
                            $full_desc_preview = strlen($plain_desc) > 100 
                                ? substr($plain_desc, 0, 100) . '...' 
                                : $plain_desc;
                        }
                    ?>
                    <tr>
                        <td>
                            <div class="action-buttons">
                                <!-- Edit button - goes to edit page -->
                                <a href="edit-blogs.php?id=<?php echo $blog['id']; ?>" class="btn-edit" title="Edit Blog">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <!-- Delete button with confirmation - NOW POINTS TO DELETE-BLOG.PHP -->
                                <a href="delete-blog.php?delete_id=<?php echo $blog['id']; ?>" class="btn-delete" 
                                   onclick="return confirmDelete()" title="Delete Blog">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </td>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <?php if (!empty($blog['image'])): ?>
                                <img src="uploads/blogs/<?php echo htmlspecialchars($blog['image']); ?>" 
                                     alt="<?php echo htmlspecialchars($blog['blog_name']); ?>" 
                                     class="blog-image"
                                     onerror="this.src='https://via.placeholder.com/80?text=No+Image'">
                            <?php else: ?>
                                <img src="https://via.placeholder.com/80?text=No+Image" 
                                     class="blog-image"
                                     alt="No Image">
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($blog['blog_name']); ?></td>
                        <td class="date-column"><?php echo $publish_date_formatted; ?></td>
                        <td><?php echo htmlspecialchars($blog['author_name']); ?></td>
                        <td class="category-column"><?php echo htmlspecialchars($blog['category']); ?></td>
                        <td title="<?php echo htmlspecialchars($blog['short_description']); ?>">
                            <div class="content-preview"><?php echo htmlspecialchars($short_desc_preview); ?></div>
                        </td>
                        <td class="full-desc-column" title="<?php echo htmlspecialchars(strip_tags($blog['description'])); ?>">
                            <div class="content-preview"><?php echo htmlspecialchars($full_desc_preview); ?></div>
                        </td>
                        <td class="date-column"><?php echo $created_formatted; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <?php endif; ?>
    </div>
</div>

<script>
// Custom notification function
function showNotification(type, message) {
    // Remove existing notifications
    const existingNotif = document.querySelector('.custom-notification');
    if (existingNotif) {
        existingNotif.remove();
    }
    
    // Create notification
    const notification = document.createElement('div');
    notification.className = `custom-notification notification-${type}`;
    
    // Add icon based on type
    let icon = 'fa-info-circle';
    if (type === 'success') icon = 'fa-check-circle';
    if (type === 'error') icon = 'fa-exclamation-circle';
    if (type === 'warning') icon = 'fa-exclamation-triangle';
    
    notification.innerHTML = `
        <i class="fas ${icon}"></i>
        <span>${message}</span>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 3 seconds
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 3000);
}

// Delete confirmation
function confirmDelete() {
    return confirm("Are you sure you want to delete this blog!");
}

// Search functionality
function searchBlogs() {
    var input = document.getElementById('searchInput');
    var filter = input.value.toUpperCase();
    var table = document.querySelector('table');
    var tr = table.getElementsByTagName('tr');
    
    for (var i = 1; i < tr.length; i++) {
        var tdName = tr[i].getElementsByTagName('td')[3]; // Blog Name column
        var tdAuthor = tr[i].getElementsByTagName('td')[5]; // Author Name column
        var tdCategory = tr[i].getElementsByTagName('td')[6]; // Category column
        var tdShortDesc = tr[i].getElementsByTagName('td')[7]; // Short Description column
        var tdFullDesc = tr[i].getElementsByTagName('td')[8]; // Full Description column
        
        var showRow = false;
        
        if (tdName) {
            var txtValue = tdName.textContent || tdName.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdAuthor) {
            var txtValue = tdAuthor.textContent || tdAuthor.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdCategory) {
            var txtValue = tdCategory.textContent || tdCategory.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdShortDesc) {
            var txtValue = tdShortDesc.textContent || tdShortDesc.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdFullDesc) {
            var txtValue = tdFullDesc.textContent || tdFullDesc.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (showRow) {
            tr[i].style.display = '';
        } else {
            tr[i].style.display = 'none';
        }
    }
}
</script>

<?php include('footer.php'); ?>