<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>GoaReddy Admin</title>
    <!-- Favicon -->
    <link rel="shortcut icon" href="images/favicon.png" type="image/png">
    <!-- Bootstrap -->
    <link href="assets/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome -->
    <link href="assets/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    
    <style>
        :root {
            --primary-color: #FF6B00;
            --dark-bg: #121212;
            --card-bg: #1E1E1E;
            --input-bg: #2D2D2D;
            --white: #ffffff;
            --light-gray: #CCCCCC;
            --border-color: #333333;
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: var(--dark-bg);
            font-family: 'Segoe UI', system-ui, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: var(--white);
        }

        .login-wrapper {
            width: 100%;
            max-width: 420px;
        }

        .login-container {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 40px 35px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        /* Goa theme decoration */
        .goa-theme::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 150px;
            height: 150px;
            background: linear-gradient(135deg, rgba(255, 107, 0, 0.1) 0%, rgba(255, 215, 0, 0.05) 100%);
            border-radius: 50%;
            transform: translate(50px, -50px);
        }

        /* Logo Section - Modern Center */
        .logo-section {
            text-align: center;
            margin-bottom: 35px;
            position: relative;
        }

        .logo-container {
            display: inline-block;
            padding: 15px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.05);
            margin-bottom: 20px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .logo {
            height: 50px;
            width: auto;
        }

        .brand-title {
            font-size: 22px;
            font-weight: 700;
            color: var(--white);
            margin-bottom: 6px;
            letter-spacing: 0.5px;
        }

        .brand-subtitle {
            font-size: 13px;
            color: var(--light-gray);
            font-weight: 400;
            line-height: 1.4;
        }

        /* Form Elements - Modern Dark */
        .form-group {
            margin-bottom: 24px;
        }

        .form-label {
            display: flex;
            align-items: center;
            font-size: 12px;
            font-weight: 600;
            color: var(--light-gray);
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-label i {
            margin-right: 10px;
            color: var(--primary-color);
            font-size: 14px;
        }

        .form-control {
            width: 100%;
            height: 48px;
            padding: 12px 45px 12px 16px;
            font-size: 14px;
            border: 1.5px solid var(--border-color);
            border-radius: 8px;
            background: var(--input-bg);
            color: var(--white);
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(255, 107, 0, 0.2);
        }

        .form-control::placeholder {
            color: #777;
            font-size: 13px;
        }

        .input-wrapper {
            position: relative;
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #777;
            cursor: pointer;
            font-size: 16px;
            padding: 0;
            width: 24px;
            height: 24px;
            transition: var(--transition);
        }

        .password-toggle:hover {
            color: var(--primary-color);
        }

        /* Button - Orange Theme */
        .login-btn {
            display: block;
            background: var(--primary-color);
            color: var(--white);
            font-size: 14px;
            font-weight: 600;
            padding: 14px 24px;
            transition: var(--transition);
            text-align: center;
            border-radius: 8px;
            border: none;
            width: 100%;
            cursor: pointer;
            margin-top: 10px;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }

        .login-btn:hover {
            background: #E55A00;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 107, 0, 0.3);
        }

        .login-btn:active {
            transform: translateY(0);
        }

        .login-btn i {
            margin-right: 8px;
        }

        /* Error Message */
        .error-message {
            background: rgba(220, 53, 69, 0.1);
            border: 1px solid rgba(220, 53, 69, 0.3);
            border-radius: 8px;
            color: #ff6b6b;
            padding: 14px;
            margin-bottom: 25px;
            font-size: 13px;
            display: none;
            align-items: center;
            animation: fadeIn 0.3s ease;
        }

        .error-message.show {
            display: flex;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-5px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Security Notice */
        .security-notice {
            text-align: center;
            margin-top: 30px;
            padding-top: 25px;
            border-top: 1px solid var(--border-color);
        }

        .security-text {
            font-size: 11px;
            color: #888;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-weight: 500;
        }

        .security-text i {
            color: var(--primary-color);
            font-size: 12px;
        }

        /* Loading State */
        .btn-loading {
            position: relative;
            color: transparent !important;
        }

        .btn-loading::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: var(--white);
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to { transform: translate(-50%, -50%) rotate(360deg); }
        }

        /* Responsive */
        @media (max-width: 480px) {
            body {
                padding: 15px;
            }
            
            .login-container {
                padding: 35px 25px;
                border-radius: 10px;
            }
            
            .logo {
                height: 45px;
            }
            
            .brand-title {
                font-size: 20px;
            }
            
            .brand-subtitle {
                font-size: 12px;
            }
            
            .form-control {
                height: 46px;
                padding: 12px 40px 12px 14px;
            }
            
            .login-btn {
                padding: 13px 20px;
                font-size: 13px;
            }
        }

        /* Animation for inputs */
        .form-control:focus {
            animation: inputFocus 0.5s ease;
        }

        @keyframes inputFocus {
            0% { box-shadow: 0 0 0 0 rgba(255, 107, 0, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(255, 107, 0, 0); }
            100% { box-shadow: 0 0 0 0 rgba(255, 107, 0, 0); }
        }
    </style>
</head>

<body>
    <!-- Login Wrapper -->
    <div class="login-wrapper">
        <div class="login-container goa-theme">
            <!-- Logo Section -->
            <div class="logo-section">
                <div class="logo-container">
                    <img src="img/logo-goa.png" alt="GoaReddy" class="logo">
                </div>
                <h1 class="brand-title">ADMIN PORTAL</h1>
                <p class="brand-subtitle">GoaReddy Management System</p>
            </div>

            <!-- Error Message -->
            <div class="error-message" id="errorMessage"> 
                <i class="fa fa-exclamation-circle me-3"></i>
                <span id="errorText">Invalid credentials. Please try again.</span>
            </div>

            <!-- Login Form -->
            <form method="post" action="admin_login.php" id="loginForm">
                <!-- Username Field -->
                <div class="form-group">
                    <label class="form-label" for="username">
                        <i class="fa fa-user"></i>
                        <span>Username</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="text" 
                               name="username" 
                               id="username" 
                               class="form-control" 
                               placeholder="Enter admin username" 
                               required
                               autocomplete="username">
                    </div>
                </div>

                <!-- Password Field -->
                <div class="form-group">
                    <label class="form-label" for="password">
                        <i class="fa fa-lock"></i>
                        <span>Password</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password" 
                               name="password" 
                               id="password" 
                               class="form-control" 
                               placeholder="Enter your password" 
                               required
                               autocomplete="current-password">
                        <button type="button" class="password-toggle" id="togglePassword">
                            <i class="fa fa-eye"></i>
                        </button>
                    </div>
                </div>

                <!-- Submit Button -->
                <div>
                    <button type="submit" name="submit" class="login-btn" id="loginBtn">
                        <i class="fa fa-sign-in"></i>
                        Login to Dashboard
                    </button>
                </div>
            </form>

            <!-- Security Notice -->
            <div class="security-notice">
                <p class="security-text">
                    <i class="fa fa-shield"></i>
                    Authorized Access Only • GoaReddy Travel Services
                </p>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="assets/plugins/jQuery/jquery-1.12.4.min.js" type="text/javascript"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>

    <script>
        // Password Toggle
        const toggleBtn = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');
        
        toggleBtn.addEventListener('click', function() {
            const icon = this.querySelector('i');
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.className = 'fa fa-eye-slash';
                this.setAttribute('title', 'Hide password');
            } else {
                passwordInput.type = 'password';
                icon.className = 'fa fa-eye';
                this.setAttribute('title', 'Show password');
            }
        });

        // Form Submission
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const btn = document.getElementById('loginBtn');
            const errorDiv = document.getElementById('errorMessage');
            const errorText = document.getElementById('errorText');
            
            // Get values
            const username = document.getElementById('username').value.trim();
            const password = document.getElementById('password').value.trim();
            
            // Clear previous errors
            errorDiv.classList.remove('show');
            
            // Validation
            if (!username || !password) {
                e.preventDefault();
                errorText.textContent = 'Please enter both username and password.';
                errorDiv.classList.add('show');
                return;
            }
            
            // Show loading
            btn.classList.add('btn-loading');
            btn.disabled = true;
            btn.innerHTML = '';
            
            // Allow form to submit normally
        });

        // Auto-focus and clear errors on input
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-focus on username
            setTimeout(() => {
                document.getElementById('username').focus();
            }, 300);
            
            // Clear error when typing
            document.querySelectorAll('.form-control').forEach(input => {
                input.addEventListener('input', function() {
                    document.getElementById('errorMessage').classList.remove('show');
                });
            });
        });
    </script>
</body>
</html>