<?php
include('header.php');
include('db.php');

/* ======================
   GET CAR ID
====================== */
$car_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

/* ======================
   FETCH CAR DATA
====================== */
$car = null;
if ($car_id > 0) {
    $stmt = $pdo->prepare("SELECT * FROM cars WHERE id = :id");
    $stmt->bindParam(':id', $car_id, PDO::PARAM_INT);
    $stmt->execute();
    $car = $stmt->fetch(PDO::FETCH_ASSOC);
}

if (!$car) {
    echo "<script>alert('Car not found!'); window.location.href='show-cars.php';</script>";
    exit;
}

/* ======================
   UPDATE CAR
====================== */
if (isset($_POST['update'])) {

    $car_name = trim($_POST['car_name']);
    $category_tags = trim($_POST['category_tags']);
    $price = str_replace(',', '', trim($_POST['price']));
    $short_description = trim($_POST['short_description']);

    // SAME IMAGE LOGIC AS BLOG
    $image = $car['image'];

    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {

        $uploadDir = 'uploads/cars/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        if (!empty($car['image'])) {
            $old_image_path = $uploadDir . $car['image'];
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }

        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['image']['tmp_name']);

        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['image']['name']);
            $targetPath = $uploadDir . $fileName;

            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $image = $fileName;
            }
        }
    }

    // REMOVE IMAGE (same as blog)
    if (isset($_POST['remove_image']) && $_POST['remove_image'] == 1) {
        if (!empty($image)) {
            $image_path = 'uploads/cars/' . $image;
            if (file_exists($image_path)) {
                unlink($image_path);
            }
            $image = '';
        }
    }

    /* UPDATE QUERY */
    $sql = "UPDATE cars SET 
            car_name = :car_name,
            category_tags = :category_tags,
            price = :price,
            short_description = :short_description,
            image = :image,
            updated_at = NOW()
            WHERE id = :id";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':car_name', $car_name);
    $stmt->bindParam(':category_tags', $category_tags);
    $stmt->bindParam(':price', $price);
    $stmt->bindParam(':short_description', $short_description);
    $stmt->bindParam(':image', $image);
    $stmt->bindParam(':id', $car_id);

    if ($stmt->execute()) {
        echo "<script>alert('Car updated successfully!'); window.location.href='show-cars.php';</script>";
        exit;
    }
}

/* ======================
   DELETE CAR
====================== */
if (isset($_POST['delete'])) {

    if (!empty($car['image'])) {
        $image_path = 'uploads/cars/' . $car['image'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }

    $stmt = $pdo->prepare("DELETE FROM cars WHERE id = :id");
    $stmt->bindParam(':id', $car_id);
    $stmt->execute();

    echo "<script>alert('Car deleted successfully!'); window.location.href='show-cars.php';</script>";
    exit;
}
?>

<style>
    /* Edit Bike Specific Styles */
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 1200px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .btn-submit {
        display: inline-block;
        width: 200px;
        background: #FF6B00 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-submit:hover {
        background: #E55A00 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-delete {
        display: inline-block;
        width: 200px;
        background: #dc3545 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-delete:hover {
        background: #c82333 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-cancel {
        display: inline-block;
        width: 200px;
        background: #6c757d !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-cancel:hover {
        background: #5a6268 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .image-preview-container {
        margin-top: 15px;
        text-align: center;
    }

    .current-image {
        max-width: 300px;
        max-height: 200px;
        border-radius: 10px;
        border: 2px solid #ddd;
        margin: 0 auto 10px;
    }

    .no-image {
        width: 300px;
        height: 200px;
        border-radius: 10px;
        border: 2px dashed #ddd;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #666;
        font-style: italic;
        margin: 0 auto 10px;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: 18px;
        height: 18px;
        margin: 0;
    }

    .checkbox-group label {
        margin: 0;
        font-weight: normal;
        color: #666;
    }

    .button-group {
        display: flex;
        justify-content: center;
        gap: 20px;
        flex-wrap: wrap;
        margin-top: 30px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-delete, .btn-cancel {
            width: 100%;
            margin: 10px 0;
        }
        .button-group {
            flex-direction: column;
            gap: 10px;
        }
    }

    @media (max-width: 480px) {
        .current-image, .no-image {
            max-width: 100%;
            height: auto;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Edit Car</h2>

        <form method="post" enctype="multipart/form-data" onsubmit="return validateForm()">

            <input type="hidden" name="car_id" value="<?php echo $car['id']; ?>">

            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Car Name *</label>
                        <input type="text" name="car_name" value="<?php echo htmlspecialchars($car['car_name']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Price (₹) *</label>
                        <input type="text" name="price" value="<?php echo htmlspecialchars($car['price']); ?>" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Category Tags *</label>
                        <input type="text" name="category_tags" value="<?php echo htmlspecialchars($car['category_tags']); ?>" required>
                    </div>
                </div>
            </div>
            
            <!-- Section 2: Image -->
            <div class="form-section">
                <div class="section-title">Car Image</div>
                
                <!-- Current Image Display -->
                <div class="form-group">
                    <label>Current Image</label>
                    <div class="image-preview-container">
                        <?php if (!empty($car['image'])): ?>
                            <img src="uploads/cars/<?php echo htmlspecialchars($car['image']); ?>" 
                                 class="current-image" 
                                 alt="Current Car Image"
                                 onerror="this.style.display='none'; document.getElementById('no-image').style.display='flex';">
                            <div id="no-image" class="no-image" style="display: none;">
                                <i class="fas fa-image"></i> Image not found
                            </div>
                        <?php else: ?>
                            <div class="no-image">
                                <i class="fas fa-image"></i> No image uploaded
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Remove Image Checkbox -->
                    <?php if (!empty($car['image'])): ?>
                    <div class="checkbox-group">
                        <input type="checkbox" name="remove_image" id="remove_image" value="1">
                        <label for="remove_image">Remove current image</label>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- New Image Upload -->
                <div class="form-group">
                    <label>Upload New Image (Optional)</label>
                    <div class="file-input-wrapper">
                        <input type="file" name="image" id="image" accept="image/*" onchange="previewNewImage(this)">
                        <div class="file-custom">
                            <i class="fas fa-cloud-upload-alt"></i> Choose New Image
                        </div>
                    </div>
                    <small>Preferred size: 800x600px, max 2MB</small>
                    
                    <div class="image-preview-container">
                        <img id="new-image-preview" class="current-image" src="" alt="New Image Preview" style="display: none;">
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Description -->
            <div class="form-section">
                <div class="section-title">Car Description</div>
                
                <div class="form-group">
                    <label>Short Description *</label>
                    <textarea name="short_description" rows="4" placeholder="Brief description (max 80 words)" required maxlength="400"><?php echo htmlspecialchars($car['short_description']); ?></textarea>
                    <small>Maximum 80 words (approximately 400 characters)</small>
                </div>
            </div>
            
            <!-- Button Group -->
            <div class="button-group">
                <button type="submit" name="update" class="btn-submit">
                    <i class="fas fa-save"></i> Update Car
                </button>
                
                <a href="show-cars.php" class="btn-cancel">
                    <i class="fas fa-times"></i> Cancel
                </a>
                
                <button type="submit" name="delete" class="btn-delete" onclick="return confirmDelete()">
                    <i class="fas fa-trash"></i> Delete Car
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Preview new image function
function previewNewImage(input) {
    var preview = document.getElementById('new-image-preview');
    var removeCheckbox = document.getElementById('remove_image');
    
    if (input.files && input.files[0]) {
        var file = input.files[0];
        
        // Check file size
        if (file.size > 2 * 1024 * 1024) {
            alert('Image size should be less than 2MB');
            input.value = '';
            return;
        }
        
        var reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
            
            // Uncheck remove image checkbox if new image is selected
            if (removeCheckbox) {
                removeCheckbox.checked = false;
            }
        }
        
        reader.readAsDataURL(file);
    } else {
        preview.style.display = 'none';
        preview.src = '';
    }
}

// Form validation
function validateForm() {
    var carName = document.querySelector('input[name="car_name"]').value;
    var price = document.querySelector('input[name="price"]').value;
    var categoryTags = document.querySelector('input[name="category_tags"]').value;
    var shortDesc = document.querySelector('textarea[name="short_description"]').value;
    var newImage = document.querySelector('input[name="image"]').files[0];
    
    // Validate required fields
    if (!carName.trim()) {
        alert("Please enter car name");
        return false;
    }
    
    if (!price.trim()) {
        alert("Please enter price");
        return false;
    }
    
    if (!categoryTags.trim()) {
        alert("Please enter category tags");
        return false;
    }
    
    if (!shortDesc.trim()) {
        alert("Please enter short description");
        return false;
    }
    
    // Check word count for description (max 80 words)
    var wordCount = shortDesc.trim().split(/\s+/).length;
    if (wordCount > 80) {
        alert("Short description should be maximum 80 words");
        return false;
    }
    
    // Check file size if new image is uploaded
    if (newImage && newImage.size > 2 * 1024 * 1024) {
        alert("Car image size should be less than 2MB");
        return false;
    }
    
    return true;
}

// Delete confirmation
function confirmDelete() {
    return confirm("Are you sure you want to delete this car?");
}
</script>

<?php include('footer.php'); ?>
