<?php
include('header.php');
include('db.php');

// Get blog ID from URL
$blog_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch blog data
$blog = null;
if ($blog_id > 0) {
    $stmt = $pdo->prepare("SELECT * FROM blogs WHERE id = :id");
    $stmt->bindParam(':id', $blog_id, PDO::PARAM_INT);
    $stmt->execute();
    $blog = $stmt->fetch(PDO::FETCH_ASSOC);
}

// If blog not found, redirect
if (!$blog) {
    echo "<script>alert('Blog not found!'); window.location.href='show-blogs.php';</script>";
    exit;
}

// Handle form submission for update
if (isset($_POST['update'])) {
    $blog_name = trim($_POST['blog_name']);
    $publish_date = $_POST['publish_date'];
    $author_name = trim($_POST['author_name']);
    $category = trim($_POST['category']);
    $short_description = trim($_POST['short_description']);
    $description = trim($_POST['description']);
    
    // Check if new image is uploaded
    $image = $blog['image']; // Keep old image by default
    
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $uploadDir = 'uploads/blogs/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        // Delete old image if exists
        if (!empty($blog['image'])) {
            $old_image_path = 'uploads/blogs/' . $blog['image'];
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }
        
        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $image = $fileName;
            }
        }
    }
    
    // Check if remove image checkbox is checked
    if (isset($_POST['remove_image']) && $_POST['remove_image'] == 1) {
        // Delete current image file
        if (!empty($image)) {
            $image_path = 'uploads/blogs/' . $image;
            if (file_exists($image_path)) {
                unlink($image_path);
            }
            $image = ''; // Set to empty
        }
    }
    
    // Update database
    $sql = "UPDATE blogs SET 
            blog_name = :blog_name,
            publish_date = :publish_date,
            author_name = :author_name,
            category = :category,
            short_description = :short_description,
            description = :description,
            image = :image,
            updated_at = NOW()
            WHERE id = :id";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':blog_name', $blog_name, PDO::PARAM_STR);
        $stmt->bindParam(':publish_date', $publish_date, PDO::PARAM_STR);
        $stmt->bindParam(':author_name', $author_name, PDO::PARAM_STR);
        $stmt->bindParam(':category', $category, PDO::PARAM_STR);
        $stmt->bindParam(':short_description', $short_description, PDO::PARAM_STR);
        $stmt->bindParam(':description', $description, PDO::PARAM_STR);
        $stmt->bindParam(':image', $image, PDO::PARAM_STR);
        $stmt->bindParam(':id', $blog_id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            echo "<script>alert('Blog updated successfully!'); window.location.href='show-blogs.php';</script>";
            exit;
        } else {
            echo "<script>alert('Failed to update blog. Please try again.');</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
    }
}

// Handle delete (separate from update)
if (isset($_POST['delete'])) {
    // Delete image file first
    if (!empty($blog['image'])) {
        $image_path = 'uploads/blogs/' . $blog['image'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }
    
    // Delete from database
    $stmt = $pdo->prepare("DELETE FROM blogs WHERE id = :id");
    $stmt->bindParam(':id', $blog_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo "<script>alert('Blog deleted successfully!'); window.location.href='show-blogs.php';</script>";
        exit;
    } else {
        echo "<script>alert('Failed to delete blog.');</script>";
    }
}
?>

<!-- External CSS -->
<link rel="stylesheet" href="assets/dist/css/style.css">

<style>
    /* Edit Blog Specific Styles */
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 1200px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .btn-submit {
        display: inline-block;
        width: 200px;
        background: #FF6B00 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-submit:hover {
        background: #E55A00 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-delete {
        display: inline-block;
        width: 200px;
        background: #dc3545 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-delete:hover {
        background: #c82333 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-cancel {
        display: inline-block;
        width: 200px;
        background: #6c757d !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-cancel:hover {
        background: #5a6268 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .image-preview-container {
        margin-top: 15px;
        text-align: center;
    }

    .current-image {
        max-width: 300px;
        max-height: 200px;
        border-radius: 10px;
        border: 2px solid #ddd;
        margin: 0 auto 10px;
    }

    .no-image {
        width: 300px;
        height: 200px;
        border-radius: 10px;
        border: 2px dashed #ddd;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #666;
        font-style: italic;
        margin: 0 auto 10px;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: 18px;
        height: 18px;
        margin: 0;
    }

    .checkbox-group label {
        margin: 0;
        font-weight: normal;
        color: #666;
    }

    .button-group {
        display: flex;
        justify-content: center;
        gap: 20px;
        flex-wrap: wrap;
        margin-top: 30px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-delete, .btn-cancel {
            width: 100%;
            margin: 10px 0;
        }
        .button-group {
            flex-direction: column;
            gap: 10px;
        }
    }

    @media (max-width: 480px) {
        .current-image, .no-image {
            max-width: 100%;
            height: auto;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Edit Blog Post</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Hidden ID field -->
            <input type="hidden" name="blog_id" value="<?php echo $blog['id']; ?>">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Blog Name *</label>
                        <input type="text" name="blog_name" 
                               value="<?php echo htmlspecialchars($blog['blog_name']); ?>" 
                               placeholder="Enter Blog Name" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Publish Date *</label>
                        <input type="date" name="publish_date" 
                               value="<?php echo htmlspecialchars($blog['publish_date']); ?>" 
                               required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Author Name *</label>
                        <input type="text" name="author_name" 
                               value="<?php echo htmlspecialchars($blog['author_name']); ?>" 
                               placeholder="Enter Author Name" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Category *</label>
                        <select name="category" required>
                            <option value="">Select Category</option>
                            <option value="Travel" <?php echo ($blog['category'] == 'Travel') ? 'selected' : ''; ?>>Travel</option>
                            <option value="Adventure" <?php echo ($blog['category'] == 'Adventure') ? 'selected' : ''; ?>>Adventure</option>
                            <option value="Beaches" <?php echo ($blog['category'] == 'Beaches') ? 'selected' : ''; ?>>Beaches</option>
                            <option value="Food" <?php echo ($blog['category'] == 'Food') ? 'selected' : ''; ?>>Food</option>
                            <option value="Culture" <?php echo ($blog['category'] == 'Culture') ? 'selected' : ''; ?>>Culture</option>
                            <option value="Events" <?php echo ($blog['category'] == 'Events') ? 'selected' : ''; ?>>Events</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- Section 2: Image -->
            <div class="form-section">
                <div class="section-title">Blog Image</div>
                
                <!-- Current Image Display -->
                <div class="form-group">
                    <label>Current Image</label>
                    <div class="image-preview-container">
                        <?php if (!empty($blog['image'])): ?>
                            <img src="uploads/blogs/<?php echo htmlspecialchars($blog['image']); ?>" 
                                 class="current-image" 
                                 alt="Current Blog Image"
                                 onerror="this.style.display='none'; document.getElementById('no-image').style.display='flex';">
                            <div id="no-image" class="no-image" style="display: none;">
                                <i class="fas fa-image"></i> Image not found
                            </div>
                        <?php else: ?>
                            <div class="no-image">
                                <i class="fas fa-image"></i> No image uploaded
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Remove Image Checkbox -->
                    <?php if (!empty($blog['image'])): ?>
                    <div class="checkbox-group">
                        <input type="checkbox" name="remove_image" id="remove_image" value="1">
                        <label for="remove_image">Remove current image</label>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- New Image Upload -->
                <div class="form-group">
                    <label>Upload New Image (Optional)</label>
                    <div class="file-input-wrapper">
                        <input type="file" name="image" id="image" accept="image/*" onchange="previewNewImage(this)">
                        <div class="file-custom">
                            <i class="fas fa-cloud-upload-alt"></i> Choose New Image
                        </div>
                    </div>
                    <small>Preferred size: 1200x630px, max 2MB</small>
                    
                    <div class="image-preview-container">
                        <img id="new-image-preview" class="current-image" src="" alt="New Image Preview" style="display: none;">
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Content -->
            <div class="form-section">
                <div class="section-title">Blog Content</div>
                
                <div class="form-group">
                    <label>Short Description *</label>
                    <textarea name="short_description" rows="3" placeholder="Brief summary (max 200 characters)" required maxlength="200"><?php echo htmlspecialchars($blog['short_description']); ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>Full Description *</label>
                    <textarea name="description" rows="8" placeholder="Write your blog content here..." required><?php echo htmlspecialchars($blog['description']); ?></textarea>
                </div>
            </div>
            
            <!-- Button Group -->
            <div class="button-group">
                <button type="submit" name="update" class="btn-submit">
                    <i class="fas fa-save"></i> Update Blog
                </button>
                
                <a href="show-blogs.php" class="btn-cancel">
                    <i class="fas fa-times"></i> Cancel
                </a>
                
                <button type="submit" name="delete" class="btn-delete" onclick="return confirmDelete()">
                    <i class="fas fa-trash"></i> Delete Blog
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Set date format for display
document.addEventListener('DOMContentLoaded', function() {
    // Format date if needed
    var dateInput = document.querySelector('input[name="publish_date"]');
    if (dateInput.value) {
        // Convert date to YYYY-MM-DD format if needed
        var date = new Date(dateInput.value);
        if (!isNaN(date.getTime())) {
            dateInput.value = date.toISOString().split('T')[0];
        }
    }
});

// Preview new image function
function previewNewImage(input) {
    var preview = document.getElementById('new-image-preview');
    var removeCheckbox = document.getElementById('remove_image');
    
    if (input.files && input.files[0]) {
        var file = input.files[0];
        
        // Check file size
        if (file.size > 2 * 1024 * 1024) {
            alert('Image size should be less than 2MB');
            input.value = '';
            return;
        }
        
        var reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
            
            // Uncheck remove image checkbox if new image is selected
            if (removeCheckbox) {
                removeCheckbox.checked = false;
            }
        }
        
        reader.readAsDataURL(file);
    } else {
        preview.style.display = 'none';
        preview.src = '';
    }
}

// Form validation
function validateForm() {
    var blogName = document.querySelector('input[name="blog_name"]').value;
    var publishDate = document.querySelector('input[name="publish_date"]').value;
    var authorName = document.querySelector('input[name="author_name"]').value;
    var category = document.querySelector('select[name="category"]').value;
    var shortDesc = document.querySelector('textarea[name="short_description"]').value;
    var description = document.querySelector('textarea[name="description"]').value;
    var newImage = document.querySelector('input[name="image"]').files[0];
    
    // Validate required fields
    if (!blogName.trim()) {
        alert("Please enter blog name");
        return false;
    }
    
    if (!publishDate) {
        alert("Please select a publish date");
        return false;
    }
    
    if (!authorName.trim()) {
        alert("Please enter author name");
        return false;
    }
    
    if (!category) {
        alert("Please select category");
        return false;
    }
    
    if (!shortDesc.trim()) {
        alert("Please enter short description");
        return false;
    }
    
    if (!description.trim()) {
        alert("Please enter blog description");
        return false;
    }
    
    // Check file size if new image is uploaded
    if (newImage && newImage.size > 2 * 1024 * 1024) {
        alert("Blog image size should be less than 2MB");
        return false;
    }
    
    return true;
}

// Delete confirmation
function confirmDelete() {
    return confirm("Are you sure you want to delete this blog !!");
}
</script>

<?php include('footer.php'); ?>