<?php
session_start();
include('db.php'); // sirf db.php include karo

// Check if delete ID is provided
if (isset($_GET['delete_id'])) {
    $car_id = (int)$_GET['delete_id'];
    
    // Fetch car data to get image name
    $stmt = $pdo->prepare("SELECT * FROM cars WHERE id = :id");
    $stmt->bindParam(':id', $car_id, PDO::PARAM_INT);
    $stmt->execute();
    $car = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($car) {
        // Delete image file if exists
        if (!empty($car['image'])) {
            $image_path = 'uploads/cars/' . $car['image'];
            if (file_exists($image_path)) {
                unlink($image_path);
            }
        }
        
        // Delete from database
        $stmt = $pdo->prepare("DELETE FROM cars WHERE id = :id");
        $stmt->bindParam(':id', $car_id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            $_SESSION['success'] = "Car deleted successfully!";
        } else {
            $_SESSION['error'] = "Failed to delete car.";
        }
    } else {
        $_SESSION['error'] = "Car not found.";
    }
}

// Always redirect back to show-cars.php
header("Location: show-cars.php");
exit;
?>