<?php
// delete-blog.php
session_start();
include('db.php');

// Check if delete_id is provided
if (!isset($_GET['delete_id'])) {
    $_SESSION['error'] = "No blog selected for deletion.";
    header("Location: show-blogs.php");
    exit;
}

$delete_id = (int)$_GET['delete_id'];

// Verify blog exists
$stmt = $pdo->prepare("SELECT * FROM blogs WHERE id = :id");
$stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
$stmt->execute();
$blog = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$blog) {
    $_SESSION['error'] = "Blog not found.";
    header("Location: show-blogs.php");
    exit;
}

// Delete image file if exists
if (!empty($blog['image'])) {
    $image_path = 'uploads/blogs/' . $blog['image'];
    if (file_exists($image_path)) {
        unlink($image_path);
    } 
}

// Delete from database
$stmt = $pdo->prepare("DELETE FROM blogs WHERE id = :id");
$stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);

if ($stmt->execute()) {
    $_SESSION['success'] = "Blog deleted successfully!";
} else {
    $_SESSION['error'] = "Failed to delete blog.";
}

// Redirect back to show-blogs.php
header("Location: show-blogs.php");
exit;
?>