<?php
session_start();
include('db.php'); // sirf db.php include karo, header.php nahi

// Check if delete ID is provided
if (isset($_GET['delete_id'])) {
    $bike_id = (int)$_GET['delete_id'];
    
    // Fetch bike data to get image name
    $stmt = $pdo->prepare("SELECT * FROM bikes WHERE id = :id");
    $stmt->bindParam(':id', $bike_id, PDO::PARAM_INT);
    $stmt->execute();
    $bike = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($bike) {
        // Delete image file if exists
        if (!empty($bike['image'])) {
            $image_path = 'uploads/bikes/' . $bike['image'];
            if (file_exists($image_path)) {
                unlink($image_path);
            }
        }
        
        // Delete from database
        $stmt = $pdo->prepare("DELETE FROM bikes WHERE id = :id");
        $stmt->bindParam(':id', $bike_id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            $_SESSION['success'] = "Bike deleted successfully!";
        } else {
            $_SESSION['error'] = "Failed to delete bike.";
        }
    } else {
        $_SESSION['error'] = "Bike not found.";
    }
}

// Always redirect back to show-bikes.php
header("Location: show-bikes.php");
exit;
?>