<?php 
include('header.php');
include('db.php');
?>

<!-- External CSS in style.css -->
<link rel="stylesheet" href="assets/dist/css/style.css">

<style>
    /* Add Tour Packages page specific styles */
    .content-wrapper {
        padding: 20px;
        min-height: calc(100vh - 60px);
    }
    
    .form-container, .table-container {
        max-width: 900px;
        margin: 0 auto 30px;
        background: white;
        border-radius: 8px;
        padding: 30px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    h2 {
        color: #333;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 2px solid #FF6B00 ;
        font-weight: 600;
    }
    
    .form-section {
        margin-bottom: 25px;
        padding: 20px;
        background: #f9f9f9;
        border-radius: 6px;
        border-left: 3px solid #FF6B00 ;
    }
    
    .section-title {
        font-size: 16px;
        color: #333;
        margin-bottom: 20px;
        font-weight: 600;
        padding-bottom: 8px;
        border-bottom: 1px solid #eee;
    }
    
    .form-row {
        display: grid;
        grid-template-columns: 1fr;
        gap: 20px;
        margin-bottom: 15px;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: #555;
        font-weight: 500;
        font-size: 14px;
    }
    
    .form-group input[type="text"] {
        width: 100%;
        padding: 12px 15px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 14px;
        transition: border 0.3s;
    }
    
    .form-group input[type="text"]:focus {
        border-color: #4a90e2;
        outline: none;
        box-shadow: 0 0 0 2px rgba(74, 144, 226, 0.2);
    }
    
    .btn-submit {
        background: #4a90e2; 
        color: white;
        border: none;
        padding: 12px 30px;
        border-radius: 5px;
        font-size: 14px;
        cursor: pointer;
        transition: background 0.3s;
        font-weight: 500;
    }
    
    .btn-submit:hover {
        background: #3a80d2;
    }
    
    /* Table Styles */
    .table-container h2 {
        margin-top: 0;
    }
    
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    
    th {
        background: #f8f9fa;
        padding: 14px;
        text-align: left;
        color: #555;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 2px solid #dee2e6;
    }
    
    td {
        padding: 14px;
        border-bottom: 1px solid #eee;
        color: #666;
        font-size: 14px;
    }
    
    tr:hover {
        background: #f9f9f9;
    }
    
    .action-buttons {
        display: flex;
        gap: 8px;
    }
    
    .btn-edit, .btn-delete {
        background: #f8f9fa;
        border: 1px solid #e0e0e0;
        border-radius: 4px;
        color: #555;
        padding: 8px 12px;
        cursor: pointer;
        transition: all 0.3s;
        font-size: 13px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }
    
    .btn-edit:hover {
        background: #4a90e2;
        border-color: #4a90e2;
        color: white;
    }
    
    .btn-delete:hover {
        background: #dc3545;
        border-color: #dc3545;
        color: white;
    }
    
    /* Modal Styles */
    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    }
    
    .modal-header {
        background: #f8f9fa;
        border-bottom: 1px solid #eee;
        border-radius: 8px 8px 0 0;
        padding: 15px 20px;
    }
    
    .modal-title {
        color: #333;
        font-weight: 600;
        font-size: 16px;
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .modal-footer {
        border-top: 1px solid #eee;
        padding: 15px 20px;
        background: #f8f9fa;
        border-radius: 0 0 8px 8px;
    }
    
    .modal-footer .btn-default {
        background: #6c757d;
        border-color: #6c757d;
        color: white;
    }
    
    .modal-footer .btn-primary {
        background: #4a90e2;
        border-color: #4a90e2;
    }
    
    .modal-footer .btn-primary:hover {
        background: #3a80d2;
        border-color: #3a80d2;
    }
    
    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: #777;
    }
    
    .empty-state i {
        font-size: 48px;
        margin-bottom: 15px;
        color: #ccc;
    }
    
    @media (max-width: 768px) {
        .content-wrapper {
            padding: 15px;
        }
        
        .form-container, .table-container {
            padding: 20px;
        }
        
        .action-buttons {
            flex-direction: column;
            gap: 5px;
        }
        
        .btn-edit, .btn-delete {
            width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add Tour Package</h2>
        <form method="post" action="">
            
            <!-- Section 1: Package Information -->
            <div class="form-section">
                <div class="section-title">Package Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Package Name *</label>
                        <input type="text" name="package_name" placeholder="Enter package name" required>
                    </div>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add Package</button>
        </form>
    </div>

<?php
if (isset($_POST['submit'])) {
    $package_name = trim($_POST['package_name']);
    if (!empty($package_name)) {

        $sql = "INSERT INTO tour_packages (package_name) VALUES (:package_name)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':package_name', $package_name, PDO::PARAM_STR);

        if ($stmt->execute()) {
            echo "<script>alert('Package Added Successfully'); window.location.href='add-package.php';</script>";
        } else {
            echo "<script>alert('Failed to add package');</script>";
        }
    } else {
        echo "<script>alert('Package name cannot be empty');</script>";
    }
}
?>

    <div class="table-container">
        <h2>Package List</h2>
        <?php
        $sql = "SELECT id, package_name, created_at FROM tour_packages ORDER BY id DESC";
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $packages = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if (empty($packages)): ?>
            <div class="empty-state">
                <i class="fas fa-box-open"></i>
                <h4>No packages added yet</h4>
                <p>Add your first package using the form above</p>
            </div>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Package Name</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead> 
                <tbody> 
                    <?php foreach ($packages as $index => $package): ?>
                        <tr>
                            <td><?php echo $index + 1; ?></td>
                            <td><?php echo htmlspecialchars($package['package_name']); ?></td>
                            <td><?php echo date('d M Y', strtotime($package['created_at'])); ?></td>
                            <td>
                                <div class="action-buttons">
                                    <button type="button" class="btn-edit" data-toggle="modal" data-target="#editModal<?php echo $package['id']; ?>">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <a href="delete-package.php?id=<?php echo $package['id']; ?>" class="btn-delete" onclick="return confirm('Are you sure?')">
                                        <i class="fas fa-trash"></i> Delete
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<!-- Edit Modals -->
<?php foreach ($packages as $package): ?>
<div class="modal fade" id="editModal<?php echo $package['id']; ?>" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document"> 
        <div class="modal-content">
            <div class="modal-header"> 
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Package</h4>
            </div>
            <div class="modal-body">
                <form method="post" action="update-package.php?id=<?php echo $package['id']; ?>">
                    <div class="form-group">
                        <label>Package Name</label>
                        <input type="text" name="package_name" class="form-control" value="<?php echo htmlspecialchars($package['package_name']); ?>" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" name="update" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div> 
</div>
<?php endforeach; ?>

<script>
// Basic form validation
document.querySelector('form').addEventListener('submit', function(e) {
    var packageName = document.querySelector('input[name="package_name"]').value;
    if (!packageName.trim()) {
        alert('Please enter package name');
        e.preventDefault();
        return false;
    }
    return true;
});
</script>

<?php include('footer.php'); ?>