<?php
// add-tour-package-details.php
include('header.php');
include('db.php');

// Handle form submission
if (isset($_POST['submit'])) {
    // Basic Info
    $package_id = $_POST['package_id'];
    $tagline = trim($_POST['tagline']);
    $duration = trim($_POST['duration']);
    $location = trim($_POST['location']);
    $url_slug = trim($_POST['url_slug']);
    
    // Check if URL slug already exists
    $check_sql = "SELECT id FROM tour_package_details WHERE url_slug = ?";
    $check_stmt = $pdo->prepare($check_sql);
    $check_stmt->execute([$url_slug]);
    
    if ($check_stmt->fetch()) {
        // If slug exists, add number to make it unique
        $counter = 1;
        $original_slug = $url_slug;
        
        while (true) {
            $new_slug = $original_slug . '-' . $counter;
            $check_stmt->execute([$new_slug]);
            if (!$check_stmt->fetch()) {
                $url_slug = $new_slug;
                break;
            }
            $counter++;
        }
    }
    
    // Pricing
    $original_price = $_POST['original_price'];
    $discounted_price = $_POST['discounted_price'];
    $price_per_person = $_POST['price_per_person'];
    
    // Status
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $featured = isset($_POST['featured']) ? 1 : 0;
    
    // Process Overview Items
    $overview_items = [];
    if (isset($_POST['overview_title'])) {
        for ($i = 0; $i < count($_POST['overview_title']); $i++) {
            $title = trim($_POST['overview_title'][$i]);
            if (!empty($title)) {
                $overview_items[] = [
                    'title' => $title,
                    'description' => $_POST['overview_description'][$i] ?? ''
                ];
            }
        }
    }
    
    // Process Activities
    $activities = [];
    if (isset($_POST['activity_name'])) {
        for ($i = 0; $i < count($_POST['activity_name']); $i++) {
            $name = trim($_POST['activity_name'][$i]);
            if (!empty($name)) {
                $activity = [
                    'name' => $name,
                    'description' => $_POST['activity_description'][$i] ?? ''
                ];
                
                // Handle activity image
                if (!empty($_FILES['activity_images']['name'][$i])) {
                    $uploadDir = 'uploads/tours/activities/';
                    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
                    
                    $fileName = uniqid() . '_' . basename($_FILES['activity_images']['name'][$i]);
                    $targetPath = $uploadDir . $fileName;
                    
                    if (move_uploaded_file($_FILES['activity_images']['tmp_name'][$i], $targetPath)) {
                        $activity['image'] = $targetPath;
                    }
                }
                
                $activities[] = $activity;
            }
        }
    }
    
    // Process Highlights, Inclusions, Exclusions
    $highlights = array_filter(array_map('trim', $_POST['highlight'] ?? []));
    $inclusions = array_filter(array_map('trim', $_POST['inclusion'] ?? []));
    $exclusions = array_filter(array_map('trim', $_POST['exclusion'] ?? []));
    
    // Upload slider images
    $slider_images = [];
    if (!empty($_FILES['slider_images']['name'][0])) {
        $uploadDir = 'uploads/tours/slider/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
        
        foreach ($_FILES['slider_images']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['slider_images']['error'][$key] === 0) {
                $file_type = mime_content_type($tmp_name);
                $allowed = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
                
                if (in_array($file_type, $allowed) && $_FILES['slider_images']['size'][$key] <= 2 * 1024 * 1024) {
                    $fileName = uniqid() . '_' . basename($_FILES['slider_images']['name'][$key]);
                    $targetPath = $uploadDir . $fileName;
                    
                    if (move_uploaded_file($tmp_name, $targetPath)) {
                        $slider_images[] = $targetPath;
                    }
                }
            }
        }
    }
    
    // Convert to JSON
    $slider_json = json_encode($slider_images);
    $overview_json = json_encode($overview_items);
    $activities_json = json_encode($activities);
    $highlights_json = json_encode($highlights);
    $inclusions_json = json_encode($inclusions);
    $exclusions_json = json_encode($exclusions);
    
    // Insert into database
    $sql = "INSERT INTO tour_package_details 
            (package_id, tagline, duration, location, url_slug, 
             original_price, discounted_price, price_per_person,
             is_active, featured, 
             slider_images, overview_items, activities, highlights, inclusions, exclusions) 
            VALUES 
            (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $package_id, $tagline, $duration, $location, $url_slug,
            $original_price, $discounted_price, $price_per_person,
            $is_active, $featured,
            $slider_json, $overview_json, $activities_json, $highlights_json, $inclusions_json, $exclusions_json
        ]);
        
        echo "<script>
            alert('Package details added successfully!');
            window.location.href = 'add-package-details.php';
        </script>";
    } catch (PDOException $e) {
        echo "<script>alert('Error: " . addslashes($e->getMessage()) . "');</script>";
    }
}
?>

<!-- External CSS in style.css -->
<link rel="stylesheet" href="assets/dist/css/style.css">

<style>
    /* EXACT SAME CSS AS YOUR ORIGINAL CODE */
    .content-wrapper {
        padding: 20px;
        min-height: calc(100vh - 60px);
    }
    
    .form-container, .table-container {
        max-width: 900px;
        margin: 0 auto 30px;
        background: white;
        border-radius: 8px;
        padding: 30px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    h2 {
        color: #333;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 2px solid #FF6B00;
        font-weight: 600;
    }
    
    .form-section {
        margin-bottom: 25px;
        padding: 20px;
        background: #f9f9f9;
        border-radius: 6px;
        border-left: 3px solid #FF6B00;
    }
    
    .section-title {
        font-size: 16px;
        color: #333;
        margin-bottom: 20px;
        font-weight: 600;
        padding-bottom: 8px;
        border-bottom: 1px solid #eee;
    }
    
    .form-row {
        display: grid;
        grid-template-columns: 1fr;
        gap: 20px;
        margin-bottom: 15px;
    }
    
    @media (min-width: 768px) {
        .form-row {
            grid-template-columns: 1fr 1fr;
        }
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: #555;
        font-weight: 500;
        font-size: 14px;
    }
    
    .form-group input[type="text"],
    .form-group input[type="number"],
    .form-group select,
    .form-group textarea {
        width: 100%;
        padding: 12px 15px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 14px;
        transition: border 0.3s;
    }
    
    .form-group input[type="text"]:focus,
    .form-group input[type="number"]:focus,
    .form-group select:focus,
    .form-group textarea:focus {
        border-color: #4a90e2;
        outline: none;
        box-shadow: 0 0 0 2px rgba(74, 144, 226, 0.2);
    }
    
    .btn-submit {
        background: #4a90e2;
        color: white;
        border: none;
        padding: 12px 30px;
        border-radius: 5px;
        font-size: 14px;
        cursor: pointer;
        transition: background 0.3s;
        font-weight: 500;
    }
    
    .btn-submit:hover {
        background: #3a80d2;
    }
    
    /* Dynamic Items Styling */
    .btn-add-more {
        background: #4CAF50;
        color: white;
        border: none;
        padding: 10px 15px;
        border-radius: 4px;
        cursor: pointer;
        margin-top: 10px;
        font-size: 14px;
    }
    
    .btn-add-more:hover {
        background: #45a049;
    }
    
    .dynamic-item {
        background: white;
        padding: 15px;
        margin-bottom: 15px;
        border-radius: 5px;
        border: 1px solid #eee;
    }
    
    .item-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }
    
    .item-handle {
        color: #666;
        cursor: move;
    }
    
    .btn-remove {
        background: #f44336;
        color: white;
        border: none;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .btn-remove:hover {
        background: #d32f2f;
    }
    
    .checkbox-wrapper {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .checkbox-wrapper input[type="checkbox"] {
        width: 18px;
        height: 18px;
    }
    
    .checkbox-wrapper label {
        margin: 0;
        cursor: pointer;
    }
    
    /* Image Upload Styling - COL-12 */
    .image-upload-section {
        width: 100%;
    }
    
    .file-input-wrapper {
        position: relative;
        margin-bottom: 10px;
        width: 100%;
    }
    
    .file-input-wrapper input[type="file"] {
        position: absolute;
        left: 0;
        top: 0;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    
    .file-custom {
        padding: 12px;
        border: 2px dashed #ddd;
        border-radius: 5px;
        text-align: center;
        color: #666;
        background: #f9f9f9;
        cursor: pointer;
        width: 100%;
        display: block;
    }
    
    .file-custom i {
        margin-right: 8px;
    }
    
    /* Slider Images Preview - Full width columns */
    .slider-preview-row {
        display: grid;
        grid-template-columns: 1fr;
        gap: 15px;
        margin-top: 15px;
        width: 100%;
    }
    
    @media (min-width: 768px) {
        .slider-preview-row {
            grid-template-columns: repeat(2, 1fr);
        }
    }
    
    @media (min-width: 992px) {
        .slider-preview-row {
            grid-template-columns: repeat(3, 1fr);
        }
    }
    
    @media (min-width: 1200px) {
        .slider-preview-row {
            grid-template-columns: repeat(4, 1fr);
        }
    }
    
    .image-preview-wrapper {
        position: relative;
        border: 1px solid #eee;
        border-radius: 5px;
        overflow: hidden;
        background: #f9f9f9;
        margin-bottom: 15px;
        width: 100%;
    }
    
    .image-preview {
        width: 100%;
        height: 150px;
        object-fit: cover;
        display: block;
    }
    
    .remove-image {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(255, 0, 0, 0.8);
        color: white;
        border: none;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        cursor: pointer;
        font-size: 14px;
        line-height: 1;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .remove-image:hover {
        background: rgba(255, 0, 0, 1);
    }
    
    .file-name {
        padding: 8px;
        font-size: 12px;
        background: #f5f5f5;
        text-align: center;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        width: 100%;
    }
    
    /* Activity Image Preview */
    .activity-image-preview {
        margin-top: 10px;
        width: 100%;
    }
    
    .activity-image-wrapper {
        position: relative;
        width: 100%;
        max-width: 200px;
        margin-top: 10px;
    }
    
    .activity-preview {
        width: 100%;
        height: 120px;
        object-fit: cover;
        border-radius: 5px;
        border: 1px solid #ddd;
    }
    
    .remove-activity-image {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(255, 0, 0, 0.8);
        color: white;
        border: none;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        cursor: pointer;
        font-size: 12px;
        line-height: 1;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    @media (max-width: 768px) {
        .content-wrapper {
            padding: 15px;
        }
        
        .form-container, .table-container {
            padding: 20px;
        }
        
        .slider-preview-row {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add Tour Package Details</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Section 1: Package Selection -->
            <div class="form-section">
                <div class="section-title">Package Selection</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Select Package *</label>
                        <select name="package_id" required>
                            <option value="">-- Select Package --</option>
                            <?php
                            $sql = "SELECT id, package_name FROM tour_packages ORDER BY package_name";
                            $stmt = $pdo->prepare($sql);
                            $stmt->execute();
                            while($package = $stmt->fetch()) {
                                echo '<option value="'.$package['id'].'">'.$package['package_name'].'</option>';
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>URL Slug *</label>
                        <input type="text" name="url_slug" placeholder="nirvana-dinner-cruise-goa" required>
                        <small style="color: #666;">Use lowercase with hyphens. If duplicate, auto-number will be added.</small>
                    </div>
                </div>
            </div>
            
            <!-- Section 2: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Tagline</label>
                        <input type="text" name="tagline" placeholder="Premium River Cruise Experience">
                    </div>
                    
                    <div class="form-group">
                        <label>Duration *</label>
                        <input type="text" name="duration" placeholder="3 Hours" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Location *</label>
                        <input type="text" name="location" placeholder="Mondovi River, Goa" required>
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Slider Images -->
            <div class="form-section">
                <div class="section-title">Slider Images</div>
                
                <div class="form-group image-upload-section">
                    <label>Upload Images</label>
                    <div class="file-input-wrapper">
                        <input type="file" name="slider_images[]" id="slider_images" accept="image/*" multiple onchange="previewSliderImages(this)">
                        <div class="file-custom">
                            <i class="fas fa-cloud-upload-alt"></i> Choose Multiple Images
                        </div>
                    </div>
                    
                    <div class="slider-preview-row" id="slider-preview-container">
                        <!-- Image previews will appear here -->
                    </div>
                </div>
            </div>
            
            <!-- Section 4: Overview (Dynamic) -->
            <div class="form-section">
                <div class="section-title">Overview Section</div>
                
                <div id="overview-container">
                    <!-- Dynamic overview items will be added here -->
                </div>
                
                <button type="button" class="btn-add-more" onclick="addOverviewItem()">
                    <i class="fas fa-plus"></i> Add Overview Point
                </button>
            </div>
            
            <!-- Section 5: Activities (Dynamic) -->
            <div class="form-section">
                <div class="section-title">Activities</div>
                
                <div id="activities-container">
                    <!-- Dynamic activities will be added here -->
                </div>
                
                <button type="button" class="btn-add-more" onclick="addActivity()">
                    <i class="fas fa-plus"></i> Add Activity
                </button>
            </div>
            
            <!-- Section 6: Pricing -->
            <div class="form-section">
                <div class="section-title">Pricing Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Original Price (₹) *</label>
                        <input type="number" name="original_price" placeholder="1999" step="0.01" min="0" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Discounted Price (₹) *</label>
                        <input type="number" name="discounted_price" placeholder="1499" step="0.01" min="0" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Price is per person?</label>
                        <select name="price_per_person" class="form-control">
                            <option value="yes">Yes, price is per person</option>
                            <option value="no">No, price is for package</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- Section 7: Highlights (Dynamic) -->
            <div class="form-section">
                <div class="section-title">Package Highlights</div>
                
                <div id="highlights-container">
                    <!-- Dynamic highlights will be added here -->
                </div>
                
                <button type="button" class="btn-add-more" onclick="addHighlight()">
                    <i class="fas fa-plus"></i> Add Highlight
                </button>
            </div>
            
            <!-- Section 8: Inclusions & Exclusions -->
            <div class="form-section">
                <div class="section-title">What's Included & Excluded</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Inclusions</label>
                        <div id="inclusions-container">
                            <!-- Dynamic inclusions will be added here -->
                        </div>
                        <button type="button" class="btn-add-more" onclick="addInclusion()" style="margin-top: 10px;">
                            <i class="fas fa-plus"></i> Add Inclusion
                        </button>
                    </div>
                    
                    <div class="form-group">
                        <label>Exclusions</label>
                        <div id="exclusions-container">
                            <!-- Dynamic exclusions will be added here -->
                        </div>
                        <button type="button" class="btn-add-more" onclick="addExclusion()" style="margin-top: 10px;">
                            <i class="fas fa-plus"></i> Add Exclusion
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Section 9: Status -->
            <div class="form-section">
                <div class="section-title">Package Status</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <div class="checkbox-wrapper">
                            <input type="checkbox" name="is_active" id="is_active" checked>
                            <label for="is_active">Active (Visible on website)</label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="checkbox-wrapper">
                            <input type="checkbox" name="featured" id="featured">
                            <label for="featured">Featured Package</label>
                        </div>
                    </div>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add Tour Package</button>
        </form>
    </div>
</div>

<!-- Templates for Dynamic Items -->
<template id="overview-item-template">
    <div class="dynamic-item">
        <div class="item-header">
            <span class="item-handle"><i class="fas fa-bars"></i></span>
            <button type="button" class="btn-remove" onclick="removeItem(this, 'overview')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label>Title *</label>
                <input type="text" name="overview_title[]" placeholder="3 Hours Cruising" required>
            </div>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="overview_description[]" rows="2" placeholder="Enjoy a relaxing river cruise" style="width: 100%;"></textarea>
        </div>
    </div>
</template>

<template id="activity-template">
    <div class="dynamic-item">
        <div class="item-header">
            <span class="item-handle"><i class="fas fa-bars"></i></span>
            <button type="button" class="btn-remove" onclick="removeItem(this, 'activity')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label>Activity Name *</label>
                <input type="text" name="activity_name[]" placeholder="Bollywood DJ Music" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group image-upload-section">
                <label>Upload Image (Optional)</label>
                <div class="file-input-wrapper">
                    <input type="file" name="activity_images[]" accept="image/*" class="activity-image-input" onchange="previewActivityImage(this)">
                    <div class="file-custom">
                        <i class="fas fa-cloud-upload-alt"></i> Choose Image
                    </div>
                </div>
                <div class="activity-image-preview"></div>
            </div>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="activity_description[]" rows="2" placeholder="Live Bollywood music and entertainment" style="width: 100%;"></textarea>
        </div>
    </div>
</template>

<template id="highlight-template">
    <div class="dynamic-item">
        <div class="item-header">
            <span class="item-handle"><i class="fas fa-bars"></i></span>
            <button type="button" class="btn-remove" onclick="removeItem(this, 'highlight')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="form-group">
            <label>Highlight *</label>
            <input type="text" name="highlight[]" placeholder="Buffet Dinner Included" required style="width: 100%;">
        </div>
    </div>
</template>

<template id="inclusion-template">
    <div class="dynamic-item">
        <div class="item-header">
            <span class="item-handle"><i class="fas fa-bars"></i></span>
            <button type="button" class="btn-remove" onclick="removeItem(this, 'inclusion')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="form-group">
            <label>Inclusion *</label>
            <input type="text" name="inclusion[]" placeholder="Pick-up & Drop from Hotel" required style="width: 100%;">
        </div>
    </div>
</template>

<template id="exclusion-template">
    <div class="dynamic-item">
        <div class="item-header">
            <span class="item-handle"><i class="fas fa-bars"></i></span>
            <button type="button" class="btn-remove" onclick="removeItem(this, 'exclusion')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="form-group">
            <label>Exclusion *</label>
            <input type="text" name="exclusion[]" placeholder="Professional Photographer" required style="width: 100%;">
        </div>
    </div>
</template>

<script>
// Initialize counters
let overviewCount = 0;
let activityCount = 0;
let highlightCount = 0;
let inclusionCount = 0;
let exclusionCount = 0;

// Add Overview Item
function addOverviewItem() {
    const template = document.getElementById('overview-item-template');
    const clone = template.content.cloneNode(true);
    document.getElementById('overview-container').appendChild(clone);
    overviewCount++;
}

// Add Activity
function addActivity() {
    const template = document.getElementById('activity-template');
    const clone = template.content.cloneNode(true);
    document.getElementById('activities-container').appendChild(clone);
    activityCount++;
}

// Add Highlight
function addHighlight() {
    const template = document.getElementById('highlight-template');
    const clone = template.content.cloneNode(true);
    document.getElementById('highlights-container').appendChild(clone);
    highlightCount++;
}

// Add Inclusion
function addInclusion() {
    const template = document.getElementById('inclusion-template');
    const clone = template.content.cloneNode(true);
    document.getElementById('inclusions-container').appendChild(clone);
    inclusionCount++;
}

// Add Exclusion
function addExclusion() {
    const template = document.getElementById('exclusion-template');
    const clone = template.content.cloneNode(true);
    document.getElementById('exclusions-container').appendChild(clone);
    exclusionCount++;
}

// Remove Item
function removeItem(element, type) {
    element.closest('.dynamic-item').remove();
}

// Preview slider images in grid
function previewSliderImages(input) {
    const container = document.getElementById('slider-preview-container');
    container.innerHTML = '';
    
    if (input.files && input.files.length > 0) {
        for (let i = 0; i < input.files.length; i++) {
            const file = input.files[i];
            
            // Check file size
            if (file.size > 2 * 1024 * 1024) {
                alert(`Image "${file.name}" is too large. Max size is 2MB.`);
                input.value = '';
                container.innerHTML = '';
                return;
            }
            
            const reader = new FileReader();
            
            reader.onload = function(e) {
                const wrapper = document.createElement('div');
                wrapper.className = 'image-preview-wrapper';
                
                const img = document.createElement('img');
                img.className = 'image-preview';
                img.src = e.target.result;
                img.alt = file.name;
                
                const fileName = document.createElement('div');
                fileName.className = 'file-name';
                fileName.textContent = file.name.length > 20 ? 
                    file.name.substring(0, 20) + '...' : file.name;
                
                const removeBtn = document.createElement('button');
                removeBtn.type = 'button';
                removeBtn.className = 'remove-image';
                removeBtn.innerHTML = '×';
                removeBtn.title = 'Remove image';
                removeBtn.onclick = function() {
                    removeSliderImage(i, input);
                };
                
                wrapper.appendChild(img);
                wrapper.appendChild(fileName);
                wrapper.appendChild(removeBtn);
                container.appendChild(wrapper);
            };
            
            reader.readAsDataURL(file);
        }
    }
}

// Remove slider image from preview and file input
function removeSliderImage(index, input) {
    const dt = new DataTransfer();
    const files = input.files;
    
    for (let i = 0; i < files.length; i++) {
        if (i !== index) {
            dt.items.add(files[i]);
        }
    }
    
    input.files = dt.files;
    previewSliderImages(input);
}

// Preview activity image
function previewActivityImage(input) {
    const previewContainer = input.closest('.image-upload-section').querySelector('.activity-image-preview');
    previewContainer.innerHTML = '';
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        // Check file size
        if (file.size > 2 * 1024 * 1024) {
            alert(`Image "${file.name}" is too large. Max size is 2MB.`);
            input.value = '';
            return;
        }
        
        const reader = new FileReader();
        
        reader.onload = function(e) {
            const wrapper = document.createElement('div');
            wrapper.className = 'activity-image-wrapper';
            
            const img = document.createElement('img');
            img.className = 'activity-preview';
            img.src = e.target.result;
            img.alt = file.name;
            
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'remove-activity-image';
            removeBtn.innerHTML = '×';
            removeBtn.title = 'Remove image';
            removeBtn.onclick = function() {
                previewContainer.innerHTML = '';
                input.value = '';
            };
            
            wrapper.appendChild(img);
            wrapper.appendChild(removeBtn);
            previewContainer.appendChild(wrapper);
        };
        
        reader.readAsDataURL(file);
    }
}

// Form Validation
function validateForm() {
    const packageId = document.querySelector('select[name="package_id"]').value;
    const urlSlug = document.querySelector('input[name="url_slug"]').value;
    const duration = document.querySelector('input[name="duration"]').value;
    const location = document.querySelector('input[name="location"]').value;
    const originalPrice = document.querySelector('input[name="original_price"]').value;
    const discountedPrice = document.querySelector('input[name="discounted_price"]').value;
    
    if (!packageId) {
        alert("Please select a package");
        return false;
    }
    
    if (!urlSlug.trim()) {
        alert("Please enter URL slug");
        return false;
    }
    
    if (!duration.trim()) {
        alert("Please enter duration");
        return false;
    }
    
    if (!location.trim()) {
        alert("Please enter location");
        return false;
    }
    
    if (!originalPrice) {
        alert("Please enter original price");
        return false;
    }
    
    if (!discountedPrice) {
        alert("Please enter discounted price");
        return false;
    }
    
    return true;
}

// Add initial items on page load
window.addEventListener('load', function() {
    addOverviewItem();
    addActivity();
    addHighlight();
    addInclusion();
    addExclusion();
});
</script>

<?php include('footer.php'); ?>