<?php
include('header.php');
include('db.php');

// Handle blog submission
if (isset($_POST['submit'])) {
    $blog_name = trim($_POST['blog_name']);
    $publish_date = trim($_POST['publish_date']);
    $author_name = trim($_POST['author_name']);
    $category = trim($_POST['category']);
    $short_description = trim($_POST['short_description']);
    $description = trim($_POST['description']);
    
    // File upload for blog images
    $image = '';
    if (!empty($_FILES['image']['name'])) {
        $uploadDir = 'uploads/blogs/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        // Validate file
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $image = $fileName;
            }
        }
    }
    
    // Insert into database
    $sql = "INSERT INTO blogs (blog_name, publish_date, author_name, category, short_description, description, image, created_at) 
            VALUES (:blog_name, :publish_date, :author_name, :category, :short_description, :description, :image, NOW())";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':blog_name', $blog_name, PDO::PARAM_STR);
        $stmt->bindParam(':publish_date', $publish_date, PDO::PARAM_STR);
        $stmt->bindParam(':author_name', $author_name, PDO::PARAM_STR);
        $stmt->bindParam(':category', $category, PDO::PARAM_STR);
        $stmt->bindParam(':short_description', $short_description, PDO::PARAM_STR);
        $stmt->bindParam(':description', $description, PDO::PARAM_STR);
        $stmt->bindParam(':image', $image, PDO::PARAM_STR);
        
        if ($stmt->execute()) {
            echo "<script>alert('Blog added successfully!'); window.location.href='add-blogs.php';</script>";
        } else {
            echo "<script>alert('Failed to add blog. Please try again.');</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
    }
} 
?>

<!-- External CSS in style.css -->
<link rel="stylesheet" href="assets/dist/css/style.css">

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add New Blog</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Blog Name/Title *</label>
                        <input type="text" name="blog_name" placeholder="e.g., 10 Best Places to Visit in Goa" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Publish Date *</label>
                        <input type="date" name="publish_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Author Name *</label>
                        <input type="text" name="author_name" placeholder="e.g., John Doe" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Category *</label>
                        <select name="category" required>
                            <option value="">Select Category</option>
                            <option value="Travel">Travel</option>
                            <option value="Adventure">Adventure</option>
                            <option value="Beaches">Beaches</option>
                            <option value="Food">Food</option>
                            <option value="Culture">Culture</option>
                            <option value="Events">Events</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- Section 2: Image -->
            <div class="form-section">
                <div class="section-title">Blog Image</div>
                
                <div class="form-group">
                    <label>Upload Featured Image *</label>
                    <div class="file-input-wrapper">
                        <input type="file" name="image" id="image" accept="image/*" onchange="previewImage(this)">
                        <div class="file-custom">
                            <i class="fas fa-cloud-upload-alt"></i> Choose Image
                        </div>
                    </div>
                    <small>Upload one main image. Preferred size: 1200x630px, max 2MB</small>
                    
                    <div class="image-preview-container" id="image-preview-container">
                        <!-- Single image preview will be added here -->
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Content -->
            <div class="form-section">
                <div class="section-title">Blog Content</div>
                
                <div class="form-group">
                    <label>Short Description *</label>
                    <textarea name="short_description" rows="3" placeholder="Brief summary (max 200 characters)" required maxlength="200"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Full Description *</label>
                    <textarea name="description" rows="8" placeholder="Write your blog content here..." required></textarea>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add Blog</button>
        </form>
    </div>
</div>

<script>
// Single image preview function
function previewImage(input) {
    var previewContainer = document.getElementById('image-preview-container');
    previewContainer.innerHTML = '';
    
    if (input.files && input.files[0]) {
        var file = input.files[0];
        
        // Check file size
        if (file.size > 2 * 1024 * 1024) {
            alert('Image size should be less than 2MB');
            input.value = '';
            return;
        }
        
        var reader = new FileReader();
        
        reader.onload = function(e) {
            var wrapper = document.createElement('div');
            wrapper.className = 'image-preview-wrapper';
            
            var img = document.createElement('img');
            img.className = 'image-preview';
            img.src = e.target.result;
            img.style.display = 'block';
            
            var removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'remove-image';
            removeBtn.innerHTML = '×';
            removeBtn.style.display = 'block';
            removeBtn.onclick = function() {
                removeImage();
            };
            
            wrapper.appendChild(img);
            wrapper.appendChild(removeBtn);
            previewContainer.appendChild(wrapper);
        };
        
        reader.readAsDataURL(file);
    }
}

// Remove image from preview
function removeImage() {
    var input = document.getElementById('image');
    input.value = '';
    document.getElementById('image-preview-container').innerHTML = '';
}

function validateForm() {
    // Check required fields
    var blogName = document.querySelector('input[name="blog_name"]').value;
    var publishDate = document.querySelector('input[name="publish_date"]').value;
    var authorName = document.querySelector('input[name="author_name"]').value;
    var category = document.querySelector('select[name="category"]').value;
    var shortDesc = document.querySelector('textarea[name="short_description"]').value;
    var description = document.querySelector('textarea[name="description"]').value;
    var image = document.querySelector('input[name="image"]').files;
    
    if (!blogName.trim()) {
        alert("Please enter blog name");
        return false;
    }
    
    if (!publishDate) {
        alert("Please select publish date");
        return false;
    }
    
    if (!authorName.trim()) {
        alert("Please enter author name");
        return false;
    }
    
    if (!category) {
        alert("Please select category");
        return false;
    }
    
    if (!shortDesc.trim()) {
        alert("Please enter short description");
        return false;
    }
    
    if (!description.trim()) {
        alert("Please enter blog description");
        return false;
    }
    
    // Check image
    if (image.length === 0) {
        alert("Please upload blog image");
        return false;
    }
    
    // Check file size
    if (image[0].size > 2 * 1024 * 1024) {
        alert("Image size should be less than 2MB");
        return false;
    }
    
    return true;
}
</script>

<?php include('footer.php'); ?>