<?php
include('header.php');
include('db.php');

// Handle bike submission
if (isset($_POST['submit'])) {
    $category_tags = trim($_POST['category_tags']);
    $bike_name = trim($_POST['bike_name']);
    $short_description = trim($_POST['short_description']);
    $price = trim($_POST['price']);
    
    // File upload for bike images
    $image = '';
    if (!empty($_FILES['image']['name'])) {
        $uploadDir = 'uploads/bikes/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        // Validate file
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $image = $fileName;
            }
        }
    }
    
    // Insert into database
    $sql = "INSERT INTO bikes (image, category_tags, bike_name, short_description, price, created_at) 
            VALUES (:image, :category_tags, :bike_name, :short_description, :price, NOW())";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':image', $image, PDO::PARAM_STR);
        $stmt->bindParam(':category_tags', $category_tags, PDO::PARAM_STR);
        $stmt->bindParam(':bike_name', $bike_name, PDO::PARAM_STR);
        $stmt->bindParam(':short_description', $short_description, PDO::PARAM_STR);
        $stmt->bindParam(':price', $price, PDO::PARAM_STR);
        
        if ($stmt->execute()) {
            echo "<script>alert('Bike added successfully!'); window.location.href='add-bike.php';</script>";
        } else {
            echo "<script>alert('Failed to add bike. Please try again.');</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
    }
}
?>

<!-- External CSS in style.css -->
<link rel="stylesheet" href="assets/dist/css/style.css">

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add New Bike</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Bike Name/Model *</label>
                        <input type="text" name="bike_name" placeholder="e.g., Royal Enfield Bullet 350" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Price (₹) *</label>
                        <input type="text" name="price" placeholder="e.g., 1,50,000" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Category Tags *</label>
                        <input type="text" name="category_tags" placeholder="e.g., Manual | 350cc | Cruiser" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Upload Bike Image *</label>
                        <div class="file-input-wrapper">
                            <input type="file" name="image" id="image" accept="image/*" onchange="previewImage(this)">
                            <div class="file-custom">
                                <i class="fas fa-cloud-upload-alt"></i> Choose Image
                            </div>
                        </div>
                        <small>Upload one bike image. Preferred size: 800x600px, max 2MB</small>
                        
                        <div class="image-preview-container" id="image-preview-container">
                            <!-- Single image preview will be added here -->
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Section 2: Description -->
            <div class="form-section">
                <div class="section-title">Bike Description</div>
                
                <div class="form-group">
                    <label>Short Description *</label>
                    <textarea name="short_description" rows="4" placeholder="Brief description (max 80 words)" required maxlength="400"></textarea>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add Bike</button>
        </form>
    </div>
</div>

<script>
// Single image preview function
function previewImage(input) {
    var previewContainer = document.getElementById('image-preview-container');
    previewContainer.innerHTML = '';
    
    if (input.files && input.files[0]) {
        var file = input.files[0];
        
        // Check file size
        if (file.size > 2 * 1024 * 1024) {
            alert('Image size should be less than 2MB');
            input.value = '';
            return;
        }
        
        var reader = new FileReader();
        
        reader.onload = function(e) {
            var wrapper = document.createElement('div');
            wrapper.className = 'image-preview-wrapper';
            
            var img = document.createElement('img');
            img.className = 'image-preview';
            img.src = e.target.result;
            img.style.display = 'block';
            
            var removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'remove-image';
            removeBtn.innerHTML = '×';
            removeBtn.style.display = 'block';
            removeBtn.onclick = function() {
                removeImage();
            };
            
            wrapper.appendChild(img);
            wrapper.appendChild(removeBtn);
            previewContainer.appendChild(wrapper);
        };
        
        reader.readAsDataURL(file);
    }
}

// Remove image from preview
function removeImage() {
    var input = document.getElementById('image');
    input.value = '';
    document.getElementById('image-preview-container').innerHTML = '';
}

function validateForm() {
    // Check required fields
    var bikeName = document.querySelector('input[name="bike_name"]').value;
    var price = document.querySelector('input[name="price"]').value;
    var categoryTags = document.querySelector('input[name="category_tags"]').value;
    var shortDesc = document.querySelector('textarea[name="short_description"]').value;
    var image = document.querySelector('input[name="image"]').files;
    
    if (!bikeName.trim()) {
        alert("Please enter bike name");
        return false;
    }
    
    if (!price.trim()) {
        alert("Please enter price");
        return false;
    }
    
    if (!categoryTags.trim()) {
        alert("Please enter category tags");
        return false;
    }
    
    if (!shortDesc.trim()) {
        alert("Please enter short description");
        return false;
    }
    
    // Check word count for description (max 80 words)
    var wordCount = shortDesc.trim().split(/\s+/).length;
    if (wordCount > 80) {
        alert("Short description should be maximum 80 words");
        return false;
    } 
    
    // Check image
    if (image.length === 0) {
        alert("Please upload bike image");
        return false;
    }
    
    // Check file size
    if (image[0].size > 2 * 1024 * 1024) {
        alert("Image size should be less than 2MB");
        return false;
    }
    
    return true;
}
</script>

<?php include('footer.php'); ?>