<?php 
include('header.php');
include('db.php'); 

// Handle delete
if (isset($_GET['delete_id'])) {
    $delete_id = (int)$_GET['delete_id'];
    
    // First get image paths to delete files
    $stmt = $pdo->prepare("SELECT main_image, other_images FROM tobacco_products WHERE id = :id");
    $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
    $stmt->execute();
    $product = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($product) {
        // Delete main image file
        if (!empty($product['main_image'])) {
            $main_image_path = 'uploads/products/' . $product['main_image'];
            if (file_exists($main_image_path)) {
                unlink($main_image_path);
            }
        }
        
        // Delete other images files
        if (!empty($product['other_images'])) {
            $other_images = json_decode($product['other_images'], true);
            if (is_array($other_images)) {
                foreach ($other_images as $image) {
                    $image_path = 'uploads/products/other/' . $image;
                    if (file_exists($image_path)) {
                        unlink($image_path);
                    }
                }
            }
        }
    }
    
    // Delete from database
    $stmt = $pdo->prepare("DELETE FROM tobacco_products WHERE id = :id");
    $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo "<script>alert('Product deleted successfully!'); window.location.href='show-tobacco-products.php';</script>";
        exit;
    } else {
        echo "<script>alert('Failed to delete product');</script>";
    }
}

// Fetch all tobacco products
$sql = "SELECT * FROM tobacco_products ORDER BY id DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .table-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        color: #000 !important;
        overflow-x: auto;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .table-scroll {
        width: 100%;
        overflow-x: auto;
        border-radius: 10px;
    }

    table {
        width: 100%;
        min-width: 1500px;
        border-collapse: collapse;
        color: #000 !important;
        background: #fff !important;
    }

    th, td {
        padding: 16px;
        text-align: left;
        border-bottom: 1px solid #ddd !important;
        color: #000 !important;
        font-size: 14px;
        background: #fff !important;
        vertical-align: middle;
        white-space: nowrap;
    }

    th {
        color: #000 !important;
        font-weight: 700;
        text-transform: uppercase;
        background: #f8f9fa !important;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    tr{
        padding:10px auto;
        background: #fff !important;
    }
    tr:hover {
        background: rgba(0, 0, 0, 0.05) !important;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    .btn-edit, .btn-delete {
        background: #273B92 !important;
        border: 1px solid #273B92 !important;
        border-radius: 8px;
        color: #fff !important;
        padding: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 16px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border: none;
    }

    .btn-edit:hover {
        background: #000 !important;
        border-color: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
    }

    .btn-delete:hover {
        background: #000 !important;
        border-color: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
    }

    .product-image {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
    }

    .image-count {
        display: inline-block;
        background: #273B92;
        color: white;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        line-height: 20px;
        text-align: center;
        font-size: 11px;
        margin-left: 5px;
        vertical-align: middle;
    }

    .empty-message {
        text-align: center;
        padding: 40px;
        color: #666;
        font-style: italic;
        min-width: 100%;
    }

    .btn-add {
        display: inline-block;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .btn-add:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
        text-decoration: none;
    }

    /* Sticky first column for actions */
    td:first-child, th:first-child {
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    th:first-child {
        z-index: 15;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px;
        }
        .table-container {
            padding: 20px;
        }
        table {
            min-width: 1700px;
        }
        .action-buttons {
            gap: 8px;
        }
        .btn-edit, .btn-delete {
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
    }
</style>

<div class="content-wrapper">
    <div class="table-container">
        <h2>Tobacco Products List</h2>
        
        <div style="margin-bottom: 20px;">
            <a href="add-tobacco-product.php" class="btn-add">
                <i class="fas fa-plus-circle"></i> Add New Tobacco Product
            </a>
        </div>

        <?php if (empty($products)): ?>
            <div class="empty-message">No tobacco products found. Add your first product above.</div>
        <?php else: ?>
        
        <div class="table-scroll">
            <table>
                <thead>
                    <tr>
                        <th>Actions</th>
                        <th>#</th>
                        <th>Image</th>
                        <th>Product Name</th>
                        <th>Product Grade</th>
                        <th>Description</th>
                        <th>Grade</th>
                        <th>Color</th>
                        <th>Texture</th>
                        <th>Moisture Content</th>
                        <th>Nicotine Content</th>
                        <th>Sugar Content</th>
                        <th>Leaf Length</th>
                        <th>Leaf Width</th>
                        <th>Stem Content</th>
                        <th>Aroma</th>
                        <th>Burning Quality</th>
                        <th>MOQ</th>
                        <th>HS Code</th>
                        <th>Created Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $index => $product): 
                        // Count other images
                        $other_images_count = 0;
                        if (!empty($product['other_images'])) {
                            $other_images = json_decode($product['other_images'], true);
                            if (is_array($other_images)) {
                                $other_images_count = count($other_images);
                            }
                        }
                        
                        // Shorten description for table view
                        $short_description = '';
                        if (!empty($product['product_description'])) {
                            $short_description = strlen($product['product_description']) > 50 
                                ? substr($product['product_description'], 0, 50) . '...' 
                                : $product['product_description'];
                        }
                    ?>
                    <tr>
                        <td>
                            <div class="action-buttons">
                                <!-- Edit button -->
                                <a href="edit-tobacco-product.php?id=<?php echo $product['id']; ?>" class="btn-edit" title="Edit Product">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <!-- Delete button with confirmation -->
                                <a href="?delete_id=<?php echo $product['id']; ?>" class="btn-delete" 
                                   onclick="return confirmDelete()" title="Delete Product">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </td>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <?php if (!empty($product['main_image'])): ?>
                                <img src="uploads/products/<?php echo htmlspecialchars($product['main_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($product['product_name']); ?>" 
                                     class="product-image"
                                     onerror="this.src='https://via.placeholder.com/60?text=No+Image'">
                                <?php if ($other_images_count > 0): ?>
                                    <span class="image-count">+<?php echo $other_images_count; ?></span>
                                <?php endif; ?>
                            <?php else: ?>
                                <img src="https://via.placeholder.com/60?text=No+Image" 
                                     class="product-image"
                                     alt="No Image">
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($product['product_name']); ?></td>
                        <td><?php echo htmlspecialchars($product['product_grade']); ?></td>
                        <td title="<?php echo htmlspecialchars($product['product_description']); ?>">
                            <?php echo htmlspecialchars($short_description); ?>
                        </td>
                        <td><?php echo htmlspecialchars($product['grade']); ?></td>
                        <td><?php echo htmlspecialchars($product['color']); ?></td>
                        <td><?php echo htmlspecialchars($product['texture']); ?></td>
                        <td><?php echo htmlspecialchars($product['moisture_content']); ?></td>
                        <td><?php echo htmlspecialchars($product['nicotine_content']); ?></td>
                        <td><?php echo htmlspecialchars($product['sugar_content']); ?></td>
                        <td><?php echo htmlspecialchars($product['leaf_length']); ?></td>
                        <td><?php echo htmlspecialchars($product['leaf_width']); ?></td>
                        <td><?php echo htmlspecialchars($product['stem_content']); ?></td>
                        <td><?php echo htmlspecialchars($product['aroma']); ?></td>
                        <td><?php echo htmlspecialchars($product['burning_quality']); ?></td>
                        <td><?php echo htmlspecialchars($product['moq']); ?></td>
                        <td><?php echo htmlspecialchars($product['hs_code']); ?></td>
                        <td>
                            <?php 
                            if (!empty($product['created_at'])) {
                                echo date('d/m/Y', strtotime($product['created_at']));
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <?php endif; ?>
    </div>
</div>

<script>
function confirmDelete() {
    return confirm("Are you sure you want to delete this tobacco product?");
}
</script>

<?php include('footer.php'); ?>