<?php 
include('header.php');
include('db.php'); 

// Handle delete
if (isset($_GET['delete_id'])) {
    $delete_id = (int)$_GET['delete_id'];
    
    // First get image path to delete file
    $stmt = $pdo->prepare("SELECT image_path FROM gallery_images WHERE id = :id");
    $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
    $stmt->execute();
    $gallery = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($gallery && !empty($gallery['image_path'])) {
        $image_path = 'uploads/gallery/' . $gallery['image_path'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }
    
    // Delete from database
    $stmt = $pdo->prepare("DELETE FROM gallery_images WHERE id = :id");
    $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo "<script>alert('Image deleted successfully!'); window.location.href='show-gallery.php';</script>";
        exit;
    } else {
        echo "<script>alert('Failed to delete image');</script>";
    }
}

// Fetch all gallery images
$sql = "SELECT * FROM gallery_images ORDER BY upload_date DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$gallery = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .table-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        color: #000 !important;
        overflow-x: auto;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .table-scroll {
        width: 100%;
        overflow-x: auto;
        border-radius: 10px;
    }

    table {
        width: 100%;
        min-width: 1000px;
        border-collapse: collapse;
        color: #000 !important;
        background: #fff !important;
    }

    th, td {
        padding: 16px;
        text-align: left;
        border-bottom: 1px solid #ddd !important;
        color: #000 !important;
        font-size: 14px;
        background: #fff !important;
        vertical-align: middle;
        white-space: nowrap;
    }

    th {
        color: #000 !important;
        font-weight: 700;
        text-transform: uppercase;
        background: #f8f9fa !important;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    tr{
        padding:10px auto;
        background: #fff !important;
    }
    tr:hover {
        background: rgba(0, 0, 0, 0.05) !important;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    .btn-edit, .btn-delete, .btn-view {
        background: #273B92 !important;
        border: 1px solid #273B92 !important;
        border-radius: 8px;
        color: #fff !important;
        padding: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 16px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border: none;
    }

    .btn-edit:hover, .btn-delete:hover, .btn-view:hover {
        background: #000 !important;
        border-color: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
    }

    .gallery-image {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
        cursor: pointer;
        transition: transform 0.3s;
    }

    .gallery-image:hover {
        transform: scale(1.1);
    }

    .empty-message {
        text-align: center;
        padding: 40px;
        color: #666;
        font-style: italic;
        min-width: 100%;
        font-size: 18px;
    }

    .btn-add {
        display: inline-block;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .btn-add:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
        text-decoration: none;
    }

    /* Sticky first column for actions */
    td:first-child, th:first-child {
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    th:first-child {
        z-index: 15;
    }

    .date-column {
        min-width: 120px;
    }

    .image-preview-modal .modal-dialog {
        max-width: 800px;
    }

    .modal-image {
        width: 100%;
        max-height: 500px;
        object-fit: contain;
        border-radius: 10px;
    }

    .modal-image-name {
        font-size: 20px;
        font-weight: 600;
        margin-top: 15px;
        color: #273B92;
    }

    .modal-image-details {
        color: #666;
        font-size: 14px;
    }

    .total-count {
        background: #273B92;
        color: white;
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 16px;
        margin-left: 10px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px;
        }
        .table-container {
            padding: 20px;
        }
        table {
            min-width: 800px;
        }
        .action-buttons {
            gap: 8px;
        }
        .btn-edit, .btn-delete, .btn-view {
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
        .gallery-image {
            width: 60px;
            height: 60px;
        }
        .empty-message {
            font-size: 16px;
            padding: 30px 20px;
        }
    }
</style>

<div class="content-wrapper">
    <div class="table-container">
        <h2>Gallery Images <span class="total-count"><?php echo count($gallery); ?></span></h2>
        
        <a href="add-gallery.php" class="btn-add">
            <i class="fas fa-plus-circle"></i> Add New Image
        </a>

        <?php if (empty($gallery)): ?>
            <div class="empty-message">
                <i class="fas fa-images" style="font-size: 50px; margin-bottom: 20px; color: #ddd;"></i><br>
                No gallery images found. Add your first image above.
            </div>
        <?php else: ?>
        
        <div class="table-scroll">
            <table>
                <thead>
                    <tr>
                        <th>Actions</th>
                        <th>#</th>
                        <th>Image</th>
                        <th>Image Name</th>
                        <th class="date-column">Upload Date</th>
                        <th>File Name</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($gallery as $index => $image): 
                        // Format date
                        $date_formatted = '';
                        if (!empty($image['upload_date'])) {
                            $date_formatted = date('d/m/Y h:i A', strtotime($image['upload_date']));
                        }
                    ?>
                    <tr>
                        <td>
                            <div class="action-buttons">
                                
                                
                                <!-- Edit button - goes to edit page -->
                                <a href="edit-gallery.php?id=<?php echo $image['id']; ?>" class="btn-edit" title="Edit Image">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <!-- Delete button with confirmation -->
                                <a href="?delete_id=<?php echo $image['id']; ?>" class="btn-delete" 
                                   onclick="return confirmDelete('<?php echo htmlspecialchars(addslashes($image['image_name'])); ?>')" title="Delete Image">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </td>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <img src="uploads/gallery/<?php echo htmlspecialchars($image['image_path']); ?>" 
                                 alt="<?php echo htmlspecialchars($image['image_name']); ?>" 
                                 class="gallery-image"
                                 onclick="viewImage(<?php echo $image['id']; ?>, '<?php echo htmlspecialchars(addslashes($image['image_name'])); ?>', 'uploads/gallery/<?php echo htmlspecialchars($image['image_path']); ?>', '<?php echo $date_formatted; ?>')"
                                 onerror="this.src='https://via.placeholder.com/80?text=No+Image'">
                        </td>
                        <td><?php echo htmlspecialchars($image['image_name']); ?></td>
                        <td class="date-column"><?php echo $date_formatted; ?></td>
                        <td>
                            <small><?php echo htmlspecialchars($image['image_path']); ?></small>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <?php endif; ?>
    </div>
</div>

<!-- Image Preview Modal -->
<div class="modal fade image-preview-modal" id="imagePreviewModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Image Preview</h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" alt="Gallery Image" class="modal-image">
                <div id="modalImageName" class="modal-image-name"></div>
                <div id="modalImageDetails" class="modal-image-details"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <a href="#" id="modalEditBtn" class="btn btn-primary">
                    <i class="fas fa-edit"></i> Edit
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(imageName) {
    return confirm("Are you sure you want to delete ?");
}

function viewImage(id, name, imagePath, uploadDate) {
    // Set modal content
    document.getElementById('modalImage').src = imagePath;
    document.getElementById('modalImageName').textContent = name;
    document.getElementById('modalImageDetails').innerHTML = 
        'Uploaded: ' + uploadDate + '<br>ID: #' + id;
    
    // Set edit button link
    document.getElementById('modalEditBtn').href = 'edit-gallery.php?id=' + id;
    
    // Show modal
    $('#imagePreviewModal').modal('show');
    return false;
}

// Optional: Add search functionality
function searchGallery() {
    var input = document.getElementById('searchInput');
    var filter = input.value.toUpperCase();
    var table = document.querySelector('table');
    var tr = table.getElementsByTagName('tr');
    
    for (var i = 1; i < tr.length; i++) {
        var tdName = tr[i].getElementsByTagName('td')[3]; // Image Name column
        var tdFileName = tr[i].getElementsByTagName('td')[5]; // File Name column
        
        var showRow = false;
        
        if (tdName) {
            var txtValue = tdName.textContent || tdName.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdFileName) {
            var txtValue = tdFileName.textContent || tdFileName.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (showRow) {
            tr[i].style.display = '';
        } else {
            tr[i].style.display = 'none';
        }
    }
}
</script>

<?php include('footer.php'); ?>