<?php 
include('header.php');
include('db.php'); 

// Handle delete
if (isset($_GET['delete_id'])) {
    $delete_id = (int)$_GET['delete_id'];
    
    // First get image path to delete file
    $stmt = $pdo->prepare("SELECT image FROM blog_posts WHERE id = :id");
    $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
    $stmt->execute();
    $blog = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($blog && !empty($blog['image'])) {
        $image_path = 'uploads/blogs/' . $blog['image'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }
    
    // Delete from database
    $stmt = $pdo->prepare("DELETE FROM blog_posts WHERE id = :id");
    $stmt->bindParam(':id', $delete_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo "<script>alert('Blog deleted successfully!'); window.location.href='show-blogs.php';</script>";
        exit;
    } else {
        echo "<script>alert('Failed to delete blog');</script>";
    }
}

// Fetch all blogs
$sql = "SELECT * FROM blog_posts ORDER BY date DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .table-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        color: #000 !important;
        overflow-x: auto;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    .table-scroll {
        width: 100%;
        overflow-x: auto;
        border-radius: 10px;
    }

    table {
        width: 100%;
        min-width: 1200px;
        border-collapse: collapse;
        color: #000 !important;
        background: #fff !important;
    }

    th, td {
        padding: 16px;
        text-align: left;
        border-bottom: 1px solid #ddd !important;
        color: #000 !important;
        font-size: 14px;
        background: #fff !important;
        vertical-align: middle;
        white-space: nowrap;
    }

    th {
        color: #000 !important;
        font-weight: 700;
        text-transform: uppercase;
        background: #f8f9fa !important;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    tr{
        padding:10px auto;
        background: #fff !important;
    }
    tr:hover {
        background: rgba(0, 0, 0, 0.05) !important;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    .btn-edit, .btn-delete, .btn-view {
        background: #273B92 !important;
        border: 1px solid #273B92 !important;
        border-radius: 8px;
        color: #fff !important;
        padding: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 16px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border: none;
    }

    .btn-edit:hover, .btn-delete:hover, .btn-view:hover {
        background: #000 !important;
        border-color: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
    }

    .blog-image {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
    }

    .empty-message {
        text-align: center;
        padding: 40px;
        color: #666;
        font-style: italic;
        min-width: 100%;
    }

    .btn-add {
        display: inline-block;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .btn-add:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
        text-decoration: none;
    }

    /* Sticky first column for actions */
    td:first-child, th:first-child {
        position: sticky;
        left: 0;
        background: inherit;
        z-index: 5;
    }

    th:first-child {
        z-index: 15;
    }

    /* Content preview styling */
    .content-preview {
        max-width: 300px;
        white-space: normal;
        max-height: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        line-height: 1.4;
    }

    .date-column {
        min-width: 120px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px;
        }
        .table-container {
            padding: 20px;
        }
        table {
            min-width: 1400px;
        }
        .action-buttons {
            gap: 8px;
        }
        .btn-edit, .btn-delete, .btn-view {
            width: 35px;
            height: 35px;
            font-size: 14px;
        }
        .blog-image {
            width: 60px;
            height: 60px;
        }
        .content-preview {
            max-width: 200px;
        }
    }
</style>

<div class="content-wrapper">
    <div class="table-container">
        <h2>Blog Posts List</h2>
        
        <a href="add-blogs.php" class="btn-add">
            <i class="fas fa-plus-circle"></i> Add New Blog
        </a>

        <?php if (empty($blogs)): ?>
            <div class="empty-message">No blog posts found. Add your first blog above.</div>
        <?php else: ?>
        
        <div class="table-scroll">
            <table>
                <thead>
                    <tr>
                        <th>Actions</th>
                        <th>#</th>
                        <th>Image</th>
                        <th>Blog Name</th>
                        <th class="date-column">Date</th>
                        <th>Author Name</th>
                        <th>Content</th>
                        <th class="date-column">Created Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($blogs as $index => $blog): 
                        // Shorten content for table view
                        $short_content = '';
                        if (!empty($blog['content'])) {
                            // Remove HTML tags for preview
                            $plain_content = strip_tags($blog['content']);
                            $short_content = strlen($plain_content) > 150 
                                ? substr($plain_content, 0, 150) . '...' 
                                : $plain_content;
                        }
                        
                        // Format date
                        $date_formatted = '';
                        if (!empty($blog['date'])) {
                            $date_formatted = date('d/m/Y', strtotime($blog['date']));
                        }
                        
                        // Format created_at
                        $created_formatted = '';
                        if (!empty($blog['created_at'])) {
                            $created_formatted = date('d/m/Y', strtotime($blog['created_at']));
                        }
                    ?>
                    <tr>
                        <td>
                            <div class="action-buttons">
                                
                                <!-- Edit button - goes to edit page -->
                                <a href="edit-blogs.php?id=<?php echo $blog['id']; ?>" class="btn-edit" title="Edit Blog">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <!-- Delete button with confirmation -->
                                <a href="?delete_id=<?php echo $blog['id']; ?>" class="btn-delete" 
                                   onclick="return confirmDelete()" title="Delete Blog">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </td>
                        <td><?php echo $index + 1; ?></td>
                        <td>
                            <?php if (!empty($blog['image'])): ?>
                                <img src="uploads/blogs/<?php echo htmlspecialchars($blog['image']); ?>" 
                                     alt="<?php echo htmlspecialchars($blog['blog_name']); ?>" 
                                     class="blog-image"
                                     onerror="this.src='https://via.placeholder.com/80?text=No+Image'">
                            <?php else: ?>
                                <img src="https://via.placeholder.com/80?text=No+Image" 
                                     class="blog-image"
                                     alt="No Image">
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($blog['blog_name']); ?></td>
                        <td class="date-column"><?php echo $date_formatted; ?></td>
                        <td><?php echo htmlspecialchars($blog['author_name']); ?></td>
                        <td title="<?php echo htmlspecialchars(strip_tags($blog['content'])); ?>">
                            <div class="content-preview"><?php echo htmlspecialchars($short_content); ?></div>
                        </td>
                        <td class="date-column"><?php echo $created_formatted; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <?php endif; ?>
    </div>
</div>

<script>
function confirmDelete() {
    return confirm("Are you sure you want to delete this blog post?");
}

// Optional: Add search functionality
function searchBlogs() {
    var input = document.getElementById('searchInput');
    var filter = input.value.toUpperCase();
    var table = document.querySelector('table');
    var tr = table.getElementsByTagName('tr');
    
    for (var i = 1; i < tr.length; i++) {
        var tdName = tr[i].getElementsByTagName('td')[3]; // Blog Name column
        var tdAuthor = tr[i].getElementsByTagName('td')[5]; // Author Name column
        var tdContent = tr[i].getElementsByTagName('td')[6]; // Content column
        
        var showRow = false;
        
        if (tdName) {
            var txtValue = tdName.textContent || tdName.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdAuthor) {
            var txtValue = tdAuthor.textContent || tdAuthor.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (!showRow && tdContent) {
            var txtValue = tdContent.textContent || tdContent.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                showRow = true;
            }
        }
        
        if (showRow) {
            tr[i].style.display = '';
        } else {
            tr[i].style.display = 'none';
        }
    }
}
</script>

<?php include('footer.php'); ?>