<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Login - Harbour Line International</title>
    <!-- Favicon -->
    <link rel="shortcut icon" href="../images/fav-icon-logo.png" type="image/png">
    <!-- Bootstrap -->
    <link href="assets/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome -->
    <link href="assets/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    
    <style>
        :root {
            --primary-color: #273B92;
            --black: #000000;
            --white: #ffffff;
            --gray: #666666;
            --light-gray: #f0f0f0;
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: #B3E0FF ;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: var(--black);
        }

        .login-wrapper {
            width: 100%;
            max-width: 420px;
        }

        .login-container {
            background: var(--white);
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--light-gray);
        }

        /* Logo Section */
        .logo-section {
            text-align: center;
            margin-bottom: 35px;
        }

        .logo {
            width: 180px;
            height: auto;
        }

        .brand-title {
            font-size: 22px; /* Reduced font size */
            font-weight: 700;
            color: var(--black);
            margin-bottom: 6px;
            line-height: 1.2;
            max-width: 320px; /* Added max-width */
            margin-left: auto;
            margin-right: auto;
        }

        .brand-subtitle {
            font-size: 15px;
            color: var(--gray);
            font-weight: 400;
            max-width: 280px; /* Added max-width */
            margin-left: auto;
            margin-right: auto;
        }

        /* Form Elements */
        .form-group {
            margin-bottom: 22px;
        }

        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: var(--black);
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-control {
            width: 100%;
            height: 48px;
            padding: 12px 45px 12px 15px;
            font-size: 15px;
            border: 1.5px solid #ddd;
            border-radius: 6px;
            background: var(--white);
            color: var(--black);
            transition: var(--transition);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.1);
        }

        .form-control::placeholder {
            color: #999;
            font-size: 14px;
        }

        .input-wrapper {
            position: relative;
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #999;
            cursor: pointer;
            font-size: 16px;
            padding: 0;
            width: 24px;
            height: 24px;
            transition: var(--transition);
        }

        .password-toggle:hover {
            color: var(--primary-color);
        }

        .help-text {
            display: block;
            font-size: 11px;
            color: var(--gray);
            margin-top: 5px;
            line-height: 1.4;
        }

        /* Button - UPDATED as per your specifications */
        .login-btn {
            display: inline-block;
            vertical-align: middle;
            background-color: #273B92; /* Updated to #273B92 */
            color: var(--white); /* White text */
            font-size: 14px;
            font-weight: 600;
            padding: 13px 30px;
            transition: var(--transition);
            text-transform: uppercase;
            position: relative;
            overflow: hidden;
            text-align: center;
            border-radius: 100px;
            border: none;
            width: 100%;
            cursor: pointer;
            margin-top: 5px;
            letter-spacing: 0.5px;
        }

        .login-btn:hover {
            background-color: #000000; /* Black on hover */
            color: var(--white); /* White text on hover */
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        .login-btn i {
            margin-right: 8px;
        }

        /* Error Message */
        .error-message {
            background: rgba(220, 53, 69, 0.05);
            border: 1px solid rgba(220, 53, 69, 0.2);
            border-radius: 6px;
            color: #dc3545;
            padding: 12px 15px;
            margin-bottom: 20px;
            font-size: 13px;
            display: none;
            align-items: center;
        }

        .error-message.show {
            display: flex;
            animation: fadeIn 0.3s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-8px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Security Notice - UPDATED color */
        .security-notice {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid var(--light-gray);
        }

        .security-text {
            font-size: 12px;
            color: var(--primary-color); /* Updated to #273B92 */
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-weight: 500;
        }

        .security-text i {
            color: var(--primary-color); /* Updated to #273B92 */
        }

        /* Loading State */
        .btn-loading {
            position: relative;
            color: transparent !important;
        }

        .btn-loading::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: var(--white);
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to { transform: translate(-50%, -50%) rotate(360deg); }
        }

        /* Responsive */
        @media (max-width: 480px) {
            body {
                padding: 15px;
            }
            
            .login-container {
                padding: 30px 25px;
                border-radius: 10px;
            }
            
            .brand-title {
                font-size: 20px;
                max-width: 280px;
            }
            
            .logo {
                width: 160px;
            }
            
            .brand-subtitle {
                font-size: 14px;
                max-width: 250px;
            }
            
            .form-control {
                height: 46px;
                padding: 12px 40px 12px 12px;
            }
            
            .login-btn {
                padding: 12px 25px;
                font-size: 13px;
            }
        }

        @media (max-width: 360px) {
            .brand-title {
                font-size: 18px;
                max-width: 250px;
            }
            
            .brand-subtitle {
                font-size: 13px;
                max-width: 220px;
            }
            
            .logo {
                width: 140px;
            }
        }
    </style>
</head>

<body>
    <!-- Login Wrapper -->
    <div class="login-wrapper">
        <div class="login-container">
            <!-- Logo Section -->
            <div class="logo-section">
                <img src="img/main-logo.svg" alt="Harbour Line International" class="logo">
                <h1 class="brand-title">Harbour Line International</h1>
                <p class="brand-subtitle">Admin Dashboard Access</p>
            </div>

            <!-- Error Message -->
            <div class="error-message" id="errorMessage">
                <i class="fa fa-exclamation-circle me-2"></i>
                <span id="errorText">Invalid credentials. Please try again.</span>
            </div>

            <!-- Login Form -->
            <form method="post" action="admin_login.php" id="loginForm">
                <!-- Username Field -->
                <div class="form-group">
                    <label class="form-label" for="username">
                        <i class="fa fa-user me-2"></i>Username
                    </label>
                    <div class="input-wrapper">
                        <input type="text" 
                               name="username" 
                               id="username" 
                               class="form-control" 
                               placeholder="Enter administrator username" 
                               required
                               autocomplete="username">
                    </div>
                    <span class="help-text">Your unique administrator username</span>
                </div>

                <!-- Password Field -->
                <div class="form-group">
                    <label class="form-label" for="password">
                        <i class="fa fa-lock me-2"></i>Password
                    </label>
                    <div class="input-wrapper">
                        <input type="password" 
                               name="password" 
                               id="password" 
                               class="form-control" 
                               placeholder="Enter your secure password" 
                               required
                               autocomplete="current-password">
                        <button type="button" class="password-toggle" id="togglePassword">
                            <i class="fa fa-eye"></i>
                        </button>
                    </div>
                    <span class="help-text">Your secure administrator password</span>
                </div>

                <!-- Submit Button -->
                <div>
                    <button type="submit" name="submit" class="login-btn" id="loginBtn">
                        <i class="fa fa-sign-in me-2"></i>Access Dashboard
                    </button>
                </div>
            </form>

            <!-- Security Notice -->
            <div class="security-notice">
                <p class="security-text">
                    <i class="fa fa-shield"></i> Secure Admin Portal • Authorized Personnel Only
                </p>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="assets/plugins/jQuery/jquery-1.12.4.min.js" type="text/javascript"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>

    <script>
        // Password Toggle
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const icon = this.querySelector('i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.className = 'fa fa-eye-slash';
                this.setAttribute('title', 'Hide password');
            } else {
                passwordInput.type = 'password';
                icon.className = 'fa fa-eye';
                this.setAttribute('title', 'Show password');
            }
        });

        // Form Submission
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const btn = document.getElementById('loginBtn');
            const errorDiv = document.getElementById('errorMessage');
            const errorText = document.getElementById('errorText');
            
            // Get values
            const username = document.getElementById('username').value.trim();
            const password = document.getElementById('password').value.trim();
            
            // Validation
            if (!username || !password) {
                e.preventDefault();
                errorText.textContent = 'Please fill in all fields.';
                errorDiv.classList.add('show');
                return;
            }
            
            // Show loading
            btn.classList.add('btn-loading');
            btn.disabled = true;
            errorDiv.classList.remove('show');
            
            // Simulate loading (remove in production)
            setTimeout(() => {
                btn.classList.remove('btn-loading');
                btn.disabled = false;
            }, 2000);
        });

        // Auto-focus on username
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('username').focus();
            
            // Clear error on input
            const inputs = document.querySelectorAll('.form-control');
            inputs.forEach(input => {
                input.addEventListener('input', function() {
                    document.getElementById('errorMessage').classList.remove('show');
                });
            });
        });
    </script>
</body>
</html>