<?php
include('header.php');

// Include database connection
include('db.php');

// Initialize the PDO connection

    // Get the 'id' parameter from the URL
    $id = $_GET['id'];

    // Prepare the SQL query to fetch the blog details
    $sqlfetch = "SELECT * FROM tbl_blog WHERE blog_id = :id";
    $stmt = $pdo->prepare($sqlfetch);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the blog data
    $rowfetch = $stmt->fetch(PDO::FETCH_ASSOC);

?>

<body>
<!-- /.content-wrapper -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header"> 
        <div class="header-icon"><i class="fa fa-suitcase"></i></div>
        <div class="header-title">
            <h1>Update Blog Section</h1>
            <small>Show Blog Detail</small>
        </div>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- Form controls -->
            <div class="col-sm-12">
                <div class="panel panel-bd lobidrag">
                    <div class="panel-body">
                        <form class="col-sm-12" method="POST" action="update_blog.php" enctype="multipart/form-data">
                            <div class="form-group col-sm-5">
                                <label for="blog_name">Blog Name</label>
                                <div class="controls">
                                    <input type="text" class="form-control" name="blog_name" id="blog_name" placeholder="" value="<?php echo $rowfetch['blog_name']; ?>" />
                                </div>
                            </div>

                            

                            <div class="form-group col-sm-12">
                                <div class="controls col-sm-4">
                                    <label class="control-label" for="form-field-2">Select Image (Only png and jpg file) if you want to change it (Size: 1024x680 PX)</label>
                                    <input type="hidden" name="blog_img" id="blog_img" value="<?php echo $rowfetch['blog_img']; ?>" />
                                    <img src="blogs/<?php echo $rowfetch['blog_img']; ?>" style="width:200px; height:200px;">
                                    <div>
                                        <input type="file" name="imgName" id="imgName" class="form-control" />
                                    </div>
                                </div>
                            </div>

                        

                            <div class="form-group col-sm-12">
                                <label for="blog_detail">Details</label>
                                <div class="controls">
                                       <textarea class="form-control" rows="3" id="editor" name="blog_detail" placeholder="Blog Detail" ><?php echo $rowfetch['blog_detail']; ?></textarea>
                                    
                                </div>
                            </div>

                            <div class="controls">
                                <input type="hidden" name="id" id="blog_id" value="<?php echo $id; ?>" />
                            </div>

                            <div class="form-actions col-sm-12" style="padding-top: 20px;">
                                <input name="update" type="submit" value="Update" class="btn btn-add">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
         <script src="//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js" type="text/javascript"></script>
      <!-- jQuery -->
      <script src="assets/plugins/jQuery/jquery-1.12.4.min.js" type="text/javascript"></script>
      <!-- jquery-ui --> 
      <script src="assets/plugins/jquery-ui-1.12.1/jquery-ui.min.js" type="text/javascript"></script>
      <!-- Bootstrap -->
      <script src="assets/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
      <!-- lobipanel -->
      <script src="assets/plugins/lobipanel/lobipanel.min.js" type="text/javascript"></script>
      <!-- Pace js -->
      <script src="assets/plugins/pace/pace.min.js" type="text/javascript"></script>
      <!-- SlimScroll -->
      <script src="assets/plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
      <!-- FastClick -->
      <script src="assets/plugins/fastclick/fastclick.min.js" type="text/javascript"></script>
      <!-- CRMadmin frame -->
      <script src="assets/dist/js/custom.js" type="text/javascript"></script>
      <!-- End Core Plugins
         =====================================================================-->
      <!-- Start Theme label Script
         =====================================================================-->
      <!-- Dashboard js -->
      <script src="assets/dist/js/dashboard.js" type="text/javascript"></script>
   <script src='https://cdn.ckeditor.com/ckeditor5/28.0.0/classic/ckeditor.js'></script>
    <script>
        ClassicEditor.create(document.querySelector("#editor"));

document.querySelector("form").addEventListener("submit", (e) => {
  e.preventDefault();
 
});
    </script>
<script>
    tinymce.init({
        selector: 'textarea',
        plugins: 'advlist autolink lists link image charmap print preview hr anchor pagebreak',
        toolbar_mode: 'floating',
    });
</script>

</body>
</html>
