<?php
include('header.php');
include('db.php');

// Check if ID is provided
if (!isset($_GET['id'])) {
    echo "<script>alert('No image selected!'); window.location.href='show-gallery.php';</script>";
    exit();
}

$id = $_GET['id'];

// Fetch image details
$sql = "SELECT * FROM gallery_images WHERE id = :id";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':id', $id, PDO::PARAM_INT);
$stmt->execute();
$image = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$image) {
    echo "<script>alert('Image not found!'); window.location.href='show-gallery.php';</script>";
    exit();
}

// Handle update
if (isset($_POST['update'])) {
    $image_name = trim($_POST['image_name']);
    $image_path = $image['image_path']; // Keep old image by default
    
    // Check if new image is uploaded
    if (isset($_FILES['gallery_image']) && $_FILES['gallery_image']['error'] === 0) {
        $uploadDir = 'uploads/gallery/';
        
        // Delete old image
        if (file_exists($uploadDir . $image['image_path'])) {
            unlink($uploadDir . $image['image_path']);
        }
        
        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['gallery_image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['gallery_image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['gallery_image']['tmp_name'], $targetPath)) {
                $image_path = $fileName;
            }
        }
    }
    
    // Update in database
    $sql = "UPDATE gallery_images SET image_name = :image_name, image_path = :image_path WHERE id = :id";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':image_name', $image_name, PDO::PARAM_STR);
        $stmt->bindParam(':image_path', $image_path, PDO::PARAM_STR);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            echo "<script>alert('Image updated successfully!'); window.location.href='show-gallery.php';</script>";
        } else {
            echo "<script>alert('Failed to update image.');</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 800px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 30px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="text"], input[type="file"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 20px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: inline-block;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 30px;
        cursor: pointer;
        transition: all 0.3s ease;
        margin-right: 15px;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
        text-decoration: none;
    }

    .btn-back {
        display: inline-block;
        background: #6c757d !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 30px;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .btn-back:hover {
        background: #5a6268 !important;
        color: #fff !important;
        transform: translateY(-2px);
        text-decoration: none;
    }

    .form-section {
        margin-bottom: 30px;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 15px;
        border: 1px solid #eee;
    }

    .section-title {
        font-size: 22px;
        font-weight: 700;
        color: #273B92;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #273B92;
    }

    .current-image {
        text-align: center;
        margin: 20px 0;
        padding: 15px;
        background: white;
        border-radius: 10px;
        border: 1px solid #ddd;
    }

    .current-image img {
        max-width: 300px;
        max-height: 200px;
        object-fit: contain;
        border-radius: 10px;
        border: 3px solid #273B92;
    }

    .image-preview-container {
        margin-top: 15px;
        text-align: center;
    }

    .image-preview {
        max-width: 300px;
        max-height: 200px;
        border-radius: 10px;
        border: 2px solid #ddd;
        display: none;
        margin: 0 auto 10px;
        object-fit: contain;
    }

    small {
        display: block;
        margin-top: 5px;
        color: #666;
        font-size: 13px;
    }

    .button-container {
        text-align: center;
        margin-top: 30px;
    }

    .current-image-info {
        background: #e9ecef;
        padding: 10px;
        border-radius: 5px;
        margin-top: 10px;
        font-size: 14px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-back {
            width: 100%;
            margin: 10px 0;
            text-align: center;
        }
        .current-image img {
            max-width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Edit Gallery Image</h2>
        
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <div class="form-section">
                <div class="section-title">Image Information</div>
                
                <div class="form-group">
                    <label>Image Name *</label>
                    <input type="text" name="image_name" placeholder="Enter Image Name" 
                           value="<?php echo htmlspecialchars($image['image_name']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Current Image</label>
                    <div class="current-image">
                        <img src="uploads/gallery/<?php echo htmlspecialchars($image['image_path']); ?>" 
                             alt="<?php echo htmlspecialchars($image['image_name']); ?>"
                             onerror="this.src='https://via.placeholder.com/300x200?text=Image+Not+Found'">
                        <div class="current-image-info">
                            File: <?php echo htmlspecialchars($image['image_path']); ?><br>
                            Uploaded: <?php echo date('d/m/Y h:i A', strtotime($image['upload_date'])); ?>
                        </div>
                    </div>
                    
                    <label>Change Image (Optional)</label>
                    <input type="file" name="gallery_image" id="gallery_image" accept="image/*" onchange="previewImage(this)">
                    <small>Leave empty to keep current image. Allowed formats: JPG, PNG, GIF, WebP | Max size: 5MB</small>
                    
                    <div class="image-preview-container">
                        <img id="image-preview" class="image-preview" src="" alt="New Image Preview">
                    </div>
                </div>
            </div>
            
            <div class="button-container">
                <a href="show-gallery.php" class="btn-back">
                    <i class="fas fa-arrow-left"></i> Back to Gallery
                </a>
                <button type="submit" name="update" class="btn-submit">
                    <i class="fas fa-save"></i> Update Image
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Image preview function
function previewImage(input) {
    var preview = document.getElementById('image-preview');
    
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        
        reader.readAsDataURL(input.files[0]);
    } else {
        preview.style.display = 'none';
        preview.src = '';
    }
}

function validateForm() {
    // Check required fields
    var imageName = document.querySelector('input[name="image_name"]').value;
    var galleryImage = document.querySelector('input[name="gallery_image"]').files[0];
    
    if (!imageName.trim()) {
        alert("Please enter image name");
        return false;
    }
    
    // Check file size if new image is selected
    if (galleryImage && galleryImage.size > 5 * 1024 * 1024) {
        alert("Image size should be less than 5MB");
        return false;
    }
    
    return true;
}
</script>

<?php include('footer.php'); ?>