<?php 
include('header.php');
include('db.php'); 

// Check if product ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>alert('Product ID is required'); window.location.href='show-chemical-products.php';</script>";
    exit;
}

$product_id = (int)$_GET['id'];

// Fetch product data
$stmt = $pdo->prepare("SELECT * FROM chemical_products WHERE id = :id");
$stmt->bindParam(':id', $product_id, PDO::PARAM_INT);
$stmt->execute();
$product = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$product) {
    echo "<script>alert('Product not found'); window.location.href='show-chemical-products.php';</script>";
    exit;
}

// Handle form submission for update
if (isset($_POST['update'])) {
    // Handle main image upload (optional - keep old if not provided)
    $main_image = $product['main_image']; // Keep old image by default
    
    if (isset($_FILES['main_image']) && $_FILES['main_image']['error'] === 0) {
        // Delete old main image if exists
        if (!empty($product['main_image'])) {
            $old_image_path = 'uploads/products/' . $product['main_image'];
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }
        
        // Upload new main image
        $uploadDir = 'uploads/products/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileName = uniqid() . '_' . basename($_FILES['main_image']['name']);
        $targetPath = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['main_image']['tmp_name'], $targetPath)) {
            $main_image = $fileName;
        }
    }
    
    // Handle other images upload
    $other_images = [];
    
    // First, keep existing images if not removing them
    if (!empty($product['other_images'])) {
        $existing_images = json_decode($product['other_images'], true);
        if (is_array($existing_images)) {
            $other_images = $existing_images;
        }
    }
    
    // Check which existing images to remove
    if (isset($_POST['remove_images']) && is_array($_POST['remove_images'])) {
        foreach ($_POST['remove_images'] as $image_to_remove) {
            // Remove from array
            $key = array_search($image_to_remove, $other_images);
            if ($key !== false) {
                unset($other_images[$key]);
                
                // Delete file from server
                $image_path = 'uploads/products/other/' . $image_to_remove;
                if (file_exists($image_path)) {
                    unlink($image_path);
                }
            }
        }
        // Re-index array
        $other_images = array_values($other_images);
    }
    
    // Add new images
    if (!empty($_FILES['other_images']['name'][0])) {
        $uploadDir = 'uploads/products/other/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        foreach ($_FILES['other_images']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['other_images']['error'][$key] === 0) {
                $fileName = uniqid() . '_' . basename($_FILES['other_images']['name'][$key]);
                $targetPath = $uploadDir . $fileName;
                
                if (move_uploaded_file($tmp_name, $targetPath)) {
                    $other_images[] = $fileName;
                }
            }
        }
    }
    
    // Convert other images array to JSON
    $other_images_json = !empty($other_images) ? json_encode($other_images) : null;
    
    // Update product in database
    $sql = "UPDATE chemical_products SET
        product_grade = :product_grade,
        product_name = :product_name,
        product_description = :product_description,
        main_image = :main_image,
        other_images = :other_images,
        cas_number = :cas_number,
        chemical_formula = :chemical_formula,
        purity_assay = :purity_assay,
        grade = :grade,
        physical_form = :physical_form,
        packaging_details = :packaging_details,
        applications = :applications,
        shelf_life = :shelf_life,
        storage_conditions = :storage_conditions,
        moq = :moq,
        hs_code = :hs_code
    WHERE id = :id";
    
    $stmt = $pdo->prepare($sql);
    
    // Bind parameters
    $stmt->bindParam(':product_grade', $_POST['product_grade'], PDO::PARAM_STR);
    $stmt->bindParam(':product_name', $_POST['product_name'], PDO::PARAM_STR);
    $stmt->bindParam(':product_description', $_POST['product_description'], PDO::PARAM_STR);
    $stmt->bindParam(':main_image', $main_image, PDO::PARAM_STR);
    $stmt->bindParam(':other_images', $other_images_json, PDO::PARAM_STR);
    
    // Chemical specifications
    $stmt->bindParam(':cas_number', $_POST['cas_number'], PDO::PARAM_STR);
    $stmt->bindParam(':chemical_formula', $_POST['chemical_formula'], PDO::PARAM_STR);
    $stmt->bindParam(':purity_assay', $_POST['purity_assay'], PDO::PARAM_STR);
    $stmt->bindParam(':grade', $_POST['grade'], PDO::PARAM_STR);
    $stmt->bindParam(':physical_form', $_POST['physical_form'], PDO::PARAM_STR);
    $stmt->bindParam(':packaging_details', $_POST['packaging_details'], PDO::PARAM_STR);
    $stmt->bindParam(':applications', $_POST['applications'], PDO::PARAM_STR);
    $stmt->bindParam(':shelf_life', $_POST['shelf_life'], PDO::PARAM_STR);
    $stmt->bindParam(':storage_conditions', $_POST['storage_conditions'], PDO::PARAM_STR);
    
    // Other details
    $stmt->bindParam(':moq', $_POST['moq'], PDO::PARAM_STR);
    $stmt->bindParam(':hs_code', $_POST['hs_code'], PDO::PARAM_STR);
    $stmt->bindParam(':id', $product_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo "<script>alert('Chemical product updated successfully!'); window.location.href='show-chemical-products.php';</script>";
        exit;
    } else {
        echo "<script>alert('Failed to update product. Please try again.');</script>";
    }
}

// Decode other images for display
$existing_other_images = [];
if (!empty($product['other_images'])) {
    $existing_other_images = json_decode($product['other_images'], true);
    if (!is_array($existing_other_images)) {
        $existing_other_images = [];
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 1200px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="text"], select, textarea {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input[type="file"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input:focus, select:focus, textarea:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: block;
        /*width: 200px;*/
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 15px;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px auto 0;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .form-section {
        margin-bottom: 30px;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 15px;
        border: 1px solid #eee;
    }

    .section-title {
        font-size: 22px;
        font-weight: 700;
        color: #273B92;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #273B92;
    }

    .form-row {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 10px;
    }

    .form-group {
        flex: 1;
        min-width: 250px;
    }

    .image-preview {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        margin-top: 10px;
    }

    .preview-img {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
        position: relative;
    }

    .existing-image {
        position: relative;
        display: inline-block;
        margin: 5px;
    }

    .remove-checkbox {
        position: absolute;
        top: -8px;
        right: -8px;
        background: #dc3545;
        color: white;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        border: none;
        cursor: pointer;
        z-index: 2;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
    }

    .remove-checkbox:hover {
        background: #c82333;
    }

    .current-image-label {
        display: block;
        margin-top: 10px;
        font-weight: 600;
        color: #273B92;
    }

    .current-image {
        max-width: 200px;
        max-height: 200px;
        border-radius: 10px;
        border: 2px solid #ddd;
        margin-top: 10px;
    }

    small {
        display: block;
        margin-top: 5px;
        color: #666;
        font-size: 13px;
    }

    .btn-back {
        display: inline-block;
        background: #6c757d !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
        margin-right: 10px;
    }

    .btn-back:hover {
        background: #545b62 !important;
        color: #fff !important;
        transform: translateY(-2px);
        text-decoration: none;
    }

    .btn-show {
        display: inline-block;
        background: #28a745 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
        margin-right: 10px;
    }

    .btn-show:hover {
        background: #218838 !important;
        color: #fff !important;
        transform: translateY(-2px);
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-back, .btn-show {
            width: 100%;
            margin-bottom: 15px;
        }
        .form-row {
            flex-direction: column;
            gap: 15px;
        }
        .form-group {
            min-width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Edit Chemical Product</h2>
        
        <div style="margin-bottom: 20px;">
            <a href="show-chemical-products.php" class="btn-back">
                <i class="fas fa-arrow-left"></i> Back to Products List
            </a>
            <a href="add-chemical-product.php" class="btn-show">
                <i class="fas fa-plus-circle"></i> Add New Product
            </a>
        </div>

        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            <input type="hidden" name="id" value="<?php echo $product_id; ?>">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Product Grade *</label>
                        <input type="text" name="product_grade" 
                               value="<?php echo htmlspecialchars($product['product_grade']); ?>" 
                               placeholder="e.g., Pharmaceutical Grade" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Product Name *</label>
                        <input type="text" name="product_name" 
                               value="<?php echo htmlspecialchars($product['product_name']); ?>" 
                               placeholder="Enter Product Name" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Product Description</label>
                    <textarea name="product_description" rows="4" placeholder="Enter product description"><?php echo htmlspecialchars($product['product_description']); ?></textarea>
                </div>
            </div>
            
            <!-- Section 2: Images -->
            <div class="form-section">
                <div class="section-title">Product Images</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Main Image (Current)</label>
                        <?php if (!empty($product['main_image'])): ?>
                            <div>
                                <img src="uploads/products/<?php echo htmlspecialchars($product['main_image']); ?>" 
                                     class="current-image"
                                     alt="Current Main Image"
                                     onerror="this.src='https://via.placeholder.com/200?text=Image+Not+Found'">
                            </div>
                        <?php else: ?>
                            <p style="color: #666;">No main image uploaded</p>
                        <?php endif; ?>
                        
                        <label style="margin-top: 15px;">Change Main Image (Optional)</label>
                        <input type="file" name="main_image" accept="image/*">
                        <small>Leave empty to keep current image</small>
                    </div>
                    
                    <div class="form-group">
                        <label>Other Images (Current)</label>
                        <?php if (!empty($existing_other_images)): ?>
                            <div class="image-preview">
                                <?php foreach ($existing_other_images as $index => $image): ?>
                                <div class="existing-image">
                                    <img src="uploads/products/other/<?php echo htmlspecialchars($image); ?>" 
                                         class="preview-img"
                                         alt="Other Image <?php echo $index + 1; ?>"
                                         onerror="this.src='https://via.placeholder.com/80?text=Image'">
                                    <button type="button" class="remove-checkbox" 
                                            onclick="toggleRemoveImage('<?php echo $image; ?>', this)">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    <input type="checkbox" name="remove_images[]" 
                                           value="<?php echo htmlspecialchars($image); ?>" 
                                           id="remove_<?php echo $index; ?>" 
                                           style="display: none;">
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <small>Click red X to mark image for removal</small>
                        <?php else: ?>
                            <p style="color: #666;">No other images uploaded</p>
                        <?php endif; ?>
                        
                        <label style="margin-top: 15px;">Add More Images (Optional)</label>
                        <input type="file" name="other_images[]" accept="image/*" multiple>
                        <small>Select multiple images to add to existing ones</small>
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Chemical Specifications -->
            <div class="form-section">
                <div class="section-title">Chemical Specifications</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>CAS Number</label>
                        <input type="text" name="cas_number" 
                               value="<?php echo htmlspecialchars($product['cas_number']); ?>" 
                               placeholder="e.g., 64-17-5">
                    </div>
                    
                    <div class="form-group">
                        <label>Chemical Formula / Molecular Weight</label>
                        <input type="text" name="chemical_formula" 
                               value="<?php echo htmlspecialchars($product['chemical_formula']); ?>" 
                               placeholder="e.g., C2H5OH / 46.07 g/mol">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Purity / Assay (%)</label>
                        <input type="text" name="purity_assay" 
                               value="<?php echo htmlspecialchars($product['purity_assay']); ?>" 
                               placeholder="e.g., 99.5%">
                    </div>
                    
                    <div class="form-group">
                        <label>Grade</label>
                        <input type="text" name="grade" 
                               value="<?php echo htmlspecialchars($product['grade']); ?>" 
                               placeholder="e.g., Technical, USP, Reagent">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Physical Form & Appearance</label>
                        <input type="text" name="physical_form" 
                               value="<?php echo htmlspecialchars($product['physical_form']); ?>" 
                               placeholder="e.g., Clear colorless liquid">
                    </div>
                    
                    <div class="form-group">
                        <label>Packaging Details</label>
                        <input type="text" name="packaging_details" 
                               value="<?php echo htmlspecialchars($product['packaging_details']); ?>" 
                               placeholder="e.g., 200L drums, 25kg bags">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Applications / End Use</label>
                    <textarea name="applications" rows="3" placeholder="e.g., Solvent, Fuel, Disinfectant"><?php echo htmlspecialchars($product['applications']); ?></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Shelf Life</label>
                        <input type="text" name="shelf_life" 
                               value="<?php echo htmlspecialchars($product['shelf_life']); ?>" 
                               placeholder="e.g., 24 months from manufacture">
                    </div>
                    
                    <div class="form-group">
                        <label>Storage Conditions</label>
                        <input type="text" name="storage_conditions" 
                               value="<?php echo htmlspecialchars($product['storage_conditions']); ?>" 
                               placeholder="e.g., Store in cool, dry place">
                    </div>
                </div>
            </div>
            
            <!-- Section 4: Other Details -->
            <div class="form-section">
                <div class="section-title">Other Details</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Minimum Order Quantity (MOQ)</label>
                        <input type="text" name="moq" 
                               value="<?php echo htmlspecialchars($product['moq']); ?>" 
                               placeholder="e.g., 500 Kg">
                    </div>
                    
                    <div class="form-group">
                        <label>HS Code</label>
                        <input type="text" name="hs_code" 
                               value="<?php echo htmlspecialchars($product['hs_code']); ?>" 
                               placeholder="e.g., 2905.11.00">
                    </div>
                </div>
            </div>
            
            <button type="submit" name="update" class="btn-submit">Update Chemical Product</button>
        </form>
    </div>
</div>

<script>
function validateForm() {
    // Check required fields
    var productName = document.querySelector('input[name="product_name"]').value;
    var productGrade = document.querySelector('input[name="product_grade"]').value;
    
    if (!productName.trim()) {
        alert("Please enter product name");
        return false;
    }
    
    if (!productGrade.trim()) {
        alert("Please enter product grade");
        return false;
    }
    
    // Check file size for main image if provided
    var mainImage = document.querySelector('input[name="main_image"]').files[0];
    if (mainImage && mainImage.size > 2 * 1024 * 1024) {
        alert("Main image size should be less than 2MB");
        return false;
    }
    
    // Check other images count and size
    var otherImages = document.querySelector('input[name="other_images[]"]').files;
    if (otherImages.length > 5) {
        alert("Maximum 5 other images can be added at once");
        return false;
    }
    
    for (var i = 0; i < otherImages.length; i++) {
        if (otherImages[i].size > 2 * 1024 * 1024) {
            alert("Image " + (i + 1) + " size should be less than 2MB");
            return false;
        }
    }
    
    return true;
}

function toggleRemoveImage(imageName, button) {
    var checkbox = document.querySelector('input[value="' + imageName + '"]');
    var img = button.parentElement.querySelector('img');
    
    if (checkbox.checked) {
        // Unmark for removal
        checkbox.checked = false;
        button.style.background = '#dc3545';
        img.style.opacity = '1';
        img.style.borderColor = '#ddd';
    } else {
        // Mark for removal
        checkbox.checked = true;
        button.style.background = '#28a745';
        img.style.opacity = '0.5';
        img.style.borderColor = '#dc3545';
    }
}

// Preview for new main image
$(document).ready(function() {
    $('input[name="main_image"]').change(function(e) {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                var previewDiv = $('#newMainImagePreview');
                if (!previewDiv.length) {
                    $(input).after('<div id="newMainImagePreview" style="margin-top: 10px;"></div>');
                    previewDiv = $('#newMainImagePreview');
                }
                previewDiv.html('<strong>New Image Preview:</strong><br>' +
                               '<img src="' + e.target.result + '" style="max-width: 200px; max-height: 200px; border-radius: 8px; margin-top: 5px; border: 2px solid #273B92;">');
            }
            reader.readAsDataURL(input.files[0]);
        }
    });
    
    // Preview for new other images
    $('input[name="other_images[]"]').change(function(e) {
        var input = this;
        var previewContainer = $('#newOtherImagesPreview');
        
        if (!previewContainer.length) {
            $(input).after('<div id="newOtherImagesPreview" style="margin-top: 10px;"></div>');
            previewContainer = $('#newOtherImagesPreview');
        } 
        
        previewContainer.html('<strong>New Images Preview:</strong><div class="image-preview"></div>');
        var previewImages = previewContainer.find('.image-preview');
        
        if (input.files) {
            for (var i = 0; i < input.files.length; i++) {
                var reader = new FileReader();
                reader.onload = (function(index) {
                    return function(e) {
                        previewImages.append('<img src="' + e.target.result + '" class="preview-img" title="New Image ' + (index + 1) + '">');
                    };
                })(i);
                reader.readAsDataURL(input.files[i]);
            }
        }
    });
});
</script>

<?php include('footer.php'); ?>