<?php
include('header.php');
include('db.php');

// Get blog ID from URL
$blog_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch blog data
$blog = null;
if ($blog_id > 0) {
    $stmt = $pdo->prepare("SELECT * FROM blog_posts WHERE id = :id");
    $stmt->bindParam(':id', $blog_id, PDO::PARAM_INT);
    $stmt->execute();
    $blog = $stmt->fetch(PDO::FETCH_ASSOC);
}

// If blog not found, redirect
if (!$blog) {
    echo "<script>alert('Blog not found!'); window.location.href='show-blogs.php';</script>";
    exit;
}

// Handle form submission for update
if (isset($_POST['update'])) {
    $blog_name = trim($_POST['blog_name']);
    $date = $_POST['date'];
    $author_name = trim($_POST['author_name']);
    $content = trim($_POST['content']);
    
    // Check if new image is uploaded
    $image = $blog['image']; // Keep old image by default
    
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $uploadDir = 'uploads/blogs/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        // Delete old image if exists
        if (!empty($blog['image'])) {
            $old_image_path = 'uploads/blogs/' . $blog['image'];
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }
        
        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $image = $fileName;
            }
        }
    }
    
    // Check if remove image checkbox is checked
    if (isset($_POST['remove_image']) && $_POST['remove_image'] == 1) {
        // Delete current image file
        if (!empty($image)) {
            $image_path = 'uploads/blogs/' . $image;
            if (file_exists($image_path)) {
                unlink($image_path);
            }
            $image = ''; // Set to empty
        }
    }
    
    // Update database
    $sql = "UPDATE blog_posts SET 
            blog_name = :blog_name,
            date = :date,
            author_name = :author_name,
            content = :content,
            image = :image
            WHERE id = :id";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':blog_name', $blog_name, PDO::PARAM_STR);
        $stmt->bindParam(':date', $date, PDO::PARAM_STR);
        $stmt->bindParam(':author_name', $author_name, PDO::PARAM_STR);
        $stmt->bindParam(':content', $content, PDO::PARAM_STR);
        $stmt->bindParam(':image', $image, PDO::PARAM_STR);
        $stmt->bindParam(':id', $blog_id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            echo "<script>alert('Blog updated successfully!'); window.location.href='show-blogs.php';</script>";
            exit;
        } else {
            echo "<script>alert('Failed to update blog. Please try again.');</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
    }
}

// Handle delete (separate from update)
if (isset($_POST['delete'])) {
    // Delete image file first
    if (!empty($blog['image'])) {
        $image_path = 'uploads/blogs/' . $blog['image'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }
    
    // Delete from database
    $stmt = $pdo->prepare("DELETE FROM blog_posts WHERE id = :id");
    $stmt->bindParam(':id', $blog_id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        echo "<script>alert('Blog deleted successfully!'); window.location.href='show-blogs.php';</script>";
        exit;
    } else {
        echo "<script>alert('Failed to delete blog.');</script>";
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 1200px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="text"], input[type="date"], select, textarea {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input[type="file"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input:focus, textarea:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: inline-block;
        width: 200px;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-delete {
        display: inline-block;
        width: 200px;
        background: #dc3545 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-delete:hover {
        background: #c82333 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-cancel {
        display: inline-block;
        width: 200px;
        background: #6c757d !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px 10px 0;
        text-align: center;
        text-decoration: none;
    }

    .btn-cancel:hover {
        background: #5a6268 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .form-section {
        margin-bottom: 30px;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 15px;
        border: 1px solid #eee;
    }

    .section-title {
        font-size: 22px;
        font-weight: 700;
        color: #273B92;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #273B92;
    }

    .form-row {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 10px;
    }

    .form-group {
        flex: 1;
        min-width: 250px;
    }

    .image-preview-container {
        margin-top: 15px;
        text-align: center;
    }

    .current-image {
        max-width: 300px;
        max-height: 200px;
        border-radius: 10px;
        border: 2px solid #ddd;
        margin: 0 auto 10px;
    }

    .no-image {
        width: 300px;
        height: 200px;
        border-radius: 10px;
        border: 2px dashed #ddd;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #666;
        font-style: italic;
        margin: 0 auto 10px;
    }

    small {
        display: block;
        margin-top: 5px;
        color: #666;
        font-size: 13px;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: 18px;
        height: 18px;
        margin: 0;
    }

    .checkbox-group label {
        margin: 0;
        font-weight: normal;
        color: #666;
    }

    .button-group {
        display: flex;
        justify-content: center;
        gap: 20px;
        flex-wrap: wrap;
        margin-top: 30px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-delete, .btn-cancel {
            width: 100%;
            margin: 10px 0;
        }
        .button-group {
            flex-direction: column;
            gap: 10px;
        }
        .form-row {
            flex-direction: column;
            gap: 15px;
        }
        .form-group {
            min-width: 100%;
        }
    }

    @media (max-width: 480px) {
        .current-image, .no-image {
            max-width: 100%;
            height: auto;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Edit Blog Post</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Hidden ID field -->
            <input type="hidden" name="blog_id" value="<?php echo $blog['id']; ?>">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Blog Name *</label>
                        <input type="text" name="blog_name" 
                               value="<?php echo htmlspecialchars($blog['blog_name']); ?>" 
                               placeholder="Enter Blog Name" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Publish Date *</label>
                        <input type="date" name="date" 
                               value="<?php echo htmlspecialchars($blog['date']); ?>" 
                               required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Author Name *</label>
                    <input type="text" name="author_name" 
                           value="<?php echo htmlspecialchars($blog['author_name']); ?>" 
                           placeholder="Enter Author Name" required>
                </div>
            </div>
            
            <!-- Section 2: Image -->
            <div class="form-section">
                <div class="section-title">Blog Image</div>
                
                <!-- Current Image Display -->
                <div class="form-group">
                    <label>Current Image</label>
                    <div class="image-preview-container">
                        <?php if (!empty($blog['image'])): ?>
                            <img src="uploads/blogs/<?php echo htmlspecialchars($blog['image']); ?>" 
                                 class="current-image" 
                                 alt="Current Blog Image"
                                 onerror="this.style.display='none'; document.getElementById('no-image').style.display='flex';">
                            <div id="no-image" class="no-image" style="display: none;">
                                <i class="fas fa-image"></i> Image not found
                            </div>
                        <?php else: ?>
                            <div class="no-image">
                                <i class="fas fa-image"></i> No image uploaded
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Remove Image Checkbox -->
                    <?php if (!empty($blog['image'])): ?>
                    <div class="checkbox-group">
                        <input type="checkbox" name="remove_image" id="remove_image" value="1">
                        <label for="remove_image">Remove current image</label>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- New Image Upload -->
                <div class="form-group">
                    <label>Upload New Image (Optional)</label>
                    <input type="file" name="image" id="image" accept="image/*" onchange="previewNewImage(this)">
                    <small>Preferred size: 1200x630px, max 2MB</small>
                    
                    <div class="image-preview-container">
                        <img id="new-image-preview" class="current-image" src="" alt="New Image Preview" style="display: none;">
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Content -->
            <div class="form-section">
                <div class="section-title">Blog Content</div>
                
                <div class="form-group">
                    <label>Content *</label>
                    <textarea name="content" rows="10" placeholder="Write your blog content here..." required><?php echo htmlspecialchars($blog['content']); ?></textarea>
                </div>
            </div>
            
            <!-- Button Group -->
            <div class="button-group">
                <button type="submit" name="update" class="btn-submit">
                    <i class="fas fa-save"></i> Update Blog
                </button>
                
                <a href="show-blogs.php" class="btn-cancel">
                    <i class="fas fa-times"></i> Cancel
                </a>
                
                <button type="submit" name="delete" class="btn-delete" onclick="return confirmDelete()">
                    <i class="fas fa-trash"></i> Delete Blog
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Set date format for display
document.addEventListener('DOMContentLoaded', function() {
    // Format date if needed
    var dateInput = document.querySelector('input[name="date"]');
    if (dateInput.value) {
        // Convert date to YYYY-MM-DD format if needed
        var date = new Date(dateInput.value);
        if (!isNaN(date.getTime())) {
            dateInput.value = date.toISOString().split('T')[0];
        }
    }
});

// Preview new image function
function previewNewImage(input) {
    var preview = document.getElementById('new-image-preview');
    var removeCheckbox = document.getElementById('remove_image');
    
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
            
            // Uncheck remove image checkbox if new image is selected
            if (removeCheckbox) {
                removeCheckbox.checked = false;
            }
        }
        
        reader.readAsDataURL(input.files[0]);
    } else {
        preview.style.display = 'none';
        preview.src = '';
    }
}

// Form validation
function validateForm() {
    var blogName = document.querySelector('input[name="blog_name"]').value;
    var date = document.querySelector('input[name="date"]').value;
    var authorName = document.querySelector('input[name="author_name"]').value;
    var content = document.querySelector('textarea[name="content"]').value;
    var newImage = document.querySelector('input[name="image"]').files[0];
    
    // Validate required fields
    if (!blogName.trim()) {
        alert("Please enter blog name");
        return false;
    }
    
    if (!date) {
        alert("Please select a publish date");
        return false;
    }
    
    if (!authorName.trim()) {
        alert("Please enter author name");
        return false;
    }
    
    if (!content.trim()) {
        alert("Please enter blog content");
        return false;
    }
    
    // Check file size if new image is uploaded
    if (newImage && newImage.size > 2 * 1024 * 1024) {
        alert("Blog image size should be less than 2MB");
        return false;
    }
    
    return true;
}

// Delete confirmation
function confirmDelete() {
    return confirm("Are you sure you want to delete this blog? This action cannot be undone!");
}
</script>

<?php include('footer.php'); ?>