<?php 
include('header.php');
?>

<style>
    .form-control {
        display: block;
        width: 50%;
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        padding: 12px 15px;
        font-size: 16px;
        transition: all 0.3s ease;
    }
    
    .form-control:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
        color: #000 !important;
    }
    
    .graph_container{
        display:block;
        max-width: 100%;
    }

    .char-content{
        margin-top: 30px;
        display: flex;
    }
    
    @media only screen and (max-width: 575px) {
        .char-content{
            display: block;
        }
        .box-shadow {
            margin: 20px 0;
        }
        .form-control {
            width: 100%;
        }
    }
    
    .col-lg-12.box-shadow {
        background: #fff !important;
        padding: 30px;
        border-radius: 20px;
        border: 1px solid #ddd !important;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
        color: #000 !important;
        margin-bottom: 30px;
    }
    
    .col-lg-12.box-shadow::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: #273B92;
    }
    
    .box-shadow h3 {
        font-size: 24px;
        color: #000 !important;
        font-weight: 700;
        margin-bottom: 20px;
        letter-spacing: 0.5px;
    }
    
    .box-shadow p {
        font-size: 16px;
        color: #666 !important;
        line-height: 1.6;
        margin-bottom: 15px;
    }
    
    p.info {
        color: #fff !important;
        background: #273B92 !important;
        display: inline-block;
        padding: 8px 20px;
        border-radius: 30px;
        font-weight: 600;
        margin-bottom: 20px;
        font-size: 14px;
        text-transform: uppercase;
        letter-spacing: 1px;
        border: none;
    }
    
    .content-box{
        margin-bottom: 40px;
    }
    
    .char-content {
        margin-top: 30px;
        display: flex;
        flex-wrap: wrap;
    }
    
    .box-shadow{
        margin-bottom: 30px;
        transition: all 0.3s ease;
    }
    
    .box-shadow:hover {
        transform: translateY(-5px);
        box-shadow: 0 30px 60px -12px rgba(0, 0, 0, 0.15) !important;
    }
    
    .box-shadow a {
        color: #273B92 !important;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        font-size: 16px;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 10px 20px;
        background: #273B92 !important;
        color: #fff !important;
        border-radius: 12px;
        border: none;
    }
    
    .box-shadow a:hover {
        background: #000 !important;
        color: #fff !important;
        text-decoration: none;
        transform: translateX(5px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }
    
    /* Content Header Styles */
    .content-header {
        background: transparent;
        padding: 30px 0;
        border-bottom: 2px solid #ddd !important;
        margin-bottom: 40px;
        display: flex;
        align-items: center;
        gap: 0px;
    }
    
    .header-title h1 {
        color: #000 !important;
        font-weight: 700;
        font-size: 36px;
        margin: 0;
        letter-spacing: 1px;
    }
    
    .header-icon {
        color: #273B92 !important;
        font-size: 32px;
    }
    
    /* Content Wrapper */
    .content-wrapper {
        background: #fff !important;
        padding: 30px 50px;
        box-sizing: border-box;
        color: #000 !important;
        min-height: 100vh;
    }
    
    .content {
        background: transparent;
    }
</style>
 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-dashboard"></i>
        </div>
        <div class="header-title">
            <h1>Harbour Line Dashboard</h1>
        </div> 
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-12 char-content content-box">
                <div class="col-lg-12">
                    <div class="col-lg-12 box-shadow">
                        <p class="info">PROFILE</p> 
                        <h3>Update Admin Password</h3> 
                        <p>You can change Admin Panel Password</p>
                        <a href="change_password.php"><strong>Change Password</strong></a> 
                    </div>
                </div>  
            </div> 
        </div>
    </section>
    <!-- /.content -->
</div>

<?php 
include('footer.php');
?>
</body>
</html>