<?php 
include('header.php');
include('db.php');

// Check if admin is logged in (you should have session check here)
// For now, we'll assume admin is logged in

// Handle password change
$success_msg = '';
$error_msg = '';

if (isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    // Basic validation
    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error_msg = "All fields are required!";
    } elseif ($new_password !== $confirm_password) {
        $error_msg = "New password and confirm password do not match!";
    } elseif (strlen($new_password) < 6) {
        $error_msg = "New password must be at least 6 characters long!";
    } else {
        // Get current admin password from database
        $stmt = $pdo->prepare("SELECT password FROM admin_login WHERE id = 1");
        $stmt->execute();
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
         
        if ($admin) {
            // Check current password (assuming plain text for now, use password_verify() if hashed)
            if ($admin['password'] === $current_password) {
                // Update password
                $update_stmt = $pdo->prepare("UPDATE admin_login SET password = :password WHERE id = 1");
                $update_stmt->bindParam(':password', $new_password, PDO::PARAM_STR);
                
                if ($update_stmt->execute()) {
                    $success_msg = "Password changed successfully!";
                } else {
                    $error_msg = "Failed to update password. Please try again.";
                }
            } else {
                $error_msg = "Current password is incorrect!";
            }
        } else {
            $error_msg = "Admin not found!";
        }
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 600px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="password"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 20px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input[type="password"]:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: block;
        width: 100%;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 30px auto 0;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-back {
        display: inline-block;
        background: #6c757d !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 12px 25px;
        text-decoration: none;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .btn-back:hover {
        background: #545b62 !important;
        color: #fff !important;
        transform: translateY(-2px);
        text-decoration: none;
    }

    .alert {
        padding: 15px;
        border-radius: 12px;
        margin-bottom: 20px;
        font-weight: 600;
    }

    .alert-success {
        background: #d4edda;
        border: 1px solid #c3e6cb;
        color: #155724;
    }

    .alert-danger {
        background: #f8d7da;
        border: 1px solid #f5c6cb;
        color: #721c24;
    }

    .password-strength {
        margin-top: -15px;
        margin-bottom: 15px;
        font-size: 13px;
    }

    .strength-weak { color: #dc3545; }
    .strength-medium { color: #ffc107; }
    .strength-strong { color: #28a745; }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-back {
            width: 100%;
            margin-bottom: 15px;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Change Admin Password</h2>
        
        <a href="dashboard.php" class="btn-back">
            <i class="fas fa-arrow-left"></i> Back to Dashboard
        </a>

        <?php if ($success_msg): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?php echo $success_msg; ?>
            </div>
        <?php endif; ?>

        <?php if ($error_msg): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error_msg; ?>
            </div>
        <?php endif; ?>

        <form method="post" action="" onsubmit="return validatePassword()">
            <div class="form-group">
                <label for="current_password">Current Password *</label>
                <input type="password" id="current_password" name="current_password" 
                       placeholder="Enter current password" required>
            </div>

            <div class="form-group">
                <label for="new_password">New Password *</label>
                <input type="password" id="new_password" name="new_password" 
                       placeholder="Enter new password (min 6 characters)" required
                       onkeyup="checkPasswordStrength(this.value)">
                <div id="passwordStrength" class="password-strength"></div>
            </div>

            <div class="form-group"> 
                <label for="confirm_password">Confirm New Password *</label>
                <input type="password" id="confirm_password" name="confirm_password" 
                       placeholder="Confirm new password" required>
                <div id="passwordMatch" style="font-size: 13px; margin-top: -15px; margin-bottom: 15px;"></div>
            </div>

            <button type="submit" name="change_password" class="btn-submit">
                <i class="fas fa-key"></i> Change Password
            </button>
        </form>
    </div>
</div>

<script>
function checkPasswordStrength(password) {
    var strength = document.getElementById('passwordStrength');
    var strongRegex = new RegExp("^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})");
    var mediumRegex = new RegExp("^(((?=.*[a-z])(?=.*[A-Z]))|((?=.*[a-z])(?=.*[0-9]))|((?=.*[A-Z])(?=.*[0-9])))(?=.{6,})");
    
    if (password.length === 0) {
        strength.innerHTML = '';
        return;
    }
    
    if (strongRegex.test(password)) {
        strength.innerHTML = '<span class="strength-strong"><i class="fas fa-check-circle"></i> Strong Password</span>';
    } else if (mediumRegex.test(password)) {
        strength.innerHTML = '<span class="strength-medium"><i class="fas fa-exclamation-triangle"></i> Medium Password</span>';
    } else {
        strength.innerHTML = '<span class="strength-weak"><i class="fas fa-times-circle"></i> Weak Password (min 6 characters)</span>';
    }
    
    // Check password match
    var confirmPassword = document.getElementById('confirm_password').value;
    if (confirmPassword) {
        checkPasswordMatch(password, confirmPassword);
    }
}

function checkPasswordMatch(password, confirmPassword) {
    var matchDiv = document.getElementById('passwordMatch');
    
    if (confirmPassword.length === 0) {
        matchDiv.innerHTML = '';
        return;
    }
    
    if (password === confirmPassword) {
        matchDiv.innerHTML = '<span style="color: #28a745;"><i class="fas fa-check-circle"></i> Passwords match</span>';
    } else {
        matchDiv.innerHTML = '<span style="color: #dc3545;"><i class="fas fa-times-circle"></i> Passwords do not match</span>';
    }
}

function validatePassword() {
    var currentPassword = document.getElementById('current_password').value;
    var newPassword = document.getElementById('new_password').value;
    var confirmPassword = document.getElementById('confirm_password').value;
    
    if (!currentPassword || !newPassword || !confirmPassword) {
        alert("All fields are required!");
        return false;
    }
    
    if (newPassword.length < 6) {
        alert("New password must be at least 6 characters long!");
        return false;
    }
    
    if (newPassword !== confirmPassword) {
        alert("New password and confirm password do not match!");
        return false;
    }
    
    return confirm("Are you sure you want to change the password?");
}

// Real-time password match checking
document.getElementById('confirm_password').addEventListener('keyup', function() {
    var password = document.getElementById('new_password').value;
    checkPasswordMatch(password, this.value); 
});

// Toggle password visibility (optional feature)
function togglePasswordVisibility(fieldId) {
    var field = document.getElementById(fieldId);
    var icon = document.querySelector('#toggle' + fieldId.charAt(0).toUpperCase() + fieldId.slice(1));
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>

<?php include('footer.php'); ?>
</body>
</html>