<?php 
include('header.php');
include('db.php'); 

// Handle form submission
if (isset($_POST['submit'])) {
    // File upload for main image
    $main_image = '';
    if (isset($_FILES['main_image']) && $_FILES['main_image']['error'] === 0) {
        $uploadDir = 'uploads/products/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileName = uniqid() . '_' . basename($_FILES['main_image']['name']);
        $targetPath = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['main_image']['tmp_name'], $targetPath)) {
            $main_image = $fileName;
        }
    }
    
    // Handle multiple images upload
    $other_images = [];
    if (!empty($_FILES['other_images']['name'][0])) {
        $uploadDir = 'uploads/products/other/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        foreach ($_FILES['other_images']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['other_images']['error'][$key] === 0) {
                $fileName = uniqid() . '_' . basename($_FILES['other_images']['name'][$key]);
                $targetPath = $uploadDir . $fileName;
                
                if (move_uploaded_file($tmp_name, $targetPath)) {
                    $other_images[] = $fileName;
                }
            }
        }
    }
    
    // Convert other images array to JSON
    $other_images_json = !empty($other_images) ? json_encode($other_images) : null;
    
    // Insert into tobacco_products table
    $sql = "INSERT INTO tobacco_products (
        product_grade, product_name, product_description, 
        main_image, other_images,
        grade, color, texture, moisture_content, nicotine_content, 
        sugar_content, leaf_length, leaf_width, stem_content, 
        aroma, burning_quality, moq, hs_code
    ) VALUES (
        :product_grade, :product_name, :product_description,
        :main_image, :other_images,
        :grade, :color, :texture, :moisture_content, :nicotine_content,
        :sugar_content, :leaf_length, :leaf_width, :stem_content,
        :aroma, :burning_quality, :moq, :hs_code
    )";
    
    $stmt = $pdo->prepare($sql);
    
    // Bind parameters
    $stmt->bindParam(':product_grade', $_POST['product_grade'], PDO::PARAM_STR);
    $stmt->bindParam(':product_name', $_POST['product_name'], PDO::PARAM_STR);
    $stmt->bindParam(':product_description', $_POST['product_description'], PDO::PARAM_STR);
    $stmt->bindParam(':main_image', $main_image, PDO::PARAM_STR);
    $stmt->bindParam(':other_images', $other_images_json, PDO::PARAM_STR);
    
    // Tobacco specifications
    $stmt->bindParam(':grade', $_POST['grade'], PDO::PARAM_STR);
    $stmt->bindParam(':color', $_POST['color'], PDO::PARAM_STR);
    $stmt->bindParam(':texture', $_POST['texture'], PDO::PARAM_STR);
    $stmt->bindParam(':moisture_content', $_POST['moisture_content'], PDO::PARAM_STR);
    $stmt->bindParam(':nicotine_content', $_POST['nicotine_content'], PDO::PARAM_STR);
    $stmt->bindParam(':sugar_content', $_POST['sugar_content'], PDO::PARAM_STR);
    $stmt->bindParam(':leaf_length', $_POST['leaf_length'], PDO::PARAM_STR);
    $stmt->bindParam(':leaf_width', $_POST['leaf_width'], PDO::PARAM_STR);
    $stmt->bindParam(':stem_content', $_POST['stem_content'], PDO::PARAM_STR);
    $stmt->bindParam(':aroma', $_POST['aroma'], PDO::PARAM_STR);
    $stmt->bindParam(':burning_quality', $_POST['burning_quality'], PDO::PARAM_STR);
    
    // Other details
    $stmt->bindParam(':moq', $_POST['moq'], PDO::PARAM_STR);
    $stmt->bindParam(':hs_code', $_POST['hs_code'], PDO::PARAM_STR);
    
    if ($stmt->execute()) {
        echo "<script>alert('Tobacco product added successfully!'); window.location.href='add-tobacco-product.php';</script>";
    } else {
        echo "<script>alert('Failed to add product. Please try again.');</script>";
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 1200px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="text"], select, textarea {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input[type="file"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input:focus, select:focus, textarea:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: block;
        /*width: 200px;*/
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 16px;
        font-weight: 600;
        padding: 15px 15px;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px auto 0;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .form-section {
        margin-bottom: 30px;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 15px;
        border: 1px solid #eee;
    }

    .section-title {
        font-size: 22px;
        font-weight: 700;
        color: #273B92;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #273B92;
    }

    .form-row {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 10px;
    }

    .form-group {
        flex: 1;
        min-width: 250px;
    }

    .image-preview {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        margin-top: 10px;
    }

    .preview-img {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        border: 2px solid #ddd;
    }

    small {
        display: block;
        margin-top: 5px;
        color: #666;
        font-size: 13px;
    }

    .btn-show {
        margin-bottom: 20px;
        margin-right: 15px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit, .btn-show {
            width: 100%;
            margin-bottom: 15px;
        }
        .form-row {
            flex-direction: column;
            gap: 15px;
        }
        .form-group {
            min-width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add Tobacco Product</h2>
    
         <div style="margin-bottom: 20px;justify-content: left;display: flex;">
            <a href="show-tobacco-products.php" class="btn-show">
                 <button type="btn" name="btn" class="btn-submit"><i class="fas fa-eye"></i> Show Tobacco Products</button>
            </a>
        </div>


        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Product Grade *</label>
                        <input type="text" name="product_grade" placeholder="e.g., Premium Grade" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Product Name *</label>
                        <input type="text" name="product_name" placeholder="Enter Product Name" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Product Description</label>
                    <textarea name="product_description" rows="4" placeholder="Enter product description"></textarea>
                </div>
            </div>
            
            <!-- Section 2: Images -->
            <div class="form-section">
                <div class="section-title">Product Images</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Main Image *</label>
                        <input type="file" name="main_image" accept="image/*" required>
                        <small>Preferred size: 500x500px, max 2MB</small>
                    </div>
                    
                    <div class="form-group">
                        <label>Other Images (Multiple)</label>
                        <input type="file" name="other_images[]" accept="image/*" multiple>
                        <small>Hold Ctrl to select multiple images (max 5 images, 2MB each)</small>
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Tobacco Specifications -->
            <div class="form-section">
                <div class="section-title">Tobacco Specifications</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Grade</label>
                        <input type="text" name="grade" placeholder="e.g., Type-1 & Type-2 available">
                    </div>
                    
                    <div class="form-group">
                        <label>Color</label>
                        <input type="text" name="color" placeholder="e.g., Bright to Medium Red">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Texture</label>
                        <input type="text" name="texture" placeholder="e.g., Fine to Medium">
                    </div>
                    
                    <div class="form-group">
                        <label>Moisture Content</label>
                        <input type="text" name="moisture_content" placeholder="e.g., 12-14%">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Nicotine Content</label>
                        <input type="text" name="nicotine_content" placeholder="e.g., 2.0-3.5%">
                    </div>
                    
                    <div class="form-group">
                        <label>Sugar Content</label>
                        <input type="text" name="sugar_content" placeholder="e.g., 15-20%">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Leaf Length</label>
                        <input type="text" name="leaf_length" placeholder="e.g., 40-60 cm">
                    </div>
                    
                    <div class="form-group">
                        <label>Leaf Width</label>
                        <input type="text" name="leaf_width" placeholder="e.g., 20-30 cm">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Stem Content</label>
                        <input type="text" name="stem_content" placeholder="e.g., Max 15%">
                    </div>
                    
                    <div class="form-group">
                        <label>Aroma</label>
                        <input type="text" name="aroma" placeholder="e.g., Rich and Distinctive">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Burning Quality</label>
                    <input type="text" name="burning_quality" placeholder="e.g., Excellent">
                </div>
            </div>
            
            <!-- Section 4: Other Details -->
            <div class="form-section">
                <div class="section-title">Other Details</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Minimum Order Quantity (MOQ)</label>
                        <input type="text" name="moq" placeholder="e.g., 500 Kg">
                    </div>
                    
                    <div class="form-group">
                        <label>HS Code</label>
                        <input type="text" name="hs_code" placeholder="e.g., 2401.10.90">
                    </div>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add Tobacco Product</button>
        </form>
    </div>
</div>

<script>
function validateForm() {
    // Check required fields
    var productName = document.querySelector('input[name="product_name"]').value;
    var productGrade = document.querySelector('input[name="product_grade"]').value;
    var mainImage = document.querySelector('input[name="main_image"]').files[0];
    
    if (!productName.trim()) {
        alert("Please enter product name");
        return false;
    }
    
    if (!productGrade.trim()) {
        alert("Please enter product grade");
        return false;
    }
    
    if (!mainImage) {
        alert("Please select a main image");
        return false;
    }
    
    // Check file size for main image (max 2MB)
    if (mainImage && mainImage.size > 2 * 1024 * 1024) {
        alert("Main image size should be less than 2MB");
        return false;
    }
    
    // Check other images count and size
    var otherImages = document.querySelector('input[name="other_images[]"]').files;
    if (otherImages.length > 5) {
        alert("Maximum 5 other images allowed");
        return false;
    }
    
    for (var i = 0; i < otherImages.length; i++) {
        if (otherImages[i].size > 2 * 1024 * 1024) {
            alert("Image " + (i + 1) + " size should be less than 2MB");
            return false;
        }
    }
    
    return true;
}
</script>

<?php include('footer.php'); ?>