<?php
include('header.php');
include('db.php');

// Handle gallery image submission
if (isset($_POST['submit'])) {
    $image_name = trim($_POST['image_name']);
    
    // File upload for gallery image
    $image_path = '';
    if (isset($_FILES['gallery_image']) && $_FILES['gallery_image']['error'] === 0) {
        $uploadDir = 'uploads/gallery/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['gallery_image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['gallery_image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['gallery_image']['tmp_name'], $targetPath)) {
                $image_path = $fileName;
            }
        }
    }
    
    // Insert into database
    if (!empty($image_path)) {
        $sql = "INSERT INTO gallery_images (image_name, image_path) 
                VALUES (:image_name, :image_path)";
        
        try {
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':image_name', $image_name, PDO::PARAM_STR);
            $stmt->bindParam(':image_path', $image_path, PDO::PARAM_STR);
            
            if ($stmt->execute()) {
                echo "<script>alert('Gallery image added successfully!'); window.location.href='add-gallery.php';</script>";
            } else {
                echo "<script>alert('Failed to add gallery image. Please try again.');</script>";
            }
        } catch (PDOException $e) {
            echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
        }
    } else {
        echo "<script>alert('Please select an image to upload.');</script>";
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 800px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 30px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="text"], input[type="file"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 20px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: block;
        width: 200px;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 30px auto 0;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .form-section {
        margin-bottom: 30px;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 15px;
        border: 1px solid #eee;
    }

    .section-title {
        font-size: 22px;
        font-weight: 700;
        color: #273B92;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #273B92;
    }

    .image-preview-container {
        margin-top: 15px;
        text-align: center;
    }

    .image-preview {
        max-width: 400px;
        max-height: 300px;
        border-radius: 10px;
        border: 2px solid #ddd;
        display: none;
        margin: 0 auto 10px;
    }

    small {
        display: block;
        margin-top: 5px;
        color: #666;
        font-size: 13px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit {
            width: 100%;
        }
        .image-preview {
            max-width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add Gallery Image</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <div class="form-section">
                <div class="section-title">Image Details</div>
                
                <div class="form-group">
                    <label>Image Name *</label>
                    <input type="text" name="image_name" placeholder="Enter Image Name" required>
                </div>
                
                <div class="form-group">
                    <label>Select Image *</label>
                    <input type="file" name="gallery_image" id="gallery_image" accept="image/*" onchange="previewImage(this)" required>
                    <small>Allowed formats: JPG, PNG, GIF, WebP | Max size: 5MB</small>
                    
                    <div class="image-preview-container">
                        <img id="image-preview" class="image-preview" src="" alt="Image Preview">
                    </div>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add to Gallery</button>
        </form>
    </div>
</div>

<script>
// Image preview function
function previewImage(input) {
    var preview = document.getElementById('image-preview');
    
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        
        reader.readAsDataURL(input.files[0]);
    } else {
        preview.style.display = 'none';
        preview.src = '';
    }
}

function validateForm() {
    // Check required fields
    var imageName = document.querySelector('input[name="image_name"]').value;
    var galleryImage = document.querySelector('input[name="gallery_image"]').files[0];
    
    if (!imageName.trim()) {
        alert("Please enter image name");
        return false;
    }
    
    if (!galleryImage) {
        alert("Please select an image");
        return false;
    }
    
    // Check file size (5MB limit)
    if (galleryImage.size > 5 * 1024 * 1024) {
        alert("Image size should be less than 5MB");
        return false;
    }
    
    return true;
}
</script>

<?php include('footer.php'); ?>