<?php
include('header.php');
include('db.php');

// Handle blog post submission
if (isset($_POST['submit'])) {
    $blog_name = trim($_POST['blog_name']);
    $date = $_POST['date'];
    $author_name = trim($_POST['author_name']);
    $content = trim($_POST['content']);
    
    // File upload for blog image
    $image = '';
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $uploadDir = 'uploads/blogs/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        // Validate file type
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        $file_type = mime_content_type($_FILES['image']['tmp_name']);
        
        if (in_array($file_type, $allowed_types)) {
            $fileName = uniqid() . '_' . basename($_FILES['image']['name']);
            $targetPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $image = $fileName;
            }
        }
    }
    
    // Insert into database
    $sql = "INSERT INTO blog_posts (blog_name, date, author_name, content, image) 
            VALUES (:blog_name, :date, :author_name, :content, :image)";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':blog_name', $blog_name, PDO::PARAM_STR);
        $stmt->bindParam(':date', $date, PDO::PARAM_STR);
        $stmt->bindParam(':author_name', $author_name, PDO::PARAM_STR);
        $stmt->bindParam(':content', $content, PDO::PARAM_STR);
        $stmt->bindParam(':image', $image, PDO::PARAM_STR);
        
        if ($stmt->execute()) {
            echo "<script>alert('Blog added successfully!'); window.location.href='add-blogs.php';</script>";
        } else {
            echo "<script>alert('Failed to add blog. Please try again.');</script>";
        }
    } catch (PDOException $e) {
        echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
    }
}
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- Bootstrap CDN -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style> 
    .content-wrapper {
        padding: 30px 50px;
        box-sizing: border-box;
        background: #fff !important;
        color: #000 !important;
        min-height: 100vh;
    }

    .form-container {
        background: #fff !important;
        border: 1px solid #ddd !important;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1) !important;
        margin: 0 auto;
        width: 100%;
        max-width: 1200px;
        color: #000 !important;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #000 !important;
        letter-spacing: 2px;
        font-size: 30px;
        font-weight: 700;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #000 !important;
    }

    input[type="text"], input[type="date"], select, textarea {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px 15px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input[type="file"] {
        background: rgba(0, 0, 0, 0.05) !important;
        border: 2px solid #ddd !important;
        border-radius: 12px;
        color: #000 !important;
        font-size: 16px;
        padding: 12px;
        width: 100%;
        margin-bottom: 15px;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input:focus, textarea:focus {
        background: rgba(0, 0, 0, 0.08) !important;
        border-color: #273B92 !important;
        box-shadow: 0 0 0 3px rgba(39, 59, 146, 0.2) !important;
        outline: none;
    }

    .btn-submit {
        display: block;
        width: 200px;
        background: #273B92 !important;
        border: none !important;
        border-radius: 12px;
        color: #fff !important;
        font-size: 18px;
        font-weight: 600;
        padding: 15px 0;
        cursor: pointer;
        transition: all 0.3s ease;
        margin: 40px auto 0;
    }

    .btn-submit:hover {
        background: #000 !important;
        color: #fff !important;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2) !important;
    }

    .form-section {
        margin-bottom: 30px;
        padding: 20px;
        background: #f8f9fa;
        border-radius: 15px;
        border: 1px solid #eee;
    }

    .section-title {
        font-size: 22px;
        font-weight: 700;
        color: #273B92;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #273B92;
    }

    .form-row {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 10px;
    }

    .form-group {
        flex: 1;
        min-width: 250px;
    }

    .image-preview-container {
        margin-top: 15px;
        text-align: center;
    }

    .image-preview {
        max-width: 300px;
        max-height: 200px;
        border-radius: 10px;
        border: 2px solid #ddd;
        display: none;
        margin: 0 auto 10px;
    }

    small {
        display: block;
        margin-top: 5px;
        color: #666;
        font-size: 13px;
    }

    @media (max-width: 768px) {
        .content-wrapper {
            padding: 20px 15px;
        }
        .form-container {
            padding: 20px;
        }
        .btn-submit {
            width: 100%;
        }
        .form-row {
            flex-direction: column;
            gap: 15px;
        }
        .form-group {
            min-width: 100%;
        }
    }
</style>

<div class="content-wrapper">
    <div class="form-container">
        <h2>Add Blog Post</h2>
        <form method="post" action="" enctype="multipart/form-data" onsubmit="return validateForm()">
            
            <!-- Section 1: Basic Information -->
            <div class="form-section">
                <div class="section-title">Basic Information</div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Blog Name *</label>
                        <input type="text" name="blog_name" placeholder="Enter Blog Name" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Publish Date *</label>
                        <input type="date" name="date" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Author Name *</label>
                    <input type="text" name="author_name" placeholder="Enter Author Name" required>
                </div>
            </div>
            
            <!-- Section 2: Image -->
            <div class="form-section">
                <div class="section-title">Blog Image</div>
                
                <div class="form-group">
                    <label>Blog Image (Optional)</label>
                    <input type="file" name="image" id="image" accept="image/*" onchange="previewImage(this)">
                    <small>Preferred size: 1200x630px, max 2MB</small>
                    
                    <div class="image-preview-container">
                        <img id="image-preview" class="image-preview" src="" alt="Image Preview">
                    </div>
                </div>
            </div>
            
            <!-- Section 3: Content -->
            <div class="form-section">
                <div class="section-title">Blog Content</div>
                
                <div class="form-group">
                    <label>Content *</label>
                    <textarea name="content" rows="10" placeholder="Write your blog content here..." required></textarea>
                </div>
            </div>
            
            <button type="submit" name="submit" class="btn-submit">Add Blog</button>
        </form>
    </div>
</div>

<script>
// Set default date to today
document.addEventListener('DOMContentLoaded', function() {
    var today = new Date().toISOString().split('T')[0];
    document.querySelector('input[name="date"]').value = today;
});

// Image preview function
function previewImage(input) {
    var preview = document.getElementById('image-preview');
    
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        
        reader.readAsDataURL(input.files[0]);
    } else {
        preview.style.display = 'none';
        preview.src = '';
    }
}

function validateForm() {
    // Check required fields
    var blogName = document.querySelector('input[name="blog_name"]').value;
    var date = document.querySelector('input[name="date"]').value;
    var authorName = document.querySelector('input[name="author_name"]').value;
    var content = document.querySelector('textarea[name="content"]').value;
    var blogImage = document.querySelector('input[name="image"]').files[0];
    
    if (!blogName.trim()) {
        alert("Please enter blog name");
        return false;
    }
    
    if (!date) {
        alert("Please select a publish date");
        return false;
    }
    
    if (!authorName.trim()) {
        alert("Please enter author name");
        return false;
    }
    
    if (!content.trim()) {
        alert("Please enter blog content");
        return false;
    }
    
    // Check file size if image is uploaded
    if (blogImage && blogImage.size > 2 * 1024 * 1024) {
        alert("Blog image size should be less than 2MB");
        return false;
    }
    
    return true;
}
</script>

<?php include('footer.php'); ?>