<?php 
include('header.php');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>
<style>
     div.ck-editor__editable {
         min-height: 200px;
     }
</style>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <div class="header-icon">
                  <i class="fa fa-plus-square"></i>
               </div>
               <div class="header-title">
                  <h1>Add & Manage Amenities</h1>
               </div>
            </section>
            <!-- Main content -->
            <section class="content"> 
               <div class="row">
                  <!-- Form controls -->
                  <div class="col-sm-12">
                     <div class="panel panel-bd lobidrag">
                        <div class="panel-heading">
                           <div class="btn-group" id="buttonlist"> 
                              <h4>Add New Amenity</h4>
                           </div>
                        </div>
                        <div class="panel-body">
                           <?php
                           include('db.php'); 

                           if (isset($_POST['submit'])) {
                               // Get form data
                               $amenity_name = trim(str_replace('-', ' ', $_POST['amenity_name']));

                               // Basic validation
                               $errors = [];
                               if (empty($amenity_name)) {
                                   $errors[] = "Amenity name is required.";
                               }

                               if (empty($errors)) {
                                   $stmt = $pdo->prepare("INSERT INTO tbl_amenities (amenity_name) 
                                                         VALUES (:amenity_name)");
                                   $success = $stmt->execute([
                                       ':amenity_name' => $amenity_name
                                   ]);

                                   if ($success) {
                                       echo "<script>alert('Amenity added successfully'); window.location.href='add-amenities.php';</script>";
                                   } else {
                                       echo "<script>alert('Database insertion failed');</script>";
                                   }
                               } else {
                                   foreach ($errors as $err) {
                                       echo "<script>alert('{$err}');</script>";
                                   }
                               }
                           }
                           ?>
                           <form class="col-sm-12" method="post" action="">
                              <div class="form-group col-sm-6">
                                 <label>Amenity Name</label>
                                 <input type="text" class="form-control" placeholder="Enter Amenity Name" required name="amenity_name">
                              </div>
                              <div class="form-group col-sm-12">
                                 <div class="reset-button">
                                    <button type="submit" name="submit" class="btn btn-success">Add</button>
                                 </div>
                              </div>
                           </form>
                        </div>
                     </div>
                  </div>
                  <!-- Amenities List -->
                  <div class="col-sm-12">
                     <div class="panel panel-bd lobidrag">
                        <div class="panel-heading">
                           <div class="btn-group" id="buttonlist"> 
                              <h4>Amenities List</h4>
                           </div>
                        </div>
                        <div class="panel-body">
                           <div class="table-responsive">
                              <table class="table table-bordered table-hover">
                                 <thead>
                                    <tr>
                                       <th>#</th>
                                       <th>Amenity Name</th>
                                       <th>Action</th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    <?php
                                    $sql = "SELECT id, amenity_name 
                                            FROM tbl_amenities 
                                            ORDER BY id ASC";
                                    $stmt = $pdo->prepare($sql);
                                    $stmt->execute();
                                    $i = 1;
                                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                       ?>
                                       <tr>
                                          <td><?php echo $i++; ?></td>
                                          <td><?php echo htmlspecialchars($row['amenity_name']); ?></td>
                                          <td>
                                             <a class="btn btn-info btn-sm" href="edit-amenity.php?id=<?php echo $row['id']; ?>">Edit</a>
                                             <a class="btn btn-danger btn-sm" href="delete-amenity.php?id=<?php echo $row['id']; ?>" 
                                                onclick="return confirm('Are you sure you want to delete this amenity?');">Delete</a>
                                          </td>
                                       </tr>
                                       <?php
                                    }
                                    ?>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </section>
         </div>
      <!-- ./wrapper -->
      <!-- Start Core Plugins -->
      <script src="//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js" type="text/javascript"></script>
      <!-- jQuery -->
      <script src="assets/plugins/jQuery/jquery-1.12.4.min.js" type="text/javascript"></script>
      <!-- jquery-ui --> 
      <script src="assets/plugins/jquery-ui-1.12.1/jquery-ui.min.js" type="text/javascript"></script>
      <!-- Bootstrap -->
      <script src="assets/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
      <!-- lobipanel -->
      <script src="assets/plugins/lobipanel/lobipanel.min.js" type="text/javascript"></script>
      <!-- Pace js -->
      <script src="assets/plugins/pace/pace.min.js" type="text/javascript"></script>
      <!-- SlimScroll -->
      <script src="assets/plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
      <!-- FastClick -->
      <script src="assets/plugins/fastclick/fastclick.min.js" type="text/javascript"></script>
      <!-- CRMadmin frame -->
      <script src="assets/dist/js/custom.js" type="text/javascript"></script>
      <!-- Dashboard js -->
      <script src="assets/dist/js/dashboard.js" type="text/javascript"></script>