<?php
// Allow CORS from specific origins
$allowedOrigins = [
    'http://localhost:65182',
    'https://dashboard.easternhimalayas.in'
];

$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if (in_array($origin, $allowedOrigins)) {
    header("Access-Control-Allow-Origin: $origin");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
}

// Handle pre-flight requests (OPTIONS)
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit;
}

include("../db.php");

// Fetch the module action from the raw JSON body or $_POST
$rawData = file_get_contents('php://input');
$requestData = json_decode($rawData, true);

// Determine the module action from either the JSON body or $_POST
$moduleAction = $requestData['module_action'] ?? $_POST['module_action'] ?? '';

// Use the moduleAction variable in the switch statement
switch ($moduleAction) {
    case 'fetchUsersEnquries':
        fetchUsersEnquries();
        break;
    default:
        echo json_encode(["message" => "Invalid action", "status" => "0"]);
        break;
}

function fetchUsersEnquries()
{
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        global $pdo; // Ensure you're using PDO connection

        // Start database transaction
        try {
            $pdo->beginTransaction();

            $return_arr = [];

            // Prepare SQL query to fetch notifications
            $sql = "SELECT * FROM product_enquiry ORDER BY id DESC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();

            // Check if the query returned any rows
            $resultCount = $stmt->rowCount();

            if ($resultCount > 0) {
                $post = ["message" => "success", "status" => "1", "result" => []];
                // Fetch each notification record
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $post['result'][] = [
                        'id' => $row['id'],
                        'product_name' => $row['product_name'],
                        'user_name' => $row['user_name'],
                        'email' => $row['email'],
                        'mobile' => $row['mobile'],
                        'company_name' => $row['company_name'],
                        'requested_qty' => $row['requested_qty'],
                        'grade_a_price' => $row['grade_b_price'],
                        'grade_b_price' => $row['grade_b_price'],
                        'expected_delivery_date' => $row['expected_delivery_date'],
                        'created_at' => $row['created_at'],
                    ];
                }
            } else {
                $post = ["message" => "No Record found", "status" => "0"];
            }

            // Commit transaction
            $pdo->commit();

            // Return the response
            echo json_encode($post);

        } catch (PDOException $e) {
            // Rollback transaction in case of error
            $pdo->rollBack();
            echo json_encode(["message" => "Database query error: " . $e->getMessage(), "status" => "0"]);
        }
    } else {
        echo json_encode(["message" => "Invalid request method", "status" => "0"]);
    }
}
?>
